/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "client.h"

#include <iostream>

namespace tp = testing::qt::tp;

tp::Client::Approver::Approver(const Tp::AbstractClientHandlerPtr handler, const Tp::ChannelClassSpecList& filter)
    : Tp::AbstractClientApprover{filter}
    , handler{handler}
{
}

void tp::Client::Approver::addDispatchOperation(const Tp::MethodInvocationContextPtr<>& context,
                                                const Tp::ChannelDispatchOperationPtr& dispatchOperation)
{
    dispatchOperation->claim(handler);
    context->setFinished();
}

tp::Client::Handler::Handler(const Tp::ChannelClassSpecList& filter)
    : Tp::AbstractClientHandler{filter}
{
}

bool tp::Client::Handler::bypassApproval() const
{
    return true;
}

void tp::Client::Handler::handleChannels(const Tp::MethodInvocationContextPtr<>& context,
                                         const Tp::AccountPtr& account,
                                         const Tp::ConnectionPtr& connection,
                                         const QList<Tp::ChannelPtr>& channels,
                                         const QList<Tp::ChannelRequestPtr>& requestsSatisfied,
                                         const QDateTime& userActionTime,
                                         const HandlerInfo& handlerInfo)
{
    Q_UNUSED(account)
    Q_UNUSED(connection)
    Q_UNUSED(requestsSatisfied)
    Q_UNUSED(userActionTime)
    Q_UNUSED(handlerInfo)

    for (const auto& channel : channels)
    {
        channels_in_flight.push_back(channel);
    }

    context->setFinished();
}

tp::Client::Client(const QDBusConnection& connection, const Tp::ChannelClassSpecList& filter)
    : ti{messaging::qt::tp::Initializer::Configuration{}}
    , handler{Tp::AbstractClientHandlerPtr{new Handler{filter}}}
    , approver{Tp::AbstractClientApproverPtr{new Approver{handler, filter}}}
    , client_registrar{Tp::ClientRegistrar::create(connection)}
{
    client_registrar->registerClient(Tp::AbstractClientPtr::dynamicCast(approver),
                                     QLatin1String{Client::name} + ".Approver");
    client_registrar->registerClient(Tp::AbstractClientPtr::dynamicCast(handler),
                                     QLatin1String{Client::name} + ".Handler");
}
