/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TESTING_QT_TP_UTILS_H_
#define TESTING_QT_TP_UTILS_H_

#include <messaging/qt/runtime.h>

#include <TelepathyQt/TextChannel>
#include <TelepathyQt/PendingOperation>

#include <QDBusConnection>

#include <gtest/gtest.h>

#include <string>
#include <functional>

namespace testing
{
namespace qt
{
namespace tp
{
/// @brief pending_operation_finished_successfully returns
/// testing::AssertionSuccess if the operation completed successfully,
/// testing::AssertionFailure in all other cases.
testing::AssertionResult pending_operation_finished_successfully(Tp::PendingOperation* op);

/// @brief when_finished wires up the given functor to the &Tp::PendingOperation::finished signal.
void when_finished(Tp::PendingOperation* op, const std::function<void(Tp::PendingOperation* op)>& then);

/// @brief when_finished wires up the given functor to the &Tp::PendingOperation::finished signal.
/// Overload not passing down the Tp::PendingOperation instance.
void when_finished(Tp::PendingOperation* op, const std::function<void()>& then);

/// @brief wait_for_connection_manager_with_name_on_bus returns testing::AssertionSuccess if the connection manager
/// with the given name showed up within 5 seconds on the given bus. Otherwise, it returns testing::AssertionFailure.
testing::AssertionResult wait_for_connection_manager_with_name_and_protocol_on_bus(const std::string& name, const std::string& protocol, const QDBusConnection& bus);

/// @brief create_account creates an account with a given connection manager and protocol names
/// and hands the account to the given functor then.
void create_account_and_then(const QString& cm_name, const QString& protocol_name, const std::shared_ptr<messaging::qt::Runtime>& runtime, const std::function<void(const Tp::AccountPtr&)>& then);

/// @brief create_online_account creates an account with a given connection manager and protocol names
/// and hands the account to the given functor then after becoming online
void create_online_account_and_then(const QString& cm_name, const QString& protocol_name, const std::shared_ptr<messaging::qt::Runtime>& runtime, const std::function<void(const Tp::AccountPtr&)>& then);

/// @brief disconnect_account disconnects the account and then executes the functor
void disconnect_account_and_then(const Tp::AccountPtr &account, const std::shared_ptr<messaging::qt::Runtime>& runtime, const std::function<void()>& then);

/// @brief ensure_text_channel makes sure that a text channel is created and hands the
/// respective instance to the given functor then.
void ensure_text_channel_and_then(const QString& cm_name, const QString& protocol_name, const std::shared_ptr<messaging::qt::Runtime>& runtime, const std::function<void(const Tp::TextChannelPtr&)>& then);

/// @brief wait_for_text_channel waits until a text channel is received and then hands it
/// to the given functor then.
void wait_for_text_channel_and_then(const Tp::AccountPtr& account, const std::shared_ptr<messaging::qt::Runtime>& runtime, const std::function<void(const Tp::TextChannelPtr&)>& then);
}
}
}

#endif  // TESTING_QT_TP_UTILS_H_
