/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/qt/runtime.h>

#include "did_finish.h"
#include "fork_and_wait.h"

#include <core/posix/fork.h>

#include <gtest/gtest.h>

#include <QTimer>

TEST(QtRuntime, construction_and_deconstruction_works)
{
    messaging::qt::Runtime::create_once_or_throw(QDBusConnection::SessionBus);
};

TEST(QtRuntime, construction_throws_for_second_creation_call)
{
    auto rt = messaging::qt::Runtime::create_once_or_throw(QDBusConnection::SessionBus);
    EXPECT_THROW(rt = messaging::qt::Runtime::create_once_or_throw(QDBusConnection::SessionBus),
                 messaging::qt::Runtime::AlreadyCreated);
};

TEST(QtRuntime, run_returns_exit_code_provided_to_stop)
{
    static const int return_code{42};

    auto rt = messaging::qt::Runtime::create_once_or_throw(QDBusConnection::SessionBus);

    // We need a timer to stop the runtime.
    QTimer stop_timer;
    stop_timer.setSingleShot(true);
    QObject::connect(&stop_timer,
                     &QTimer::timeout,
                     [&rt]()
                     {
        rt->stop(return_code);
    });
    stop_timer.start(500);

    // Execute the runtime.
    EXPECT_EQ(return_code, rt->run());
};
