/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <messaging/qt/variant_map_facade.h>

#include <gtest/gtest.h>

TEST(QtVariantMapFacade, stores_correct_values_for_map_passed_on_construction)
{
    QVariantMap vm;
    vm["test1"] = QVariant(uint(42));
    vm["test2"] = QVariant(uint(41));
    vm["test3"] = QVariant(QString("41"));

    messaging::qt::VariantMapFacade vmf{vm};

    EXPECT_TRUE(vmf.has_value_for_key("test1"));
    EXPECT_TRUE(vmf.has_value_for_key("test2"));
    EXPECT_TRUE(vmf.has_value_for_key("test3"));

    EXPECT_EQ(42, vmf.value_for_key("test1").as_int());
    EXPECT_EQ(41, vmf.value_for_key("test2").as_int());
    EXPECT_EQ("41", vmf.value_for_key("test3").as_string());
}
