/*
 * Copyright © 2016 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef TESTING_TYPED_CONNECTOR_FACTORY_H_
#define TESTING_TYPED_CONNECTOR_FACTORY_H_

#include <messaging/connector_factory.h>

namespace testing
{
/// @brief TypedConnectorFactory implements messaging ConnectorFactory
/// returning instances of the template type Connector for queries.
template <typename Connector>
struct TypedConnectorFactory : public messaging::ConnectorFactory
{
    messaging::ConnectorFactory::Generator create_instance_for_name(const std::string&) const override
    {
        return [](const messaging::Dictionary<std::string, std::string>&)
        {
            return std::make_shared<Connector>();
        };
    }
};
}

#endif  // TESTING_TYPED_CONNECTOR_FACTORY_H_
