#!/bin/sh -e

# called by uscan with '--upstream-version' <version> <file>
DIR=mondrian-$2
TAR=mondrian_$2.orig.tar.gz

# Repack upstream source to tar.gz
mkdir $DIR
(
cd $DIR
unzip -j $3 mondrian-*/mondrian-*-src.zip
unzip -d . mondrian-*-src.zip
mv mondrian-*/* .
rm mondrian-*-src.zip
)
GZIP=--best tar czf $TAR -X debian/orig-tar.exclude $DIR
rm -rf $DIR
