// created by jay 0.7 (c) 1998 Axel.Schreiner@informatik.uni-osnabrueck.de

#line 2 "cs-parser.jay"
//
// cs-parser.jay: The Parser for the C# compiler
//
// Authors: Miguel de Icaza (miguel@gnome.org)
//          Ravi Pratap     (ravi@ximian.com)
//          Marek Safar	    (marek.safar@gmail.com)
//
// Dual Licensed under the terms of the GNU GPL and the MIT X11 license
//
// (C) 2001 Ximian, Inc (http://www.ximian.com)
// (C) 2004-2011 Novell, Inc
// Copyright 2011 Xamarin Inc.
//
// TODO:
//   (1) Figure out why error productions dont work.  `type-declaration' is a
//       great spot to put an `error' because you can reproduce it with this input:
//	 "public X { }"
//

using System.Text;
using System.IO;
using System;
using System.Collections.Generic;

namespace Mono.CSharp
{
	/// <summary>
	///    The C# Parser
	/// </summary>
	public class CSharpParser
	{
		[Flags]
		enum ParameterModifierType
		{
			Ref		= 1 << 1,
			Out		= 1 << 2,
			This	= 1 << 3,
			Params	= 1 << 4,
			Arglist	= 1 << 5,
			DefaultValue = 1 << 6,
			
			All = Ref | Out | This | Params | Arglist | DefaultValue
		}
		
		static readonly object ModifierNone = 0;
	
		NamespaceContainer  current_namespace;
		TypeContainer   current_container;
		DeclSpace	current_class;
		PropertyBase current_property;
		EventProperty current_event;
		EventField current_event_field;
		FieldBase current_field;
	
		/// <summary>
		///   Current block is used to add statements as we find
		///   them.  
		/// </summary>
		Block      current_block;
		
		BlockVariableDeclaration current_variable;

		Delegate   current_delegate;
		
		AnonymousMethodExpression current_anonymous_method;

		/// <summary>
		///   This is used by the unary_expression code to resolve
		///   a name against a parameter.  
		/// </summary>
		
		// FIXME: This is very ugly and it's very hard to reset it correctly
		// on all places, especially when some parameters are autogenerated.
		ParametersCompiled current_local_parameters;

		bool parsing_anonymous_method;

		///
		/// An out-of-band stack.
		///
		static Stack<object> oob_stack;

		///
		/// Controls the verbosity of the errors produced by the parser
		///
		static public int yacc_verbose_flag;

		/// 
		/// Used by the interactive shell, flags whether EOF was reached
		/// and an error was produced
		///
		public bool UnexpectedEOF;

		///
		/// The current file.
		///
		readonly CompilationSourceFile file;

		///
		/// Temporary Xml documentation cache.
		/// For enum types, we need one more temporary store.
		///
		string tmpComment;
		string enumTypeComment;
	       		
		/// Current attribute target
		string current_attr_target;
		
		ParameterModifierType valid_param_mod;
		
		bool default_parameter_used;

		/// When using the interactive parser, this holds the
		/// resulting expression
		public Class InteractiveResult;

		//
		// Keeps track of global data changes to undo on parser error
		//
		public Undo undo;
		
		Stack<Linq.QueryBlock> linq_clause_blocks;

		ModuleContainer module;
		
		readonly CompilerContext compiler;
		readonly LanguageVersion lang_version;
		readonly bool doc_support;
		readonly CompilerSettings settings;
		readonly Report report;
		
		//
		// Instead of allocating carrier array everytime we
		// share the bucket for very common constructs which can never
		// be recursive
		//
		static List<Parameter> parameters_bucket = new List<Parameter> (6);
		
		//
		// Full AST support members
		//
		LocationsBag lbag;
		UsingsBag ubag;
		List<Tuple<Modifiers, Location>> mod_locations;
		Location parameterModifierLocation, savedLocation, savedOpenLocation, savedCloseLocation;
		Location savedAttrParenOpenLocation, savedAttrParenCloseLocation, savedOperatorLocation;
		Stack<List<Location>> locationListStack = new Stack<List<Location>> (); // used for type parameters
		List<Location> attributeCommas = new List<Location> ();
		List<Location> attributeArgumentCommas = new List<Location> ();
		List<Location> parameterListCommas = new List<Location> ();
		List<Location> enumCommas = new List<Location> ();
		
		object lastYYVal;
		
		// Can be used for code completion to get the last valid expression before an error.
		// needs a hack in yyparse to make it work add 
		// lastYYVal = yyVal;
		// after the big switch/case (somewhere around line 3915)
		public object LastYYVal {
			get {
				return lastYYVal;
			}
		}
		
#line default

  /** error output stream.
      It should be changeable.
    */
  public System.IO.TextWriter ErrorOutput = System.Console.Out;

  /** simplified error message.
      @see <a href="#yyerror(java.lang.String, java.lang.String[])">yyerror</a>
    */
  public void yyerror (string message) {
    yyerror(message, null);
  }

  /* An EOF token */
  public int eof_token;

  /** (syntax) error message.
      Can be overwritten to control message format.
      @param message text to be displayed.
      @param expected vector of acceptable tokens, if available.
    */
  public void yyerror (string message, string[] expected) {
    if ((yacc_verbose_flag > 0) && (expected != null) && (expected.Length  > 0)) {
      ErrorOutput.Write (message+", expecting");
      for (int n = 0; n < expected.Length; ++ n)
        ErrorOutput.Write (" "+expected[n]);
        ErrorOutput.WriteLine ();
    } else
      ErrorOutput.WriteLine (message);
  }

  /** debugging support, requires the package jay.yydebug.
      Set to null to suppress debugging messages.
    */
//t  internal yydebug.yyDebug debug;

  protected const int yyFinal = 7;
//t // Put this array into a separate class so it is only initialized if debugging is actually used
//t // Use MarshalByRefObject to disable inlining
//t class YYRules : MarshalByRefObject {
//t  public static readonly string [] yyRule = {
//t    "$accept : compilation_unit",
//t    "compilation_unit : outer_declaration opt_EOF",
//t    "$$1 :",
//t    "compilation_unit : interactive_parsing $$1 opt_EOF",
//t    "compilation_unit : documentation_parsing",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations opt_attributes",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives attribute_sections",
//t    "outer_declaration : error",
//t    "opt_EOF :",
//t    "opt_EOF : EOF",
//t    "extern_alias_directives : extern_alias_directive",
//t    "extern_alias_directives : extern_alias_directives extern_alias_directive",
//t    "extern_alias_directive : EXTERN_ALIAS IDENTIFIER IDENTIFIER SEMICOLON",
//t    "extern_alias_directive : EXTERN_ALIAS error",
//t    "using_directives : using_directive",
//t    "using_directives : using_directives using_directive",
//t    "using_directive : using_alias_directive",
//t    "using_directive : using_namespace_directive",
//t    "using_alias_directive : USING IDENTIFIER ASSIGN namespace_or_type_name SEMICOLON",
//t    "using_alias_directive : USING error",
//t    "using_namespace_directive : USING namespace_name SEMICOLON",
//t    "$$2 :",
//t    "$$3 :",
//t    "namespace_declaration : opt_attributes NAMESPACE qualified_identifier $$2 OPEN_BRACE $$3 opt_extern_alias_directives opt_using_directives opt_namespace_or_type_declarations CLOSE_BRACE opt_semicolon",
//t    "qualified_identifier : IDENTIFIER",
//t    "qualified_identifier : qualified_identifier DOT IDENTIFIER",
//t    "qualified_identifier : error",
//t    "opt_semicolon :",
//t    "opt_semicolon : SEMICOLON",
//t    "opt_comma :",
//t    "opt_comma : COMMA",
//t    "namespace_name : namespace_or_type_name",
//t    "opt_using_directives :",
//t    "opt_using_directives : using_directives",
//t    "opt_extern_alias_directives :",
//t    "opt_extern_alias_directives : extern_alias_directives",
//t    "opt_namespace_or_type_declarations :",
//t    "opt_namespace_or_type_declarations : namespace_or_type_declarations",
//t    "namespace_or_type_declarations : namespace_or_type_declaration",
//t    "namespace_or_type_declarations : namespace_or_type_declarations namespace_or_type_declaration",
//t    "namespace_or_type_declaration : type_declaration",
//t    "namespace_or_type_declaration : namespace_declaration",
//t    "type_declaration : class_declaration",
//t    "type_declaration : struct_declaration",
//t    "type_declaration : interface_declaration",
//t    "type_declaration : enum_declaration",
//t    "type_declaration : delegate_declaration",
//t    "opt_attributes :",
//t    "opt_attributes : attribute_sections",
//t    "attribute_sections : attribute_section",
//t    "attribute_sections : attribute_sections attribute_section",
//t    "$$4 :",
//t    "attribute_section : OPEN_BRACKET $$4 attribute_section_cont",
//t    "$$5 :",
//t    "attribute_section_cont : attribute_target COLON $$5 attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_section_cont : attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_target : IDENTIFIER",
//t    "attribute_target : EVENT",
//t    "attribute_target : RETURN",
//t    "attribute_target : error",
//t    "attribute_list : attribute",
//t    "attribute_list : attribute_list COMMA attribute",
//t    "$$6 :",
//t    "attribute : attribute_name $$6 opt_attribute_arguments",
//t    "attribute_name : namespace_or_type_name",
//t    "opt_attribute_arguments :",
//t    "opt_attribute_arguments : OPEN_PARENS attribute_arguments CLOSE_PARENS",
//t    "attribute_arguments :",
//t    "attribute_arguments : positional_or_named_argument",
//t    "attribute_arguments : named_attribute_argument",
//t    "attribute_arguments : attribute_arguments COMMA positional_or_named_argument",
//t    "attribute_arguments : attribute_arguments COMMA named_attribute_argument",
//t    "positional_or_named_argument : expression",
//t    "positional_or_named_argument : named_argument",
//t    "$$7 :",
//t    "named_attribute_argument : IDENTIFIER ASSIGN $$7 expression",
//t    "named_argument : IDENTIFIER COLON opt_named_modifier expression",
//t    "opt_named_modifier :",
//t    "opt_named_modifier : REF",
//t    "opt_named_modifier : OUT",
//t    "opt_class_member_declarations :",
//t    "opt_class_member_declarations : class_member_declarations",
//t    "class_member_declarations : class_member_declaration",
//t    "class_member_declarations : class_member_declarations class_member_declaration",
//t    "class_member_declaration : constant_declaration",
//t    "class_member_declaration : field_declaration",
//t    "class_member_declaration : method_declaration",
//t    "class_member_declaration : property_declaration",
//t    "class_member_declaration : event_declaration",
//t    "class_member_declaration : indexer_declaration",
//t    "class_member_declaration : operator_declaration",
//t    "class_member_declaration : constructor_declaration",
//t    "class_member_declaration : destructor_declaration",
//t    "class_member_declaration : type_declaration",
//t    "class_member_declaration : error",
//t    "$$8 :",
//t    "$$9 :",
//t    "$$10 :",
//t    "$$11 :",
//t    "$$12 :",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT $$8 type_declaration_name $$9 opt_class_base opt_type_parameter_constraints_clauses $$10 OPEN_BRACE $$11 opt_class_member_declarations CLOSE_BRACE $$12 opt_semicolon",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT error",
//t    "$$13 :",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type IDENTIFIER $$13 constant_initializer opt_constant_declarators SEMICOLON",
//t    "opt_constant_declarators :",
//t    "opt_constant_declarators : constant_declarators",
//t    "constant_declarators : constant_declarator",
//t    "constant_declarators : constant_declarators constant_declarator",
//t    "constant_declarator : COMMA IDENTIFIER constant_initializer",
//t    "$$14 :",
//t    "constant_initializer : ASSIGN $$14 constant_initializer_expr",
//t    "constant_initializer : error",
//t    "constant_initializer_expr : constant_expression",
//t    "constant_initializer_expr : array_initializer",
//t    "$$15 :",
//t    "field_declaration : opt_attributes opt_modifiers member_type IDENTIFIER $$15 opt_field_initializer opt_field_declarators SEMICOLON",
//t    "$$16 :",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type IDENTIFIER $$16 fixed_field_size opt_fixed_field_declarators SEMICOLON",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type error SEMICOLON",
//t    "opt_field_initializer :",
//t    "$$17 :",
//t    "opt_field_initializer : ASSIGN $$17 variable_initializer",
//t    "opt_field_declarators :",
//t    "opt_field_declarators : field_declarators",
//t    "field_declarators : field_declarator",
//t    "field_declarators : field_declarators field_declarator",
//t    "field_declarator : COMMA IDENTIFIER",
//t    "$$18 :",
//t    "field_declarator : COMMA IDENTIFIER ASSIGN $$18 variable_initializer",
//t    "opt_fixed_field_declarators :",
//t    "opt_fixed_field_declarators : fixed_field_declarators",
//t    "fixed_field_declarators : fixed_field_declarator",
//t    "fixed_field_declarators : fixed_field_declarators fixed_field_declarator",
//t    "fixed_field_declarator : COMMA IDENTIFIER fixed_field_size",
//t    "$$19 :",
//t    "fixed_field_size : OPEN_BRACKET $$19 expression CLOSE_BRACKET",
//t    "fixed_field_size : OPEN_BRACKET error",
//t    "variable_initializer : expression",
//t    "variable_initializer : array_initializer",
//t    "variable_initializer : error",
//t    "$$20 :",
//t    "method_declaration : method_header $$20 method_body",
//t    "$$21 :",
//t    "$$22 :",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name OPEN_PARENS $$21 opt_formal_parameter_list CLOSE_PARENS $$22 opt_type_parameter_constraints_clauses",
//t    "$$23 :",
//t    "$$24 :",
//t    "$$25 :",
//t    "method_header : opt_attributes opt_modifiers PARTIAL VOID $$23 method_declaration_name OPEN_PARENS $$24 opt_formal_parameter_list CLOSE_PARENS $$25 opt_type_parameter_constraints_clauses",
//t    "method_header : opt_attributes opt_modifiers member_type modifiers method_declaration_name OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS",
//t    "method_body : block",
//t    "method_body : SEMICOLON",
//t    "opt_formal_parameter_list :",
//t    "opt_formal_parameter_list : formal_parameter_list",
//t    "formal_parameter_list : fixed_parameters",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array",
//t    "formal_parameter_list : fixed_parameters COMMA arglist_modifier",
//t    "formal_parameter_list : parameter_array COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array COMMA error",
//t    "formal_parameter_list : arglist_modifier COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA ARGLIST COMMA error",
//t    "formal_parameter_list : parameter_array",
//t    "formal_parameter_list : arglist_modifier",
//t    "formal_parameter_list : error",
//t    "fixed_parameters : fixed_parameter",
//t    "fixed_parameters : fixed_parameters COMMA fixed_parameter",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER OPEN_BRACKET CLOSE_BRACKET",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type error",
//t    "$$26 :",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER ASSIGN $$26 constant_expression",
//t    "opt_parameter_modifier :",
//t    "opt_parameter_modifier : parameter_modifiers",
//t    "parameter_modifiers : parameter_modifier",
//t    "parameter_modifiers : parameter_modifiers parameter_modifier",
//t    "parameter_modifier : REF",
//t    "parameter_modifier : OUT",
//t    "parameter_modifier : THIS",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER ASSIGN constant_expression",
//t    "parameter_array : opt_attributes params_modifier type error",
//t    "params_modifier : PARAMS",
//t    "params_modifier : PARAMS parameter_modifier",
//t    "params_modifier : PARAMS params_modifier",
//t    "arglist_modifier : ARGLIST",
//t    "$$27 :",
//t    "$$28 :",
//t    "$$29 :",
//t    "property_declaration : opt_attributes opt_modifiers member_type member_declaration_name $$27 OPEN_BRACE $$28 accessor_declarations $$29 CLOSE_BRACE",
//t    "$$30 :",
//t    "$$31 :",
//t    "$$32 :",
//t    "indexer_declaration : opt_attributes opt_modifiers member_type indexer_declaration_name OPEN_BRACKET $$30 opt_formal_parameter_list CLOSE_BRACKET OPEN_BRACE $$31 accessor_declarations $$32 CLOSE_BRACE",
//t    "accessor_declarations : get_accessor_declaration",
//t    "accessor_declarations : get_accessor_declaration accessor_declarations",
//t    "accessor_declarations : set_accessor_declaration",
//t    "accessor_declarations : set_accessor_declaration accessor_declarations",
//t    "accessor_declarations : error",
//t    "$$33 :",
//t    "get_accessor_declaration : opt_attributes opt_modifiers GET $$33 accessor_body",
//t    "$$34 :",
//t    "set_accessor_declaration : opt_attributes opt_modifiers SET $$34 accessor_body",
//t    "accessor_body : block",
//t    "accessor_body : SEMICOLON",
//t    "accessor_body : error",
//t    "$$35 :",
//t    "$$36 :",
//t    "$$37 :",
//t    "$$38 :",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE $$35 type_declaration_name $$36 opt_class_base opt_type_parameter_constraints_clauses $$37 OPEN_BRACE opt_interface_member_declarations CLOSE_BRACE $$38 opt_semicolon",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE error",
//t    "opt_interface_member_declarations :",
//t    "opt_interface_member_declarations : interface_member_declarations",
//t    "interface_member_declarations : interface_member_declaration",
//t    "interface_member_declarations : interface_member_declarations interface_member_declaration",
//t    "interface_member_declaration : constant_declaration",
//t    "interface_member_declaration : field_declaration",
//t    "interface_member_declaration : method_declaration",
//t    "interface_member_declaration : property_declaration",
//t    "interface_member_declaration : event_declaration",
//t    "interface_member_declaration : indexer_declaration",
//t    "interface_member_declaration : operator_declaration",
//t    "interface_member_declaration : constructor_declaration",
//t    "interface_member_declaration : type_declaration",
//t    "$$39 :",
//t    "operator_declaration : opt_attributes opt_modifiers operator_declarator $$39 operator_body",
//t    "operator_body : block",
//t    "operator_body : SEMICOLON",
//t    "operator_type : type_expression_or_array",
//t    "operator_type : VOID",
//t    "$$40 :",
//t    "operator_declarator : operator_type OPERATOR overloadable_operator OPEN_PARENS $$40 opt_formal_parameter_list CLOSE_PARENS",
//t    "operator_declarator : conversion_operator_declarator",
//t    "overloadable_operator : BANG",
//t    "overloadable_operator : TILDE",
//t    "overloadable_operator : OP_INC",
//t    "overloadable_operator : OP_DEC",
//t    "overloadable_operator : TRUE",
//t    "overloadable_operator : FALSE",
//t    "overloadable_operator : PLUS",
//t    "overloadable_operator : MINUS",
//t    "overloadable_operator : STAR",
//t    "overloadable_operator : DIV",
//t    "overloadable_operator : PERCENT",
//t    "overloadable_operator : BITWISE_AND",
//t    "overloadable_operator : BITWISE_OR",
//t    "overloadable_operator : CARRET",
//t    "overloadable_operator : OP_SHIFT_LEFT",
//t    "overloadable_operator : OP_SHIFT_RIGHT",
//t    "overloadable_operator : OP_EQ",
//t    "overloadable_operator : OP_NE",
//t    "overloadable_operator : OP_GT",
//t    "overloadable_operator : OP_LT",
//t    "overloadable_operator : OP_GE",
//t    "overloadable_operator : OP_LE",
//t    "$$41 :",
//t    "conversion_operator_declarator : IMPLICIT OPERATOR type OPEN_PARENS $$41 opt_formal_parameter_list CLOSE_PARENS",
//t    "$$42 :",
//t    "conversion_operator_declarator : EXPLICIT OPERATOR type OPEN_PARENS $$42 opt_formal_parameter_list CLOSE_PARENS",
//t    "conversion_operator_declarator : IMPLICIT error",
//t    "conversion_operator_declarator : EXPLICIT error",
//t    "constructor_declaration : constructor_declarator constructor_body",
//t    "$$43 :",
//t    "$$44 :",
//t    "constructor_declarator : opt_attributes opt_modifiers IDENTIFIER $$43 OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS $$44 opt_constructor_initializer",
//t    "constructor_body : block_prepared",
//t    "constructor_body : SEMICOLON",
//t    "opt_constructor_initializer :",
//t    "opt_constructor_initializer : constructor_initializer",
//t    "$$45 :",
//t    "constructor_initializer : COLON BASE OPEN_PARENS $$45 opt_argument_list CLOSE_PARENS",
//t    "$$46 :",
//t    "constructor_initializer : COLON THIS OPEN_PARENS $$46 opt_argument_list CLOSE_PARENS",
//t    "constructor_initializer : error",
//t    "$$47 :",
//t    "destructor_declaration : opt_attributes opt_modifiers TILDE $$47 IDENTIFIER OPEN_PARENS CLOSE_PARENS method_body",
//t    "$$48 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name $$48 opt_event_initializer opt_event_declarators SEMICOLON",
//t    "$$49 :",
//t    "$$50 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name OPEN_BRACE $$49 event_accessor_declarations $$50 CLOSE_BRACE",
//t    "opt_event_initializer :",
//t    "$$51 :",
//t    "opt_event_initializer : ASSIGN $$51 event_variable_initializer",
//t    "opt_event_declarators :",
//t    "opt_event_declarators : event_declarators",
//t    "event_declarators : event_declarator",
//t    "event_declarators : event_declarators event_declarator",
//t    "event_declarator : COMMA IDENTIFIER",
//t    "$$52 :",
//t    "event_declarator : COMMA IDENTIFIER ASSIGN $$52 event_variable_initializer",
//t    "$$53 :",
//t    "event_variable_initializer : $$53 variable_initializer",
//t    "event_accessor_declarations : add_accessor_declaration remove_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration add_accessor_declaration",
//t    "event_accessor_declarations : add_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration",
//t    "event_accessor_declarations : error",
//t    "$$54 :",
//t    "add_accessor_declaration : opt_attributes opt_modifiers ADD $$54 event_accessor_block",
//t    "$$55 :",
//t    "remove_accessor_declaration : opt_attributes opt_modifiers REMOVE $$55 event_accessor_block",
//t    "event_accessor_block : opt_semicolon",
//t    "event_accessor_block : block",
//t    "$$56 :",
//t    "$$57 :",
//t    "$$58 :",
//t    "$$59 :",
//t    "enum_declaration : opt_attributes opt_modifiers ENUM $$56 type_declaration_name opt_enum_base $$57 OPEN_BRACE $$58 opt_enum_member_declarations $$59 CLOSE_BRACE opt_semicolon",
//t    "opt_enum_base :",
//t    "opt_enum_base : COLON type",
//t    "opt_enum_base : COLON error",
//t    "opt_enum_member_declarations :",
//t    "opt_enum_member_declarations : enum_member_declarations",
//t    "opt_enum_member_declarations : enum_member_declarations COMMA",
//t    "enum_member_declarations : enum_member_declaration",
//t    "enum_member_declarations : enum_member_declarations COMMA enum_member_declaration",
//t    "enum_member_declaration : opt_attributes IDENTIFIER",
//t    "$$60 :",
//t    "enum_member_declaration : opt_attributes IDENTIFIER $$60 ASSIGN constant_expression",
//t    "$$61 :",
//t    "$$62 :",
//t    "$$63 :",
//t    "delegate_declaration : opt_attributes opt_modifiers DELEGATE member_type type_declaration_name OPEN_PARENS $$61 opt_formal_parameter_list CLOSE_PARENS $$62 opt_type_parameter_constraints_clauses $$63 SEMICOLON",
//t    "opt_nullable :",
//t    "opt_nullable : INTERR_NULLABLE",
//t    "namespace_or_type_name : member_name",
//t    "namespace_or_type_name : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "member_name : type_name",
//t    "member_name : namespace_or_type_name DOT IDENTIFIER opt_type_argument_list",
//t    "type_name : IDENTIFIER opt_type_argument_list",
//t    "opt_type_argument_list :",
//t    "opt_type_argument_list : OP_GENERICS_LT type_arguments OP_GENERICS_GT",
//t    "opt_type_argument_list : OP_GENERICS_LT error",
//t    "type_arguments : type",
//t    "type_arguments : type_arguments COMMA type",
//t    "$$64 :",
//t    "type_declaration_name : IDENTIFIER $$64 opt_type_parameter_list",
//t    "member_declaration_name : method_declaration_name",
//t    "method_declaration_name : type_declaration_name",
//t    "method_declaration_name : explicit_interface IDENTIFIER opt_type_parameter_list",
//t    "indexer_declaration_name : THIS",
//t    "indexer_declaration_name : explicit_interface THIS",
//t    "explicit_interface : IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : qualified_alias_member IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : explicit_interface IDENTIFIER opt_type_argument_list DOT",
//t    "opt_type_parameter_list :",
//t    "opt_type_parameter_list : OP_GENERICS_LT_DECL type_parameters OP_GENERICS_GT",
//t    "type_parameters : type_parameter",
//t    "type_parameters : type_parameters COMMA type_parameter",
//t    "type_parameter : opt_attributes opt_type_parameter_variance IDENTIFIER",
//t    "type_parameter : error",
//t    "type_and_void : type_expression_or_array",
//t    "type_and_void : VOID",
//t    "member_type : type_and_void",
//t    "type : type_expression_or_array",
//t    "type : VOID",
//t    "simple_type : type_expression",
//t    "simple_type : VOID",
//t    "parameter_type : type_expression_or_array",
//t    "parameter_type : VOID",
//t    "type_expression_or_array : type_expression",
//t    "type_expression_or_array : type_expression rank_specifiers",
//t    "type_expression : namespace_or_type_name opt_nullable",
//t    "type_expression : namespace_or_type_name pointer_stars",
//t    "type_expression : builtin_types opt_nullable",
//t    "type_expression : builtin_types pointer_stars",
//t    "type_expression : VOID pointer_stars",
//t    "type_list : base_type_name",
//t    "type_list : type_list COMMA base_type_name",
//t    "base_type_name : type",
//t    "base_type_name : error",
//t    "builtin_types : OBJECT",
//t    "builtin_types : STRING",
//t    "builtin_types : BOOL",
//t    "builtin_types : DECIMAL",
//t    "builtin_types : FLOAT",
//t    "builtin_types : DOUBLE",
//t    "builtin_types : integral_type",
//t    "integral_type : SBYTE",
//t    "integral_type : BYTE",
//t    "integral_type : SHORT",
//t    "integral_type : USHORT",
//t    "integral_type : INT",
//t    "integral_type : UINT",
//t    "integral_type : LONG",
//t    "integral_type : ULONG",
//t    "integral_type : CHAR",
//t    "primary_expression : primary_expression_or_type",
//t    "primary_expression : literal",
//t    "primary_expression : array_creation_expression",
//t    "primary_expression : parenthesized_expression",
//t    "primary_expression : default_value_expression",
//t    "primary_expression : invocation_expression",
//t    "primary_expression : element_access",
//t    "primary_expression : this_access",
//t    "primary_expression : base_access",
//t    "primary_expression : post_increment_expression",
//t    "primary_expression : post_decrement_expression",
//t    "primary_expression : object_or_delegate_creation_expression",
//t    "primary_expression : anonymous_type_expression",
//t    "primary_expression : typeof_expression",
//t    "primary_expression : sizeof_expression",
//t    "primary_expression : checked_expression",
//t    "primary_expression : unchecked_expression",
//t    "primary_expression : pointer_member_access",
//t    "primary_expression : anonymous_method_expression",
//t    "primary_expression : undocumented_expressions",
//t    "primary_expression_or_type : IDENTIFIER opt_type_argument_list",
//t    "primary_expression_or_type : IDENTIFIER GENERATE_COMPLETION",
//t    "primary_expression_or_type : member_access",
//t    "literal : boolean_literal",
//t    "literal : LITERAL",
//t    "literal : NULL",
//t    "boolean_literal : TRUE",
//t    "boolean_literal : FALSE",
//t    "open_parens_any : OPEN_PARENS",
//t    "open_parens_any : OPEN_PARENS_CAST",
//t    "close_parens : CLOSE_PARENS",
//t    "close_parens : COMPLETE_COMPLETION",
//t    "parenthesized_expression : OPEN_PARENS expression CLOSE_PARENS",
//t    "parenthesized_expression : OPEN_PARENS expression COMPLETE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : builtin_types DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : BASE DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "member_access : primary_expression DOT GENERATE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT IDENTIFIER GENERATE_COMPLETION",
//t    "invocation_expression : primary_expression open_parens_any opt_argument_list close_parens",
//t    "opt_object_or_collection_initializer :",
//t    "opt_object_or_collection_initializer : object_or_collection_initializer",
//t    "object_or_collection_initializer : OPEN_BRACE opt_member_initializer_list close_brace_or_complete_completion",
//t    "object_or_collection_initializer : OPEN_BRACE member_initializer_list COMMA CLOSE_BRACE",
//t    "opt_member_initializer_list :",
//t    "opt_member_initializer_list : member_initializer_list",
//t    "member_initializer_list : member_initializer",
//t    "member_initializer_list : member_initializer_list COMMA member_initializer",
//t    "member_initializer_list : member_initializer_list error",
//t    "member_initializer : IDENTIFIER ASSIGN initializer_value",
//t    "member_initializer : GENERATE_COMPLETION",
//t    "member_initializer : non_assignment_expression opt_COMPLETE_COMPLETION",
//t    "member_initializer : OPEN_BRACE expression_list CLOSE_BRACE",
//t    "member_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "initializer_value : expression",
//t    "initializer_value : object_or_collection_initializer",
//t    "opt_argument_list :",
//t    "opt_argument_list : argument_list",
//t    "argument_list : argument_or_named_argument",
//t    "argument_list : argument_list COMMA argument",
//t    "argument_list : argument_list COMMA named_argument",
//t    "argument_list : argument_list COMMA",
//t    "argument_list : COMMA error",
//t    "argument : expression",
//t    "argument : non_simple_argument",
//t    "argument_or_named_argument : argument",
//t    "argument_or_named_argument : named_argument",
//t    "non_simple_argument : REF variable_reference",
//t    "non_simple_argument : OUT variable_reference",
//t    "non_simple_argument : ARGLIST OPEN_PARENS argument_list CLOSE_PARENS",
//t    "non_simple_argument : ARGLIST OPEN_PARENS CLOSE_PARENS",
//t    "variable_reference : expression",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "expression_list : expression",
//t    "expression_list : expression_list COMMA expression",
//t    "expression_list : expression_list error",
//t    "expression_list_arguments : expression_list_argument",
//t    "expression_list_arguments : expression_list_arguments COMMA expression_list_argument",
//t    "expression_list_argument : expression",
//t    "expression_list_argument : named_argument",
//t    "this_access : THIS",
//t    "base_access : BASE OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "base_access : BASE OPEN_BRACKET error",
//t    "post_increment_expression : primary_expression OP_INC",
//t    "post_decrement_expression : primary_expression OP_DEC",
//t    "object_or_delegate_creation_expression : NEW new_expr_type open_parens_any opt_argument_list CLOSE_PARENS opt_object_or_collection_initializer",
//t    "object_or_delegate_creation_expression : NEW new_expr_type object_or_collection_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET_EXPR expression_list CLOSE_BRACKET opt_rank_specifier opt_array_initializer",
//t    "array_creation_expression : NEW new_expr_type rank_specifiers opt_array_initializer",
//t    "array_creation_expression : NEW rank_specifier array_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET CLOSE_BRACKET OPEN_BRACKET_EXPR error CLOSE_BRACKET",
//t    "array_creation_expression : NEW new_expr_type error",
//t    "$$65 :",
//t    "new_expr_type : $$65 simple_type",
//t    "anonymous_type_expression : NEW OPEN_BRACE anonymous_type_parameters_opt_comma CLOSE_BRACE",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters_opt",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters COMMA",
//t    "anonymous_type_parameters_opt :",
//t    "anonymous_type_parameters_opt : anonymous_type_parameters",
//t    "anonymous_type_parameters : anonymous_type_parameter",
//t    "anonymous_type_parameters : anonymous_type_parameters COMMA anonymous_type_parameter",
//t    "anonymous_type_parameter : IDENTIFIER ASSIGN variable_initializer",
//t    "anonymous_type_parameter : IDENTIFIER",
//t    "anonymous_type_parameter : member_access",
//t    "anonymous_type_parameter : error",
//t    "opt_rank_specifier :",
//t    "opt_rank_specifier : rank_specifiers",
//t    "rank_specifiers : rank_specifier",
//t    "rank_specifiers : rank_specifier rank_specifiers",
//t    "rank_specifier : OPEN_BRACKET CLOSE_BRACKET",
//t    "rank_specifier : OPEN_BRACKET dim_separators CLOSE_BRACKET",
//t    "dim_separators : COMMA",
//t    "dim_separators : dim_separators COMMA",
//t    "opt_array_initializer :",
//t    "opt_array_initializer : array_initializer",
//t    "array_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "array_initializer : OPEN_BRACE variable_initializer_list opt_comma CLOSE_BRACE",
//t    "variable_initializer_list : variable_initializer",
//t    "variable_initializer_list : variable_initializer_list COMMA variable_initializer",
//t    "$$66 :",
//t    "typeof_expression : TYPEOF $$66 open_parens_any typeof_type_expression CLOSE_PARENS",
//t    "typeof_type_expression : type_and_void",
//t    "typeof_type_expression : unbound_type_name",
//t    "typeof_type_expression : error",
//t    "unbound_type_name : IDENTIFIER generic_dimension",
//t    "unbound_type_name : qualified_alias_member IDENTIFIER generic_dimension",
//t    "unbound_type_name : unbound_type_name DOT IDENTIFIER",
//t    "unbound_type_name : unbound_type_name DOT IDENTIFIER generic_dimension",
//t    "unbound_type_name : namespace_or_type_name DOT IDENTIFIER generic_dimension",
//t    "generic_dimension : GENERIC_DIMENSION",
//t    "qualified_alias_member : IDENTIFIER DOUBLE_COLON",
//t    "sizeof_expression : SIZEOF open_parens_any type CLOSE_PARENS",
//t    "checked_expression : CHECKED open_parens_any expression CLOSE_PARENS",
//t    "unchecked_expression : UNCHECKED open_parens_any expression CLOSE_PARENS",
//t    "pointer_member_access : primary_expression OP_PTR IDENTIFIER opt_type_argument_list",
//t    "$$67 :",
//t    "anonymous_method_expression : DELEGATE opt_anonymous_method_signature $$67 block",
//t    "$$68 :",
//t    "anonymous_method_expression : ASYNC DELEGATE opt_anonymous_method_signature $$68 block",
//t    "opt_anonymous_method_signature :",
//t    "opt_anonymous_method_signature : anonymous_method_signature",
//t    "$$69 :",
//t    "anonymous_method_signature : OPEN_PARENS $$69 opt_formal_parameter_list CLOSE_PARENS",
//t    "default_value_expression : DEFAULT open_parens_any type CLOSE_PARENS",
//t    "unary_expression : primary_expression",
//t    "unary_expression : BANG prefixed_unary_expression",
//t    "unary_expression : TILDE prefixed_unary_expression",
//t    "unary_expression : cast_expression",
//t    "unary_expression : await_expression",
//t    "cast_expression : OPEN_PARENS_CAST type CLOSE_PARENS prefixed_unary_expression",
//t    "await_expression : AWAIT unary_expression",
//t    "prefixed_unary_expression : unary_expression",
//t    "prefixed_unary_expression : PLUS prefixed_unary_expression",
//t    "prefixed_unary_expression : MINUS prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_INC prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_DEC prefixed_unary_expression",
//t    "prefixed_unary_expression : STAR prefixed_unary_expression",
//t    "prefixed_unary_expression : BITWISE_AND prefixed_unary_expression",
//t    "multiplicative_expression : prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression DIV prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression PERCENT prefixed_unary_expression",
//t    "additive_expression : multiplicative_expression",
//t    "additive_expression : additive_expression PLUS multiplicative_expression",
//t    "additive_expression : additive_expression MINUS multiplicative_expression",
//t    "additive_expression : parenthesized_expression MINUS multiplicative_expression",
//t    "additive_expression : additive_expression AS type",
//t    "additive_expression : additive_expression IS type",
//t    "shift_expression : additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT additive_expression",
//t    "relational_expression : shift_expression",
//t    "relational_expression : relational_expression OP_LT shift_expression",
//t    "relational_expression : relational_expression OP_GT shift_expression",
//t    "relational_expression : relational_expression OP_LE shift_expression",
//t    "relational_expression : relational_expression OP_GE shift_expression",
//t    "equality_expression : relational_expression",
//t    "equality_expression : equality_expression OP_EQ relational_expression",
//t    "equality_expression : equality_expression OP_NE relational_expression",
//t    "and_expression : equality_expression",
//t    "and_expression : and_expression BITWISE_AND equality_expression",
//t    "exclusive_or_expression : and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET and_expression",
//t    "inclusive_or_expression : exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR exclusive_or_expression",
//t    "conditional_and_expression : inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND inclusive_or_expression",
//t    "conditional_or_expression : conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR conditional_and_expression",
//t    "null_coalescing_expression : conditional_or_expression",
//t    "null_coalescing_expression : conditional_or_expression OP_COALESCING null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON expression",
//t    "assignment_expression : prefixed_unary_expression ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MULT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_DIV_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MOD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_ADD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SUB_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_LEFT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_RIGHT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_AND_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_OR_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_XOR_ASSIGN expression",
//t    "lambda_parameter_list : lambda_parameter",
//t    "lambda_parameter_list : lambda_parameter_list COMMA lambda_parameter",
//t    "lambda_parameter : parameter_modifier parameter_type IDENTIFIER",
//t    "lambda_parameter : parameter_type IDENTIFIER",
//t    "lambda_parameter : IDENTIFIER",
//t    "opt_lambda_parameter_list :",
//t    "opt_lambda_parameter_list : lambda_parameter_list",
//t    "lambda_expression_body : lambda_expression_body_simple",
//t    "lambda_expression_body : block",
//t    "$$70 :",
//t    "lambda_expression_body_simple : $$70 expression_or_error",
//t    "expression_or_error : expression",
//t    "expression_or_error : error",
//t    "$$71 :",
//t    "lambda_expression : IDENTIFIER ARROW $$71 lambda_expression_body",
//t    "$$72 :",
//t    "lambda_expression : ASYNC IDENTIFIER ARROW $$72 lambda_expression_body",
//t    "$$73 :",
//t    "$$74 :",
//t    "lambda_expression : OPEN_PARENS_LAMBDA $$73 opt_lambda_parameter_list CLOSE_PARENS ARROW $$74 lambda_expression_body",
//t    "$$75 :",
//t    "$$76 :",
//t    "lambda_expression : ASYNC OPEN_PARENS_LAMBDA $$75 opt_lambda_parameter_list CLOSE_PARENS ARROW $$76 lambda_expression_body",
//t    "expression : assignment_expression",
//t    "expression : non_assignment_expression",
//t    "non_assignment_expression : conditional_expression",
//t    "non_assignment_expression : lambda_expression",
//t    "non_assignment_expression : query_expression",
//t    "non_assignment_expression : ARGLIST",
//t    "undocumented_expressions : REFVALUE OPEN_PARENS non_assignment_expression COMMA type CLOSE_PARENS",
//t    "undocumented_expressions : REFTYPE open_parens_any expression CLOSE_PARENS",
//t    "undocumented_expressions : MAKEREF open_parens_any expression CLOSE_PARENS",
//t    "constant_expression : expression",
//t    "boolean_expression : expression",
//t    "$$77 :",
//t    "$$78 :",
//t    "$$79 :",
//t    "$$80 :",
//t    "class_declaration : opt_attributes opt_modifiers opt_partial CLASS $$77 type_declaration_name $$78 opt_class_base opt_type_parameter_constraints_clauses $$79 OPEN_BRACE opt_class_member_declarations CLOSE_BRACE $$80 opt_semicolon",
//t    "opt_partial :",
//t    "opt_partial : PARTIAL",
//t    "opt_modifiers :",
//t    "opt_modifiers : modifiers",
//t    "modifiers : modifier",
//t    "modifiers : modifiers modifier",
//t    "modifier : NEW",
//t    "modifier : PUBLIC",
//t    "modifier : PROTECTED",
//t    "modifier : INTERNAL",
//t    "modifier : PRIVATE",
//t    "modifier : ABSTRACT",
//t    "modifier : SEALED",
//t    "modifier : STATIC",
//t    "modifier : READONLY",
//t    "modifier : VIRTUAL",
//t    "modifier : OVERRIDE",
//t    "modifier : EXTERN",
//t    "modifier : VOLATILE",
//t    "modifier : UNSAFE",
//t    "modifier : ASYNC",
//t    "opt_class_base :",
//t    "opt_class_base : COLON type_list",
//t    "opt_type_parameter_constraints_clauses :",
//t    "opt_type_parameter_constraints_clauses : type_parameter_constraints_clauses",
//t    "opt_type_parameter_constraints_clauses : error",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clause",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clauses type_parameter_constraints_clause",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER COLON type_parameter_constraints",
//t    "type_parameter_constraints : type_parameter_constraint",
//t    "type_parameter_constraints : type_parameter_constraints COMMA type_parameter_constraint",
//t    "type_parameter_constraint : type",
//t    "type_parameter_constraint : NEW OPEN_PARENS CLOSE_PARENS",
//t    "type_parameter_constraint : CLASS",
//t    "type_parameter_constraint : STRUCT",
//t    "opt_type_parameter_variance :",
//t    "opt_type_parameter_variance : type_parameter_variance",
//t    "type_parameter_variance : OUT",
//t    "type_parameter_variance : IN",
//t    "$$81 :",
//t    "block : OPEN_BRACE $$81 opt_statement_list block_end",
//t    "block_end : CLOSE_BRACE",
//t    "block_end : COMPLETE_COMPLETION",
//t    "$$82 :",
//t    "block_prepared : OPEN_BRACE $$82 opt_statement_list CLOSE_BRACE",
//t    "opt_statement_list :",
//t    "opt_statement_list : statement_list",
//t    "statement_list : statement",
//t    "statement_list : statement_list statement",
//t    "statement : block_variable_declaration",
//t    "statement : valid_declaration_statement",
//t    "statement : labeled_statement",
//t    "statement : error",
//t    "interactive_statement_list : interactive_statement",
//t    "interactive_statement_list : interactive_statement_list interactive_statement",
//t    "interactive_statement : block_variable_declaration",
//t    "interactive_statement : interactive_valid_declaration_statement",
//t    "interactive_statement : labeled_statement",
//t    "valid_declaration_statement : block",
//t    "valid_declaration_statement : empty_statement",
//t    "valid_declaration_statement : expression_statement",
//t    "valid_declaration_statement : selection_statement",
//t    "valid_declaration_statement : iteration_statement",
//t    "valid_declaration_statement : jump_statement",
//t    "valid_declaration_statement : try_statement",
//t    "valid_declaration_statement : checked_statement",
//t    "valid_declaration_statement : unchecked_statement",
//t    "valid_declaration_statement : lock_statement",
//t    "valid_declaration_statement : using_statement",
//t    "valid_declaration_statement : unsafe_statement",
//t    "valid_declaration_statement : fixed_statement",
//t    "interactive_valid_declaration_statement : block",
//t    "interactive_valid_declaration_statement : empty_statement",
//t    "interactive_valid_declaration_statement : interactive_expression_statement",
//t    "interactive_valid_declaration_statement : selection_statement",
//t    "interactive_valid_declaration_statement : iteration_statement",
//t    "interactive_valid_declaration_statement : jump_statement",
//t    "interactive_valid_declaration_statement : try_statement",
//t    "interactive_valid_declaration_statement : checked_statement",
//t    "interactive_valid_declaration_statement : unchecked_statement",
//t    "interactive_valid_declaration_statement : lock_statement",
//t    "interactive_valid_declaration_statement : using_statement",
//t    "interactive_valid_declaration_statement : unsafe_statement",
//t    "interactive_valid_declaration_statement : fixed_statement",
//t    "embedded_statement : valid_declaration_statement",
//t    "embedded_statement : block_variable_declaration",
//t    "embedded_statement : labeled_statement",
//t    "embedded_statement : error",
//t    "empty_statement : SEMICOLON",
//t    "$$83 :",
//t    "labeled_statement : IDENTIFIER COLON $$83 statement",
//t    "variable_type : variable_type_simple",
//t    "variable_type : variable_type_simple rank_specifiers",
//t    "variable_type_simple : primary_expression_or_type opt_nullable",
//t    "variable_type_simple : primary_expression_or_type pointer_stars",
//t    "variable_type_simple : builtin_types opt_nullable",
//t    "variable_type_simple : builtin_types pointer_stars",
//t    "variable_type_simple : VOID pointer_stars",
//t    "variable_type_simple : VOID",
//t    "pointer_stars : pointer_star",
//t    "pointer_stars : pointer_star pointer_stars",
//t    "pointer_star : STAR",
//t    "$$84 :",
//t    "block_variable_declaration : variable_type IDENTIFIER $$84 opt_local_variable_initializer opt_variable_declarators SEMICOLON",
//t    "$$85 :",
//t    "block_variable_declaration : CONST variable_type IDENTIFIER $$85 const_variable_initializer opt_const_declarators SEMICOLON",
//t    "opt_local_variable_initializer :",
//t    "opt_local_variable_initializer : ASSIGN block_variable_initializer",
//t    "opt_local_variable_initializer : error",
//t    "opt_variable_declarators :",
//t    "opt_variable_declarators : variable_declarators",
//t    "opt_using_or_fixed_variable_declarators :",
//t    "opt_using_or_fixed_variable_declarators : variable_declarators",
//t    "variable_declarators : variable_declarator",
//t    "variable_declarators : variable_declarators variable_declarator",
//t    "variable_declarator : COMMA IDENTIFIER",
//t    "variable_declarator : COMMA IDENTIFIER ASSIGN block_variable_initializer",
//t    "const_variable_initializer :",
//t    "const_variable_initializer : ASSIGN constant_initializer_expr",
//t    "opt_const_declarators :",
//t    "opt_const_declarators : const_declarators",
//t    "const_declarators : const_declarator",
//t    "const_declarators : const_declarators const_declarator",
//t    "const_declarator : COMMA IDENTIFIER ASSIGN constant_initializer_expr",
//t    "block_variable_initializer : variable_initializer",
//t    "block_variable_initializer : STACKALLOC simple_type OPEN_BRACKET_EXPR expression CLOSE_BRACKET",
//t    "block_variable_initializer : STACKALLOC simple_type",
//t    "expression_statement : statement_expression SEMICOLON",
//t    "expression_statement : statement_expression COMPLETE_COMPLETION",
//t    "interactive_expression_statement : interactive_statement_expression SEMICOLON",
//t    "interactive_expression_statement : interactive_statement_expression COMPLETE_COMPLETION",
//t    "statement_expression : expression",
//t    "interactive_statement_expression : expression",
//t    "interactive_statement_expression : error",
//t    "selection_statement : if_statement",
//t    "selection_statement : switch_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement ELSE embedded_statement",
//t    "$$86 :",
//t    "switch_statement : SWITCH open_parens_any expression CLOSE_PARENS OPEN_BRACE $$86 opt_switch_sections CLOSE_BRACE",
//t    "opt_switch_sections :",
//t    "opt_switch_sections : switch_sections",
//t    "switch_sections : switch_section",
//t    "switch_sections : switch_sections switch_section",
//t    "switch_sections : error",
//t    "$$87 :",
//t    "switch_section : switch_labels $$87 statement_list",
//t    "switch_labels : switch_label",
//t    "switch_labels : switch_labels switch_label",
//t    "switch_label : CASE constant_expression COLON",
//t    "switch_label : DEFAULT_COLON",
//t    "iteration_statement : while_statement",
//t    "iteration_statement : do_statement",
//t    "iteration_statement : for_statement",
//t    "iteration_statement : foreach_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression CLOSE_PARENS SEMICOLON",
//t    "$$88 :",
//t    "for_statement : FOR open_parens_any $$88 for_statement_cont",
//t    "for_statement_cont : opt_for_initializer SEMICOLON opt_for_condition SEMICOLON opt_for_iterator CLOSE_PARENS embedded_statement",
//t    "for_statement_cont : error",
//t    "opt_for_initializer :",
//t    "opt_for_initializer : for_initializer",
//t    "$$89 :",
//t    "for_initializer : variable_type IDENTIFIER $$89 opt_local_variable_initializer opt_variable_declarators",
//t    "for_initializer : statement_expression_list",
//t    "opt_for_condition :",
//t    "opt_for_condition : boolean_expression",
//t    "opt_for_iterator :",
//t    "opt_for_iterator : for_iterator",
//t    "for_iterator : statement_expression_list",
//t    "statement_expression_list : statement_expression",
//t    "statement_expression_list : statement_expression_list COMMA statement_expression",
//t    "foreach_statement : FOREACH open_parens_any type IN expression CLOSE_PARENS",
//t    "$$90 :",
//t    "foreach_statement : FOREACH open_parens_any type IDENTIFIER IN expression CLOSE_PARENS $$90 embedded_statement",
//t    "jump_statement : break_statement",
//t    "jump_statement : continue_statement",
//t    "jump_statement : goto_statement",
//t    "jump_statement : return_statement",
//t    "jump_statement : throw_statement",
//t    "jump_statement : yield_statement",
//t    "break_statement : BREAK SEMICOLON",
//t    "continue_statement : CONTINUE SEMICOLON",
//t    "goto_statement : GOTO IDENTIFIER SEMICOLON",
//t    "goto_statement : GOTO CASE constant_expression SEMICOLON",
//t    "goto_statement : GOTO DEFAULT SEMICOLON",
//t    "return_statement : RETURN opt_expression SEMICOLON",
//t    "throw_statement : THROW opt_expression SEMICOLON",
//t    "yield_statement : IDENTIFIER RETURN opt_expression SEMICOLON",
//t    "yield_statement : IDENTIFIER BREAK SEMICOLON",
//t    "opt_expression :",
//t    "opt_expression : expression",
//t    "try_statement : TRY block catch_clauses",
//t    "try_statement : TRY block FINALLY block",
//t    "try_statement : TRY block catch_clauses FINALLY block",
//t    "try_statement : TRY block error",
//t    "catch_clauses : catch_clause",
//t    "catch_clauses : catch_clauses catch_clause",
//t    "opt_identifier :",
//t    "opt_identifier : IDENTIFIER",
//t    "catch_clause : CATCH block",
//t    "$$91 :",
//t    "catch_clause : CATCH open_parens_any type opt_identifier CLOSE_PARENS $$91 block_prepared",
//t    "catch_clause : CATCH open_parens_any error",
//t    "checked_statement : CHECKED block",
//t    "unchecked_statement : UNCHECKED block",
//t    "$$92 :",
//t    "unsafe_statement : UNSAFE $$92 block",
//t    "lock_statement : LOCK open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "$$93 :",
//t    "$$94 :",
//t    "fixed_statement : FIXED open_parens_any variable_type IDENTIFIER $$93 using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators CLOSE_PARENS $$94 embedded_statement",
//t    "$$95 :",
//t    "$$96 :",
//t    "using_statement : USING open_parens_any variable_type IDENTIFIER $$95 using_or_fixed_variable_initializer opt_using_or_fixed_variable_declarators CLOSE_PARENS $$96 embedded_statement",
//t    "using_statement : USING open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "using_or_fixed_variable_initializer :",
//t    "using_or_fixed_variable_initializer : ASSIGN variable_initializer",
//t    "query_expression : first_from_clause query_body",
//t    "query_expression : nested_from_clause query_body",
//t    "query_expression : first_from_clause COMPLETE_COMPLETION",
//t    "query_expression : nested_from_clause COMPLETE_COMPLETION",
//t    "first_from_clause : FROM_FIRST IDENTIFIER IN expression",
//t    "first_from_clause : FROM_FIRST type IDENTIFIER IN expression",
//t    "nested_from_clause : FROM IDENTIFIER IN expression",
//t    "nested_from_clause : FROM type IDENTIFIER IN expression",
//t    "$$97 :",
//t    "from_clause : FROM IDENTIFIER IN $$97 expression",
//t    "$$98 :",
//t    "from_clause : FROM type IDENTIFIER IN $$98 expression",
//t    "query_body : opt_query_body_clauses select_or_group_clause opt_query_continuation",
//t    "query_body : opt_query_body_clauses COMPLETE_COMPLETION",
//t    "query_body : error",
//t    "$$99 :",
//t    "select_or_group_clause : SELECT $$99 expression",
//t    "$$100 :",
//t    "$$101 :",
//t    "select_or_group_clause : GROUP $$100 expression $$101 BY expression",
//t    "opt_query_body_clauses :",
//t    "opt_query_body_clauses : query_body_clauses",
//t    "query_body_clauses : query_body_clause",
//t    "query_body_clauses : query_body_clauses query_body_clause",
//t    "query_body_clause : from_clause",
//t    "query_body_clause : let_clause",
//t    "query_body_clause : where_clause",
//t    "query_body_clause : join_clause",
//t    "query_body_clause : orderby_clause",
//t    "$$102 :",
//t    "let_clause : LET IDENTIFIER ASSIGN $$102 expression",
//t    "$$103 :",
//t    "where_clause : WHERE $$103 expression",
//t    "$$104 :",
//t    "$$105 :",
//t    "$$106 :",
//t    "join_clause : JOIN IDENTIFIER IN $$104 expression ON $$105 expression EQUALS $$106 expression opt_join_into",
//t    "$$107 :",
//t    "$$108 :",
//t    "$$109 :",
//t    "join_clause : JOIN type IDENTIFIER IN $$107 expression ON $$108 expression EQUALS $$109 expression opt_join_into",
//t    "opt_join_into :",
//t    "opt_join_into : INTO IDENTIFIER",
//t    "$$110 :",
//t    "orderby_clause : ORDERBY $$110 orderings",
//t    "orderings : order_by",
//t    "$$111 :",
//t    "orderings : order_by COMMA $$111 orderings_then_by",
//t    "orderings_then_by : then_by",
//t    "$$112 :",
//t    "orderings_then_by : orderings_then_by COMMA $$112 then_by",
//t    "order_by : expression",
//t    "order_by : expression ASCENDING",
//t    "order_by : expression DESCENDING",
//t    "then_by : expression",
//t    "then_by : expression ASCENDING",
//t    "then_by : expression DESCENDING",
//t    "opt_query_continuation :",
//t    "$$113 :",
//t    "opt_query_continuation : INTO IDENTIFIER $$113 query_body",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER EOF",
//t    "interactive_parsing : EVAL_USING_DECLARATIONS_UNIT_PARSER using_directives opt_COMPLETE_COMPLETION",
//t    "$$114 :",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER $$114 interactive_statement_list opt_COMPLETE_COMPLETION",
//t    "interactive_parsing : EVAL_COMPILATION_UNIT_PARSER interactive_compilation_unit",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations",
//t    "opt_COMPLETE_COMPLETION :",
//t    "opt_COMPLETE_COMPLETION : COMPLETE_COMPLETION",
//t    "close_brace_or_complete_completion : CLOSE_BRACE",
//t    "close_brace_or_complete_completion : COMPLETE_COMPLETION",
//t    "documentation_parsing : DOC_SEE doc_cref",
//t    "doc_cref : doc_type_declaration_name opt_doc_method_sig",
//t    "doc_cref : builtin_types opt_doc_method_sig",
//t    "doc_cref : builtin_types DOT IDENTIFIER opt_doc_method_sig",
//t    "doc_cref : doc_type_declaration_name DOT THIS",
//t    "$$115 :",
//t    "doc_cref : doc_type_declaration_name DOT THIS OPEN_BRACKET $$115 opt_doc_parameters CLOSE_BRACKET",
//t    "doc_cref : EXPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : IMPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : OPERATOR overloadable_operator opt_doc_method_sig",
//t    "doc_type_declaration_name : type_declaration_name",
//t    "doc_type_declaration_name : doc_type_declaration_name DOT type_declaration_name",
//t    "opt_doc_method_sig :",
//t    "$$116 :",
//t    "opt_doc_method_sig : OPEN_PARENS $$116 opt_doc_parameters CLOSE_PARENS",
//t    "opt_doc_parameters :",
//t    "opt_doc_parameters : doc_parameters",
//t    "doc_parameters : doc_parameter",
//t    "doc_parameters : doc_parameters COMMA doc_parameter",
//t    "doc_parameter : opt_parameter_modifier parameter_type",
//t  };
//t public static string getRule (int index) {
//t    return yyRule [index];
//t }
//t}
  protected static readonly string [] yyNames = {    
    "end-of-file",null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,"EOF","NONE","ERROR",
    "FIRST_KEYWORD","ABSTRACT","AS","ADD","BASE","BOOL","BREAK","BYTE",
    "CASE","CATCH","CHAR","CHECKED","CLASS","CONST","CONTINUE","DECIMAL",
    "DEFAULT","DELEGATE","DO","DOUBLE","ELSE","ENUM","EVENT","EXPLICIT",
    "EXTERN","FALSE","FINALLY","FIXED","FLOAT","FOR","FOREACH","GOTO",
    "IF","IMPLICIT","IN","INT","INTERFACE","INTERNAL","IS","LOCK","LONG",
    "NAMESPACE","NEW","NULL","OBJECT","OPERATOR","OUT","OVERRIDE",
    "PARAMS","PRIVATE","PROTECTED","PUBLIC","READONLY","REF","RETURN",
    "REMOVE","SBYTE","SEALED","SHORT","SIZEOF","STACKALLOC","STATIC",
    "STRING","STRUCT","SWITCH","THIS","THROW","TRUE","TRY","TYPEOF",
    "UINT","ULONG","UNCHECKED","UNSAFE","USHORT","USING","VIRTUAL","VOID",
    "VOLATILE","WHERE","WHILE","ARGLIST","PARTIAL","ARROW","FROM",
    "FROM_FIRST","JOIN","ON","EQUALS","SELECT","GROUP","BY","LET",
    "ORDERBY","ASCENDING","DESCENDING","INTO","INTERR_NULLABLE",
    "EXTERN_ALIAS","REFVALUE","REFTYPE","MAKEREF","ASYNC","AWAIT","GET",
    "SET","LAST_KEYWORD","OPEN_BRACE","CLOSE_BRACE","OPEN_BRACKET",
    "CLOSE_BRACKET","OPEN_PARENS","CLOSE_PARENS","DOT","COMMA","COLON",
    "SEMICOLON","TILDE","PLUS","MINUS","BANG","ASSIGN","OP_LT","OP_GT",
    "BITWISE_AND","BITWISE_OR","STAR","PERCENT","DIV","CARRET","INTERR",
    "DOUBLE_COLON","OP_INC","OP_DEC","OP_SHIFT_LEFT","OP_SHIFT_RIGHT",
    "OP_LE","OP_GE","OP_EQ","OP_NE","OP_AND","OP_OR","OP_MULT_ASSIGN",
    "OP_DIV_ASSIGN","OP_MOD_ASSIGN","OP_ADD_ASSIGN","OP_SUB_ASSIGN",
    "OP_SHIFT_LEFT_ASSIGN","OP_SHIFT_RIGHT_ASSIGN","OP_AND_ASSIGN",
    "OP_XOR_ASSIGN","OP_OR_ASSIGN","OP_PTR","OP_COALESCING",
    "OP_GENERICS_LT","OP_GENERICS_LT_DECL","OP_GENERICS_GT","LITERAL",
    "IDENTIFIER","OPEN_PARENS_LAMBDA","OPEN_PARENS_CAST",
    "GENERIC_DIMENSION","DEFAULT_COLON","OPEN_BRACKET_EXPR",
    "EVAL_STATEMENT_PARSER","EVAL_COMPILATION_UNIT_PARSER",
    "EVAL_USING_DECLARATIONS_UNIT_PARSER","DOC_SEE","GENERATE_COMPLETION",
    "COMPLETE_COMPLETION","UMINUS",
  };

  /** index-checked interface to yyNames[].
      @param token single character or %token value.
      @return token name or [illegal] or [unknown].
    */
//t  public static string yyname (int token) {
//t    if ((token < 0) || (token > yyNames.Length)) return "[illegal]";
//t    string name;
//t    if ((name = yyNames[token]) != null) return name;
//t    return "[unknown]";
//t  }

  int yyExpectingState;
  /** computes list of expected tokens on error by tracing the tables.
      @param state for which to compute the list.
      @return list of token names.
    */
  protected int [] yyExpectingTokens (int state){
    int token, n, len = 0;
    bool[] ok = new bool[yyNames.Length];
    if ((n = yySindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    if ((n = yyRindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    int [] result = new int [len];
    for (n = token = 0; n < len;  ++ token)
      if (ok[token]) result[n++] = token;
    return result;
  }
  protected string[] yyExpecting (int state) {
    int [] tokens = yyExpectingTokens (state);
    string [] result = new string[tokens.Length];
    for (int n = 0; n < tokens.Length;  n++)
      result[n++] = yyNames[tokens [n]];
    return result;
  }

  /** the generated parser, with debugging messages.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @param yydebug debug message writer implementing yyDebug, or null.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex, Object yyd)
				 {
//t    this.debug = (yydebug.yyDebug)yyd;
    return yyparse(yyLex);
  }

  /** initial size and increment of the state/value stack [default 256].
      This is not final so that it can be overwritten outside of invocations
      of yyparse().
    */
  protected int yyMax;

  /** executed at the beginning of a reduce action.
      Used as $$ = yyDefault($1), prior to the user-specified action, if any.
      Can be overwritten to provide deep copy, etc.
      @param first value for $1, or null.
      @return first.
    */
  protected Object yyDefault (Object first) {
    return first;
  }

	static int[] global_yyStates;
	static object[] global_yyVals;
	protected bool use_global_stacks;
	object[] yyVals;					// value stack
	object yyVal;						// value stack ptr
	int yyToken;						// current input
	int yyTop;

  /** the generated parser.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex)
  {
    if (yyMax <= 0) yyMax = 256;		// initial size
    int yyState = 0;                   // state stack ptr
    int [] yyStates;               	// state stack 
    yyVal = null;
    yyToken = -1;
    int yyErrorFlag = 0;				// #tks to shift
	if (use_global_stacks && global_yyStates != null) {
		yyVals = global_yyVals;
		yyStates = global_yyStates;
   } else {
		yyVals = new object [yyMax];
		yyStates = new int [yyMax];
		if (use_global_stacks) {
			global_yyVals = yyVals;
			global_yyStates = yyStates;
		}
	}

    /*yyLoop:*/ for (yyTop = 0;; ++ yyTop) {
      if (yyTop >= yyStates.Length) {			// dynamically increase
        global::System.Array.Resize (ref yyStates, yyStates.Length+yyMax);
        global::System.Array.Resize (ref yyVals, yyVals.Length+yyMax);
      }
      yyStates[yyTop] = yyState;
      yyVals[yyTop] = yyVal;
//t      if (debug != null) debug.push(yyState, yyVal);

      /*yyDiscarded:*/ while (true) {	// discarding a token does not change stack
        int yyN;
        if ((yyN = yyDefRed[yyState]) == 0) {	// else [default] reduce (yyN)
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t              debug.lex(yyState, yyToken, yyname(yyToken), yyLex.value());
          }
          if ((yyN = yySindex[yyState]) != 0 && ((yyN += yyToken) >= 0)
              && (yyN < yyTable.Length) && (yyCheck[yyN] == yyToken)) {
//t            if (debug != null)
//t              debug.shift(yyState, yyTable[yyN], yyErrorFlag-1);
            yyState = yyTable[yyN];		// shift to yyN
            yyVal = yyLex.value();
            yyToken = -1;
            if (yyErrorFlag > 0) -- yyErrorFlag;
            goto continue_yyLoop;
          }
          if ((yyN = yyRindex[yyState]) != 0 && (yyN += yyToken) >= 0
              && yyN < yyTable.Length && yyCheck[yyN] == yyToken)
            yyN = yyTable[yyN];			// reduce (yyN)
          else
            switch (yyErrorFlag) {
  
            case 0:
              yyExpectingState = yyState;
              // yyerror(String.Format ("syntax error, got token `{0}'", yyname (yyToken)), yyExpecting(yyState));
//t              if (debug != null) debug.error("syntax error");
              if (yyToken == 0 /*eof*/ || yyToken == eof_token) throw new yyParser.yyUnexpectedEof ();
              goto case 1;
            case 1: case 2:
              yyErrorFlag = 3;
              do {
                if ((yyN = yySindex[yyStates[yyTop]]) != 0
                    && (yyN += Token.yyErrorCode) >= 0 && yyN < yyTable.Length
                    && yyCheck[yyN] == Token.yyErrorCode) {
//t                  if (debug != null)
//t                    debug.shift(yyStates[yyTop], yyTable[yyN], 3);
                  yyState = yyTable[yyN];
                  yyVal = yyLex.value();
                  goto continue_yyLoop;
                }
//t                if (debug != null) debug.pop(yyStates[yyTop]);
              } while (-- yyTop >= 0);
//t              if (debug != null) debug.reject();
              throw new yyParser.yyException("irrecoverable syntax error");
  
            case 3:
              if (yyToken == 0) {
//t                if (debug != null) debug.reject();
                throw new yyParser.yyException("irrecoverable syntax error at end-of-file");
              }
//t              if (debug != null)
//t                debug.discard(yyState, yyToken, yyname(yyToken),
//t  							yyLex.value());
              yyToken = -1;
              goto continue_yyDiscarded;		// leave stack alone
            }
        }
        int yyV = yyTop + 1-yyLen[yyN];
//t        if (debug != null)
//t          debug.reduce(yyState, yyStates[yyV-1], yyN, YYRules.getRule (yyN), yyLen[yyN]);
        yyVal = yyV > yyTop ? null : yyVals[yyV]; // yyVal = yyDefault(yyV > yyTop ? null : yyVals[yyV]);
        switch (yyN) {
case 1:
#line 400 "cs-parser.jay"
  {
		Lexer.check_incorrect_doc_comment ();
	  }
  break;
case 2:
#line 401 "cs-parser.jay"
  { Lexer.CompleteOnEOF = false; }
  break;
case 6:
  case_6();
  break;
case 7:
#line 418 "cs-parser.jay"
  {
		module.AddAttributes ((Attributes) yyVals[0+yyTop], current_namespace);
	  }
  break;
case 8:
  case_8();
  break;
case 13:
  case_13();
  break;
case 14:
#line 456 "cs-parser.jay"
  {
	  	syntax_error (GetLocation (yyVals[-1+yyTop]), "`alias' expected");   /* TODO: better*/
	  }
  break;
case 17:
  case_17();
  break;
case 18:
  case_18();
  break;
case 19:
  case_19();
  break;
case 20:
  case_20();
  break;
case 21:
  case_21();
  break;
case 22:
  case_22();
  break;
case 23:
  case_23();
  break;
case 24:
  case_24();
  break;
case 25:
  case_25();
  break;
case 26:
  case_26();
  break;
case 27:
  case_27();
  break;
case 32:
  case_32();
  break;
case 41:
  case_41();
  break;
case 42:
#line 645 "cs-parser.jay"
  {
		current_namespace.DeclarationFound = true;
	  }
  break;
case 50:
  case_50();
  break;
case 51:
  case_51();
  break;
case 52:
  case_52();
  break;
case 53:
  case_53();
  break;
case 54:
  case_54();
  break;
case 55:
  case_55();
  break;
case 56:
  case_56();
  break;
case 57:
  case_57();
  break;
case 58:
#line 754 "cs-parser.jay"
  { yyVal = "event"; savedCloseLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 59:
#line 755 "cs-parser.jay"
  { yyVal = "return"; savedCloseLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 60:
  case_60();
  break;
case 61:
#line 772 "cs-parser.jay"
  {
		yyVal = new List<Attribute> (4) { (Attribute) yyVals[0+yyTop] };
	  }
  break;
case 62:
  case_62();
  break;
case 63:
#line 787 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 64:
  case_64();
  break;
case 66:
#line 814 "cs-parser.jay"
  { yyVal = null; }
  break;
case 67:
  case_67();
  break;
case 68:
#line 825 "cs-parser.jay"
  { yyVal = null; }
  break;
case 69:
  case_69();
  break;
case 70:
  case_70();
  break;
case 71:
  case_71();
  break;
case 72:
  case_72();
  break;
case 73:
#line 869 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 75:
#line 877 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 76:
  case_76();
  break;
case 77:
  case_77();
  break;
case 78:
#line 903 "cs-parser.jay"
  { yyVal = null; }
  break;
case 79:
#line 907 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Ref;
	  }
  break;
case 80:
#line 911 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Out;
	  }
  break;
case 83:
#line 923 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 84:
#line 927 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 95:
  case_95();
  break;
case 96:
#line 957 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 97:
  case_97();
  break;
case 98:
  case_98();
  break;
case 99:
  case_99();
  break;
case 100:
  case_100();
  break;
case 101:
  case_101();
  break;
case 102:
#line 998 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 103:
  case_103();
  break;
case 104:
  case_104();
  break;
case 107:
#line 1039 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 108:
#line 1043 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 109:
  case_109();
  break;
case 110:
#line 1059 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 111:
  case_111();
  break;
case 112:
  case_112();
  break;
case 115:
  case_115();
  break;
case 116:
  case_116();
  break;
case 117:
  case_117();
  break;
case 118:
  case_118();
  break;
case 119:
#line 1138 "cs-parser.jay"
  {
		report.Error (1641, GetLocation (yyVals[-1+yyTop]), "A fixed size buffer field must have the array size specifier after the field name");
	  }
  break;
case 121:
  case_121();
  break;
case 122:
  case_122();
  break;
case 125:
#line 1168 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 126:
#line 1172 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 127:
  case_127();
  break;
case 128:
#line 1185 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 129:
  case_129();
  break;
case 132:
#line 1204 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 133:
#line 1208 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 134:
  case_134();
  break;
case 135:
#line 1224 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 136:
  case_136();
  break;
case 137:
  case_137();
  break;
case 140:
  case_140();
  break;
case 141:
  case_141();
  break;
case 142:
  case_142();
  break;
case 143:
#line 1295 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.All;
	  }
  break;
case 144:
#line 1299 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 145:
  case_145();
  break;
case 146:
#line 1333 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 147:
  case_147();
  break;
case 148:
#line 1343 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 149:
  case_149();
  break;
case 150:
  case_150();
  break;
case 152:
#line 1401 "cs-parser.jay"
  { savedLocation = GetLocation (yyVals[0+yyTop]); yyVal = null; }
  break;
case 153:
#line 1405 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 155:
  case_155();
  break;
case 156:
  case_156();
  break;
case 157:
  case_157();
  break;
case 158:
  case_158();
  break;
case 159:
  case_159();
  break;
case 160:
  case_160();
  break;
case 161:
  case_161();
  break;
case 162:
#line 1477 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[0+yyTop] } );
	  }
  break;
case 163:
#line 1481 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[0+yyTop])) }, true);
	  }
  break;
case 164:
  case_164();
  break;
case 165:
  case_165();
  break;
case 166:
  case_166();
  break;
case 167:
  case_167();
  break;
case 168:
  case_168();
  break;
case 169:
  case_169();
  break;
case 170:
#line 1556 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 171:
  case_171();
  break;
case 172:
#line 1597 "cs-parser.jay"
  { yyVal = Parameter.Modifier.NONE; }
  break;
case 174:
#line 1605 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 175:
  case_175();
  break;
case 176:
  case_176();
  break;
case 177:
  case_177();
  break;
case 178:
  case_178();
  break;
case 179:
  case_179();
  break;
case 180:
  case_180();
  break;
case 181:
  case_181();
  break;
case 182:
  case_182();
  break;
case 183:
  case_183();
  break;
case 184:
#line 1698 "cs-parser.jay"
  {
		Error_DuplicateParameterModifier (GetLocation (yyVals[-1+yyTop]), Parameter.Modifier.PARAMS);
	  }
  break;
case 185:
  case_185();
  break;
case 186:
  case_186();
  break;
case 187:
  case_187();
  break;
case 188:
  case_188();
  break;
case 189:
  case_189();
  break;
case 190:
#line 1752 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 191:
  case_191();
  break;
case 192:
#line 1781 "cs-parser.jay"
  {
		lexer.PropertyParsing = false;
	  }
  break;
case 193:
  case_193();
  break;
case 198:
  case_198();
  break;
case 199:
  case_199();
  break;
case 200:
  case_200();
  break;
case 201:
  case_201();
  break;
case 202:
  case_202();
  break;
case 204:
  case_204();
  break;
case 205:
  case_205();
  break;
case 206:
#line 1930 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 207:
  case_207();
  break;
case 208:
  case_208();
  break;
case 209:
  case_209();
  break;
case 210:
  case_210();
  break;
case 211:
#line 1967 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);	  
	  }
  break;
case 214:
#line 1979 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 215:
#line 1983 "cs-parser.jay"
  {
		lexer.parsing_modifiers = true;
	  }
  break;
case 216:
#line 1990 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 217:
#line 1994 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 222:
#line 2002 "cs-parser.jay"
  {
	  	report.Error (567, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain operators");
	  }
  break;
case 223:
#line 2006 "cs-parser.jay"
  {
	  	report.Error (526, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain contructors");
	  }
  break;
case 224:
#line 2010 "cs-parser.jay"
  {
	  	report.Error (524, GetLocation (yyVals[0+yyTop]), "Interfaces cannot declare classes, structs, interfaces, delegates, or enumerations");
	  }
  break;
case 225:
#line 2016 "cs-parser.jay"
  {
	  }
  break;
case 226:
  case_226();
  break;
case 228:
#line 2049 "cs-parser.jay"
  { savedLocation = GetLocation (yyVals[0+yyTop]); yyVal = null; }
  break;
case 230:
  case_230();
  break;
case 231:
#line 2065 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 232:
  case_232();
  break;
case 234:
#line 2111 "cs-parser.jay"
  { yyVal = Operator.OpType.LogicalNot; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 235:
#line 2112 "cs-parser.jay"
  { yyVal = Operator.OpType.OnesComplement; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 236:
#line 2113 "cs-parser.jay"
  { yyVal = Operator.OpType.Increment; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 237:
#line 2114 "cs-parser.jay"
  { yyVal = Operator.OpType.Decrement; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 238:
#line 2115 "cs-parser.jay"
  { yyVal = Operator.OpType.True; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 239:
#line 2116 "cs-parser.jay"
  { yyVal = Operator.OpType.False; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 240:
#line 2118 "cs-parser.jay"
  { yyVal = Operator.OpType.Addition; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 241:
#line 2119 "cs-parser.jay"
  { yyVal = Operator.OpType.Subtraction; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 242:
#line 2121 "cs-parser.jay"
  { yyVal = Operator.OpType.Multiply; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 243:
#line 2122 "cs-parser.jay"
  {  yyVal = Operator.OpType.Division; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 244:
#line 2123 "cs-parser.jay"
  { yyVal = Operator.OpType.Modulus; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 245:
#line 2124 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseAnd; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 246:
#line 2125 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseOr; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 247:
#line 2126 "cs-parser.jay"
  { yyVal = Operator.OpType.ExclusiveOr; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 248:
#line 2127 "cs-parser.jay"
  { yyVal = Operator.OpType.LeftShift; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 249:
#line 2128 "cs-parser.jay"
  { yyVal = Operator.OpType.RightShift; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 250:
#line 2129 "cs-parser.jay"
  { yyVal = Operator.OpType.Equality; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 251:
#line 2130 "cs-parser.jay"
  { yyVal = Operator.OpType.Inequality; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 252:
#line 2131 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThan; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 253:
#line 2132 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThan; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 254:
#line 2133 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThanOrEqual; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 255:
#line 2134 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThanOrEqual; savedOperatorLocation = GetLocation (yyVals[0+yyTop]); }
  break;
case 256:
#line 2141 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 257:
  case_257();
  break;
case 258:
#line 2160 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 259:
  case_259();
  break;
case 260:
  case_260();
  break;
case 261:
  case_261();
  break;
case 262:
  case_262();
  break;
case 263:
  case_263();
  break;
case 264:
  case_264();
  break;
case 265:
  case_265();
  break;
case 267:
#line 2263 "cs-parser.jay"
  { current_block = null; yyVal = null; }
  break;
case 270:
#line 2275 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 271:
  case_271();
  break;
case 272:
#line 2285 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 273:
  case_273();
  break;
case 274:
  case_274();
  break;
case 275:
  case_275();
  break;
case 276:
  case_276();
  break;
case 277:
  case_277();
  break;
case 278:
  case_278();
  break;
case 279:
  case_279();
  break;
case 280:
  case_280();
  break;
case 281:
  case_281();
  break;
case 283:
#line 2394 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 284:
  case_284();
  break;
case 287:
#line 2411 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 288:
#line 2415 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 289:
  case_289();
  break;
case 290:
#line 2428 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 291:
  case_291();
  break;
case 292:
  case_292();
  break;
case 293:
#line 2453 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 296:
  case_296();
  break;
case 297:
  case_297();
  break;
case 298:
  case_298();
  break;
case 299:
  case_299();
  break;
case 300:
  case_300();
  break;
case 301:
  case_301();
  break;
case 302:
  case_302();
  break;
case 303:
  case_303();
  break;
case 305:
#line 2547 "cs-parser.jay"
  {
		enumCommas.Add (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 306:
  case_306();
  break;
case 307:
  case_307();
  break;
case 308:
  case_308();
  break;
case 309:
  case_309();
  break;
case 311:
  case_311();
  break;
case 312:
  case_312();
  break;
case 315:
#line 2615 "cs-parser.jay"
  {
	  	enumCommas.Add (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 317:
  case_317();
  break;
case 318:
  case_318();
  break;
case 319:
  case_319();
  break;
case 320:
  case_320();
  break;
case 321:
#line 2673 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 322:
  case_322();
  break;
case 323:
#line 2695 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = false;
	  }
  break;
case 324:
  case_324();
  break;
case 326:
  case_326();
  break;
case 328:
  case_328();
  break;
case 330:
  case_330();
  break;
case 331:
  case_331();
  break;
case 333:
  case_333();
  break;
case 334:
  case_334();
  break;
case 335:
  case_335();
  break;
case 336:
  case_336();
  break;
case 337:
#line 2800 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 338:
  case_338();
  break;
case 339:
  case_339();
  break;
case 341:
  case_341();
  break;
case 342:
  case_342();
  break;
case 343:
  case_343();
  break;
case 344:
  case_344();
  break;
case 345:
  case_345();
  break;
case 346:
  case_346();
  break;
case 348:
  case_348();
  break;
case 349:
  case_349();
  break;
case 350:
  case_350();
  break;
case 351:
  case_351();
  break;
case 352:
  case_352();
  break;
case 354:
#line 2921 "cs-parser.jay"
  {
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 355:
#line 2928 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 357:
  case_357();
  break;
case 359:
  case_359();
  break;
case 361:
  case_361();
  break;
case 363:
#line 2966 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 364:
  case_364();
  break;
case 365:
#line 2986 "cs-parser.jay"
  {
		yyVal = new ComposedCast (((MemberName) yyVals[-1+yyTop]).GetTypeExpression (), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 366:
  case_366();
  break;
case 367:
#line 2995 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 368:
#line 2999 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 369:
  case_369();
  break;
case 370:
  case_370();
  break;
case 371:
  case_371();
  break;
case 372:
  case_372();
  break;
case 373:
#line 3038 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Object, GetLocation (yyVals[0+yyTop])); }
  break;
case 374:
#line 3039 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.String, GetLocation (yyVals[0+yyTop])); }
  break;
case 375:
#line 3040 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Bool, GetLocation (yyVals[0+yyTop])); }
  break;
case 376:
#line 3041 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Decimal, GetLocation (yyVals[0+yyTop])); }
  break;
case 377:
#line 3042 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Float, GetLocation (yyVals[0+yyTop])); }
  break;
case 378:
#line 3043 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Double, GetLocation (yyVals[0+yyTop])); }
  break;
case 380:
#line 3048 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.SByte, GetLocation (yyVals[0+yyTop])); }
  break;
case 381:
#line 3049 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Byte, GetLocation (yyVals[0+yyTop])); }
  break;
case 382:
#line 3050 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Short, GetLocation (yyVals[0+yyTop])); }
  break;
case 383:
#line 3051 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UShort, GetLocation (yyVals[0+yyTop])); }
  break;
case 384:
#line 3052 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Int, GetLocation (yyVals[0+yyTop])); }
  break;
case 385:
#line 3053 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UInt, GetLocation (yyVals[0+yyTop])); }
  break;
case 386:
#line 3054 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Long, GetLocation (yyVals[0+yyTop])); }
  break;
case 387:
#line 3055 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.ULong, GetLocation (yyVals[0+yyTop])); }
  break;
case 388:
#line 3056 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Char, GetLocation (yyVals[0+yyTop])); }
  break;
case 409:
  case_409();
  break;
case 410:
  case_410();
  break;
case 414:
#line 3103 "cs-parser.jay"
  { yyVal = new NullLiteral (GetLocation (yyVals[0+yyTop])); }
  break;
case 415:
#line 3107 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, true, GetLocation (yyVals[0+yyTop])); }
  break;
case 416:
#line 3108 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, false, GetLocation (yyVals[0+yyTop])); }
  break;
case 421:
  case_421();
  break;
case 422:
#line 3141 "cs-parser.jay"
  {
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop]);
	  }
  break;
case 423:
  case_423();
  break;
case 424:
  case_424();
  break;
case 425:
  case_425();
  break;
case 426:
  case_426();
  break;
case 427:
#line 3176 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null,GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 428:
  case_428();
  break;
case 429:
#line 3184 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null, lexer.Location);
	  }
  break;
case 430:
  case_430();
  break;
case 431:
  case_431();
  break;
case 432:
#line 3200 "cs-parser.jay"
  { yyVal = null; }
  break;
case 434:
  case_434();
  break;
case 435:
  case_435();
  break;
case 436:
#line 3223 "cs-parser.jay"
  { yyVal = null; }
  break;
case 437:
#line 3227 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	}
  break;
case 438:
  case_438();
  break;
case 439:
  case_439();
  break;
case 440:
  case_440();
  break;
case 441:
  case_441();
  break;
case 442:
#line 3260 "cs-parser.jay"
  {
		yyVal = new CompletionElementInitializer (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 443:
  case_443();
  break;
case 444:
  case_444();
  break;
case 445:
  case_445();
  break;
case 448:
#line 3288 "cs-parser.jay"
  { yyVal = null; }
  break;
case 450:
  case_450();
  break;
case 451:
  case_451();
  break;
case 452:
  case_452();
  break;
case 453:
  case_453();
  break;
case 454:
  case_454();
  break;
case 455:
#line 3340 "cs-parser.jay"
  {
		yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 459:
  case_459();
  break;
case 460:
  case_460();
  break;
case 461:
  case_461();
  break;
case 462:
  case_462();
  break;
case 464:
  case_464();
  break;
case 465:
  case_465();
  break;
case 466:
  case_466();
  break;
case 467:
  case_467();
  break;
case 468:
  case_468();
  break;
case 469:
  case_469();
  break;
case 470:
#line 3427 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 472:
#line 3435 "cs-parser.jay"
  {
		yyVal = new This (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 473:
  case_473();
  break;
case 474:
  case_474();
  break;
case 475:
#line 3455 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostIncrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 476:
#line 3462 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostDecrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 477:
  case_477();
  break;
case 478:
  case_478();
  break;
case 479:
  case_479();
  break;
case 480:
  case_480();
  break;
case 481:
  case_481();
  break;
case 482:
  case_482();
  break;
case 483:
  case_483();
  break;
case 484:
#line 3528 "cs-parser.jay"
  {
		++lexer.parsing_type;
	  }
  break;
case 485:
  case_485();
  break;
case 486:
  case_486();
  break;
case 489:
#line 3555 "cs-parser.jay"
  { yyVal = null; }
  break;
case 491:
  case_491();
  break;
case 492:
  case_492();
  break;
case 493:
  case_493();
  break;
case 494:
  case_494();
  break;
case 495:
  case_495();
  break;
case 496:
  case_496();
  break;
case 500:
  case_500();
  break;
case 501:
  case_501();
  break;
case 502:
  case_502();
  break;
case 503:
#line 3633 "cs-parser.jay"
  {
		yyVal = 2;
	  }
  break;
case 504:
#line 3637 "cs-parser.jay"
  {
		yyVal = ((int) yyVals[-1+yyTop]) + 1;
	  }
  break;
case 505:
#line 3644 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 506:
#line 3648 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 507:
  case_507();
  break;
case 508:
  case_508();
  break;
case 509:
  case_509();
  break;
case 510:
  case_510();
  break;
case 511:
#line 3692 "cs-parser.jay"
  {
	  	lexer.TypeOfParsing = true;
	  }
  break;
case 512:
  case_512();
  break;
case 515:
  case_515();
  break;
case 516:
  case_516();
  break;
case 517:
  case_517();
  break;
case 518:
  case_518();
  break;
case 519:
  case_519();
  break;
case 520:
  case_520();
  break;
case 521:
  case_521();
  break;
case 522:
  case_522();
  break;
case 523:
  case_523();
  break;
case 524:
  case_524();
  break;
case 525:
  case_525();
  break;
case 526:
  case_526();
  break;
case 527:
#line 3812 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], false, GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 528:
  case_528();
  break;
case 529:
#line 3825 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], true, GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 530:
  case_530();
  break;
case 531:
#line 3842 "cs-parser.jay"
  {
		yyVal = ParametersCompiled.Undefined;
	  }
  break;
case 533:
#line 3850 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 534:
  case_534();
  break;
case 535:
  case_535();
  break;
case 537:
#line 3876 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.LogicalNot, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 538:
#line 3880 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.OnesComplement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 541:
  case_541();
  break;
case 542:
  case_542();
  break;
case 544:
#line 3910 "cs-parser.jay"
  { 
	  	yyVal = new Unary (Unary.Operator.UnaryPlus, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 545:
#line 3914 "cs-parser.jay"
  { 
		yyVal = new Unary (Unary.Operator.UnaryNegation, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 546:
#line 3918 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 547:
#line 3922 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 548:
#line 3926 "cs-parser.jay"
  {
		yyVal = new Indirection ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 549:
#line 3930 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.AddressOf, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 551:
  case_551();
  break;
case 552:
  case_552();
  break;
case 553:
  case_553();
  break;
case 555:
  case_555();
  break;
case 556:
#line 3962 "cs-parser.jay"
  {
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 557:
  case_557();
  break;
case 558:
#line 3971 "cs-parser.jay"
  {
		yyVal = new As ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 559:
#line 3975 "cs-parser.jay"
  {
		yyVal = new Is ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 561:
  case_561();
  break;
case 562:
  case_562();
  break;
case 564:
  case_564();
  break;
case 565:
  case_565();
  break;
case 566:
  case_566();
  break;
case 567:
  case_567();
  break;
case 569:
  case_569();
  break;
case 570:
  case_570();
  break;
case 572:
  case_572();
  break;
case 574:
  case_574();
  break;
case 576:
  case_576();
  break;
case 578:
  case_578();
  break;
case 580:
  case_580();
  break;
case 582:
  case_582();
  break;
case 584:
  case_584();
  break;
case 585:
#line 4099 "cs-parser.jay"
  {
		yyVal = new SimpleAssign ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 586:
  case_586();
  break;
case 587:
  case_587();
  break;
case 588:
  case_588();
  break;
case 589:
  case_589();
  break;
case 590:
  case_590();
  break;
case 591:
  case_591();
  break;
case 592:
  case_592();
  break;
case 593:
  case_593();
  break;
case 594:
  case_594();
  break;
case 595:
  case_595();
  break;
case 596:
  case_596();
  break;
case 597:
  case_597();
  break;
case 598:
  case_598();
  break;
case 599:
  case_599();
  break;
case 600:
  case_600();
  break;
case 601:
#line 4196 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 602:
  case_602();
  break;
case 605:
#line 4212 "cs-parser.jay"
  {
		start_block (lexer.Location);
	  }
  break;
case 606:
  case_606();
  break;
case 608:
  case_608();
  break;
case 609:
  case_609();
  break;
case 610:
  case_610();
  break;
case 611:
  case_611();
  break;
case 612:
  case_612();
  break;
case 613:
#line 4257 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 614:
  case_614();
  break;
case 615:
  case_615();
  break;
case 616:
#line 4271 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;	  
	  }
  break;
case 617:
  case_617();
  break;
case 618:
  case_618();
  break;
case 624:
#line 4296 "cs-parser.jay"
  {
		yyVal = new ArglistAccess (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 625:
  case_625();
  break;
case 626:
  case_626();
  break;
case 627:
  case_627();
  break;
case 629:
#line 4325 "cs-parser.jay"
  {
		yyVal = new BooleanExpression ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 630:
#line 4338 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 631:
  case_631();
  break;
case 632:
  case_632();
  break;
case 633:
  case_633();
  break;
case 634:
  case_634();
  break;
case 635:
#line 4381 "cs-parser.jay"
  { yyVal = null; }
  break;
case 636:
#line 4383 "cs-parser.jay"
  { yyVal = yyVals[0+yyTop]; StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[0+yyTop])); }
  break;
case 637:
  case_637();
  break;
case 638:
#line 4396 "cs-parser.jay"
  {
		lexer.parsing_modifiers = false;		
	  }
  break;
case 640:
  case_640();
  break;
case 641:
  case_641();
  break;
case 642:
  case_642();
  break;
case 643:
  case_643();
  break;
case 644:
  case_644();
  break;
case 645:
  case_645();
  break;
case 646:
  case_646();
  break;
case 647:
  case_647();
  break;
case 648:
  case_648();
  break;
case 649:
  case_649();
  break;
case 650:
  case_650();
  break;
case 651:
  case_651();
  break;
case 652:
  case_652();
  break;
case 653:
  case_653();
  break;
case 654:
  case_654();
  break;
case 655:
  case_655();
  break;
case 657:
  case_657();
  break;
case 659:
#line 4516 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 660:
  case_660();
  break;
case 661:
  case_661();
  break;
case 662:
  case_662();
  break;
case 663:
  case_663();
  break;
case 664:
  case_664();
  break;
case 665:
  case_665();
  break;
case 666:
  case_666();
  break;
case 667:
  case_667();
  break;
case 668:
#line 4607 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Class, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 669:
#line 4611 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Struct, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 670:
#line 4618 "cs-parser.jay"
  {
		yyVal = Variance.None;
	  }
  break;
case 671:
  case_671();
  break;
case 672:
  case_672();
  break;
case 673:
  case_673();
  break;
case 674:
  case_674();
  break;
case 675:
#line 4663 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 676:
  case_676();
  break;
case 677:
  case_677();
  break;
case 678:
  case_678();
  break;
case 679:
  case_679();
  break;
case 684:
#line 4707 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 685:
#line 4711 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 687:
  case_687();
  break;
case 690:
#line 4735 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 691:
#line 4739 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 720:
  case_720();
  break;
case 721:
  case_721();
  break;
case 722:
  case_722();
  break;
case 723:
  case_723();
  break;
case 724:
  case_724();
  break;
case 727:
  case_727();
  break;
case 728:
  case_728();
  break;
case 729:
  case_729();
  break;
case 730:
  case_730();
  break;
case 731:
#line 4883 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 732:
#line 4887 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 733:
  case_733();
  break;
case 735:
  case_735();
  break;
case 736:
#line 4908 "cs-parser.jay"
  {
		yyVal = ComposedTypeSpecifier.CreatePointer (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 737:
  case_737();
  break;
case 738:
  case_738();
  break;
case 739:
  case_739();
  break;
case 740:
  case_740();
  break;
case 742:
  case_742();
  break;
case 743:
  case_743();
  break;
case 747:
  case_747();
  break;
case 750:
  case_750();
  break;
case 751:
  case_751();
  break;
case 752:
#line 5008 "cs-parser.jay"
  {
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
	  }
  break;
case 753:
  case_753();
  break;
case 758:
  case_758();
  break;
case 760:
  case_760();
  break;
case 761:
  case_761();
  break;
case 762:
  case_762();
  break;
case 763:
#line 5058 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 764:
#line 5062 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 765:
#line 5063 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 766:
  case_766();
  break;
case 767:
  case_767();
  break;
case 768:
  case_768();
  break;
case 771:
  case_771();
  break;
case 772:
  case_772();
  break;
case 773:
#line 5131 "cs-parser.jay"
  {
		start_block (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 774:
  case_774();
  break;
case 775:
  case_775();
  break;
case 777:
  case_777();
  break;
case 778:
  case_778();
  break;
case 779:
  case_779();
  break;
case 780:
#line 5175 "cs-parser.jay"
  {
		current_block = current_block.CreateSwitchBlock (lexer.Location);
	  }
  break;
case 781:
#line 5179 "cs-parser.jay"
  {
		yyVal = new SwitchSection ((List<SwitchLabel>) yyVals[-2+yyTop], current_block);
	  }
  break;
case 782:
  case_782();
  break;
case 783:
  case_783();
  break;
case 784:
  case_784();
  break;
case 785:
#line 5208 "cs-parser.jay"
  {
		yyVal = new SwitchLabel (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 790:
  case_790();
  break;
case 791:
  case_791();
  break;
case 792:
  case_792();
  break;
case 793:
#line 5247 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 794:
  case_794();
  break;
case 795:
  case_795();
  break;
case 796:
#line 5275 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 798:
  case_798();
  break;
case 799:
  case_799();
  break;
case 801:
#line 5296 "cs-parser.jay"
  { yyVal = null; }
  break;
case 803:
#line 5301 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 807:
  case_807();
  break;
case 808:
  case_808();
  break;
case 809:
  case_809();
  break;
case 810:
  case_810();
  break;
case 817:
  case_817();
  break;
case 818:
  case_818();
  break;
case 819:
  case_819();
  break;
case 820:
  case_820();
  break;
case 821:
  case_821();
  break;
case 822:
  case_822();
  break;
case 823:
  case_823();
  break;
case 824:
  case_824();
  break;
case 825:
  case_825();
  break;
case 828:
#line 5456 "cs-parser.jay"
  {
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], (List<Catch>) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), false);
	  }
  break;
case 829:
  case_829();
  break;
case 830:
  case_830();
  break;
case 831:
  case_831();
  break;
case 832:
  case_832();
  break;
case 833:
  case_833();
  break;
case 836:
#line 5509 "cs-parser.jay"
  {
		yyVal = new Catch ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 837:
  case_837();
  break;
case 838:
#line 5528 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 839:
  case_839();
  break;
case 840:
#line 5546 "cs-parser.jay"
  {
		yyVal = new Checked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 841:
#line 5553 "cs-parser.jay"
  {
		yyVal = new Unchecked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 842:
  case_842();
  break;
case 843:
#line 5563 "cs-parser.jay"
  {
		yyVal = new Unsafe ((Block) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 844:
  case_844();
  break;
case 845:
  case_845();
  break;
case 846:
  case_846();
  break;
case 847:
  case_847();
  break;
case 848:
  case_848();
  break;
case 849:
  case_849();
  break;
case 850:
  case_850();
  break;
case 851:
  case_851();
  break;
case 852:
#line 5646 "cs-parser.jay"
  {
		Error_MissingInitializer (lexer.Location);
	  }
  break;
case 853:
  case_853();
  break;
case 854:
  case_854();
  break;
case 855:
  case_855();
  break;
case 856:
  case_856();
  break;
case 857:
  case_857();
  break;
case 858:
  case_858();
  break;
case 859:
  case_859();
  break;
case 860:
  case_860();
  break;
case 861:
  case_861();
  break;
case 862:
#line 5747 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 863:
  case_863();
  break;
case 864:
#line 5762 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 865:
  case_865();
  break;
case 866:
  case_866();
  break;
case 868:
  case_868();
  break;
case 869:
#line 5807 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 870:
  case_870();
  break;
case 871:
  case_871();
  break;
case 872:
  case_872();
  break;
case 873:
  case_873();
  break;
case 877:
  case_877();
  break;
case 883:
#line 5866 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 884:
  case_884();
  break;
case 885:
#line 5885 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 886:
  case_886();
  break;
case 887:
  case_887();
  break;
case 888:
  case_888();
  break;
case 889:
  case_889();
  break;
case 890:
  case_890();
  break;
case 891:
  case_891();
  break;
case 892:
  case_892();
  break;
case 893:
  case_893();
  break;
case 894:
  case_894();
  break;
case 896:
#line 6029 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 897:
#line 6036 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 898:
  case_898();
  break;
case 900:
  case_900();
  break;
case 901:
  case_901();
  break;
case 903:
  case_903();
  break;
case 904:
  case_904();
  break;
case 905:
#line 6082 "cs-parser.jay"
  {
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 906:
  case_906();
  break;
case 907:
  case_907();
  break;
case 908:
#line 6099 "cs-parser.jay"
  {
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 909:
  case_909();
  break;
case 910:
  case_910();
  break;
case 912:
  case_912();
  break;
case 913:
  case_913();
  break;
case 916:
  case_916();
  break;
case 917:
  case_917();
  break;
case 925:
#line 6223 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedName = (MemberName) yyVals[0+yyTop];
	  }
  break;
case 926:
#line 6230 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
	  }
  break;
case 927:
  case_927();
  break;
case 928:
  case_928();
  break;
case 929:
#line 6247 "cs-parser.jay"
  {
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], new MemberName (MemberCache.IndexerNameAlias));
	  }
  break;
case 930:
#line 6251 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 931:
  case_931();
  break;
case 932:
  case_932();
  break;
case 933:
  case_933();
  break;
case 934:
  case_934();
  break;
case 936:
#line 6287 "cs-parser.jay"
  {
		yyVal = new MemberName (((MemberName) yyVals[-2+yyTop]), (MemberName) yyVals[0+yyTop]);
	  }
  break;
case 938:
#line 6295 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 939:
#line 6299 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 940:
#line 6306 "cs-parser.jay"
  {
		yyVal = new List<DocumentationParameter> (0);
	  }
  break;
case 942:
  case_942();
  break;
case 943:
  case_943();
  break;
case 944:
  case_944();
  break;
#line default
        }
        yyTop -= yyLen[yyN];
        yyState = yyStates[yyTop];
        int yyM = yyLhs[yyN];
        if (yyState == 0 && yyM == 0) {
//t          if (debug != null) debug.shift(0, yyFinal);
          yyState = yyFinal;
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t               debug.lex(yyState, yyToken,yyname(yyToken), yyLex.value());
          }
          if (yyToken == 0) {
//t            if (debug != null) debug.accept(yyVal);
            return yyVal;
          }
          goto continue_yyLoop;
        }
        if (((yyN = yyGindex[yyM]) != 0) && ((yyN += yyState) >= 0)
            && (yyN < yyTable.Length) && (yyCheck[yyN] == yyState))
          yyState = yyTable[yyN];
        else
          yyState = yyDgoto[yyM];
//t        if (debug != null) debug.shift(yyStates[yyTop], yyState);
	 goto continue_yyLoop;
      continue_yyDiscarded: ;	// implements the named-loop continue: 'continue yyDiscarded'
      }
    continue_yyLoop: ;		// implements the named-loop continue: 'continue yyLoop'
    }
  }

/*
 All more than 3 lines long rules are wrapped into a method
*/
void case_6()
#line 408 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			Attributes attrs = (Attributes) yyVals[0+yyTop];
			report.Error (1730, attrs.Attrs [0].Location,
				"Assembly and module attributes must precede all other elements except using clauses and extern alias declarations");
		}
	  }

void case_8()
#line 420 "cs-parser.jay"
{
		if (yyToken == Token.EXTERN_ALIAS)
			report.Error (439, lexer.Location, "An extern alias declaration must precede all other elements");
		else
			Error_SyntaxError (yyToken);
	  }

void case_13()
#line 440 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "alias"){
			syntax_error (lt.Location, "`alias' expected");
		} else if (lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (lt.Location, "external alias");
		} else {
			lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop]; 
			current_namespace.AddUsingExternalAlias (lt.Value, lt.Location, report);
			ubag.AddExternAlias  (GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]), lt, GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_17()
#line 466 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_18()
#line 471 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_19()
#line 479 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		if (lang_version != LanguageVersion.ISO_1 && lt.Value == "global") {
			report.Warning (440, 2, lt.Location,
			 "An alias named `global' will not be used when resolving `global::'. The global namespace will be used instead");
		}

		current_namespace.AddUsingAlias (lt.Value, (MemberName) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		ubag.AddUsingAlias (GetLocation (yyVals[-4+yyTop]), lt, GetLocation (yyVals[-2+yyTop]), (MemberName) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
		  }

void case_20()
#line 490 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_21()
#line 498 "cs-parser.jay"
{
		current_namespace.AddUsing ((MemberName) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		ubag.AddUsing (GetLocation (yyVals[-2+yyTop]), (MemberName) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_22()
#line 511 "cs-parser.jay"
{
		Attributes attrs = (Attributes) yyVals[-2+yyTop];
		MemberName name = (MemberName) yyVals[0+yyTop];
		if (attrs != null) {
			bool valid_global_attrs = true;
			if ((current_namespace.DeclarationFound || current_namespace != file.NamespaceContainer)) {
				valid_global_attrs = false;
			} else {
				foreach (var a in attrs.Attrs) {
					if (a.ExplicitTarget == "assembly" || a.ExplicitTarget == "module")
						continue;
						
					valid_global_attrs = false;
					break;
				}
			}
			
			if (!valid_global_attrs)
				report.Error (1671, name.Location, "A namespace declaration cannot have modifiers or attributes");
		}
	
		module.AddAttributes (attrs, current_namespace);
		
		current_namespace = new NamespaceContainer (name, module, current_namespace, file);
		module.AddTypesContainer (current_namespace);
		current_class = current_namespace.SlaveDeclSpace;
		current_container = current_class.PartialContainer;
		
		ubag.DeclareNamespace (GetLocation (yyVals[-1+yyTop]), name);
	  }

void case_23()
#line 542 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
		ubag.OpenNamespace (GetLocation (yyVals[0+yyTop]));
	  }

void case_24()
#line 548 "cs-parser.jay"
{
		current_namespace = current_namespace.Parent;
		current_class = current_namespace.SlaveDeclSpace;
		current_container = current_class.PartialContainer;
		ubag.CloseNamespace (GetLocation (yyVals[-1+yyTop]));
		if (yyVals[0+yyTop] != null)
			ubag.EndNamespace (GetLocation (yyVals[0+yyTop]));
		else
			ubag.EndNamespace ();
	  }

void case_25()
#line 562 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName (lt.Value, lt.Location);
	  }

void case_26()
#line 567 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], lt.Value, lt.Location) {
			DotLocation = GetLocation (yyVals[-1+yyTop])
		};
	  }

void case_27()
#line 574 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new MemberName ("<invalid>", lexer.Location);
	  }

void case_32()
#line 592 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[0+yyTop];

		if (name.TypeArguments != null)
			syntax_error (lexer.Location, "namespace name expected");

		yyVal = name;
	  }

void case_41()
#line 624 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			TypeContainer ds = (TypeContainer)yyVals[0+yyTop];

			if ((ds.ModFlags & (Modifiers.PRIVATE | Modifiers.PROTECTED)) != 0){
				report.Error (1527, ds.Location, 
				"Namespace elements cannot be explicitly declared as private, protected or protected internal");
			}

			/* Here is a trick, for explicit attributes we don't know where they belong to until*/
			/* we parse succeeding declaration hence we parse them as normal and re-attach them*/
			/* when we know whether they are global (assembly:, module:) or local (type:).*/
			if (ds.OptAttributes != null) {
				ds.OptAttributes.ConvertGlobalAttributes (ds, current_namespace, !current_namespace.DeclarationFound && current_namespace == file.NamespaceContainer);
			}
		}
		current_namespace.DeclarationFound = true;
	  }

void case_50()
#line 674 "cs-parser.jay"
{
		var sect = (List<Attribute>) yyVals[0+yyTop];
		yyVal = new Attributes (sect);
		if (locationListStack.Count > 0)
			lbag.AddLocation (sect, locationListStack.Pop ());
		if (attributeCommas.Count > 0) {
			lbag.AppendTo (sect, attributeCommas);
			attributeCommas.Clear ();
		}
	  }

void case_51()
#line 685 "cs-parser.jay"
{
		Attributes attrs = yyVals[-1+yyTop] as Attributes;
		var sect = (List<Attribute>) yyVals[0+yyTop];
		
		if (locationListStack.Count > 0)
			lbag.AddLocation (sect, locationListStack.Pop ());
		if (attrs == null)
			attrs = new Attributes (sect);
		else
			attrs.AddAttributes (sect);
		yyVal = attrs;
	  }

void case_52()
#line 701 "cs-parser.jay"
{
		lexer.parsing_attribute_section = true;
		savedOpenLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_53()
#line 706 "cs-parser.jay"
{
		lexer.parsing_attribute_section = false;
		yyVal = yyVals[0+yyTop];
	  }

void case_54()
#line 714 "cs-parser.jay"
{
		current_attr_target = (string) yyVals[-1+yyTop];
		if (current_attr_target == "assembly" || current_attr_target == "module") {
			Lexer.check_incorrect_doc_comment ();
		}
	  }

void case_55()
#line 721 "cs-parser.jay"
{
		/* when attribute target is invalid*/
		if (current_attr_target == string.Empty)
			yyVal = new List<Attribute> (0);
		else
			yyVal = yyVals[-2+yyTop];
	  
		current_attr_target = null;
		lexer.parsing_attribute_section = false;
		if (yyVals[-1+yyTop] != null) {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, savedCloseLocation, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]) }));
		} else {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, savedCloseLocation, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]) }));
		}
 	  }

void case_56()
#line 737 "cs-parser.jay"
{
		yyVal = yyVals[-2+yyTop];
		if (yyVals[-1+yyTop] != null) {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]) }));
		} else {
			locationListStack.Push (new List<Location>(new [] { savedOpenLocation, GetLocation (yyVals[0+yyTop]) }));
		}
	  }

void case_57()
#line 749 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = CheckAttributeTarget (lt.Value, lt.Location);
		savedCloseLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_60()
#line 757 "cs-parser.jay"
{
		if (yyToken == Token.IDENTIFIER) {
			Error_SyntaxError (yyToken);
			yyVal = null;
		} else {
			string name = GetTokenName (yyToken);
			yyVal = CheckAttributeTarget (name, GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_62()
#line 774 "cs-parser.jay"
{
		var attrs = (List<Attribute>) yyVals[-2+yyTop];
		attrs.Add ((Attribute) yyVals[0+yyTop]);
		attributeCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = attrs;
	  }

void case_64()
#line 789 "cs-parser.jay"
{
		--lexer.parsing_block;
		MemberName mname = (MemberName) yyVals[-2+yyTop];
		if (mname.IsGeneric) {
			report.Error (404, lexer.Location,
				      "'<' unexpected: attributes cannot be generic");
		}

		Arguments [] arguments = (Arguments []) yyVals[0+yyTop];
		ATypeNameExpression expr = mname.GetTypeExpression ();
		yyVal = new Attribute (current_attr_target, expr, arguments, mname.Location, lexer.IsEscapedIdentifier (mname));
		if (arguments != null) {
			attributeArgumentCommas.Insert (0, savedAttrParenOpenLocation);
			attributeArgumentCommas.Add (savedAttrParenCloseLocation);
			lbag.AddLocation (yyVal, attributeArgumentCommas);
			attributeArgumentCommas.Clear ();
		}
	  }

void case_67()
#line 816 "cs-parser.jay"
{
		savedAttrParenOpenLocation = GetLocation (yyVals[-2+yyTop]);
		savedAttrParenCloseLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = yyVals[-1+yyTop];
	  }

void case_69()
#line 827 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);
		yyVal = new Arguments [] { a, null };
	  }

void case_70()
#line 833 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);  
		yyVal = new Arguments [] { null, a };
	  }

void case_71()
#line 839 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] != null) {
			report.Error (1016, ((Argument) yyVals[0+yyTop]).Expr.Location, "Named attribute arguments must appear after the positional arguments");
			o [0] = new Arguments (4);
		}
		
		Arguments args = ((Arguments) o [0]);
		if (args.Count > 0 && !(yyVals[0+yyTop] is NamedArgument) && args [args.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
		
		args.Add ((Argument) yyVals[0+yyTop]);
		attributeArgumentCommas.Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_72()
#line 854 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] == null) {
			o [1] = new Arguments (4);
		}

		((Arguments) o [1]).Add ((Argument) yyVals[0+yyTop]);
		attributeArgumentCommas.Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_76()
#line 879 "cs-parser.jay"
{
	  	--lexer.parsing_block;
	  	var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop]);	  
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_77()
#line 889 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "named argument");
			
		/* Avoid boxing in common case (no modifier)*/
		var arg_mod = yyVals[-1+yyTop] == null ? Argument.AType.None : (Argument.AType) yyVals[-1+yyTop];
			
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop], arg_mod);
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_95()
#line 942 "cs-parser.jay"
{
		report.Error (1519, lexer.Location, "Unexpected symbol `{0}' in class, struct, or interface member declaration",
			GetSymbolName (yyToken));
		yyVal = null;
		lexer.parsing_generic_declaration = false;
	  }

void case_97()
#line 959 "cs-parser.jay"
{ 
		MemberName name = MakeName ((MemberName) yyVals[0+yyTop]);
		push_current_class (new Struct (current_namespace, current_class, name, (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_class, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));
	  }

void case_98()
#line 966 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		current_class.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support)
			current_container.DocComment = Lexer.consume_doc_comment ();

		
		lexer.parsing_modifiers = true;
	  }

void case_99()
#line 978 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_100()
#line 983 "cs-parser.jay"
{
		lbag.AppendToMember (current_class, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_101()
#line 990 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != null) 
			current_class.OptionalSemicolon = GetLocation (yyVals[-1+yyTop]);
		yyVal = pop_current_class ();
	  }

void case_103()
#line 1005 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var mod = (Modifiers) yyVals[-3+yyTop];
		current_field = new Const (current_class, (FullNamedExpression) yyVals[-1+yyTop], mod, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
		current_container.AddConstant ((Const) current_field);
		
		if ((mod & Modifiers.STATIC) != 0) {
			report.Error (504, current_field.Location, "The constant `{0}' cannot be marked static", current_field.GetSignatureForError ());
		}
		
		yyVal = current_field;
	  }

void case_104()
#line 1018 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_field = null;
	  }

void case_109()
#line 1048 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_111()
#line 1061 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_112()
#line 1067 "cs-parser.jay"
{
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
		yyVal = null;
	  }

void case_115()
#line 1082 "cs-parser.jay"
{
	  	lexer.parsing_generic_declaration = false;

		FullNamedExpression type = (FullNamedExpression) yyVals[-1+yyTop];
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (670, GetLocation (yyVals[-1+yyTop]), "Fields cannot have void type");
			
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		current_field = new Field (current_class, type, (Modifiers) yyVals[-2+yyTop], new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-3+yyTop]);
		current_container.AddField (current_field);
		yyVal = current_field;
	  }

void case_116()
#line 1097 "cs-parser.jay"
{ 
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
			
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
		current_field = null;
	  }

void case_117()
#line 1110 "cs-parser.jay"
{ 
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "fixed size buffers");

		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		current_field = new FixedField (current_class, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop],
			new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
			
		current_container.AddField (current_field);
	  }

void case_118()
#line 1121 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
	    }

		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];	    
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
	    current_field = null;
	  }

void case_121()
#line 1144 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_122()
#line 1150 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_field.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendToMember (current_field, GetLocation (yyVals[-2+yyTop]));
		end_block (lexer.Location);
		current_local_parameters = null;
	  }

void case_127()
#line 1177 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_129()
#line 1187 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_134()
#line 1213 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];	  
		yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_136()
#line 1226 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_137()
#line 1232 "cs-parser.jay"
{
		report.Error (443, lexer.Location, "Value or constant expected");
		yyVal = null;
	  }

void case_140()
#line 1242 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  	yyVal = null;
	  }

void case_141()
#line 1251 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.NotAllowed;

		/* Add it early in the case of body being eof for full ast*/
		Method m = (Method) yyVals[0+yyTop];
		lexer.async_block = (m.ModFlags & Modifiers.ASYNC) != 0;
		current_container.AddMethod (m);
	  }

void case_142()
#line 1261 "cs-parser.jay"
{
		Method method = (Method) yyVals[-2+yyTop];
		method.Block = (ToplevelBlock) yyVals[0+yyTop];
		lexer.async_block = false;
		
		if (method.Block == null) {
			lbag.AppendToMember (method, savedLocation); /* semicolon*/
			method.ParameterInfo.CheckParameters (method);

			if ((method.ModFlags & Modifiers.ASYNC) != 0) {
				report.Error (1994, method.Location, "`{0}': The async modifier can only be used with methods that have a body",
					method.GetSignatureForError ());
			}
		} else {
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, method.Location, "`{0}': interface members cannot have a definition",
					method.GetSignatureForError ());
			}
		}

		current_local_parameters = null;

		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_145()
#line 1301 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;
		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		GenericMethod generic = null;
		if (name.TypeArguments != null) {
			generic = new GenericMethod (current_namespace, current_class, name,
						     (FullNamedExpression) yyVals[-7+yyTop], current_local_parameters);

			generic.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);
		} else if (yyVals[0+yyTop] != null) {
			report.Error (80, GetLocation (yyVals[0+yyTop]),
				"Constraints are not allowed on non-generic declarations");
		}

		var method = Method.Create (current_class, generic, (FullNamedExpression) yyVals[-7+yyTop], (Modifiers) yyVals[-8+yyTop],
				     name, current_local_parameters, (Attributes) yyVals[-9+yyTop], yyVals[0+yyTop] != null);
				     
		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_147()
#line 1336 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
	  	valid_param_mod = ParameterModifierType.All;
	  }

void case_149()
#line 1345 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;

		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		if (yyVals[-1+yyTop] != null && name.TypeArguments == null)
			report.Error (80, lexer.Location,
				      "Constraints are not allowed on non-generic declarations");

		GenericMethod generic = null;
		if (name.TypeArguments != null) {
			generic = new GenericMethod (current_namespace, current_class, name,
				new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-8+yyTop])),
				current_local_parameters);

			generic.SetParameterInfo ((List<Constraints>) yyVals[-1+yyTop]);
		}

		var modifiers = (Modifiers) yyVals[-10+yyTop];
		modifiers |= Modifiers.PARTIAL;

		var method = Method.Create (current_class, generic, new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-8+yyTop])),
				     modifiers, name, current_local_parameters, (Attributes) yyVals[-11+yyTop], yyVals[-1+yyTop] != null);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[-9+yyTop]));
		lbag.AddMember (method, mod_locations, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_150()
#line 1382 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[-3+yyTop];
		report.Error (1585, name.Location, 
			"Member modifier `{0}' must precede the member type and name", ModifiersExtensions.Name ((Modifiers) yyVals[-4+yyTop]));

		var method = Method.Create (current_class, null, (FullNamedExpression) yyVals[-5+yyTop],
					    0, name, (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop], false);

		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_155()
#line 1411 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
	  	yyVal = new ParametersCompiled (pars_list.ToArray ());
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_156()
#line 1417 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add ((Parameter) yyVals[0+yyTop]);
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray ()); 
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_157()
#line 1426 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[0+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_158()
#line 1435 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[-2+yyTop] } );			
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_159()
#line 1443 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-3+yyTop]));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_160()
#line 1456 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[-2+yyTop])) }, true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_161()
#line 1463 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));
		parameterListCommas.Add (GetLocation (yyVals[-3+yyTop]));
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  	lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_164()
#line 1483 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_165()
#line 1491 "cs-parser.jay"
{
		parameters_bucket.Clear ();
		Parameter p = (Parameter) yyVals[0+yyTop];
		parameters_bucket.Add (p);
		parameterListCommas.Clear ();
		default_parameter_used = p.HasDefaultValue;
		yyVal = parameters_bucket;
	  }

void case_166()
#line 1500 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter) yyVals[0+yyTop];
		if (p != null) {
			if (p.HasExtensionMethodModifier)
				report.Error (1100, p.Location, "The parameter modifier `this' can only be used on the first parameter");
			else if (!p.HasDefaultValue && default_parameter_used)
				report.Error (1737, p.Location, "Optional parameter cannot precede required parameters");

			default_parameter_used |= p.HasDefaultValue;
			pars.Add (p);
			
			parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));
		}
		
		yyVal = yyVals[-2+yyTop];
	  }

void case_167()
#line 1524 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_168()
#line 1533 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		report.Error (1552, lt.Location, "Array type specifier, [], must appear before parameter name");
		yyVal = new Parameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Parameter.Modifier) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_169()
#line 1543 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	  
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], null, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], l);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_171()
#line 1558 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		if (lang_version <= LanguageVersion.V_3) {
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "optional parameter");
		}
		
		Parameter.Modifier mod = (Parameter.Modifier) yyVals[-5+yyTop];
		if (mod != Parameter.Modifier.NONE) {
			switch (mod) {
			case Parameter.Modifier.REF:
			case Parameter.Modifier.OUT:
				report.Error (1741, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
				
			case Parameter.Modifier.This:
				report.Error (1743, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
			default:
				throw new NotImplementedException (mod.ToString ());
			}
				
			mod = Parameter.Modifier.NONE;
		}
		
		if ((valid_param_mod & ParameterModifierType.DefaultValue) == 0)
			report.Error (1065, GetLocation (yyVals[-2+yyTop]), "Optional parameter is not valid in this context");
		
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-4+yyTop], lt.Value, mod, (Attributes) yyVals[-6+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation, GetLocation (yyVals[-2+yyTop])); /* parameterModifierLocation should be ignored when mod == NONE*/
		
		if (yyVals[0+yyTop] != null)
			((Parameter) yyVal).DefaultValue = new DefaultParameterValueExpression ((Expression) yyVals[0+yyTop]);
	  }

void case_175()
#line 1607 "cs-parser.jay"
{
		Parameter.Modifier p2 = (Parameter.Modifier)yyVals[0+yyTop];
  		Parameter.Modifier mod = (Parameter.Modifier)yyVals[-1+yyTop] | p2;
  		if (((Parameter.Modifier)yyVals[-1+yyTop] & p2) == p2) {
  			Error_DuplicateParameterModifier (lexer.Location, p2);
  		} else {
	  		switch (mod & ~Parameter.Modifier.This) {
  				case Parameter.Modifier.REF:
					report.Error (1101, lexer.Location, "The parameter modifiers `this' and `ref' cannot be used altogether");
  					break;
   				case Parameter.Modifier.OUT:
					report.Error (1102, lexer.Location, "The parameter modifiers `this' and `out' cannot be used altogether");
  					break;
  				default:
 					report.Error (1108, lexer.Location, "A parameter cannot have specified more than one modifier");
 					break;
 			}
  		}
  		yyVal = mod;
	  }

void case_176()
#line 1631 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Ref) == 0)
	  		Error_ParameterModifierNotValid ("ref", GetLocation (yyVals[0+yyTop]));
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = Parameter.Modifier.REF;
	  }

void case_177()
#line 1638 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Out) == 0)
	  		Error_ParameterModifierNotValid ("out", GetLocation (yyVals[0+yyTop]));
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = Parameter.Modifier.OUT;
	  }

void case_178()
#line 1645 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.This) == 0)
	  		Error_ParameterModifierNotValid ("this", GetLocation (yyVals[0+yyTop]));

	  	if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "extension methods");
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
		yyVal = Parameter.Modifier.This;
	  }

void case_179()
#line 1658 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, savedLocation);
	  }

void case_180()
#line 1664 "cs-parser.jay"
{
		report.Error (1751, GetLocation (yyVals[-4+yyTop]), "Cannot specify a default value for a parameter array");
		
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Attributes) yyVals[-5+yyTop], lt.Location);		
		lbag.AddLocation (yyVal, savedLocation);
	  }

void case_181()
#line 1672 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_182()
#line 1680 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.Params) == 0)
			report.Error (1670, (GetLocation (yyVals[0+yyTop])), "The `params' modifier is not allowed in current context");
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_183()
#line 1686 "cs-parser.jay"
{
		Parameter.Modifier mod = (Parameter.Modifier)yyVals[0+yyTop];
		if ((mod & Parameter.Modifier.This) != 0) {
			report.Error (1104, GetLocation (yyVals[-1+yyTop]), "The parameter modifiers `this' and `params' cannot be used altogether");
		} else {
			report.Error (1611, GetLocation (yyVals[-1+yyTop]), "The params parameter cannot be declared as ref or out");
		}	  
		savedLocation = GetLocation (yyVals[-1+yyTop]);
	  }

void case_185()
#line 1703 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Arglist) == 0)
	  		report.Error (1669, GetLocation (yyVals[0+yyTop]), "__arglist is not valid in this context");
	  }

void case_186()
#line 1714 "cs-parser.jay"
{
		if (doc_support)
			tmpComment = Lexer.consume_doc_comment ();
	  }

void case_187()
#line 1719 "cs-parser.jay"
{
		var type = (FullNamedExpression) yyVals[-3+yyTop];
		current_property = new Property (current_class, type, (Modifiers) yyVals[-4+yyTop],
			(MemberName) yyVals[-2+yyTop], (Attributes) yyVals[-5+yyTop]);
			
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (547, GetLocation (yyVals[-3+yyTop]), "`{0}': property or indexer cannot have void type", current_property.GetSignatureForError ());					
			
		current_container.AddProperty ((Property)current_property);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		
		lexer.PropertyParsing = true;
	  }

void case_188()
#line 1733 "cs-parser.jay"
{
		lexer.PropertyParsing = false;
		
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();				
	  }

void case_189()
#line 1740 "cs-parser.jay"
{
		lbag.AppendToMember (current_property, GetLocation (yyVals[0+yyTop]));
		current_property = null;
	  }

void case_191()
#line 1754 "cs-parser.jay"
{
		valid_param_mod = 0;
		var type = (FullNamedExpression) yyVals[-6+yyTop];
		Indexer indexer = new Indexer (current_class, type, (MemberName) yyVals[-5+yyTop], (Modifiers) yyVals[-7+yyTop], (ParametersCompiled) yyVals[-2+yyTop], (Attributes) yyVals[-8+yyTop]);
			
		current_property = indexer;

  		current_container.AddIndexer (indexer);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
  		
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (620, GetLocation (yyVals[-6+yyTop]), "`{0}': indexer return type cannot be `void'", indexer.GetSignatureForError ());  		

		if (indexer.ParameterInfo.IsEmpty) {
			report.Error (1551, GetLocation (yyVals[-4+yyTop]), "Indexers must have at least one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		lexer.PropertyParsing = true;
	  }

void case_193()
#line 1783 "cs-parser.jay"
{
		if (current_property.AccessorFirst != null && current_property.AccessorFirst.Block == null)
			((Indexer) current_property).ParameterInfo.CheckParameters (current_property);
	  
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();
			
		lbag.AppendToMember (current_property, GetLocation (yyVals[-1+yyTop]));
		current_property = null;		
	  }

void case_198()
#line 1802 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_BRACE) {
	  		report.Error (548, lexer.Location, "`{0}': property or indexer must have at least one accessor", current_property.GetSignatureForError ());
		} else {
			if (yyToken == Token.SEMICOLON)
				report.Error (1597, lexer.Location, "Semicolon after method or accessor block is not valid");
			else
				report.Error (1014, GetLocation (yyVals[0+yyTop]), "A get or set accessor expected");
		}
	  }

void case_199()
#line 1816 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
	  
		if (current_property.Get != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
		
		if (current_property is Indexer) {
			current_property.Get = new Indexer.GetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop], ((Indexer)current_property).ParameterInfo.Clone (),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Get = new Property.GetMethod (current_property,
				(Modifiers) yyVals[-1+yyTop], (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}	
	  
		current_local_parameters = current_property.Get.ParameterInfo;	  
		lexer.PropertyParsing = false;
	  }

void case_200()
#line 1837 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] != null) {
	  		current_property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];			
	  	
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Get.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Get.GetSignatureForError ());
			}
			lbag.AddMember (current_property.Get, GetModifierLocations ());
		} else {
			lbag.AddMember (current_property.Get, GetModifierLocations (), savedLocation);
		}
	  
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support)
			if (Lexer.doc_state == XmlCommentState.Error)
				Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_201()
#line 1861 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
		
		if (current_property.Set != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
	  
		if (current_property is Indexer) {
			current_property.Set = new Indexer.SetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop],
				ParametersCompiled.MergeGenerated (compiler,
				((Indexer)current_property).ParameterInfo, true, new Parameter (
					current_property.TypeExpression, "value", Parameter.Modifier.NONE, null, GetLocation (yyVals[0+yyTop])),
					null),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Set = new Property.SetMethod (current_property, (Modifiers) yyVals[-1+yyTop], 
				ParametersCompiled.CreateImplicitParameter (current_property.TypeExpression, GetLocation (yyVals[0+yyTop])),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}
		
		current_local_parameters = current_property.Set.ParameterInfo;	
		lexer.PropertyParsing = false;
	  }

void case_202()
#line 1887 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {		
			current_property.Set.Block = (ToplevelBlock) yyVals[0+yyTop];
		
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Set.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Set.GetSignatureForError ());
			}
			lbag.AddMember (current_property.Set, GetModifierLocations ());
		} else {
			lbag.AddMember (current_property.Set, GetModifierLocations (), savedLocation);
		}
		
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support
			&& Lexer.doc_state == XmlCommentState.Error)
			Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_204()
#line 1912 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  	yyVal = null;
	  }

void case_205()
#line 1917 "cs-parser.jay"
{
	  	Error_SyntaxError (1043, yyToken, "Invalid accessor body");
	  	yyVal = null;
	  }

void case_207()
#line 1932 "cs-parser.jay"
{
		MemberName name = MakeName ((MemberName) yyVals[0+yyTop]);
		push_current_class (new Interface (current_namespace, current_class, name, (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_class, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));		
	  }

void case_208()
#line 1939 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		current_class.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_209()
#line 1952 "cs-parser.jay"
{
		--lexer.parsing_declaration;	  
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_210()
#line 1958 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) 
			current_class.OptionalSemicolon = GetLocation (yyVals[0+yyTop]);
		lbag.AppendToMember (current_class, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = pop_current_class ();
	  }

void case_226()
#line 2018 "cs-parser.jay"
{
		OperatorDeclaration decl = (OperatorDeclaration) yyVals[-2+yyTop];
		if (decl != null) {
			Operator op = new Operator (
				current_class, decl.optype, decl.ret_type, (Modifiers) yyVals[-3+yyTop], 
				current_local_parameters,
				(ToplevelBlock) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop], decl.location);
				
			if (op.Block == null)
				op.ParameterInfo.CheckParameters (op);

			if (doc_support) {
				op.DocComment = tmpComment;
				Lexer.doc_state = XmlCommentState.Allowed;
			}

			/* Note again, checking is done in semantic analysis*/
			current_container.AddOperator (op);

			lbag.AddMember (op, GetModifierLocations (), lbag.GetLocations (decl));
			if (yyVals[0+yyTop] == null) { /* Semicolon*/
				lbag.AppendTo (op, savedLocation); 
			}
		}
		
		current_local_parameters = null;
	  }

void case_230()
#line 2055 "cs-parser.jay"
{
		report.Error (590, GetLocation (yyVals[0+yyTop]), "User-defined operators cannot return void");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_232()
#line 2067 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		Operator.OpType op = (Operator.OpType) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];
		
		int p_count = current_local_parameters.Count;
		if (p_count == 1) {
			if (op == Operator.OpType.Addition)
				op = Operator.OpType.UnaryPlus;
			else if (op == Operator.OpType.Subtraction)
				op = Operator.OpType.UnaryNegation;
		}
		
		if (IsUnaryOperator (op)) {
			if (p_count == 2) {
				report.Error (1020, loc, "Overloadable binary operator expected");
			} else if (p_count != 1) {
				report.Error (1535, loc, "Overloaded unary operator `{0}' takes one parameter",
					Operator.GetName (op));
			}
		} else {
			if (p_count > 2) {
				report.Error (1534, loc, "Overloaded binary operator `{0}' takes two parameters",
					Operator.GetName (op));
			} else if (p_count != 2) {
				report.Error (1019, loc, "Overloadable unary operator expected");
			}
		}
		
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (op, (FullNamedExpression) yyVals[-6+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), savedOperatorLocation, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_257()
#line 2143 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  
		  
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_259()
#line 2162 "cs-parser.jay"
{
		valid_param_mod = 0;
		
		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  
		  
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Explicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_260()
#line 2177 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_261()
#line 2183 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	yyVal = new OperatorDeclaration (Operator.OpType.Explicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_262()
#line 2193 "cs-parser.jay"
{ 
		Constructor c = (Constructor) yyVals[-1+yyTop];
		c.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (doc_support)
			c.DocComment = ConsumeStoredComment ();

		current_container.AddConstructor (c);

		current_local_parameters = null;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_263()
#line 2212 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		valid_param_mod = ParameterModifierType.All;
	  }

void case_264()
#line 2221 "cs-parser.jay"
{
		valid_param_mod = 0;
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];  
		
		/**/
		/* start block here, so possible anonymous methods inside*/
		/* constructor initializer can get correct parent block*/
		/**/
	  	start_block (lexer.Location);
	  }

void case_265()
#line 2232 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-6+yyTop];
		var mods = (Modifiers) yyVals[-7+yyTop];
		ConstructorInitializer ci = (ConstructorInitializer) yyVals[0+yyTop];

		Constructor c = new Constructor (current_class, lt.Value, mods,
			(Attributes) yyVals[-8+yyTop], current_local_parameters, ci, lt.Location);
		
		if (lt.Value != current_container.MemberName.Name) {
			report.Error (1520, c.Location, "Class, struct, or interface method must have a return type");
		} else if ((mods & Modifiers.STATIC) != 0) {
			if ((mods & Modifiers.AccessibilityMask) != 0){
				report.Error (515, c.Location,
					"`{0}': static constructor cannot have an access modifier",
					c.GetSignatureForError ());
			}
			if (ci != null) {
				report.Error (514, c.Location,
					"`{0}': static constructor cannot have an explicit `this' or `base' constructor call",
					c.GetSignatureForError ());
			
			}
		}
		
		lbag.AddMember (c, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = c;
	  }

void case_271()
#line 2277 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorBaseInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_273()
#line 2287 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorThisInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_274()
#line 2293 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_275()
#line 2301 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
		
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_276()
#line 2310 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		if (lt.Value != current_container.MemberName.Name){
			report.Error (574, lt.Location, "Name of destructor must match name of class");
		} else if (current_container.Kind != MemberKind.Class){
			report.Error (575, lt.Location, "Only class types can contain destructor");
		}
		
		Destructor d = new Destructor (current_class, (Modifiers) yyVals[-6+yyTop],
			ParametersCompiled.EmptyReadOnlyParameters, (Attributes) yyVals[-7+yyTop], lt.Location);
		if (doc_support)
			d.DocComment = ConsumeStoredComment ();
		  
		d.Block = (ToplevelBlock) yyVals[0+yyTop];
		current_container.AddMethod (d);
		lbag.AddMember (d, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[-1+yyTop]));

		current_local_parameters = null;
	  }

void case_277()
#line 2335 "cs-parser.jay"
{
		current_event_field = new EventField (current_class, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], (MemberName) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop]);
		current_container.AddEvent (current_event_field);
		
		if (current_event_field.MemberName.Left != null) {
			report.Error (71, current_event_field.Location, "`{0}': An explicit interface implementation of an event must use property syntax",
			current_event_field.GetSignatureForError ());
		}
		
		yyVal = current_event_field;
	  }

void case_278()
#line 2349 "cs-parser.jay"
{
		if (doc_support) {
			current_event_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AddMember (current_event_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_event_field = null;
	  }

void case_279()
#line 2362 "cs-parser.jay"
{
		current_event = new EventProperty (current_class, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-4+yyTop], (MemberName) yyVals[-1+yyTop], (Attributes) yyVals[-5+yyTop]);
		current_container.AddEvent (current_event);
		lbag.AddMember (current_event, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		
		lexer.EventParsing = true;
	  }

void case_280()
#line 2370 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface)
			report.Error (69, GetLocation (yyVals[-2+yyTop]), "Event in interface cannot have add or remove accessors");
	  
		lexer.EventParsing = false;
	  }

void case_281()
#line 2377 "cs-parser.jay"
{
		if (doc_support) {
			current_event.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AppendToMember (current_event, GetLocation (yyVals[-1+yyTop]));
	  	current_event = null;	
		current_local_parameters = null;
	  }

void case_284()
#line 2396 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_event_field.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_289()
#line 2420 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_291()
#line 2430 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_292()
#line 2439 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (68, lexer.Location, "`{0}': event in interface cannot have an initializer",
				current_event_field.GetSignatureForError ());
		}
		
	  	if ((current_event_field.ModFlags & Modifiers.ABSTRACT) != 0) {
			report.Error (74, lexer.Location, "`{0}': abstract event cannot have an initializer",
				current_event_field.GetSignatureForError ());
	  	}		
	  }

void case_296()
#line 2460 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_297()
#line 2465 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_298()
#line 2470 "cs-parser.jay"
{ 
		report.Error (1055, GetLocation (yyVals[0+yyTop]), "An add or remove accessor expected");
		yyVal = null;
	  }

void case_299()
#line 2478 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Add = new EventProperty.AddDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Add.ParameterInfo;
		
		lbag.AddMember (current_event.Add, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_300()
#line 2490 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Add.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Add.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Add.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_301()
#line 2506 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Remove = new EventProperty.RemoveDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Remove.ParameterInfo;

		lbag.AddMember (current_event.Remove, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_302()
#line 2518 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Remove.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Remove.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Remove.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_303()
#line 2534 "cs-parser.jay"
{
		report.Error (73, lexer.Location, "An add or remove accessor must have a body");
		yyVal = null;
	  }

void case_306()
#line 2550 "cs-parser.jay"
{
		if (doc_support)
			enumTypeComment = Lexer.consume_doc_comment ();
	  }

void case_307()
#line 2555 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
		enumCommas.Add (GetLocation (yyVals[0+yyTop]));

		MemberName name = (MemberName) yyVals[-3+yyTop];
		if (name.IsGeneric) {
			report.Error (1675, name.Location, "Enums cannot have type parameters");
		}
		
		push_current_class (new Enum (current_namespace, current_class, (TypeExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-6+yyTop], MakeName (name), (Attributes) yyVals[-7+yyTop]), null);
	  }

void case_308()
#line 2568 "cs-parser.jay"
{
	  	/* here will be evaluated after CLOSE_BLACE is consumed.*/
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_309()
#line 2574 "cs-parser.jay"
{
		enumCommas.Add (GetLocation (yyVals[-1+yyTop]));
		if (yyVals[0+yyTop] != null)
			current_class.OptionalSemicolon = GetLocation (yyVals[0+yyTop]);
		if (doc_support)
			current_class.DocComment = enumTypeComment;
			
		--lexer.parsing_declaration;

		lbag.AddMember (current_class, GetModifierLocations (), enumCommas);
		enumCommas.Clear ();
		yyVal = pop_current_class ();
	  }

void case_311()
#line 2592 "cs-parser.jay"
{
	 	var te = yyVals[0+yyTop] as TypeExpression;
		if (te == null || !EnumSpec.IsValidUnderlyingType (te.Type)) {
			Enum.Error_1008 (GetLocation (yyVals[0+yyTop]), report);
			yyVal = null;
		} else {
			enumCommas.Add (GetLocation (yyVals[-1+yyTop]));
			yyVal = yyVals[0+yyTop];
		}
	 }

void case_312()
#line 2603 "cs-parser.jay"
{
	 	Error_TypeExpected (GetLocation (yyVals[-1+yyTop]));
		yyVal = null;
	 }

void case_317()
#line 2621 "cs-parser.jay"
{
	  	enumCommas.Add (GetLocation (yyVals[-1+yyTop]));
	  	yyVal = yyVals[0+yyTop];
	  }

void case_318()
#line 2629 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	var em = new EnumMember ((Enum) current_class, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-1+yyTop]);
	  	((Enum) current_class).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_319()
#line 2642 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
	  }

void case_320()
#line 2650 "cs-parser.jay"
{ 
		--lexer.parsing_block;
		
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
	  	var em = new EnumMember ((Enum) current_class, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
	  	em.Initializer = new ConstInitializer (em, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  	((Enum) current_class).AddEnumMember (em);
		
		if (doc_support)
			em.DocComment = ConsumeStoredComment ();

		yyVal = em;
	  }

void case_322()
#line 2675 "cs-parser.jay"
{
		valid_param_mod = 0;

		MemberName name = MakeName ((MemberName) yyVals[-4+yyTop]);
		ParametersCompiled p = (ParametersCompiled) yyVals[-1+yyTop];

		Delegate del = new Delegate (current_namespace, current_class, (FullNamedExpression) yyVals[-5+yyTop],
					     (Modifiers) yyVals[-7+yyTop], name, p, (Attributes) yyVals[-8+yyTop]);
		p.CheckParameters (del);

		ubag.PushTypeDeclaration (del);
		ubag.PopTypeDeclaration ();

		current_container.AddDelegate (del);
		current_delegate = del;
		lexer.ConstraintsParsing = true;
	  }

void case_324()
#line 2697 "cs-parser.jay"
{
		if (doc_support) {
			current_delegate.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  
		current_delegate.SetParameterInfo ((List<Constraints>) yyVals[-2+yyTop]);
		lbag.AddMember (current_delegate, GetModifierLocations (), GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));

		yyVal = current_delegate;

		current_delegate = null;
	  }

void case_326()
#line 2715 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "nullable types");
	  
	  	yyVal = ComposedTypeSpecifier.CreateNullable (GetLocation (yyVals[0+yyTop]));
	  }

void case_328()
#line 2726 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new MemberName (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
	  }

void case_330()
#line 2737 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_331()
#line 2747 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);	  
	  }

void case_333()
#line 2759 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
		var list = locationListStack.Pop ();
		list.Add (GetLocation (yyVals[-2+yyTop]));
		list.Add (GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVals[-1+yyTop], list);
	
		yyVal = yyVals[-1+yyTop];;
	  }

void case_334()
#line 2770 "cs-parser.jay"
{
		Error_TypeExpected (lexer.Location);
		yyVal = new TypeArguments ();
	  }

void case_335()
#line 2778 "cs-parser.jay"
{
		TypeArguments type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
		locationListStack.Push (new List<Location> ());
	  }

void case_336()
#line 2785 "cs-parser.jay"
{
		TypeArguments type_args = (TypeArguments) yyVals[-2+yyTop];
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
		locationListStack.Peek ().Add (GetLocation (yyVals[-1+yyTop]));
	  }

void case_338()
#line 2802 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);
	  }

void case_339()
#line 2811 "cs-parser.jay"
{
	  	MemberName mn = (MemberName)yyVals[0+yyTop];
	  	if (mn.TypeArguments != null)
	  		syntax_error (mn.Location, string.Format ("Member `{0}' cannot declare type arguments",
	  			mn.GetSignatureForError ()));
	  }

void case_341()
#line 2822 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
	  }

void case_342()
#line 2831 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		yyVal = new MemberName (TypeContainer.DefaultIndexerName, GetLocation (yyVals[0+yyTop]));
	  }

void case_343()
#line 2836 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		yyVal = new MemberName ((MemberName) yyVals[-1+yyTop], TypeContainer.DefaultIndexerName, null, GetLocation (yyVals[0+yyTop]));
	  }

void case_344()
#line 2844 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName (lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_345()
#line 2850 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		
		yyVal = new MemberName (lt1.Value, lt2.Value, (TypeArguments) yyVals[-1+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_346()
#line 2858 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_348()
#line 2868 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
	  
		yyVal = yyVals[-1+yyTop];
		lbag.AppendTo (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_349()
#line 2879 "cs-parser.jay"
{
		TypeArguments type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression)yyVals[0+yyTop]);
		yyVal = type_args;
	  }

void case_350()
#line 2885 "cs-parser.jay"
{
		TypeArguments type_args = (TypeArguments) yyVals[-2+yyTop];
		type_args.Add ((FullNamedExpression)yyVals[0+yyTop]);
		yyVal = type_args;
		lbag.AppendTo (type_args, GetLocation (yyVals[-1+yyTop]));
	  }

void case_351()
#line 2895 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[0+yyTop];
		var variance =  (Variance) yyVals[-1+yyTop];
		yyVal = new TypeParameterName (lt.Value, (Attributes)yyVals[-2+yyTop], variance, lt.Location);
		if (variance != Variance.None)
			lbag.AddLocation (yyVal, savedLocation);
  	  }

void case_352()
#line 2903 "cs-parser.jay"
{
  	  	if (GetTokenName (yyToken) == "type")
			report.Error (81, GetLocation (yyVals[0+yyTop]), "Type parameter declaration must be an identifier not a type");
		else
			Error_SyntaxError (yyToken);
			
  	  	yyVal = new TypeParameterName ("", null, lexer.Location);
  	  }

void case_357()
#line 2937 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_359()
#line 2946 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_361()
#line 2955 "cs-parser.jay"
{
	  	report.Error (1536, GetLocation (yyVals[0+yyTop]), "Invalid parameter type `void'");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_364()
#line 2971 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[-1+yyTop];

		if (yyVals[0+yyTop] != null) {
			yyVal = new ComposedCast (name.GetTypeExpression (), (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			if (name.Left == null && name.Name == "var")
				yyVal = new VarExpr (name.Location);
			else
				yyVal = name.GetTypeExpression ();
		}
	  }

void case_366()
#line 2988 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_369()
#line 3004 "cs-parser.jay"
{
		var types = new List<FullNamedExpression> (2);
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = types;
	  }

void case_370()
#line 3010 "cs-parser.jay"
{
		var types = (List<FullNamedExpression>) yyVals[-2+yyTop];
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		lbag.AppendTo (types, GetLocation (yyVals[-1+yyTop]));
		yyVal = types;
	  }

void case_371()
#line 3020 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast) {
			report.Error (1521, GetLocation (yyVals[0+yyTop]), "Invalid base type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
		}
		yyVal = yyVals[0+yyTop];
	  }

void case_372()
#line 3027 "cs-parser.jay"
{
	  	Error_TypeExpected (lexer.Location);
		yyVal = null;
	  }

void case_409()
#line 3089 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);	  
	  }

void case_410()
#line 3093 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	       yyVal = new CompletionSimpleName (MemberName.MakeName (lt.Value, null), lt.Location);
	  }

void case_421()
#line 3134 "cs-parser.jay"
{
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_423()
#line 3146 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_424()
#line 3153 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_425()
#line 3160 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_426()
#line 3167 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_428()
#line 3177 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
	  }

void case_430()
#line 3185 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
 	  }

void case_431()
#line 3193 "cs-parser.jay"
{
		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_434()
#line 3206 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] == null) {
	  		yyVal = CollectionOrObjectInitializers.Empty;
	  		/* TODO: lbag*/
	  	} else {
	  		yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  	}
	  }

void case_435()
#line 3216 "cs-parser.jay"
{
	  	yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_438()
#line 3232 "cs-parser.jay"
{
	  	var a = new List<Expression> ();
	  	a.Add ((Expression) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_439()
#line 3238 "cs-parser.jay"
{
	  	var a = (List<Expression>)yyVals[-2+yyTop];
	  	a.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (a, GetLocation (yyVals[-1+yyTop]));
	  	yyVal = a;
	  }

void case_440()
#line 3244 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_441()
#line 3252 "cs-parser.jay"
{
	  	var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
	  	yyVal = new ElementInitializer (lt.Value, (Expression)yyVals[0+yyTop], lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_443()
#line 3261 "cs-parser.jay"
{
		CompletionSimpleName csn = yyVals[-1+yyTop] as CompletionSimpleName;
		if (csn == null)
			yyVal = new CollectionElementInitializer ((Expression)yyVals[-1+yyTop]);
		else
			yyVal = new CompletionElementInitializer (csn.Prefix, csn.Location);
	  }

void case_444()
#line 3269 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] == null)
			yyVal = null;
		else
	  		yyVal = new CollectionElementInitializer ((List<Expression>)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_445()
#line 3276 "cs-parser.jay"
{
	  	report.Error (1920, GetLocation (yyVals[-1+yyTop]), "An element initializer cannot be empty");
		yyVal = null;
	  }

void case_450()
#line 3294 "cs-parser.jay"
{ 
		Arguments list = new Arguments (4);
		list.Add ((Argument) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_451()
#line 3300 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		if (list [list.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) list [list.Count - 1]);
		
		list.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_452()
#line 3310 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		NamedArgument a = (NamedArgument) yyVals[0+yyTop];
		for (int i = 0; i < list.Count; ++i) {
			NamedArgument na = list [i] as NamedArgument;
			if (na != null && na.Name == a.Name)
				report.Error (1740, na.Location, "Named argument `{0}' specified multiple times",
					na.Name);
		}
		
		list.Add (a);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_453()
#line 3325 "cs-parser.jay"
{
	  	report.Error (839, GetLocation (yyVals[0+yyTop]), "An argument is missing");
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_454()
#line 3330 "cs-parser.jay"
{
	  	report.Error (839, GetLocation (yyVals[-1+yyTop]), "An argument is missing");
	  	yyVal = null;
	  }

void case_459()
#line 3351 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Ref);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_460()
#line 3356 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Out);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_461()
#line 3361 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_462()
#line 3366 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist (GetLocation (yyVals[-2+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_464()
#line 3378 "cs-parser.jay"
{
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_465()
#line 3386 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_466()
#line 3392 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_467()
#line 3398 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_468()
#line 3406 "cs-parser.jay"
{
		Arguments args = new Arguments (4);
		args.Add ((Argument) yyVals[0+yyTop]);
		yyVal = args;
	  }

void case_469()
#line 3412 "cs-parser.jay"
{
		Arguments args = (Arguments) yyVals[-2+yyTop];
		if (args [args.Count - 1] is NamedArgument && !(yyVals[0+yyTop] is NamedArgument))
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
	  
		args.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (args, GetLocation (yyVals[-1+yyTop]));
		yyVal = args;	  
	  }

void case_473()
#line 3440 "cs-parser.jay"
{
	  	yyVal = new ElementAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_474()
#line 3445 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = new ElementAccess (null, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_477()
#line 3467 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			if (lang_version <= LanguageVersion.ISO_2)
				FeatureIsNotAvailable (GetLocation (yyVals[-5+yyTop]), "object initializers");
				
			yyVal = new NewInitialize ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		} else {
			yyVal = new New ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], GetLocation (yyVals[-5+yyTop]));
		}
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_478()
#line 3480 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "collection initializers");
	  
		yyVal = new NewInitialize ((FullNamedExpression) yyVals[-1+yyTop], null, (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_479()
#line 3492 "cs-parser.jay"
{
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], (List<Expression>) yyVals[-3+yyTop],
				new ComposedTypeSpecifier (((List<Expression>) yyVals[-3+yyTop]).Count, GetLocation (yyVals[-4+yyTop])) {
	  				Next = (ComposedTypeSpecifier) yyVals[-1+yyTop]
			  	}, (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_480()
#line 3500 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] == null)
	  		report.Error (1586, GetLocation (yyVals[-3+yyTop]), "Array creation must have array size or array initializer");

		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-2+yyTop], (ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
	  }

void case_481()
#line 3507 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "implicitly typed arrays");
	  
		yyVal = new ImplicitlyTypedArrayCreation ((ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_482()
#line 3514 "cs-parser.jay"
{
		report.Error (178, GetLocation (yyVals[-1+yyTop]), "Invalid rank specifier, expecting `,' or `]'");
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], null, GetLocation (yyVals[-6+yyTop]));
	  }

void case_483()
#line 3519 "cs-parser.jay"
{
		Error_SyntaxError (1526, yyToken, "Unexpected symbol");
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_485()
#line 3530 "cs-parser.jay"
{
		--lexer.parsing_type;
		yyVal = yyVals[0+yyTop];
	  }

void case_486()
#line 3538 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "anonymous types");

		yyVal = new NewAnonymousType ((List<AnonymousTypeParameter>) yyVals[-1+yyTop], current_container, GetLocation (yyVals[-3+yyTop]));
		
		/* TODO: lbag comma location*/
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_491()
#line 3561 "cs-parser.jay"
{
	  	var a = new List<AnonymousTypeParameter> (4);
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_492()
#line 3567 "cs-parser.jay"
{
	  	var a = (List<AnonymousTypeParameter>) yyVals[-2+yyTop];
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	lbag.AppendTo (a, GetLocation (yyVals[-1+yyTop]));

	  	yyVal = a;
	  }

void case_493()
#line 3578 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[-2+yyTop];
	  	yyVal = new AnonymousTypeParameter ((Expression)yyVals[0+yyTop], lt.Value, lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_494()
#line 3584 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (new SimpleName (lt.Value, lt.Location),
	  		lt.Value, lt.Location);
	  }

void case_495()
#line 3590 "cs-parser.jay"
{
	  	MemberAccess ma = (MemberAccess) yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (ma, ma.Name, ma.Location);
	  }

void case_496()
#line 3595 "cs-parser.jay"
{
		report.Error (746, lexer.Location,
			"Invalid anonymous type member declarator. Anonymous type members must be a member assignment, simple name or member access expression");
		yyVal = null;
	  }

void case_500()
#line 3610 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_501()
#line 3618 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension (1, GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_502()
#line 3623 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension ((int)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_507()
#line 3653 "cs-parser.jay"
{
		var ai = new ArrayInitializer (0, GetLocation (yyVals[-1+yyTop]));
		ai.VariableDeclaration = current_variable;
		lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		yyVal = ai;
	  }

void case_508()
#line 3660 "cs-parser.jay"
{
		var ai = new ArrayInitializer ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
		ai.VariableDeclaration = current_variable;
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (ai, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		}
		yyVal = ai;
	  }

void case_509()
#line 3674 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_510()
#line 3680 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_512()
#line 3694 "cs-parser.jay"
{
	  	lexer.TypeOfParsing = false;
		yyVal = new TypeOf ((FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_515()
#line 3705 "cs-parser.jay"
{
	 	Error_TypeExpected (lexer.Location);
	 	yyVal = null;
	 }

void case_516()
#line 3713 "cs-parser.jay"
{  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new SimpleName (lt.Value, (int) yyVals[0+yyTop], lt.Location);
	  }

void case_517()
#line 3719 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (int) yyVals[0+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_518()
#line 3727 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		
		yyVal = new MemberAccess ((Expression) yyVals[-2+yyTop], lt.Value, lt.Location) {
			DotLocation = GetLocation (yyVals[-1+yyTop])
		};
	  }

void case_519()
#line 3735 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (int) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_520()
#line 3743 "cs-parser.jay"
{
		var te = ((MemberName) yyVals[-3+yyTop]).GetTypeExpression ();
		if (te.HasTypeArguments)
			Error_TypeExpected (GetLocation (yyVals[0+yyTop]));

		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (te, lt.Value, (int) yyVals[0+yyTop], lt.Location) {
			DotLocation = GetLocation (yyVals[-2+yyTop])
		};
	  }

void case_521()
#line 3757 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "generics");

		yyVal = yyVals[0+yyTop];
	  }

void case_522()
#line 3767 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (lt.Location, "namespace alias qualifier");

		yyVal = lt;		
	  }

void case_523()
#line 3778 "cs-parser.jay"
{ 
		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_524()
#line 3786 "cs-parser.jay"
{
		yyVal = new CheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_525()
#line 3794 "cs-parser.jay"
{
		yyVal = new UnCheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_526()
#line 3802 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new Indirection ((Expression) yyVals[-3+yyTop], GetLocation (yyVals[-2+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
	  }

void case_528()
#line 3814 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), savedOpenLocation, savedCloseLocation);
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_530()
#line 3827 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), savedOpenLocation, savedCloseLocation);
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_534()
#line 3852 "cs-parser.jay"
{
		valid_param_mod = 0;
	  	yyVal = yyVals[-1+yyTop];
	  	savedOpenLocation = GetLocation (yyVals[-3+yyTop]);
	  	savedCloseLocation = GetLocation (yyVals[-2+yyTop]);
	  }

void case_535()
#line 3862 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "default value expression");

		yyVal = new DefaultValueExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_541()
#line 3887 "cs-parser.jay"
{
		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_542()
#line 3895 "cs-parser.jay"
{
		current_block.ParametersBlock.IsAsync = true;
		yyVal = new Await ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_551()
#line 3936 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Multiply, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_552()
#line 3941 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Division, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_553()
#line 3946 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Modulus, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_555()
#line 3955 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Addition, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_557()
#line 3964 "cs-parser.jay"
{
	  	/* Shift/Reduce conflict*/
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
  	  }

void case_561()
#line 3981 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LeftShift, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_562()
#line 3986 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.RightShift, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_564()
#line 3995 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThan, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_565()
#line 4000 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThan, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_566()
#line 4005 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThanOrEqual, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_567()
#line 4010 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_569()
#line 4019 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Equality, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_570()
#line 4024 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Inequality, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_572()
#line 4033 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseAnd, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_574()
#line 4042 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.ExclusiveOr, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_576()
#line 4051 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseOr, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_578()
#line 4060 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalAnd, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_580()
#line 4069 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalOr, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_582()
#line 4078 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "null coalescing operator");
			
		yyVal = new Nullable.NullCoalescingOperator ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_584()
#line 4089 "cs-parser.jay"
{
		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_586()
#line 4101 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_587()
#line 4106 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_588()
#line 4111 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_589()
#line 4116 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_590()
#line 4121 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_591()
#line 4126 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_592()
#line 4131 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_593()
#line 4136 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_594()
#line 4141 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_595()
#line 4146 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_596()
#line 4154 "cs-parser.jay"
{
		var pars = new List<Parameter> (4);
		pars.Add ((Parameter) yyVals[0+yyTop]);
		parameterListCommas.Clear ();
		yyVal = pars;
	  }

void case_597()
#line 4161 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter)yyVals[0+yyTop];
		if (pars[0].GetType () != p.GetType ()) {
			report.Error (748, p.Location, "All lambda parameters must be typed either explicitly or implicitly");
		}
		
		pars.Add (p);
		parameterListCommas.Add (GetLocation (yyVals[-1+yyTop]));

		yyVal = pars;
	  }

void case_598()
#line 4177 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], null, lt.Location);
	  }

void case_599()
#line 4183 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, Parameter.Modifier.NONE, null, lt.Location);
	  }

void case_600()
#line 4189 "cs-parser.jay"
{
	  	var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new ImplicitLambdaParameter (lt.Value, lt.Location);
	  }

void case_602()
#line 4197 "cs-parser.jay"
{ 
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
		yyVal = new ParametersCompiled (pars_list.ToArray ());
		lbag.AddLocation (yyVal, parameterListCommas);
	  }

void case_606()
#line 4214 "cs-parser.jay"
{
		Block b = end_block (lexer.Location);
		b.IsCompilerGenerated = true;
		b.AddStatement (new ContextualReturn ((Expression) yyVals[0+yyTop]));
		yyVal = b;
	  }

void case_608()
#line 4225 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	
		yyVal = EmptyExpression.Null;
	  }

void case_609()
#line 4233 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];	
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), false, lt.Location);
	  }

void case_610()
#line 4239 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_611()
#line 4244 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), true, lt.Location);
	  }

void case_612()
#line 4250 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_614()
#line 4259 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], false, GetLocation (yyVals[-4+yyTop]));
	  }

void case_615()
#line 4264 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_617()
#line 4273 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], true, GetLocation (yyVals[-5+yyTop]));
	  }

void case_618()
#line 4278 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_625()
#line 4301 "cs-parser.jay"
{
		yyVal = new RefValueExpr ((Expression) yyVals[-3+yyTop], (FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_626()
#line 4306 "cs-parser.jay"
{
		yyVal = new RefTypeExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_627()
#line 4311 "cs-parser.jay"
{
		yyVal = new MakeRefExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));	  
	  }

void case_631()
#line 4340 "cs-parser.jay"
{
		MemberName name = MakeName ((MemberName) yyVals[0+yyTop]);
		Class c = new Class (current_namespace, current_class, name, (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]);
		if (((c.ModFlags & Modifiers.STATIC) != 0) && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (c.Location, "static classes");
		}
		
		push_current_class (c, yyVals[-3+yyTop]);
		lbag.AddMember (current_class, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));
	  }

void case_632()
#line 4352 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		current_class.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lexer.parsing_modifiers = true;
	  }

void case_633()
#line 4365 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_634()
#line 4371 "cs-parser.jay"
{
		lbag.AppendToMember (current_class, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		if (yyVals[0+yyTop] != null) 
			current_class.OptionalSemicolon = GetLocation (yyVals[0+yyTop]);
		yyVal = pop_current_class ();
	  }

void case_637()
#line 4388 "cs-parser.jay"
{
	    mod_locations = null;
		yyVal = ModifierNone;
		lexer.parsing_modifiers = false;
	  }

void case_640()
#line 4402 "cs-parser.jay"
{ 
		var m1 = (Modifiers) yyVals[-1+yyTop];
		var m2 = (Modifiers) yyVals[0+yyTop];

		if ((m1 & m2) != 0) {
			report.Error (1004, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"Duplicate `{0}' modifier", ModifiersExtensions.Name (m2));
		} else if ((m2 & Modifiers.AccessibilityMask) != 0 && (m1 & Modifiers.AccessibilityMask) != 0 &&
			((m2 | m1 & Modifiers.AccessibilityMask) != (Modifiers.PROTECTED | Modifiers.INTERNAL))) {
			report.Error (107, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"More than one protection modifier specified");
		}
		
		yyVal = m1 | m2;
	  }

void case_641()
#line 4421 "cs-parser.jay"
{
		yyVal = Modifiers.NEW;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		
		if (current_container == module)
			report.Error (1530, GetLocation (yyVals[0+yyTop]), "Keyword `new' is not allowed on namespace elements");
	  }

void case_642()
#line 4429 "cs-parser.jay"
{
		yyVal = Modifiers.PUBLIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_643()
#line 4434 "cs-parser.jay"
{
		yyVal = Modifiers.PROTECTED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_644()
#line 4439 "cs-parser.jay"
{
		yyVal = Modifiers.INTERNAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_645()
#line 4444 "cs-parser.jay"
{
		yyVal = Modifiers.PRIVATE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_646()
#line 4449 "cs-parser.jay"
{
		yyVal = Modifiers.ABSTRACT;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_647()
#line 4454 "cs-parser.jay"
{
		yyVal = Modifiers.SEALED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_648()
#line 4459 "cs-parser.jay"
{
		yyVal = Modifiers.STATIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_649()
#line 4464 "cs-parser.jay"
{
		yyVal = Modifiers.READONLY;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_650()
#line 4469 "cs-parser.jay"
{
		yyVal = Modifiers.VIRTUAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_651()
#line 4474 "cs-parser.jay"
{
		yyVal = Modifiers.OVERRIDE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_652()
#line 4479 "cs-parser.jay"
{
		yyVal = Modifiers.EXTERN;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_653()
#line 4484 "cs-parser.jay"
{
		yyVal = Modifiers.VOLATILE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_654()
#line 4489 "cs-parser.jay"
{
		yyVal = Modifiers.UNSAFE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_655()
#line 4496 "cs-parser.jay"
{
		yyVal = Modifiers.ASYNC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_657()
#line 4505 "cs-parser.jay"
{
		lbag.AppendToMember (current_class, GetLocation (yyVals[-1+yyTop]));
		current_container.AddBasesForPart (current_class, (List<FullNamedExpression>) yyVals[0+yyTop]);
	 }

void case_660()
#line 4518 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	 }

void case_661()
#line 4526 "cs-parser.jay"
{
		var constraints = new List<Constraints> (1);
		constraints.Add ((Constraints) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_662()
#line 4532 "cs-parser.jay"
{
		var constraints = (List<Constraints>) yyVals[-1+yyTop];
		Constraints new_constraint = (Constraints)yyVals[0+yyTop];

		foreach (Constraints c in constraints) {
			if (new_constraint.TypeParameter.Value == c.TypeParameter.Value) {
				report.Error (409, new_constraint.Location,
					"A constraint clause has already been specified for type parameter `{0}'",
					new_constraint.TypeParameter.Value);
			}
		}

		constraints.Add (new_constraint);
		yyVal = constraints;
	  }

void case_663()
#line 4551 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), (List<FullNamedExpression>) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_664()
#line 4560 "cs-parser.jay"
{
		var constraints = new List<FullNamedExpression> (1);
		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_665()
#line 4566 "cs-parser.jay"
{
		var constraints = (List<FullNamedExpression>) yyVals[-2+yyTop];
		var prev = constraints [constraints.Count - 1] as SpecialContraintExpr;
		if (prev != null && (prev.Constraint & SpecialConstraint.Constructor) != 0) {			
			report.Error (401, GetLocation (yyVals[-1+yyTop]), "The `new()' constraint must be the last constraint specified");
		}
		
		prev = yyVals[0+yyTop] as SpecialContraintExpr;
		if (prev != null) {
			if ((prev.Constraint & (SpecialConstraint.Class | SpecialConstraint.Struct)) != 0) {
				report.Error (449, prev.Location, "The `class' or `struct' constraint must be the first constraint specified");			
			} else {
			 	prev = constraints [0] as SpecialContraintExpr;
			 	if (prev != null && (prev.Constraint & SpecialConstraint.Struct) != 0) {			
					report.Error (451, GetLocation (yyVals[0+yyTop]), "The `new()' constraint cannot be used with the `struct' constraint");
				}
			}
		}

		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		lbag.AppendTo (constraints, GetLocation (yyVals[-1+yyTop]));
		yyVal = constraints;
	  }

void case_666()
#line 4593 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast)
			report.Error (706, GetLocation (yyVals[0+yyTop]), "Invalid constraint type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
	  
	  	yyVal = yyVals[0+yyTop];
	  }

void case_667()
#line 4600 "cs-parser.jay"
{
		yyVal = new SpecialContraintExpr (SpecialConstraint.Constructor, GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_671()
#line 4620 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (lexer.Location, "generic type variance");

		yyVal = yyVals[0+yyTop];
	  }

void case_672()
#line 4630 "cs-parser.jay"
{
		yyVal = Variance.Covariant;
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_673()
#line 4635 "cs-parser.jay"
{
		yyVal = Variance.Contravariant;
		savedLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_674()
#line 4656 "cs-parser.jay"
{
		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_676()
#line 4668 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_677()
#line 4673 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (lexer.Location);
	  }

void case_678()
#line 4682 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_block.StartLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_679()
#line 4687 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_687()
#line 4714 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_720()
#line 4778 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_721()
#line 4783 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_722()
#line 4788 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_723()
#line 4796 "cs-parser.jay"
{
		/* Uses lexer.Location because semicolon location is not kept in quick mode*/
		yyVal = new EmptyStatement (lexer.Location);
	  }

void case_724()
#line 4804 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		LabeledStatement labeled = new LabeledStatement (lt.Value, current_block, lt.Location);
		lbag.AddLocation (labeled, GetLocation (yyVals[0+yyTop]));
		current_block.AddLabel (labeled);
		current_block.AddStatement (labeled);
	  }

void case_727()
#line 4817 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] is VarExpr)
			yyVals[-1+yyTop] = new SimpleName ("var", ((VarExpr) yyVals[-1+yyTop]).Location);
	  
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_728()
#line 4833 "cs-parser.jay"
{ 
		/* Ok, the above "primary_expression" is there to get rid of*/
		/* both reduce/reduce and shift/reduces in the grammar, it should*/
		/* really just be "type_name".  If you use type_name, a reduce/reduce*/
		/* creeps up.  If you use namespace_or_type_name (which is all we need*/
		/* really) two shift/reduces appear.*/
		/* */

		/* So the super-trick is that primary_expression*/
		/* can only be either a SimpleName or a MemberAccess. */
		/* The MemberAccess case arises when you have a fully qualified type-name like :*/
		/* Foo.Bar.Blah i;*/
		/* SimpleName is when you have*/
		/* Blah i;*/
		
		Expression expr = (Expression) yyVals[-1+yyTop];
		if (yyVals[0+yyTop] == null) {
			SimpleName sn = expr as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		} else if (expr is ATypeNameExpression) {
			yyVal = new ComposedCast ((ATypeNameExpression)expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName (expr);
			yyVal = null;
		}
	  }

void case_729()
#line 4863 "cs-parser.jay"
{
		ATypeNameExpression expr = yyVals[-1+yyTop] as ATypeNameExpression;

		if (expr != null) {
			yyVal = new ComposedCast (expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName ((Expression)yyVals[-1+yyTop]);
			yyVal = expr;
		}
	  }

void case_730()
#line 4874 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null)
			yyVal = yyVals[-1+yyTop];
		else
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_733()
#line 4889 "cs-parser.jay"
{
		Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_735()
#line 4898 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_737()
#line 4913 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_738()
#line 4920 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
		lbag.AppendTo (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_739()
#line 4926 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockConstantDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_740()
#line 4933 "cs-parser.jay"
{
		if (current_variable.Initializer != null) {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = current_variable;;
		current_variable = null;
	  }

void case_742()
#line 4947 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendTo (current_variable, GetLocation (yyVals[-1+yyTop]));
	  }

void case_743()
#line 4952 "cs-parser.jay"
{
	  	if (yyToken == Token.OPEN_BRACKET_EXPR) {
			report.Error (650, lexer.Location,
				"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
		} else {
			Error_SyntaxError (yyToken);
		}
	  }

void case_747()
#line 4970 "cs-parser.jay"
{
		foreach (var d in current_variable.Declarators) {
			if (d.Initializer == null)
				Error_MissingInitializer (d.Variable.Location);
		}
	  }

void case_750()
#line 4985 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, null);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-1+yyTop]));
	  }

void case_751()
#line 4994 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_753()
#line 5010 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_758()
#line 5028 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_760()
#line 5041 "cs-parser.jay"
{
		yyVal = new StackAlloc ((Expression) yyVals[-3+yyTop], (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_761()
#line 5046 "cs-parser.jay"
{
		report.Error (1575, GetLocation (yyVals[-1+yyTop]), "A stackalloc expression requires [] after type");
		yyVal = new StackAlloc ((Expression) yyVals[0+yyTop], null, GetLocation (yyVals[-1+yyTop]));		
	  }

void case_762()
#line 5054 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_766()
#line 5072 "cs-parser.jay"
{
		ExpressionStatement s = yyVals[0+yyTop] as ExpressionStatement;
		if (s == null) {
			Expression.Error_InvalidExpressionStatement (report, GetLocation (yyVals[0+yyTop]));
			yyVal = new StatementExpression (EmptyExpressionStatement.Instance);
		} else {
			yyVal = new StatementExpression (s);
		}
	  }

void case_767()
#line 5085 "cs-parser.jay"
{
		Expression expr = (Expression) yyVals[0+yyTop];
		ExpressionStatement s;

	        s = new OptionalAssign (new SimpleName ("$retval", lexer.Location), expr, lexer.Location);
		yyVal = new StatementExpression (s);
	  }

void case_768()
#line 5093 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_771()
#line 5107 "cs-parser.jay"
{ 
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		yyVal = new If ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_772()
#line 5116 "cs-parser.jay"
{
		yyVal = new If ((BooleanExpression) yyVals[-4+yyTop], (Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		
		if (yyVals[-2+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[-2+yyTop]));
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_774()
#line 5133 "cs-parser.jay"
{
		yyVal = new Switch ((Expression) yyVals[-5+yyTop], (ExplicitBlock) current_block.Explicit, (List<SwitchSection>) yyVals[-1+yyTop], GetLocation (yyVals[-7+yyTop]));	
		end_block (GetLocation (yyVals[0+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_775()
#line 5142 "cs-parser.jay"
{
		report.Warning (1522, 1, current_block.StartLocation, "Empty switch block"); 
		yyVal = new List<SwitchSection> ();
	  }

void case_777()
#line 5151 "cs-parser.jay"
{
		var sections = new List<SwitchSection> (4);

		sections.Add ((SwitchSection) yyVals[0+yyTop]);
		yyVal = sections;
	  }

void case_778()
#line 5158 "cs-parser.jay"
{
		var sections = (List<SwitchSection>) yyVals[-1+yyTop];

		sections.Add ((SwitchSection) yyVals[0+yyTop]);
		yyVal = sections;
	  }

void case_779()
#line 5165 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	  
		yyVal = new List<SwitchSection> ();
	  }

void case_782()
#line 5184 "cs-parser.jay"
{
		var labels = new List<SwitchLabel> (2);

		labels.Add ((SwitchLabel) yyVals[0+yyTop]);
		yyVal = labels;
	  }

void case_783()
#line 5191 "cs-parser.jay"
{
		var labels = (List<SwitchLabel>) (yyVals[-1+yyTop]);
		labels.Add ((SwitchLabel) yyVals[0+yyTop]);

		yyVal = labels;
	  }

void case_784()
#line 5201 "cs-parser.jay"
{
	 	yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	 	lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	 }

void case_790()
#line 5220 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new While ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_791()
#line 5232 "cs-parser.jay"
{
		yyVal = new Do ((Statement) yyVals[-5+yyTop], (BooleanExpression) yyVals[-2+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_792()
#line 5240 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[0+yyTop]));
		current_block.IsCompilerGenerated = true;
	  }

void case_794()
#line 5256 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		For f = new For ((Statement) yyVals[-6+yyTop], (BooleanExpression) yyVals[-4+yyTop], (Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, current_block.StartLocation, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));

		yyVal = end_block (GetLocation (yyVals[-5+yyTop]));
	  }

void case_795()
#line 5268 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = end_block (current_block.StartLocation);
	  }

void case_798()
#line 5281 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_799()
#line 5288 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_807()
#line 5312 "cs-parser.jay"
{
	  	var sl = yyVals[-2+yyTop] as StatementList;
	  	if (sl == null) {
	  		sl = new StatementList ((Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop]);
			lbag.AddStatement (sl, GetLocation (yyVals[-1+yyTop]));
	  	} else {
	  		sl.Add ((Statement) yyVals[0+yyTop]);
	  		lbag.AppendTo (sl, GetLocation (yyVals[-1+yyTop]));
	  	}
	  		
		yyVal = sl;
	  }

void case_808()
#line 5328 "cs-parser.jay"
{
		report.Error (230, GetLocation (yyVals[-5+yyTop]), "Type and identifier are both required in a foreach statement");
		yyVal = null;
	  }

void case_809()
#line 5333 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-5+yyTop]));
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		yyVal = li;
	  }

void case_810()
#line 5342 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Foreach f = new Foreach ((Expression) yyVals[-6+yyTop], (LocalVariable) yyVals[-1+yyTop], (Expression) yyVals[-3+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-8+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_817()
#line 5365 "cs-parser.jay"
{
		yyVal = new Break (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_818()
#line 5373 "cs-parser.jay"
{
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_819()
#line 5381 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new Goto (lt.Value, GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_820()
#line 5387 "cs-parser.jay"
{
		yyVal = new GotoCase ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_821()
#line 5392 "cs-parser.jay"
{
		yyVal = new GotoDefault (GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_822()
#line 5400 "cs-parser.jay"
{
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_823()
#line 5408 "cs-parser.jay"
{
		yyVal = new Throw ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_824()
#line 5416 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.ParametersBlock.TopBlock.IsIterator = true;
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_825()
#line 5432 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.ParametersBlock.TopBlock.IsIterator = true;
		yyVal = new YieldBreak (lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_829()
#line 5458 "cs-parser.jay"
{
		yyVal = new TryFinally ((Statement) yyVals[-2+yyTop], (Block) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_830()
#line 5463 "cs-parser.jay"
{
		yyVal = new TryFinally (new TryCatch ((Block) yyVals[-3+yyTop], (List<Catch>) yyVals[-2+yyTop], GetLocation (yyVals[-4+yyTop]), true), (Block) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_831()
#line 5468 "cs-parser.jay"
{
		report.Error (1524, GetLocation (yyVals[-2+yyTop]), "Expected catch or finally");
		yyVal = null;
	  }

void case_832()
#line 5476 "cs-parser.jay"
{
		var l = new List<Catch> (2);

		l.Add ((Catch) yyVals[0+yyTop]);
		yyVal = l;
	  }

void case_833()
#line 5483 "cs-parser.jay"
{
		var l = (List<Catch>) yyVals[-1+yyTop];
		
		Catch c = (Catch) yyVals[0+yyTop];
		if (l [0].IsGeneral) {
			report.Error (1017, c.loc, "Try statement already has an empty catch block");
		} else {
			if (c.IsGeneral)
				l.Insert (0, c);
			else
				l.Add (c);
		}
		
		yyVal = l;
	  }

void case_837()
#line 5511 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		var c = new Catch (current_block, GetLocation (yyVals[-4+yyTop]));
		c.TypeExpression = (FullNamedExpression) yyVals[-2+yyTop];

		if (yyVals[-1+yyTop] != null) {
			var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
			current_block.AddLocalName (c.Variable);
		}

		lbag.AddLocation (c, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;
	  }

void case_839()
#line 5530 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_PARENS) {
			report.Error (1015, lexer.Location,
				"A type that derives from `System.Exception', `object', or `string' expected");
		} else {
			Error_SyntaxError (yyToken);
		}
		
		yyVal = new Catch (null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_842()
#line 5558 "cs-parser.jay"
{
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_844()
#line 5568 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Lock ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_845()
#line 5579 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.FixedVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Fixed.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_846()
#line 5589 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_847()
#line 5594 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Fixed f = new Fixed ((Fixed.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, GetLocation (yyVals[-8+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_848()
#line 5607 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.UsingVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Using.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_849()
#line 5617 "cs-parser.jay"
{
		yyVal = current_variable;	  
		current_variable = null;
	  }

void case_850()
#line 5622 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Using u = new Using ((Using.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		lbag.AddStatement (u, GetLocation (yyVals[-8+yyTop]), GetLocation (yyVals[-2+yyTop]));
		current_block.AddStatement (u);
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_851()
#line 5632 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Using u = new Using ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (u, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		yyVal = u;
	  }

void case_853()
#line 5648 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendTo (current_variable, GetLocation (yyVals[-1+yyTop]));
		yyVal = current_variable;
	  }

void case_854()
#line 5660 "cs-parser.jay"
{
		lexer.query_parsing = false;
			
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_855()
#line 5672 "cs-parser.jay"
{
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_856()
#line 5683 "cs-parser.jay"
{
	        lexer.query_parsing = false;
		yyVal = yyVals[-1+yyTop];

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_857()
#line 5690 "cs-parser.jay"
{
	        yyVal = yyVals[-1+yyTop];
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_858()
#line 5699 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop])));
	  }

void case_859()
#line 5707 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (
			new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
				IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
			}
		);
	  }

void case_860()
#line 5722 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop])));
	  }

void case_861()
#line 5730 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (
			new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
				IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
			}
		);
	  }

void case_863()
#line 5749 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_865()
#line 5764 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);

		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-4+yyTop]
		};
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_866()
#line 5781 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[-1+yyTop];
		
		if (yyVals[0+yyTop] != null)
			head.Next = (Linq.AQueryClause)yyVals[0+yyTop];
				
		if (yyVals[-2+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-2+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_868()
#line 5797 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_870()
#line 5809 "cs-parser.jay"
{
		yyVal = new Linq.Select ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_871()
#line 5816 "cs-parser.jay"
{
	  	if (linq_clause_blocks == null)
	  		linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  	linq_clause_blocks.Push ((Linq.QueryBlock)current_block);
	  }

void case_872()
#line 5824 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_873()
#line 5831 "cs-parser.jay"
{
		yyVal = new Linq.GroupBy ((Linq.QueryBlock)current_block, (Expression)yyVals[-3+yyTop], linq_clause_blocks.Pop (), (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_877()
#line 5848 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-1+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-1+yyTop];
	  }

void case_884()
#line 5868 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
	  	yyVal = new Linq.Let ((Linq.QueryBlock) current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_886()
#line 5887 "cs-parser.jay"
{
		yyVal = new Linq.Where ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_887()
#line 5897 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_888()
#line 5905 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_889()
#line 5913 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_890()
#line 5921 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();

		var lt = (Tokenizer.LocatedToken) yyVals[-10+yyTop];	
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-11+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
			
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location);

			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-11+yyTop]));	
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		}

		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);
	  }

void case_891()
#line 5959 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_892()
#line 5967 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_893()
#line 5975 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_894()
#line 5983 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();
		
		var lt = (Tokenizer.LocatedToken) yyVals[-10+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;		
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
		
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location); /* TODO:*/
			
			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};			
		}
		
		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);		
	  }

void case_898()
#line 6038 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		yyVal = yyVals[0+yyTop];
	  }

void case_900()
#line 6049 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_901()
#line 6056 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	  }

void case_903()
#line 6065 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock ((Linq.QueryBlock) current_block, lexer.Location);	 
	 }

void case_904()
#line 6072 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	 }

void case_906()
#line 6084 "cs-parser.jay"
{
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_907()
#line 6089 "cs-parser.jay"
{
		yyVal = new Linq.OrderByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_909()
#line 6101 "cs-parser.jay"
{
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_910()
#line 6106 "cs-parser.jay"
{
		yyVal = new Linq.ThenByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_912()
#line 6116 "cs-parser.jay"
{
		/* query continuation block is not linked with query block but with block*/
		/* before. This means each query can use same range variable names for*/
		/* different identifiers.*/

		current_block.SetEndLocation (GetLocation (yyVals[-1+yyTop]));
		current_block = current_block.Parent;
	
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);		
	  }

void case_913()
#line 6132 "cs-parser.jay"
{
		var current_block = linq_clause_blocks.Pop ();	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
  		yyVal = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, null, rv, GetLocation (yyVals[-3+yyTop])) {
  			next = (Linq.AQueryClause)yyVals[0+yyTop]
  		};
	  }

void case_916()
#line 6159 "cs-parser.jay"
{ 
		current_container = new Class (current_namespace, current_class, new MemberName ("<InteractiveExpressionClass>"), Modifiers.PUBLIC, null);
		current_class = current_container;

		/* (ref object retval)*/
		Parameter [] mpar = new Parameter [1];
		mpar [0] = new Parameter (new TypeExpression (compiler.BuiltinTypes.Object, Location.Null), "$retval", Parameter.Modifier.REF, null, Location.Null);

		ParametersCompiled pars = new ParametersCompiled (mpar);
		var mods = Modifiers.PUBLIC | Modifiers.STATIC;
		if (settings.Unsafe)
			mods |= Modifiers.UNSAFE;

		current_local_parameters = pars;
		Method method = new Method (
			current_class,
			null, /* generic*/
			new TypeExpression (compiler.BuiltinTypes.Void, Location.Null),
			mods,
			new MemberName ("Host"),
			pars,
			null /* attributes */);
			
		current_container.AddMethod (method);			

		oob_stack.Push (method);
		++lexer.parsing_block;
		start_block (lexer.Location);
	  }

void case_917()
#line 6189 "cs-parser.jay"
{
		--lexer.parsing_block;
		Method method = (Method) oob_stack.Pop ();

		method.Block = (ToplevelBlock) end_block(lexer.Location);

		InteractiveResult = (Class) pop_current_class ();
		current_local_parameters = null;
	  }

void case_927()
#line 6232 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-1+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		yyVal = null;
	  }

void case_928()
#line 6238 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-3+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value);
	  }

void case_931()
#line 6253 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-6+yyTop], new MemberName (MemberCache.IndexerNameAlias));
	  }

void case_932()
#line 6258 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Explicit;
		yyVal = null;
	  }

void case_933()
#line 6266 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Implicit;
		yyVal = null;
	  }

void case_934()
#line 6274 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = (Operator.OpType) yyVals[-1+yyTop];
		yyVal = null;
	  }

void case_942()
#line 6312 "cs-parser.jay"
{
		var parameters = new List<DocumentationParameter> ();
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_943()
#line 6318 "cs-parser.jay"
{
		var parameters = yyVals[-2+yyTop] as List<DocumentationParameter>;
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_944()
#line 6327 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != null)
			yyVal = new DocumentationParameter ((Parameter.Modifier) yyVals[-1+yyTop], (FullNamedExpression) yyVals[0+yyTop]);
		else
			yyVal = new DocumentationParameter ((FullNamedExpression) yyVals[0+yyTop]);
	  }

#line default
   static readonly short [] yyLhs  = {              -1,
    0,    4,    0,    0,    1,    1,    1,    1,    2,    2,
   11,   11,   12,   12,   13,   13,   14,   14,   15,   15,
   16,   21,   22,   19,   20,   20,   20,   24,   24,   25,
   25,   18,    7,    7,    6,    6,   23,   23,    8,    8,
   26,   26,   27,   27,   27,   27,   27,    9,    9,   10,
   10,   35,   33,   38,   34,   34,   36,   36,   36,   36,
   37,   37,   42,   39,   40,   41,   41,   43,   43,   43,
   43,   43,   44,   44,   48,   45,   47,   49,   49,   49,
   50,   50,   51,   51,   52,   52,   52,   52,   52,   52,
   52,   52,   52,   52,   52,   65,   67,   69,   70,   71,
   29,   29,   74,   53,   75,   75,   76,   76,   77,   79,
   73,   73,   78,   78,   84,   54,   88,   54,   54,   83,
   91,   83,   85,   85,   92,   92,   93,   94,   93,   89,
   89,   95,   95,   96,   97,   87,   87,   90,   90,   90,
  100,   55,  103,  104,   98,  105,  106,  107,   98,   98,
   99,   99,  102,  102,  110,  110,  110,  110,  110,  110,
  110,  110,  110,  110,  111,  111,  114,  114,  114,  117,
  114,  115,  115,  118,  118,  119,  119,  119,  112,  112,
  112,  120,  120,  120,  113,  122,  124,  125,   56,  127,
  128,  129,   58,  123,  123,  123,  123,  123,  133,  130,
  134,  131,  132,  132,  132,  135,  136,  137,  139,   30,
   30,  138,  138,  140,  140,  141,  141,  141,  141,  141,
  141,  141,  141,  141,  144,   59,  143,  143,  145,  145,
  148,  142,  142,  147,  147,  147,  147,  147,  147,  147,
  147,  147,  147,  147,  147,  147,  147,  147,  147,  147,
  147,  147,  147,  147,  147,  150,  149,  151,  149,  149,
  149,   60,  154,  156,  152,  153,  153,  155,  155,  160,
  158,  161,  158,  158,  162,   61,  164,   57,  167,  168,
   57,  163,  170,  163,  165,  165,  171,  171,  172,  173,
  172,  174,  169,  166,  166,  166,  166,  166,  178,  175,
  179,  176,  177,  177,  180,  182,  184,  185,   31,  181,
  181,  181,  183,  183,  183,  186,  186,  187,  188,  187,
  189,  190,  191,   32,  192,  192,   17,   17,  193,  193,
  196,  195,  195,  195,  197,  197,  199,   64,  121,  101,
  101,  126,  126,  200,  200,  200,  198,  198,  201,  201,
  202,  202,  204,  204,   82,   72,   72,   86,   86,  116,
  116,  146,  146,  205,  205,  205,  205,  205,  209,  209,
  210,  210,  208,  208,  208,  208,  208,  208,  208,  211,
  211,  211,  211,  211,  211,  211,  211,  211,  212,  212,
  212,  212,  212,  212,  212,  212,  212,  212,  212,  212,
  212,  212,  212,  212,  212,  212,  212,  212,  213,  213,
  213,  214,  214,  214,  234,  234,  235,  235,  236,  236,
  216,  216,  233,  233,  233,  233,  233,  233,  233,  233,
  218,  237,  237,  238,  238,  239,  239,  241,  241,  241,
  242,  242,  242,  242,  242,  243,  243,  159,  159,  247,
  247,  247,  247,  247,  249,  249,  248,  248,  250,  250,
  250,  250,  251,  219,  246,  246,  246,  252,  252,  253,
  253,  220,  221,  221,  222,  223,  224,  224,  215,  215,
  215,  215,  215,  258,  254,  225,  259,  259,  260,  260,
  261,  261,  262,  262,  262,  262,  255,  255,  206,  206,
  257,  257,  263,  263,  256,  256,   81,   81,  264,  264,
  265,  226,  266,  266,  266,  267,  267,  267,  267,  267,
  268,  194,  227,  228,  229,  230,  270,  231,  271,  231,
  269,  269,  273,  272,  217,  274,  274,  274,  274,  274,
  276,  277,  275,  275,  275,  275,  275,  275,  275,  278,
  278,  278,  278,  279,  279,  279,  279,  279,  279,  280,
  280,  280,  281,  281,  281,  281,  281,  282,  282,  282,
  283,  283,  284,  284,  285,  285,  286,  286,  287,  287,
  288,  288,  289,  289,  290,  290,  290,  290,  290,  290,
  290,  290,  290,  290,  290,  291,  291,  292,  292,  292,
  293,  293,  294,  294,  297,  295,  296,  296,  299,  298,
  300,  298,  301,  302,  298,  303,  304,  298,   46,   46,
  244,  244,  244,  244,  232,  232,  232,   80,  306,  307,
  308,  309,  310,   28,   63,   63,   62,   62,  108,  108,
  311,  311,  311,  311,  311,  311,  311,  311,  311,  311,
  311,  311,  311,  311,  311,   66,   66,   68,   68,   68,
  312,  312,  313,  314,  314,  315,  315,  315,  315,  203,
  203,  316,  316,  318,  109,  319,  319,  320,  157,  317,
  317,  321,  321,  322,  322,  322,  322,  326,  326,  327,
  327,  327,  324,  324,  324,  324,  324,  324,  324,  324,
  324,  324,  324,  324,  324,  328,  328,  328,  328,  328,
  328,  328,  328,  328,  328,  328,  328,  328,  342,  342,
  342,  342,  329,  343,  325,  344,  344,  345,  345,  345,
  345,  345,  345,  207,  207,  346,  348,  323,  351,  323,
  347,  347,  347,  349,  349,  355,  355,  354,  354,  356,
  356,  350,  350,  352,  352,  357,  357,  358,  353,  353,
  353,  330,  330,  341,  341,  359,  360,  360,  331,  331,
  361,  361,  364,  362,  363,  363,  365,  365,  365,  368,
  366,  367,  367,  369,  369,  332,  332,  332,  332,  370,
  371,  375,  372,  374,  374,  376,  376,  380,  379,  379,
  377,  377,  378,  378,  382,  381,  381,  373,  383,  373,
  333,  333,  333,  333,  333,  333,  384,  385,  386,  386,
  386,  387,  388,  389,  389,  390,  390,  334,  334,  334,
  334,  391,  391,  393,  393,  392,  394,  392,  392,  335,
  336,  395,  339,  337,  397,  398,  340,  399,  400,  338,
  338,  396,  396,  305,  305,  305,  305,  401,  401,  403,
  403,  405,  404,  406,  404,  402,  402,  402,  410,  408,
  411,  412,  408,  407,  407,  413,  413,  414,  414,  414,
  414,  414,  419,  415,  420,  416,  421,  422,  423,  417,
  425,  426,  427,  417,  424,  424,  429,  418,  428,  432,
  428,  431,  434,  431,  430,  430,  430,  433,  433,  433,
  409,  435,  409,    3,    3,  436,    3,    3,  437,  437,
  245,  245,  240,  240,    5,  438,  438,  438,  438,  442,
  438,  438,  438,  438,  439,  439,  440,  443,  440,  441,
  441,  444,  444,  445,
  };
   static readonly short [] yyLen = {           2,
    2,    0,    3,    1,    2,    4,    3,    1,    0,    1,
    1,    2,    4,    2,    1,    2,    1,    1,    5,    2,
    3,    0,    0,   11,    1,    3,    1,    0,    1,    0,
    1,    1,    0,    1,    0,    1,    0,    1,    1,    2,
    1,    1,    1,    1,    1,    1,    1,    0,    1,    1,
    2,    0,    3,    0,    6,    3,    1,    1,    1,    1,
    1,    3,    0,    3,    1,    0,    3,    0,    1,    1,
    3,    3,    1,    1,    0,    4,    4,    0,    1,    1,
    0,    1,    1,    2,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    0,    0,    0,    0,    0,
   16,    5,    0,    9,    0,    1,    1,    2,    3,    0,
    3,    1,    1,    1,    0,    8,    0,    9,    6,    0,
    0,    3,    0,    1,    1,    2,    2,    0,    5,    0,
    1,    1,    2,    3,    0,    4,    2,    1,    1,    1,
    0,    3,    0,    0,   10,    0,    0,    0,   12,    8,
    1,    1,    0,    1,    1,    3,    3,    3,    5,    3,
    5,    1,    1,    1,    1,    3,    4,    6,    4,    0,
    7,    0,    1,    1,    2,    1,    1,    1,    4,    6,
    4,    1,    2,    2,    1,    0,    0,    0,   10,    0,
    0,    0,   13,    1,    2,    1,    2,    1,    0,    5,
    0,    5,    1,    1,    1,    0,    0,    0,    0,   15,
    5,    0,    1,    1,    2,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    0,    5,    1,    1,    1,    1,
    0,    7,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    0,    7,    0,    7,    2,
    2,    2,    0,    0,    9,    1,    1,    0,    1,    0,
    6,    0,    6,    1,    0,    8,    0,    9,    0,    0,
   10,    0,    0,    3,    0,    1,    1,    2,    2,    0,
    5,    0,    2,    2,    2,    1,    1,    1,    0,    5,
    0,    5,    1,    1,    0,    0,    0,    0,   13,    0,
    2,    2,    0,    1,    2,    1,    3,    2,    0,    5,
    0,    0,    0,   13,    0,    1,    1,    3,    1,    4,
    2,    0,    3,    2,    1,    3,    0,    3,    1,    1,
    3,    1,    2,    3,    4,    4,    0,    3,    1,    3,
    3,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    2,    2,    2,    2,    2,    2,    1,    3,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    2,    2,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    3,    3,    4,    4,    4,    3,    3,    4,    3,    4,
    4,    0,    1,    3,    4,    0,    1,    1,    3,    2,
    3,    1,    2,    3,    2,    1,    1,    0,    1,    1,
    3,    3,    2,    2,    1,    1,    1,    1,    2,    2,
    4,    3,    1,    4,    1,    3,    2,    1,    3,    1,
    1,    1,    4,    3,    2,    2,    6,    3,    7,    4,
    3,    7,    3,    0,    2,    4,    1,    2,    0,    1,
    1,    3,    3,    1,    1,    1,    0,    1,    1,    2,
    2,    3,    1,    2,    0,    1,    2,    4,    1,    3,
    0,    5,    1,    1,    1,    2,    3,    3,    4,    4,
    1,    2,    4,    4,    4,    4,    0,    4,    0,    5,
    0,    1,    0,    4,    4,    1,    2,    2,    1,    1,
    4,    2,    1,    2,    2,    2,    2,    2,    2,    1,
    3,    3,    3,    1,    3,    3,    3,    3,    3,    1,
    3,    3,    1,    3,    3,    3,    3,    1,    3,    3,
    1,    3,    1,    3,    1,    3,    1,    3,    1,    3,
    1,    3,    1,    5,    3,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    3,    1,    3,    3,    2,    1,
    0,    1,    1,    1,    0,    2,    1,    1,    0,    4,
    0,    5,    0,    0,    7,    0,    0,    8,    1,    1,
    1,    1,    1,    1,    6,    4,    4,    1,    1,    0,
    0,    0,    0,   15,    0,    1,    0,    1,    1,    2,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    0,    2,    0,    1,    1,
    1,    2,    4,    1,    3,    1,    3,    1,    1,    0,
    1,    1,    1,    0,    4,    1,    1,    0,    4,    0,
    1,    1,    2,    1,    1,    1,    1,    1,    2,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    0,    4,    1,    2,    2,    2,    2,
    2,    2,    1,    1,    2,    1,    0,    6,    0,    7,
    0,    2,    1,    0,    1,    0,    1,    1,    2,    2,
    4,    0,    2,    0,    1,    1,    2,    4,    1,    5,
    2,    2,    2,    2,    2,    1,    1,    1,    1,    1,
    5,    7,    0,    8,    0,    1,    1,    2,    1,    0,
    3,    1,    2,    3,    1,    1,    1,    1,    1,    5,
    7,    0,    4,    7,    1,    0,    1,    0,    5,    1,
    0,    1,    0,    1,    1,    1,    3,    6,    0,    9,
    1,    1,    1,    1,    1,    1,    2,    2,    3,    4,
    3,    3,    3,    4,    3,    0,    1,    3,    4,    5,
    3,    1,    2,    0,    1,    2,    0,    7,    3,    2,
    2,    0,    3,    5,    0,    0,   10,    0,    0,   10,
    5,    0,    2,    2,    2,    2,    2,    4,    5,    4,
    5,    0,    5,    0,    6,    3,    2,    1,    0,    3,
    0,    0,    6,    0,    1,    1,    2,    1,    1,    1,
    1,    1,    0,    5,    0,    3,    0,    0,    0,   12,
    0,    0,    0,   13,    0,    2,    0,    3,    1,    0,
    4,    1,    0,    4,    1,    2,    2,    1,    2,    2,
    0,    0,    4,    2,    3,    0,    4,    2,    2,    3,
    0,    1,    1,    1,    2,    2,    2,    4,    3,    0,
    7,    4,    4,    3,    1,    3,    0,    0,    4,    0,
    1,    1,    3,    2,
  };
   static readonly short [] yyDefRed = {            0,
    8,    0,    0,    0,    0,    0,    0,    0,    2,    4,
    0,    0,   11,   14,    0,  914,    0,    0,  918,    0,
    0,   15,   17,   18,  375,  381,  388,  376,  378,    0,
  377,    0,  384,  386,  373,    0,  380,  382,  374,  385,
  387,  383,  337,  935,    0,  379,  925,    0,   10,    1,
    0,    0,    0,   12,    0,  768,    0,    0,    0,    0,
    0,    0,    0,    0,  416,    0,    0,    0,    0,    0,
    0,    0,  414,    0,    0,    0,  472,    0,  415,    0,
  511,    0,  842,    0,    0,    0,  624,    0,    0,    0,
    0,    0,    0,    0,  674,    0,  723,    0,    0,    0,
    0,    0,    0,    0,    0,  413,    0,  613,    0,  767,
  706,    0,    0,    0,    0,  390,  391,    0,  393,  394,
  395,  396,  397,  398,  399,  400,  401,  402,  403,  404,
  405,  406,  407,  408,  411,  412,  620,  543,    0,  539,
  540,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  621,  619,  622,  623,  690,  692,    0,  688,
  691,  707,  709,  710,  711,  712,  713,  714,  715,  716,
  717,  718,  708,    0,    0,    0,  769,  770,  786,  787,
  788,  789,  811,  812,  813,  814,  815,  816,    0,    0,
    0,   20,    0,    0,    0,  327,    0,  329,  922,   16,
  915,    0,    0,  239,  238,  235,  240,  241,  234,  253,
  252,  245,  246,  242,  244,  243,  247,  236,  237,  248,
  249,  255,  254,  250,  251,    0,    0,  938,    0,  927,
    0,  926,    3,   52,    0,    0,    0,   42,   39,   41,
   43,   44,   45,   46,   47,   50,   13,    0,    0,    0,
  817,  417,  418,  840,    0,    0,    0,    0,    0,    0,
  392,    0,  818,    0,  533,  527,  532,  722,  766,  693,
  720,  719,  721,  694,  695,  696,  697,  698,  699,  700,
  701,  702,  703,  704,  705,    0,    0,    0,  792,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  827,    0,  389,    0,    0,    0,    0,    0,    0,
  841,    0,    0,    0,  736,  732,    0,    0,    0,    0,
    0,    0,  356,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  616,  542,    0,    0,  538,  544,  545,  537,
  549,  548,  546,  547,    0,    0,  609,  724,  522,    0,
  410,  409,    0,    0,    0,    0,  326,    0,  730,  731,
    0,  475,  476,    0,    0,    0,  728,  729,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  917,  689,  737,  727,    0,  764,  765,  868,
  885,    0,    0,    0,  897,  856,  854,  878,    0,    0,
  876,  879,  880,  881,  882,  857,  855,    0,    0,    0,
  331,    0,   21,    0,    0,    0,  934,    0,  338,    0,
    0,    0,  936,    0,    0,   40,  646,  652,  644,    0,
  641,  651,  645,  643,  642,  649,  647,  648,  654,  650,
  653,  655,    0,    0,  639,   51,  474,    0,    0,  470,
  471,    0,  468,    0,  739,    0,    0,    0,    0,  762,
  763,    0,    0,    0,  628,    0,  821,  819,  629,    0,
    0,  496,    0,    0,    0,  487,    0,  491,  501,  503,
    0,  483,    0,    0,    0,    0,    0,  478,    0,  481,
    0,  485,  358,  822,    0,    0,  823,  831,    0,    0,
    0,  832,    0,    0,  843,    0,    0,  735,    0,  368,
    0,  364,  365,    0,  363,  366,  367,    0,    0,    0,
  550,    0,    0,  529,  611,    0,  687,    0,    0,  682,
  684,  685,  686,  421,  422,  825,    0,    0,    0,  334,
  335,    0,  177,  176,  178,    0,    0,    0,    0,  360,
    0,  596,    0,    0,  426,    0,  429,    0,  427,    0,
    0,    0,    0,    0,    0,  455,  458,    0,    0,  450,
  457,  456,    0,  585,  586,  587,  588,  589,  590,  591,
  592,  593,  595,  594,  551,  553,  552,  558,  559,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  582,    0,    0,  500,    0,    0,
    0,    0,    0,    0,    0,  869,  871,  867,    0,  877,
    0,    0,  328,  932,  933,  352,    0,    0,  349,    0,
    0,  174,    0,    0,  942,  928,  930,   60,   58,   59,
    0,    0,   53,    0,    0,   61,   63,   27,   25,    0,
    0,  305,  636,    0,  640,  425,    0,  473,    0,  524,
    0,  535,  164,  185,    0,    0,  154,    0,    0,    0,
  165,  528,    0,  845,  795,    0,  806,  793,    0,  797,
    0,    0,    0,  820,    0,    0,    0,  486,    0,  502,
  504,    0,    0,  442,    0,    0,  438,    0,    0,  465,
    0,  506,  480,    0,  140,  507,  138,  139,  509,    0,
  523,    0,  836,    0,  829,    0,  833,  515,    0,    0,
    0,  353,    0,  513,    0,    0,  525,    0,  848,    0,
  860,    0,  858,    0,    0,  626,  627,    0,    0,    0,
  676,  677,  675,  683,  824,  604,  610,  603,    0,  725,
    0,  333,  599,    0,    0,    0,  541,  430,  424,  428,
  423,  526,  464,  463,  460,  459,    0,  454,  419,  420,
  431,    0,    0,  743,    0,    0,  886,  862,    0,  887,
    0,  883,    0,  898,    0,    0,    0,    0,  866,   19,
  330,  673,  672,    0,  671,    0,  348,  944,  175,  939,
    0,    0,   54,    0,    0,    0,    0,    0,    0,  355,
    0,  630,    0,    0,   80,   79,    0,  469,    0,    0,
    0,    0,    0,  534,    0,    0,    0,    0,    0,  798,
    0,    0,    0,    0,    0,  844,  493,  492,  445,    0,
    0,  923,  924,  434,  440,    0,  443,    0,  467,    0,
    0,    0,    0,    0,  773,  839,    0,  830,  521,  516,
    0,    0,  512,    0,  851,    0,  790,  861,  859,    0,
  530,  612,    0,  608,  607,  606,  336,  598,  597,  614,
  462,    0,  452,  451,  584,    0,  759,  742,    0,    0,
    0,  748,    0,  864,    0,  891,    0,  906,  907,  900,
  870,  872,  912,  351,  350,  943,    0,    0,   62,   56,
    0,   64,   26,   23,    0,    0,    0,  211,    0,  102,
    0,   77,  753,  113,  114,    0,    0,    0,  756,  183,
  184,    0,    0,    0,    0,  157,  166,  158,  160,    0,
    0,    0,    0,  802,    0,  807,  808,    0,    0,  444,
  446,  447,  441,  435,  439,    0,  498,    0,  466,  477,
  433,  510,  508,    0,  835,    0,    0,  517,    0,    0,
  625,  617,    0,  461,    0,    0,  738,  749,  863,    0,
    0,    0,  884,    0,    0,    0,  931,    0,    0,    0,
   69,   70,   73,   74,    0,  321,    0,  306,  631,  207,
   97,    0,  740,  757,  169,    0,  181,    0,    0,    0,
  791,  853,    0,    0,    0,    0,  809,  772,  482,  479,
  779,    0,  785,    0,    0,  777,    0,  782,  837,  520,
  519,    0,    0,  615,    0,    0,  865,  888,    0,    0,
    0,  902,    0,  913,    0,   75,   67,    0,    0,    0,
  312,  311,    0,    0,    0,    0,    0,    0,  170,    0,
  161,  159,  846,  799,    0,    0,  804,    0,    0,  774,
  778,    0,  783,    0,  849,  618,    0,  751,    0,  892,
  909,  910,  903,  873,   55,    0,   71,   72,    0,    0,
  307,    0,    0,    0,    0,  758,  168,    0,  180,    0,
    0,  810,  784,    0,  678,  838,    0,  760,    0,    0,
    0,   76,    0,    0,  322,    0,  372,  371,    0,  369,
  660,    0,  632,    0,  661,  208,   98,  171,  847,  794,
    0,  850,  889,    0,  904,    0,    0,    0,  308,    0,
  316,    0,    0,    0,  662,    0,    0,    0,    0,  893,
   29,   24,  323,    0,    0,    0,  370,    0,    0,    0,
   99,  679,    0,    0,    0,    0,    0,  317,  668,    0,
  669,  666,    0,  664,   95,    0,   94,    0,    0,   83,
   85,   86,   87,   88,   89,   90,   91,   92,   93,  141,
    0,    0,  224,  216,  217,  218,  219,  220,  221,  222,
  223,    0,    0,  214,    0,    0,  890,    0,  324,    0,
  309,    0,    0,    0,  633,   84,    0,  267,  262,  266,
    0,  209,  215,    0,  896,  894,  320,  667,  665,    0,
    0,    0,    0,    0,    0,    0,  275,    0,    0,  225,
    0,    0,  233,    0,  152,  142,  151,    0,  100,    0,
    0,  261,    0,    0,  260,    0,  146,    0,    0,  342,
    0,  340,    0,    0,  186,    0,    0,    0,    0,    0,
  634,  210,    0,  103,    0,  339,    0,    0,    0,    0,
  117,    0,    0,    0,    0,    0,    0,  143,    0,    0,
  190,    0,  343,    0,  228,  227,  226,    0,  101,    0,
  279,    0,  258,  119,    0,  256,    0,    0,    0,  121,
    0,  344,    0,    0,  187,    0,    0,    0,  341,  231,
  112,  110,    0,    0,  283,    0,    0,    0,    0,    0,
  147,    0,  264,    0,    0,    0,    0,  125,    0,    0,
    0,    0,  345,  346,    0,    0,    0,    0,    0,  107,
  298,    0,  280,    0,    0,  292,    0,    0,    0,  287,
    0,  137,    0,    0,    0,    0,  132,    0,    0,  276,
    0,  122,    0,  116,  126,  144,  150,  198,    0,  188,
    0,    0,    0,    0,  111,    0,  104,  108,    0,    0,
    0,  294,    0,  295,  284,    0,    0,  278,  288,  259,
    0,    0,  118,  133,  257,    0,  274,    0,  265,  269,
  128,    0,    0,    0,  195,  197,  191,  232,  109,  299,
  301,  281,    0,    0,  293,  290,  136,  134,  148,    0,
    0,    0,  145,  199,  201,  189,    0,    0,    0,  292,
    0,  270,  272,  129,    0,    0,  192,  303,  304,  300,
  302,  291,  149,    0,    0,  205,  204,  203,  200,  202,
    0,    0,    0,  193,  271,  273,
  };
  protected static readonly short [] yyDgoto  = {             7,
    8,   50,    9,   51,   10,   11,   52,  235,  685,  429,
   12,   13,   53,   22,   23,   24,  321,  195,  238,  670,
  828, 1015, 1134, 1468,  825,  239,  240,  241,  242,  243,
  244,  245,  246,  663,  444,  664,  665,  928,  666,  667,
  932,  826, 1010, 1011, 1012,  269,  587, 1106,  837, 1198,
 1199, 1200, 1201, 1202, 1203, 1204, 1205, 1206, 1207, 1208,
 1209,  463,  674, 1282,  941, 1113, 1076, 1143, 1167, 1225,
 1293, 1138, 1343, 1320, 1368, 1369, 1370,  943, 1366,  944,
  728, 1259, 1331, 1306, 1356,  512, 1349, 1325, 1385,  907,
 1354, 1357, 1358, 1452, 1386, 1387, 1383, 1210, 1266, 1237,
 1283,  686, 1333, 1432, 1303, 1389, 1461,  464,  270,  687,
  688,  689,  690,  691,  650,  568, 1118,  651,  652,  843,
 1285, 1310, 1400, 1361, 1434, 1286, 1336, 1457, 1481, 1401,
 1402, 1479, 1465, 1466,  939, 1075, 1166, 1222, 1268, 1223,
 1224, 1260, 1317, 1289, 1261,  323,  226, 1365, 1263, 1350,
 1347, 1211, 1239, 1279, 1429, 1391, 1126, 1430,  588, 1474,
 1475, 1278, 1346, 1322, 1378, 1373, 1344, 1410, 1415, 1376,
 1379, 1380, 1460, 1416, 1374, 1375, 1470, 1458, 1459,  831,
 1018, 1073, 1159, 1136, 1175, 1160, 1161, 1186, 1070, 1157,
 1185,  532,  196,  112,  431,  198,  562,  439,  227, 1298,
  648,  649,  814,  830,  324,  406,  530,  303, 1139, 1140,
   46,  114,  304,  116,  117,  118,  119,  120,  121,  122,
  123,  124,  125,  126,  127,  128,  129,  130,  131,  132,
  133,  134,  135,  136,  255,  791,  980,  508,  715,  864,
  716,  717,  973,  137,  201,  721,  589,  590,  591,  592,
  785,  472,  473,  298,  978,  723,  407,  300,  495,  496,
  497,  498,  501,  730,  310,  745,  746,  880,  266,  478,
  758,  267,  477,  138,  139,  140,  141,  142,  143,  144,
  145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
  571,  572,  573,  767,  768,  896,  769,  155,  558,  759,
  353,  993,  546, 1053,  156,  490,  937, 1074, 1164, 1264,
  465, 1144, 1145, 1193, 1194,  815,  548,  335,  763, 1151,
  549,  550,  271,  272,  273,  159,  160,  161,  274,  275,
  276,  277,  278,  279,  280,  281,  282,  283,  284,  285,
  173,  286,  559,  174,  175,  317,  796,  627,  910,  840,
  681,  947,  908,  911, 1034,  912,  948,  949,  287,  176,
  177,  178, 1044,  984, 1045, 1046, 1047, 1092, 1048,  179,
  180,  181,  182,  698,  483,  699,  965, 1085,  700,  963,
  701, 1087, 1088,  183,  184,  185,  186,  187,  188,  305,
  521,  522,  986, 1094,  313,  962,  849, 1120,  886, 1127,
  189,  417,  190,  418,  913, 1000,  419,  639,  809,  806,
  807, 1005,  420,  421,  422,  423,  424,  425,  917,  629,
  915, 1099, 1169, 1227, 1002, 1130, 1184,  804,  635,  805,
 1061, 1004, 1062, 1131, 1006,   17,   19,   47,   48,  230,
  653,  822,  440,  654,  655,
  };
  protected static readonly short [] yySindex = {         -185,
    0, -190, -128, -221,  -14,11657,    0,  -93,    0,    0,
  -14, -221,    0,    0,  -72,    0, 6676,  -14,    0, -173,
 -247,    0,    0,    0,    0,    0,    0,    0,    0,   46,
    0,  112,    0,    0,    0, 5062,    0,    0,    0,    0,
    0,    0,    0,    0,  288,    0,    0,  335,    0,    0,
  -93,  128,  -14,    0,    5,    0,  -36,  103,  129,11157,
  147, -272,  230, 6833,    0, -272, -272, -272, -166, -272,
 -272,  374,    0,10176, -272, -272,    0,10176,    0,  267,
    0,  129,    0, -272,  228, -272,    0, 7930, 8225,  329,
 -272, -272, -219,10980,    0,10176,    0,10856,10856,10856,
10856,10856,10856,10856,10856,    0,   70,    0, 8382,    0,
    0,  394,  341,  252, -233,    0,    0,  409,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  893,    0,
    0,  708,  168,  373,  475,  556,  447,  460,  480,  445,
  -74,  498,    0,    0,    0,    0,    0,    0, 3428,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  491,  570,   75,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -208, -174,
  128,    0,  391,  574,  589,    0,  564,    0,    0,    0,
    0, 8382, 8382,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  624,  583,    0,  586,    0,
 -249,    0,    0,    0,  128,12382,  128,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  775,  630,10312,
    0,    0,    0,    0,10176, -272, -272,  781,  311,  252,
    0,  643,    0, 8382,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  725,   95,11157,    0, 8382,
10176,  697,  712,10176,10176, 4630,  604, -144,  717,11676,
  183,    0,  706,    0,  715, 8382,10176,  727,  561, -272,
    0,10176,  267, 9632,    0,    0,  228,10176,  228,  -92,
  456,  710,    0,  570, -233,  -83,  743,10176,10176,10176,
  230,  772,    0,    0, 6990, -258,    0,    0,    0,    0,
    0,    0,    0,    0,  734,10176,    0,    0,    0,  320,
    0,    0,11586,  235,  752,  755,    0, -126,    0,    0,
  240,    0,    0,  747,10312, 9360,    0,    0,10856,10176,
10176,10176,10176,10176,10176,10176,10176,10176,10176,10176,
10856,10856,10856, 8382, 8382,10856,10856,10856,10856,10856,
10856,10856,10856,10856,10856,10856,10856,10856,10856,10856,
10856,10176,    0,    0,    0,    0,  570,    0,    0,    0,
    0,11730,11747,  758,    0,    0,    0,    0, -252,  617,
    0,    0,    0,    0,    0,    0,    0,  128,  128,  761,
    0,  778,    0,  755,  624,  624,    0, -145,    0,  399,
  624,  764,    0, -192,12382,    0,    0,    0,    0, -171,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, -168, 9092,    0,    0,    0,  755,  111,    0,
    0,  631,    0,  774,    0,  832, -161,  267, -272,    0,
    0,  797, 7913, -202,    0,  840,    0,    0,    0,  845,
  848,    0,  241,    0,  853,    0,  849,    0,    0,    0,
  654,    0, 8049,  662,10176,  717, 9360,    0, 7461,    0,
  228,    0,    0,    0,  855,  857,    0,    0,  129,  267,
  463,    0, 1429,  858,    0,  859,  814,    0,  861,    0,
10176,    0,    0,  940,    0,    0,    0,10176,  943,  865,
    0,  868,  869,    0,    0,11586,    0, -261, 6990,    0,
    0,    0,    0,    0,    0,    0,  872,  267, 6990,    0,
    0, -254,    0,    0,    0,  228,  235,  831,11801,    0,
  877,    0,  880,10856,    0,  355,    0,  366,    0,  755,
  663,10176,10176,  882,  998,    0,    0,   38,  881,    0,
    0,    0,  708,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  708,
  708,  168,  168,  373,  373,  373,  373,  475,  475,  556,
  447,  460,  480,  445,    0,  884, -191,    0,10176,  -48,
  839,   20,  842,  883,10176,    0,    0,    0,  906,    0,
  545,  755,    0,    0,    0,    0,  520,  247,    0,11801,
  399,    0,  891,  892,    0,    0,    0,    0,    0,    0,
  235,  574,    0,  895,  897,    0,    0,    0,    0,  894,
11825,    0,    0,   68,    0,    0,  204,    0,10312,    0,
  896,    0,    0,    0,  542,  903,    0,  907,  909,  910,
    0,    0,10176,    0,    0,  862,    0,    0,  911,    0,
  912,10176,  995,    0, 6833, 6833, 8208,    0, 4630,    0,
    0, 9768,  189,    0,  -61, -138,    0,  863,  867,    0,
  -90,    0,    0,  919,    0,    0,    0,    0,    0,  932,
    0,  941,    0, 4152,    0,  267,    0,    0,  228,  370,
  560,    0,  889,    0,  951,  953,    0, 6833,    0, 6833,
    0,10176,    0,10176, 8382,    0,    0,  267,  267,  957,
    0,    0,    0,    0,    0,    0,    0,    0, 8365,    0,
 8382,    0,    0,  913,11586,  987,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 9224,    0,    0,    0,
    0, 9496,10176,    0, 7618,  958,    0,    0, 1039,    0,
 1041,    0,  744,    0,  969,10176,10176,  926,    0,    0,
    0,    0,    0,  927,    0, -145,    0,    0,    0,    0,
  399,  399,    0,  761,  976,  977,  929,  983,  935,    0,
  935,    0, 1099, 1101,    0,    0,10176,    0, 9904,  990,
  542,11801, 8382,    0,  332, 1105, 1109,  997,  992,    0,
10176,10176,  999,10176, 1095,    0,    0,    0,    0,   85,
10040,    0,    0,    0,    0, 7754,    0, 1123,    0,  570,
10176, 1014, 8208, 1017,    0,    0,  964,    0,    0,    0,
  970,  239,    0,  971,    0,  992,    0,    0,    0, 1015,
    0,    0, 1047,    0,    0,    0,    0,    0,    0,    0,
    0,  421,    0,    0,    0,11676,    0,    0,  973, 1016,
  958,    0,10176,    0,10176,    0,10176,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1024,  761,    0,    0,
10448,    0,    0,    0, 1025, 1023,  935,    0,  935,    0,
  935,    0,    0,    0,    0,  982, 1026,  990,    0,    0,
    0, -167, -156, 1027, 1029,    0,    0,    0,    0, 1028,
 8208,  958, -191,    0, 1032,    0,    0, 1033, 6833,    0,
    0,    0,    0,    0,    0, 1040,    0,  717,    0,    0,
    0,    0,    0, -213,    0, 1037,  239,    0,  991,  958,
    0,    0,  267,    0,  988, 1034,    0,    0,    0,10176,
 1067,10176,    0,10176, 1065,  225,    0,  897,  219,  557,
    0,    0,    0,    0, -221,    0, 4311,    0,    0,    0,
    0, 1036,    0,    0,    0,  493,    0, 1038, 1162, 1164,
    0,    0,  958, 1049,  958,10176,    0,    0,    0,    0,
    0,10176,    0, 1055, -224,    0, -224,    0,    0,    0,
    0, 1052,  267,    0,10176, 7618,    0,    0, 1078,  782,
 1053,    0,10176,    0, 1056,    0,    0,10448,  -14, -161,
    0,    0, 1061, 1054, 1054, 1054, 9904, 1060,    0,10176,
    0,    0,    0,    0, 1059,  912,    0, 6833, 1057,    0,
    0, 6990,    0, 1066,    0,    0, 1064,    0,10176,    0,
    0,    0,    0,    0,    0,10176,    0,    0,  128, 1068,
    0, 4470, -153, -153, -153,    0,    0,10176,    0, 6833,
 6833,    0,    0, 6990,    0,    0, 6833,    0, 1088,10176,
10176,    0,  128, 1069,    0,  128,    0,    0, 1070,    0,
    0, 1020,    0, 1100,    0,    0,    0,    0,    0,    0,
 6990,    0,    0, 1093,    0, 1071, -153, 1030,    0, 1075,
    0, 4470, 1076, 1083,    0, 1089, 1092, 1074,10176,    0,
    0,    0,    0,    0, 1087,  128,    0,11236,  -75,  128,
    0,    0, 1104,10176, 1086, 1062, 1071,    0,    0, 1090,
    0,    0, 1096,    0,    0, 9092,    0, 1120,  -75,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 -248, 9092,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1121,  128,    0,  -75, 1045,    0, 1104,    0,10176,
    0, 1097,11236,11402,    0,    0, -244,    0,    0,    0,
11434,    0,    0, 1122,    0,    0,    0,    0,    0, 8382,
 8382, -122,11676, -109,  228, 1154,    0,  235, 9160,    0,
 1188,    0,    0, 1071,    0,    0,    0, 1071,    0, 1081,
 1082,    0, 8382, -152,    0, 8382,    0, 1108, 1125,    0,
  235,    0, 1130,  682,    0, 1135, 1112,    1,  354, 5062,
    0,    0, 1071,    0,  235,    0, 1127, 1113, 1134, 1139,
    0, 1156, 1082, 1163, -161, 1152, 1165,    0, 1168, 1173,
    0,  755,    0,  736,    0,    0,    0, 1170,    0, -178,
    0, 1161,    0,    0, 1174,    0, 1175, 1176, 1178,    0,
 1171,    0, -161, -161,    0, -161, 1181, 1182,    0,    0,
    0,    0, 1177,  -59,    0, 1183, -161, 1300, 1184, -161,
    0, -244,    0, 8208, 1141, 1185, 1171,    0, 1190, 1191,
   27, 1194,    0,    0, -161, 9904, 1142, 1189, 1177,    0,
    0, 9092,    0,  128,  128,    0, 1148, 1192, 1183,    0,
 1197,    0,10176, 1155, 1196, 1184,    0, 1202, -161,    0,
 -107,    0, 1195,    0,    0,    0,    0,    0, 9092,    0,
   27,   27, 1220, 1217,    0, -178,    0,    0, -148, 1224,
 9092,    0, 9092,    0,    0, 8208, 1212,    0,    0,    0,
 1225, 1174,    0,    0,    0, 1222,    0,   83,    0,    0,
    0, -153,  834, 1228,    0,    0,    0,    0,    0,    0,
    0,    0, 1282, 1335,    0,    0,    0,    0,    0, 1229,
 1233, 8208,    0,    0,    0,    0,   27,  484,  484,    0,
 -153,    0,    0,    0,  -80,  -80,    0,    0,    0,    0,
    0,    0,    0, 9360, 9360,    0,    0,    0,    0,    0,
 1240, 1237, 1238,    0,    0,    0,
  };
  protected static readonly short [] yyRindex = {         2961,
    0,    0, 7147, 2961,    0,    0,    0, 1611,    0,    0,
 3114, 2892,    0,    0,    0,    0,    0, 3114,    0,    0,
   52,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1613,    0,    0, 1613,    0,    0,
 1611, 3157, 3008,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1247,    0,    0,    0,    0,    0,    0,    0,
    0,11875,    0, 1239,    0,    0,    0, 1239,    0,    0,
    0,    0,    0,    0,  -35,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 3740,    0,    0,    0,
    0,    0,  171, 4628, 3581,    0,    0, 4469,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 4784,    0,
    0, 4852, 5196, 5400, 5740, 5944, 6080, 6216, 6352, 6488,
  529,  966,    0,    0,    0,    0,    0,    0,   52,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1198,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  805,  805,
 3200,    0,  572, 1242,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1613,   47,    0,    0,    0,
    0,    0,    0,    0, 3243,  432, 3286,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 3515,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1262,    0,    0,    0,    0,
 3515,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 2149,    0, 1273,  132,
 2279,    0,    0, 2426, 2279,  132,    0,    0,    0,    0,
 1247,    0,    0,    0,    4,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1239,    0,    0,    0,    0,
    0,    0, 1259, 2551,    0, 3515,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  106,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1532,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   40,
    0,    0,    0,    0,    0,    0,    0, 3349, 2716,    0,
    0,    0,    0, 1996, 1613, 1613,    0, -189,    0, 7478,
 1613, 1632,    0,    0,  135,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  296,11089,    0,    0,    0, 3515, 3899,    0,
    0,    0,    0,    0,    0,    0,11478,    0,    0,    0,
    0,    0, 1257,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  719,  785,    0,    0, 1266,    0,    0,    0,
    0,    0,    6,    0,    0, 3992, 1263,    0,    0,    0,
  184,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1700,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1259,    0,    0,   31,    0,
    0,    0,    0,    0,    0,    0,    0, 8522,    0,    0,
    0,    0,    0,    0,    0, -181,  385,    0,    0,    0,
 1264,    0,    0,    0,    0, 3515,    0, 3515,    0, 4151,
    0,    0,    0,   90,    0,    0,    0,    0,  144,    0,
    0,    0, 4956,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 5024,
 5128, 5264, 5332, 5468, 5536, 5604, 5672, 5808, 5876, 6012,
 6148, 6284, 6420, 6544,    0,    0,  597,    0,    0,  132,
    0,  132,    0,    0,    0,    0,    0,    0, 1231,    0,
    0, 1996,    0,    0,    0,    0, 1219,    0,    0,    0,
11899,    0,    0,  641,    0,    0,    0,    0,    0,    0,
  519,  626,    0,    0, 1268,    0,    0,    0,    0, 1275,
    0,    0,    0,    0,    0,    0,10584,    0,    0,    0,
  733,    0,    0,    0,11953,    0,    0,  732,  746,  749,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1270,    0,    0,    0,    0,    0,    0,    0, 1285,    0,
    0,    0, 1124,    0,    0,   41,    0,  117, 3674,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1286,
    0,    0,    0,    0,    0,    0,    0,    0,  -68,  595,
  650,    0,    0,    0,    0, 1278,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 8522,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  162,    0,    0,    0, 1288,    0,    0,    0,    0,
    0,    0,  458,    0,  677,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, -189,    0,    0,    0,    0,
11953, 7635,    0, 1291,    0,  680,    0,    0,    0,    0,
    0,    0, 1248, 1258,    0,    0,    0,    0,    0, 1289,
11970,    0,    0,    0,11554,    0,    0,    0,  748,    0,
 1299,    0,    0,    0, 1867,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 3833,
    0, 4310, 1309,    0,    0,    0, 1306,    0,    0,    0,
    0,  595,    0,    0,    0,  748,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
 1303,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  751,    0,    0,    0,    0, 1313,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1305,    0,    0,
    0,    0,    0,  790,  794,    0,    0,    0,    0,    0,
    0, 1310,  597,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 3992,    0,    0,
    0,    0,    0, 1315,    0,    0,  595,    0,  828, 1310,
    0,    0, 8522,    0,  614,  636,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   44,    0, 1268, 8572,    0,
    0,    0,    0,    0,12001,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  671,    0,  692,    0,    0,
    0,    0,  858,    0, 1288, 1312,    0,    0,    0,    0,
    0,    0,    0,    0, 1319,    0, 7304,    0,    0,    0,
    0,    0, 8522,    0,    0,    0,    0,    0,    0,  588,
  703,    0,    0,    0,    0,    0,    0,    0,12044,11478,
    0,    0,    0,  -51,  -51,  -51,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1316,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,12113,    0,
    0,    0, 1323, 1323, 1323,    0,    0,    0,    0,    0,
    0,    0,    0, -205,    0,    0,    0,    0,    0,    0,
    0,    0,12156,    0,    0,   64,    0,    0,  109,    0,
    0,    0,    0,  540,    0,    0,    0,    0,    0,    0,
 1324,    0,    0,    0,    0, 3071, 1317,    0,    0, 1327,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  485,    0,  154,    0,    0, 8726, 8924,
    0,    0,  728,    0,    0,    0, 2829,    0,    0,    0,
    0,    0,  397,    0,    0,11260,    0,    0, 8825,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,11328,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 9018,    0, 8726,    0,    0,  728,    0,    0,
    0,    0,    0,  296,    0,    0,    0,    0,    0,    0,
  296,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 4758,  344,    0, 9060,    0,    0,
    0, 9130,    0, 2829,    0,    0,    0, 2829,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  307,    0, 1330,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 2829,    0,  425,    0,  442,    0,    0,    0,
    0,    0,    0,    0,11478,  798,    0,    0,    0,    0,
    0, 1325,    0,  767,    0,    0,    0,    0,    0,    0,
    0,  806,    0,    0,    0,    0,    0,    0,    0,    0,
 1329,    0,11478,11478,    0,11510,    0,    0,    0,    0,
    0,    0, 1331,12342,    0, 1333,11478,10720, 1336,11478,
    0,    0,    0,    0,    0,    0, 1337,    0,    0,    0,
12312,    0,    0,    0,11478,    0,    0,    0, 1339,    0,
    0,  266,    0, 1470,12274,    0,    0,    0, 1340,    0,
    0,    0,    0,    0,    0, 1342,    0,    0,11478,    0,
  548,    0,  818,    0,    0,    0,    0,    0,  838,    0,
12198,12236,    0,    0,    0,    0,    0,    0,    0,    0,
 1386,    0, 1440,    0,    0,    0,  819,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  559,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,12312,  382,10892,    0,
  559,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1263, 1263,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,
  };
  protected static readonly short [] yyGindex = {            0,
    0, 1655,    0,    0,    0,   -1,  -12, -179,  -50, 1659,
    0, 1707, 1715,   87,    0,    0,   -3,    0,    0,    0,
    0,    0,    0, -781, -693, -222, -446,    0,    0,    0,
    0,    0, -198,    0,    0,    0,  793,    0,  898,    0,
    0,    0,    0,  655,  657,  -17, -235,    0,    0,  501,
    0,  528, -686, -685, -617, -594, -592, -575, -571, -553,
    0,-1140,    0,   12,    0,  131,    0,-1061,    0,    0,
    0,   -8,  322,    0,    0,    0,  361,-1046,    0, -280,
 -291, 1073,    0,    0,    0, -871,  310,    0,    0, -493,
    0,    0,  378,    0,    0,  350,    0,    0,  386,    0,
 -555, -806,    0,    0,    0,    0,    0,  478,  -13,    0,
    0,  905,  908,  916, 1063, -524,    0,    0, -326,  899,
  468,    0,-1078,    0,    0,    0,    0,    0,    0,    0,
    0,  275,    0,    0,    0,    0,    0,    0,    0,    0,
  532,    0,    0,    0,    0, -339,  462,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  546,    0, -498,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  298,    0,
    0,  377,    0,    0,  387,  390,  306,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  592,    0,    0,    0,
    0,  -53,    0,  -15,  -67,    0,    0,  455,    0,  511,
    0,  959,    0, 1251, -293, -274,  -64,  622,    0,  616,
    0,  -38,  158,    0,    0,   56,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, -262,    0, 1292,    0,    0, -279,    0,    0,
    0,  917,    0, -299, -134, 1077,  989,    0,  994,    0,
 1207, 1427, 1116,    0,    0,  820, 1724,    0,    0,    0,
    0, 1098,    0,    0,    0,    0,    0, -537, 1466,    0,
    0,    0,    0, 1705, 1085,    0,    0,  483,  821,  678,
  817, 1405, 1407, 1404, 1406, 1409,    0, 1411,    0,    0,
    0, 1035, 1267, -723,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, -290,    0,    0,    0,    0,
 -445,    0,  670,    0,  582,    0,  666,    0,    0,    0,
  726, -526,  -16, -305,   -7,    0, 1660,    0,   42,    0,
   51,   53,   60,   76,   89,  104,  108,  110,  122,  134,
    0, -664,    0,  -28,    0,    0,  860,    0,  786,    0,
    0,    0,  766, -325,  830, -820,    0,  876, -457,    0,
    0,    0,    0,    0,    0,  780,    0,    0,  784,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  791,    0,    0,    0,    0,    0,    0,    0,    0,  -40,
    0, 1307,    0,    0,    0,  947,    0,    0,    0,    0,
    0, -170,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1415,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  608,    0,    0,    0,    0,    0,    0,
    0,    0,  709,    0,    0,    0,    0,    0,    0,   39,
 1042,    0,    0,    0, 1031,
  };
  protected static readonly short [] yyTable = {           110,
  157,  236,   18,  111,  197,  191,  513,  510,  724,  158,
  486,  428,  446,  570,  471,  729,  194,   44,  675,  427,
  316,  260,  764,  506,  403,  697,  569,  529,  540,  552,
 1116,  262,  770,  494,  995,  892,  874,  308,  466,  352,
  855,  856, 1041, 1042,  774,  254,  347,  410,  360,  535,
  368,  921, 1146, 1147, 1042, 1234,  302,  331,  162,  359,
  302,  367,  781,  658,  794,   14,  309,  163,  311,  164,
    1, 1241,  197,  197,  361,  442,  165, 1341,  336,  322,
  327,  410,  192,  885,  668,  887,  232,   20, 1025,  659,
  998,  702,  166,  197,  683, 1173,  636,  637,  252, 1027,
  355,  291, 1141, 1300,   48,  167,  761,  200,  671,  292,
  646,  502,  672,  554, 1440,  261,   48,  865, 1125,  771,
  168,  660,   95,  357,  169,  818,  170, 1238,   16,  471,
  411, 1265,  628, 1272,    6,  412,    2,  413,  171,  200,
  236,  110,  157,  414,  415,  111, 1275,  253, 1427,  261,
  172,  158,  315,  261,  261,  261,  261,  261,  261,  261,
  261,  772,  781,   49,  411,  869, 1441,  762,   43,  412,
  555,  413,    2,  673,  115, 1476,  638,  414,  415,  684,
 1195,  199, 1273,  742,  445, 1142,  197,  197,  361,  795,
  361,  352,  361,  435,  436, 1276, 1371, 1043,  332,  333,
  162,  531, 1342,  718,  656,  446,  570,  234, 1043,  163,
  538,  164,  998,  857,  722,  703,  781,  115,  165,  569,
  416,  115,  503,  234,  504,  661,  252,   15,   48,  570,
  466, 1409,  470,  352,  166,  866,  361,  474,    3,    4,
    5,    6,  443,  552,  193,  798,  669,  167,  197,  260,
 1026,  293,  528,  552,  426,  476,  533,  260, 1433,  482,
  537, 1028,  168, 1110,  437, 1301,  169, 1428,  170, 1054,
 1443,  536, 1444,  485,  197,  253,  489,  491,  505,  870,
  171,  484, 1398,  871,  197,  527,   95,  656,  575,  516,
  197,  576,  172,  234,  524, 1477,  526,  515,  349,  525,
  489,  577,  347,  354, 1038,  557,  862,  349,  921,  234,
  570,  542,  543,  800, 1065,  656,  115,  952,  551, 1405,
   20,  350, 1435, 1436,  819, 1313,  400,  553,  302, 1096,
  350,  742,  248,  733,  197,  345,  249,  197,  401,  832,
  869,  561,  349,  261,  988,   55, 1450,  470,  586,  354,
  202,  261,  594,  595,  596,  597,  598,  599,  600,  601,
  602,  603,  604,  833,  657,  350,  643,  863,  197,  197,
 1453,  680,  921,  436, 1172,  608,  609,  236, 1467,  982,
  247, 1274,  733,  346,  626,  347,  250,  647,  875,  875,
  834,    6,  874,  874,  966,  234,  197,  197,  681, 1473,
  676,  352,  848,  631,  633, 1231,  637, 1451,  437,  789,
  349,  637,  347,  347,  197,  637,  203,  347, 1314,  347,
  347,  347,  347, 1122,  261,  352,  641,  347,  197,  384,
  637,  313,  680,  350,  436,  570,  261,  261,  261,  359,
  662,  261,  261,  471,  348,  115,  494,  657,  569, 1050,
  408, 1051,  970,  347,  696, 1149, 1150,  637,  871,  681,
  349,  624, 1152,  624,  692,  385,  790, 1032,  875,  437,
  480,  115,  874,  644,  645,  657,  637,  448,  251,  656,
  410,   48, 1291,  350,  921,  677, 1292,  720,  332,  586,
  921,  727,  115, 1214, 1215,   95,  234,  351, 1329,  252,
  332,  349,  570,  409,  332,  733,  735,  743,  779,  835,
  781, 1319,  782,  751,  950,  449,  836,  332,  624,  741,
  753,  315,  263,  481,  350,  347, 1359, 1360,  637, 1362,
  197,  347,  551,  453,  448,  453, 1214, 1215,  351,  325,
 1381,  553,  551, 1388,  766,  386,  387,  945,  253,  332,
  359,  553,  359,  197,  359,  359,  903,  359, 1404,  359,
  964,  347, 1216,  411,  784,  784,  718,  635,  412,  861,
  413,   48,  449,  349,  811,  560,  414,  415,  697,  349,
  637,  972, 1426,  867,   25, 1217,   26, 1218,  325,   27,
  453,  635,  981,  677,   28,  977,  350,  764,   29, 1066,
  265,  359,  350,  359, 1219, 1216,  359,   31, 1220,  349,
  351,  797,  513,  315,   33,  636,  351,  803,  635,   34,
  816,  707,  252,   35,  361,  349, 1221,   45, 1217,  261,
 1218,  349,  350,   95,  197,   37, 1033,   38,  113,  636,
  115,   39,   28,  362,  363,  352,  351, 1219,  350,   40,
   41, 1220,  350,   42,  350,  197,  319,  578,  228,  879,
  229,  470,  817,  364, 1033,   28,  636,  579,  351, 1221,
  260,  253,  954,  337,  365,  489,  533,  337,   28,  332,
  115,  113,  115,   28,  853,  113,  722,  115,   28,  727,
   28,   28,   28,   28,  720, 1014,   28,  357,   28,  328,
  234,  349,   28,  637,  563,  228,  115,  231,  637,  325,
  325,  564,  637,  358,   28, 1296,  115,   28,  197,   28,
   95,  337,  878,  565,  350,  877,  315,  637, 1309, 1315,
  325,  519, 1197, 1213,  888,  663,  889,  354,  351,  197,
  296,  332,  297,   28,  891,  766,  890, 1327,  736,   28,
   28,  895, 1197,  332,  637,  197,  600,  332,  600,  197,
  349, 1089,  897,  663,  261,  647,  388,  389,  350,  586,
  332,  430,  663,  637,  586,  905, 1213,  727, 1197,  350,
  113,  349,  778,  350,  581,  945,  552,  369,  921,  922,
  879,  337,  994,  780,  792,  337,  905,  332,  337, 1119,
  337,  905,  332,  905,  350,  337,  905,  905,  197,  905,
  905,  356,  357,  812,  643,  277,  518,  277,  552,  942,
  662,  485,  277,  325,  325,  813,  197,  197,  432,  519,
  396,  905, 1014,  489,  953, 1064,  968, 1148,  675,  337,
  935,  315,  936,  971,  399,  552,  520,  563,  397,  841,
   95,  593,  318,  979,  564,  727,  390,  391,  318, 1171,
 1392, 1078,  115,  115,  398,  319,  565,  581,  610,  611,
  392,  393,  581, 1079,  581,  581,  581,  581,  581,  581,
  581,  581,  581,  581,  581,  325,  905,  402,  332,  332,
  197,  332,  332,   57, 1262,  999,  581, 1001,  581, 1003,
  581, 1262,  581,  581,  581,  115,  659,  115,  405,  113,
  446,  325,  197, 1013,  268,  659,  357,  432,  581,  811,
  810,  325, 1445,  268,  662,  658,  908,  325, 1067, 1133,
 1068,  908,  881,  908,  658,  113,  908,  908,  297,  908,
  908,  352,  447,  727,  332,  315,  432,  332, 1019, 1247,
 1020,  332, 1021,  394,  395,  411,  113,  581, 1464,  513,
  412,  908,  413,  332,  433,  448,  332,  332,  414,  415,
  741,  325,  741,  499,  325, 1482, 1483,  500,  449,  766,
  332,  434, 1057,  451, 1059,  761, 1060,  761,  452,  761,
  453,  454,  455,  456,  228,   65,   65,  438,  457,   65,
  678,  197,  458,  441,  679,  325,  325,  750, 1072,  750,
  941,  750,  941, 1069,  459,  899,  908,  460,  325,  461,
  899,  325,  899,  710,  485,  899,  899,  711,  899,  899,
  467,  719,  783,  325,  325,  500,  679, 1097,  727,  766,
  167,  901,  167,  462,  167, 1104,  901,  468,  901,   66,
 1013,  901,  901,   66,  901,  901, 1109,  331,  236,  485,
  475,  179,  485,  179,  479,  179,  895,  614,  615,  616,
  617,  895,  487,  895,  945,  551,  895,  895,  358,  895,
  895, 1129,  236,  509,  553, 1158,  494,  488, 1132,  332,
  514,  332,  494,  381,  382,  383,  197,  918,  919, 1295,
  485,  155,  517,  155,  113,  899,  752,  551,  752,  556,
  332,  332, 1154, 1060,  545,  162,  553,  162,  163,  852,
  163,  852,   68,  574,   68, 1158,  115,  534, 1196, 1212,
  332,  901,  657,  347,  551, 1101, 1102,  347,  332,  332,
  347,  332,  347,  553,  325,  680,  197,  347, 1196,  350,
  438, 1183,  495,  874,  874,  411,  895,  411,  495,  185,
  539,  185,  197,  156,  580,  156, 1228,  325,  350, 1192,
  113,  120, 1212,  120, 1196,  634,  411,  411,  354,  282,
  113,  282,  337,  338,  339,  340,  341,  342,  343,  344,
  325,  127,  289,  127,  289,  642,  411, 1454, 1455,  518,
  518,  637,  637,  682,  411, 1114, 1115,  411,  612,  613,
  618,  619,  485, 1307,  694,  704,  705,  197,  197,  706,
  708,  583,  709, 1267, 1192,  197,  731, 1307,  732,  747,
  748,  749,  750,  752,  197,  197,  754,  197,  755,  756,
  757, 1270, 1271, 1287, 1337,  115, 1338,  765,  773,  115,
  775,  776,  787,  788,  792, 1287,  799,  197,  793,  801,
  197,  808,  820,  802, 1299,  821,  827, 1302, 1287,  823,
  824,  325,  357,  370,  844, 1316,  839,  115,  115,  850,
  845,  115,  846,  847,  115,  852,  851, 1287,  854,  868,
  872,  199,  325, 1372,  371,  372,  373,  374,  375,  376,
  377,  378,  379,  380,  583,  873,  882,  875,  115,  583,
 1399,  583,  583,  583,  583,  583,  583,  583,  583,  583,
  583,  583,  883, 1411, 1413,  884,  113,  113,  893,  900,
  898,  909,  914,  583,  916,  583,  727,  583, 1267,  583,
  583,  583,  920,  923,  924,  930,  933,  931,  485,  934,
 1399, 1399,   43,  264,  938,  325,  940,  288,  289,  290,
  958,  294,  295,  946,  959, 1421,  306,  307,  960,  113,
  967,  113,  961,  312,  969,  314,  325,  318,  976,  332,
  503,  985,  329,  330,  983,  332,  991,  987,  989,  992,
  996,  997,  325, 1007,  583, 1016,  325, 1017,  727, 1022,
 1029, 1023, 1030, 1031, 1037,  366, 1399, 1036, 1049, 1039,
 1055,  879,  541, 1058, 1056, 1063, 1077, 1081, 1080, 1082,
 1083,  332, 1090, 1095, 1100, 1105, 1103, 1111, 1112, 1117,
 1121, 1123, 1125, 1128,  727, 1153, 1156, 1163, 1142, 1135,
 1170, 1182, 1230, 1162, 1469, 1469, 1171, 1174, 1176, 1179,
 1178, 1478, 1478,  541, 1187, 1180,  586,  586, 1181, 1226,
 1232, 1229, 1245,  325,  325,  605,  606,  607, 1248, 1233,
  541,  541,  541,  541,  541,  541,  541,  541,  541,  541,
  541,  541,  541,  541,  541,  541,  911, 1235, 1242, 1269,
 1277,  332, 1290, 1321,  332, 1305,  332,  332, 1294, 1295,
 1308,  332,  332, 1311, 1323,  332,  332,  332,  332,  332,
  332,  332,  332,  332, 1324,  332,  332,  332,  332,  332,
  332,  332,  332,  332,  332, 1304, 1326,  325,  357, 1312,
 1314,  499, 1330, 1328,  357,  332,  332, 1332, 1334, 1335,
 1340, 1345, 1348,  332, 1355, 1351,  332, 1352,  312, 1353,
 1367,  366,  332, 1363, 1364, 1382, 1377, 1384, 1393, 1406,
 1394, 1396, 1397, 1403, 1407, 1417,  357, 1418, 1420,  911,
  357, 1423, 1422, 1425,  911, 1431,  911,  911,  911,  911,
  911,  911,  911,  911,  911,  911, 1437,  541, 1438,  507,
  113, 1442, 1446, 1449, 1447, 1456, 1441, 1440,  911, 1462,
  911,  523,  911, 1463,  911,  911,  911, 1484, 1485, 1486,
    9,  357,  937,  531,  826,  726,  357,   32,  357,  357,
  357,  357,  357,  357,  357,  357,  357,  357,  357,  489,
  601,  929,  796,  490,  448,  602,  670,   30,  325,  357,
  357,   22,  357,  357,  357,  800,  357,  357,  357,  514,
  357,  357,  488,   30,  357,  357,  357,  357,  777,  911,
   31,  357,  357,  744,  754,  206,  357,  357,  357,  357,
  357,  357,  357,  357,  801,   96,   31,  834,  745,  310,
  755,  746,  775,  803,  738,  357,  776,  805,  357,  658,
  357,  680,  658,   25,  314,   26,  339,  332,   27,  828,
  637,  357,  637,   28,  123,  233,  105,   29,  285,  113,
  237,  130,  124,  113,  106,  286,   31,  131,   54,   21,
 1008,  929, 1107,   33, 1108, 1244, 1236, 1439,   34, 1408,
   48, 1448,   35,  325, 1395, 1424, 1284, 1390, 1297,  951,
 1480,  113,  113,  829,   37,  113,   38,  842,  113,  955,
   39, 1318,  956,   48, 1243, 1419, 1240, 1472,   40,   41,
  957, 1414,   42, 1412, 1471,  739,   48, 1188, 1339, 1288,
  693,   48,  113,  744,  925,  902,   48, 1177,   48,   48,
   48,   48,  975,  325,   48,  904,   48,  499,  860,  786,
   48,  581,  499,  499,  838,  299,  544, 1040,  334,  325,
  620,  622,   48,  621,  623,   48,  858,   48,  624,  899,
  734,  625,  760, 1165, 1249,  499, 1168, 1124,  404, 1052,
 1084, 1098, 1035, 1024, 1091,  499, 1086,  737,  499,  499,
 1093,   48,  990,  499,  640, 1246,  499,  296,  499, 1155,
  499,  499,  499,  499,    0,    0,  740,    0,  499,    0,
    0,  926,  499,    0,  325,  325,  499,    0,    0,    0,
    0,    0,  325,  927,  499,    0,  771,  499,    0,  499,
  499,  325,  325,    0,  325,  499,    0,  499,  499,  499,
  499,  499,  499,  499,  499,  499,  499,  499,    0,    0,
    0,    0,    0,  499,  325,    0,    0,  325,  499,  499,
    0,  499,  499,  499,  499,  499,  499,  499,    0,  499,
  499,    0,  499,  499,  499,  499,  499,  499,  499,  499,
  499,  499,    0,  499,  499,  499,  499,  499,  499,  499,
  499,  499,  499,  499,  499,  499,  499,  499,  499,  499,
  499,  499,  499,  499,  499,    0,    0,  499,    0,  499,
  541,  499,    0,    0,  499,  828,  828,    0,    0,    0,
  499,    0,    0,  828,  828,  828,  828,  828,    0,  828,
  828,    0,  828,  828,  828,  828,  828,  828,  828,  828,
    0,    0,    0,    0,  828,    0,  828,  828,  828,  828,
  828,  828,    0,    0,  828,  332,    0,    0,  828,  828,
    0,  828,  828,  828,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  828,    0,  828,    0,  828,  828,    0,
    0,  828,    0,  828,  828,  828,  828,  828,  828,  828,
  828,  828,  828,  828,  828,    0,  828,    0,    0,  828,
  828,    0,    0,  828,  828,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  828,  828,
  828,  828,  828,    0,    0,    0,  828,  828,    0,    0,
  828,    0,    0,    0,    0,  828,  828,  828,  828,  828,
    0,    0,    0,  828,    0,  828,    0,    0,    0,    0,
    0,  828,  828,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  828,  828,  828,  828,
    0,  828,  771,  771,    0,    0,    0,    0,  828,    0,
  771,  771,  771,  771,  771,    0,  771,  771,    0,  771,
  771,  771,  771,  771,  771,  771,    0,    0,  734,    0,
    0,  771,    0,  771,  771,  771,  771,  771,  771,    0,
    0,  771,    0,    0,    0,  771,  771,    0,  771,  771,
  771,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  771,    0,  771,    0,  771,  771,    0,    0,  771,    0,
  771,  771,  771,  771,  771,  771,  771,  771,  771,  771,
  771,  771,    0,  771,    0,    0,  771,  771,    0,    0,
  771,  771,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  771,  771,  771,  771,  771,
    0,    0,    0,  771,  771,    0,    0,  771,    0,    0,
    0,    0,  771,  771,  771,  771,  771,    0,    0,    0,
  771,  332,  771,    0,    0,    0,  332,  332,  771,  771,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  325,  332,
    0,    0,    0,  771,  771,  771,  771,    0,  771,  332,
    0,    0,  332,  332,    0,  771,    0,  332,    0,    0,
  332,    0,  332,    0,  332,  332,  332,  332,    0,    0,
    0,    0,  332,    0,    0,    0,  332,    0,    0,    0,
  332,    0,    0,    0,    0,    0,    0,    0,  332,    0,
    0,  332,    0,  332,  332,    0,    0,    0,    0,  332,
    0,  332,  332,  332,  332,  332,  332,  332,  332,  332,
  332,  332,  332,    0,    0,    0,    0,  332,    0,    0,
    0,    0,  332,  332,  332,  332,  332,  332,  332,  332,
  332,  332,    0,  332,  332,    0,    0,  332,  332,  332,
  332,  332,    0,    0,  332,  332,    0,    0,    0,  332,
  332,  332,  332,  332,  332,  332,  332,    0,    0,    0,
    0,    0,    0,    0,  734,    0,    0,    0,  332,  734,
  734,  332,    0,  332,    0,  332,    0,    0,  332,    0,
    0,    0,    0,    0,  332,  362,    0,    0,    0,    0,
    0,    0,  734,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  734,    0,    0,  734,  734,    0,    0,    0,
  734,    0,    0,  734,    0,  734,    0,  734,  734,  734,
  734,    0,    0,    0,    0,  734,    0,    0,    0,  734,
    0,    0,    0,  734,    0,    0,    0,    0,    0,    0,
    0,  734,    0,    0,  734,    0,  734,  734,    0,    0,
    0,    0,  734,    0,  734,  734,  734,  734,  734,  734,
  734,  734,  734,  734,  734,    0,    0,    0,    0,    0,
  734,    0,    0,    0,    0,  734,  734,  734,  734,  734,
  734,    0,  734,  734,  734,    0,  734,  734,    0,    0,
  734,  734,  734,  734,  325,    0,    0,  734,  734,  325,
  325,    0,  734,  734,  734,  734,  734,  734,  734,  734,
  332,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  734,  325,    0,  734,    0,  734,    0,  734,    0,
    0,  734,  325,    0,    0,  325,  325,  734,    0,    0,
  325,    0,    0,  325,    0,  325,    0,  325,  325,  325,
  325,    0,    0,    0,    0,  325,    0,    0,    0,  325,
    0,    0,    0,  325,    0,    0,    0,    0,    0,    0,
    0,  325,    0,    0,  325,    0,  325,  325,    0,    0,
    0,    0,  325,    0,  325,  325,  325,  325,  325,  325,
  325,  325,  325,  325,  325,    0,    0,    0,    0,    0,
  325,    0,    0,    0,    0,  325,  325,  325,  325,  325,
  325,    0,  325,  325,  325,    0,  325,  325,    0,    0,
  325,  325,  325,  325,    0,    0,    0,  325,  325,    0,
    0,    0,  325,  325,  325,  325,  325,  325,  325,  325,
    0,  362,    0,    0,    0,    0,  362,  362,    0,    0,
    0,  325,    0,    0,  325,    0,  325,    0,  325,    0,
    0,  325,    0,    0,    0,    0,    0,  325,    0,  362,
    0,    0,    0,    0,    0,   49,    0,    0,    0,  362,
    0,    0,  362,  362,    0,    0,    0,  362,    0,    0,
  362,    0,  362,    0,  362,  362,  362,  362,    0,    0,
    0,    0,  362,    0,    0,    0,  362,    0,    0,    0,
  362,    0,    0,    0,    0,    0,    0,    0,  362,    0,
    0,  362,    0,  362,  362,    0,    0,    0,    0,  362,
    0,  362,  362,  362,  362,  362,  362,  362,  362,  362,
  362,  362,    0,    0,    0,    0,    0,  362,    0,    0,
    0,    0,  362,  362,    0,  362,  362,  362,    0,  362,
  362,  362,    0,  362,  362,    0,  332,  362,  362,  362,
  362,    0,  332,    0,  362,  362,    0,    0,    0,  362,
  362,  362,  362,  362,  362,  362,  362,    0,   28,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  362,    0,
    0,  362,    0,  362,  332,    0,    0,    0,  332,    0,
    0,    0,    0,    0,  362,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  332,
    0,   36,    0,    0,  332,    0,  332,  332,  332,  332,
  332,  332,  332,  332,  332,  332,  332,  332,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  332,  332,  332,
  332,  332,  332,  332,  332,  332,  332,    0,  332,  332,
    0,    0,  332,  332,  332,  332,  332,    0,    0,  332,
  332,    0,    0,    0,  332,  332,  332,  332,  332,  332,
  332,  332,    0,    0,    0,    0,    0,    0,    0,    0,
   35,    0,    0,  332,    0,    0,  332,    0,  332,    0,
  332,    0,   49,  332,    0,    0,   49,    0,   49,  332,
   49,    0,   49,    0,    0,   49,    0,   49,   49,    0,
   49,    0,   49,    0,   49,    0,   49,   49,   49,   49,
    0,    0,   49,   49,    0,    0,    0,   34,   49,   49,
   49,   49,   49,    0,    0,   49,   49,   49,    0,   49,
    0,   49,   49,   49,   49,   49,   49,   49,   49,    0,
   49,   49,   49,   49,    0,    0,   49,   49,   49,    0,
   49,    0,    0,    0,    0,   49,   49,    0,   49,   49,
    0,   49,   49,   49,    0,    0,    0,   49,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   28,    0,    0,    0,    0,    0,    0,   49,    0,   49,
   49,    0,    0,    0,   28,   28,    0,    0,    0,   28,
    0,    0,   49,   28,    0,   28,    0,    0,   28,    0,
   28,   28,    0,   28,    0,   28,    0,   28,    0,   28,
   28,   28,   28,   33,    0,   28,   28,    0,    0,    0,
    0,   28,    0,   28,   28,   28,    0,    0,   28,   28,
   28,    0,   28,   49,    0,   28,    0,   28,   28,   28,
   28,    0,    0,    0,   28,   28,   28,    0,   36,   28,
   28,   28,   36,    0,    0,    0,    5,    0,   28,   28,
    0,   28,   28,   36,   28,   28,   28,    0,   36,    0,
   28,    0,   36,    0,    0,   36,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   36,   36,    0,
   28,    0,   36,   36,    0,    0,   28,   28,   36,  919,
   36,   36,   36,   36,    0,   28,    0,    0,   36,    0,
    0,    0,   36,    0,   36,    0,    0,   35,    0,    0,
    0,   35,    0,    0,   36,    0,   36,   36,    0,   36,
    0,    0,   35,   36,    0,    0,    0,   35,    0,    0,
    0,   35,   48,    0,   35,    0,   28,    0,    0,    0,
    0,    0,    0,   36,    0,    0,   35,   35,    0,   36,
   36,   35,   35,    0,   34,    0,    0,   35,   34,   35,
   35,   35,   35,    0,    0,    0,    0,   35,    0,   34,
    0,   35,    0,   35,   34,    7,    0,    0,   34,    0,
    0,   34,    0,   35,    0,   35,   35,    0,   35,    0,
    0,    0,   35,   34,   34,    0,    0,    0,   34,   34,
    0,    0,    0,    0,   34,    0,   34,   34,   34,   34,
    0,    0,   35,    0,   34,    0,    0,   28,   34,   35,
   34,   28,    0,    0,    0,    0,    0,    0,    0,    0,
   34,    0,   28,   34,    0,   34,    0,   28,  920,   34,
    0,   28,    0,    0,   28,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   28,   28,    0,   34,
   33,   28,   28,    0,   33,   34,   34,   28,    0,   28,
   28,   28,   28,    0,    0,   33,    0,   28,    0,    0,
   33,   28,    0,   28,   33,    0,    0,   33,    0,    0,
    0,    0,    0,   28,    0,    0,   28,    0,   28,   33,
   33,    0,   28,    5,   33,   33,    0,   48,    0,    0,
   33,    0,   33,   33,   33,   33,    0,    0,   48,    0,
   33,    0,   28,   48,   33,    0,   33,   48,   28,   28,
   48,    0,    0,    0,    0,    0,   33,    0,    0,   33,
    0,   33,   48,   48,    0,   33,  919,   48,   48,    0,
   48,    0,    0,   48,    0,   48,   48,   48,   48,    0,
    0,   48,    0,   48,    0,   33,   48,   48,    0,   48,
   48,    0,   33,   48,    0,    0,    0,    0,    0,   48,
    0,    0,   48,    0,   48,   48,   48,    0,   48,   48,
   48,   48,    0,   48,    0,    0,   48,    0,   48,   48,
   48,   48,    0,    0,   48,    0,   48,    0,   48,   48,
   48,    0,   48,   48,    0,    0,   48,    0,    0,    0,
    0,    0,   48,    0,    0,   48,    0,   48,   48,   48,
    0,   48,    7,   48,   48,    0,   49,    0,    0,   48,
    0,   48,   48,   48,   48,    0,    0,   49,    0,   48,
    0,   48,   49,   48,    0,   48,   49,    0,    0,   49,
    0,    0,    0,    0,    0,   48,    0,    0,   48,    0,
   48,   49,   49,    0,   48,    0,   49,   49,    0,    0,
    0,    0,   49,    0,   49,   49,   49,   49,    0,    0,
    0,    0,   49,    0,   48,  920,   49,    0,   49,   48,
    0,    0,    0,    0,    0,    0,    0,    0,   49,    0,
   48,   49,    0,   49,    0,   48,    0,   49,    0,   48,
    0,    0,   48,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   48,   48,    0,   49,    0,   48,
   48,    0,    0,    0,    0,   48,    0,   48,   48,   48,
   48,    0,    0,    0,    0,   48,    0,    0,    0,   48,
    0,   48,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   48,    0,   56,   48,    0,   48,    0,    0,    0,
   48,   57,   25,   58,   26,    0,    0,   27,   59,    0,
   60,   61,   28,   62,   63,   64,   29,    0,    0,    0,
   48,    0,   65,    0,   66,   31,   67,   68,   69,   70,
    0,    0,   33,    0,    0,    0,   71,   34,    0,   72,
   73,   35,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   74,    0,   37,    0,   38,   75,    0,    0,   39,
    0,   76,   77,   78,   79,   80,   81,   40,   41,   82,
   83,   42,   84,    0,   85,    0,    0,   86,   87,    0,
  332,   88,   89,    0,    0,    0,  332,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,   93,
   94,    0,    0,    0,   95,    0,    0,    0,   96,    0,
    0,    0,    0,   97,   98,   99,  100,  101,    0,    0,
    0,  102,  332,  103,    0,    0,    0,    0,    0,  104,
  105,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  389,    0,  106,  107,  108,  109,    0,    0,
    0,    0,    0,  332,    0,    0,  199,    0,  332,    0,
  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
  332,  332,    0,    0,    0,    0,    0,    0,  389,    0,
    0,    0,  332,  332,  332,  332,  332,  332,  332,  332,
  332,    0,  332,  332,    0,  332,  332,  332,  332,  332,
  332,  332,  332,  332,  332,    0,  332,  332,  332,  332,
  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
  332,  332,  332,  332,  332,  332,  332,  332,    0,  501,
    0,    0,  332,    0,  332,  501,    0,  332,    0,    0,
    0,    0,    0,  332,    0,    0,    0,    0,    0,  325,
    0,  389,  389,  389,  389,    0,  389,    0,  389,  389,
    0,  389,  389,  389,  389,  389,    0,  389,  389,  389,
  389,  501,  389,  389,  389,  389,  389,  389,  389,  389,
  389,  389,  389,  389,  389,  389,  389,  389,  389,  389,
  389,  389,  389,  389,    0,    0,    0,    0,  325,    0,
  389,  332,    0,  389,    0,    0,    0,    0,    0,  389,
    0,    0,  501,    0,    0,    0,    0,  501,    0,  501,
  501,  501,  501,  501,  501,  501,  501,  501,  501,  501,
    0,    0,    0,    0,    0,    0,    0,  332,    0,    0,
  501,  501,  501,  501,  501,  501,  501,  501,  501,  501,
    0,  501,  501,    0,  501,  501,  501,  501,  501,  501,
  501,  501,  501,  501,    0,  501,  501,  501,  501,  501,
  501,  501,  501,  501,  501,  501,  501,  501,  501,  501,
  501,  501,  501,  501,  501,  501,  501,    0,  497,    0,
    0,    0,    0,  501,  497,    0,  332,    0,    0,    0,
    0,    0,  501,    0,    0,    0,    0,    0,  332,    0,
  332,    0,  332,    0,    0,  332,    0,  332,  332,    0,
  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
  497,  332,  332,  332,  332,  332,  332,  332,  332,  332,
  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
  332,  332,  332,    0,    0,    0,    0,  332,    0,  332,
  332,    0,  332,    0,    0,    0,    0,    0,  332,    0,
    0,  497,    0,    0,    0,    0,  497,    0,  497,  497,
  497,  497,  497,  497,  497,  497,  497,  497,  497,    0,
    0,    0,    0,    0,    0,    0,  332,    0,    0,  497,
  497,    0,  497,  497,  497,  497,  497,  497,  497,    0,
  497,  497,    0,  497,  497,  497,  497,  497,  497,  497,
  497,  497,  497,    0,  497,  497,  497,  497,  497,  497,
  497,  497,  497,  497,  497,  497,  497,  497,  497,  497,
  497,  497,  497,  497,  497,  497,    0,  505,    0,    0,
    0,    0,  497,  505,    0,  497,    0,    0,    0,    0,
    0,  497,    0,    0,    0,    0,    0,    0,  332,  332,
  332,  332,  332,    0,    0,    0,  332,  332,    0,  332,
  332,  332,  332,  332,  332,  332,  332,  332,  332,  505,
  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
  332,  332,    0,    0,    0,    0,    0,    0,  332,    0,
    0,  332,    0,    0,    0,    0,    0,  332,    0,    0,
  505,    0,    0,    0,    0,  505,    0,  505,  505,  505,
  505,  505,  505,  505,  505,  505,  505,  505,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  505,
    0,  505,  505,  505,  505,  505,  505,  505,    0,  505,
  505,    0,  505,  505,  505,  505,  505,  505,  505,  505,
  505,  505,    0,  505,  505,  505,  505,  505,  505,  505,
  505,  505,  505,  505,  505,  505,  505,  505,  505,  505,
  505,  505,  505,  505,  505,    0,  332,  876,    0,    0,
    0,  505,  332,    0,  505,    0,   25,    0,   26,    0,
  505,   27,    0,    0,    0,    0,   28,    0,    0,    0,
   29,    0,    0,    0,    0,    0,    0,    0,    0,   31,
    0,    0,    0,    0,    0,    0,   33,    0,  332,    0,
    0,   34,    0,    0,    0,   35,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   37,    0,   38,
    0,    0,    0,   39,    0,    0,    0,    0,    0,    0,
    0,   40,   41,    0,    0,   42,    0,    0,  319,  332,
    0,    0,    0,    0,  332,    0,  332,  332,  332,  332,
  332,  332,  332,  332,  332,  332,  332,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  332,    0,
  332,  332,  332,  332,  332,  332,  332,    0,  332,  332,
    0,  332,  332,  332,  332,  332,  332,  332,  332,  332,
  332,    0,  332,  332,  332,  332,  332,  332,  332,  332,
  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
  332,  332,  332,  332,    0,  432, 1071,    0,    0,  354,
  332,  432,    0,  332,    0,   25,    0,   26,    0,  332,
   27,    0,    0,    0,    0,   28,    0,    0,    0,   29,
    0,    0,    0,    0,    0,    0,    0,    0,   31,    0,
    0,    0,    0,    0,    0,   33,    0,  432,    0,    0,
   34,    0,    0,    0,   35,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   37,    0,   38,    0,
    0,    0,   39,    0,    0,    0,    0,    0,    0,    0,
   40,   41,    0,    0,   42,    0,    0,  319,  432,    0,
    0,    0,    0,  432,    0,  432,  432,  432,  432,  432,
  432,  432,  432,  432,  432,  432,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  432,    0,  432,
  432,  432,  432,  432,  432,  432,    0,  432,  432,    0,
  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
    0,  432,  432,  432,  432,  432,  432,  432,  432,  432,
  432,  432,  432,  432,  432,  432,  432,  432,  432,  432,
  432,  432,  432,    0,  392, 1137,    0,    0,  354,  432,
  392,    0,  432,    0,   25,    0,   26,    0,  432,   27,
    0,    0,    0,    0,   28,    0,    0,    0,   29,    0,
    0,    0,    0,    0,    0,    0,    0,   31,    0,    0,
    0,    0,    0,    0,   33,    0,  392,    0,    0,   34,
    0,    0,    0,   35,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   37,    0,   38,    0,    0,
    0,   39,    0,    0,    0,    0,    0,    0,    0,   40,
   41,    0,    0,   42,    0,    0,  319,  392,    0,    0,
    0,    0,  392,    0,  392,  392,  392,  392,  392,  392,
  392,  392,  392,  392,  392,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  392,    0,  392,  392,
  392,  392,  392,  392,  392,    0,  392,    0,    0,  392,
  392,  392,  392,  392,  392,  392,  392,  392,  392,    0,
  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,
  392,  392,  392,  392,  392,  392,  392,  392,  392,  392,
  392,  392,    0,  536,    0,  492,    0,  354,  392,  536,
    0,  392,    0,   57,   25,    0,   26,  392,    0,   27,
  256,    0,    0,    0,   28,   62,   63,    0,   29,    0,
    0,    0,    0,    0,   65,    0,    0,   31,    0,    0,
    0,    0,    0,    0,   33,  536,    0,    0,    0,   34,
    0,   72,   73,   35,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   37,    0,   38,   75,    0,
    0,   39,    0,    0,   77,    0,   79,    0,   81,   40,
   41,  257,    0,   42,    0,    0,  536,    0,    0,    0,
    0,  536,    0,  536,  536,  536,  536,  536,  536,  536,
  536,  536,  536,  536,    0,    0,    0,    0,   90,   91,
   92,  258,    0,    0,    0,  536,    0,  536,    0,  536,
   96,  536,  536,  536,    0,  536,  536,    0,  536,  536,
  536,  536,  536,  536,  536,  536,  536,  536,  354,    0,
    0,  536,  536,  536,  536,  536,  536,  536,  536,  536,
  536,  536,  536,  536,  536,  536,  536,  536,  536,  550,
  536,  354,    0,    0,    0,  550,  106,  493,    0,    0,
    0,    0,    0,    0,  354,    0,  536,    0,    0,  354,
    0,    0,  230,    0,  354,    0,  354,  354,  354,  354,
    0,    0,    0,    0,  354,    0,    0,    0,  354,    0,
    0,  550,  354,    0,    0,    0,    0,    0,    0,    0,
  354,    0,    0,  354,    0,  354,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  554,    0,    0,
    0,    0,    0,  554,    0,    0,    0,    0,    0,  354,
    0,    0,  550,    0,    0,    0,    0,  550,    0,  550,
  550,  550,  550,  550,  550,  550,  550,  550,  550,  550,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  554,
    0,  550,    0,  550,    0,  550,    0,  550,  550,  550,
    0,  550,  550,    0,    0,  550,  550,  550,  550,  550,
  550,  550,  550,  550,    0,  354,    0,  550,  550,  550,
  550,  550,  550,  550,  550,    0,    0,    0,    0,    0,
  554,    0,    0,    0,    0,  554,  550,  554,  554,  554,
  554,  554,  554,  554,  554,  554,  554,  554,    0,    0,
    0,  557,  550,    0,    0,    0,    0,  557,    0,  554,
    0,  554,    0,  554,    0,  554,  554,  554,    0,  554,
  554,    0,    0,  554,  554,  554,  554,    0,    0,    0,
  554,  554,    0,    0,    0,  554,  554,  554,  554,  554,
  554,  554,  554,  557,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  554,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  555,
  554,    0,    0,    0,    0,  555,    0,    0,    0,    0,
    0,    0,    0,    0,  557,    0,    0,    0,    0,  557,
    0,  557,  557,  557,  557,  557,  557,  557,  557,  557,
  557,  557,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  555,    0,  557,    0,  557,    0,  557,    0,  557,
  557,  557,    0,  557,  557,    0,    0,  557,  557,  557,
  557,    0,    0,    0,  557,  557,  204,    0,    0,  557,
  557,  557,  557,  557,  557,  557,  557,    0,    0,    0,
    0,    0,  555,    0,    0,    0,    0,  555,  557,  555,
  555,  555,  555,  555,  555,  555,  555,  555,  555,  555,
    0,    0,    0,  556,  557,    0,    0,    0,  205,  556,
    0,  555,    0,  555,    0,  555,    0,  555,  555,  555,
    0,  555,  555,    0,    0,  555,  555,  555,  555,    0,
    0,    0,  555,  555,    0,    0,    0,  555,  555,  555,
  555,  555,  555,  555,  555,  556,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  555,    0,  206,  207,
  208,  209,    0,  210,  211,  212,  213,  214,  215,  216,
  217,  560,  555,  218,  219,  220,  221,  222,  223,  224,
  225,    0,    0,    0,    0,    0,  556,    0,    0,    0,
    0,  556,    0,  556,  556,  556,  556,  556,  556,  556,
  556,  556,  556,  556,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  556,    0,  556,    0,  556,
    0,  556,  556,  556,    0,  556,  556,    0,    0,  556,
  556,  556,  556,    0,    0,    0,  556,  556,    0,  561,
    0,  556,  556,  556,  556,  556,  556,  556,  556,    0,
    0,    0,    0,    0,  560,    0,    0,    0,    0,  560,
  556,  560,  560,  560,  560,  560,  560,  560,  560,  560,
  560,  560,    0,    0,    0,    0,  556,    0,    0,    0,
    0,    0,    0,  560,    0,  560,    0,  560,    0,  560,
  560,  560,    0,    0,    0,    0,    0,  560,  560,  560,
  560,    0,    0,    0,  560,  560,    0,  562,    0,  560,
  560,  560,  560,  560,  560,  560,  560,    0,    0,    0,
    0,    0,  561,    0,    0,    0,    0,  561,  560,  561,
  561,  561,  561,  561,  561,  561,  561,  561,  561,  561,
    0,    0,    0,    0,  560,    0,    0,    0,    0,    0,
    0,  561,    0,  561,    0,  561,    0,  561,  561,  561,
    0,    0,    0,    0,    0,  561,  561,  561,  561,    0,
    0,    0,  561,  561,    0,  563,    0,  561,  561,  561,
  561,  561,  561,  561,  561,    0,    0,    0,    0,    0,
  562,    0,    0,    0,    0,  562,  561,  562,  562,  562,
  562,  562,  562,  562,  562,  562,  562,  562,    0,    0,
    0,    0,  561,    0,    0,    0,    0,    0,    0,  562,
    0,  562,    0,  562,    0,  562,  562,  562,    0,    0,
    0,    0,    0,  562,  562,  562,  562,    0,    0,    0,
  562,  562,    0,  564,    0,  562,  562,  562,  562,  562,
  562,  562,  562,    0,    0,    0,    0,    0,  563,    0,
    0,    0,    0,  563,  562,  563,  563,  563,  563,  563,
  563,  563,  563,  563,  563,  563,    0,    0,    0,    0,
  562,    0,    0,    0,    0,    0,    0,  563,    0,  563,
    0,  563,    0,  563,  563,  563,    0,    0,    0,    0,
    0,  563,  563,  563,  563,    0,    0,    0,  563,  563,
    0,  565,    0,    0,    0,  563,  563,  563,  563,  563,
  563,    0,    0,    0,    0,    0,  564,    0,    0,    0,
    0,  564,  563,  564,  564,  564,  564,  564,  564,  564,
  564,  564,  564,  564,    0,    0,    0,    0,  563,    0,
    0,    0,    0,    0,    0,  564,    0,  564,    0,  564,
    0,  564,  564,  564,    0,    0,    0,    0,    0,  564,
  564,  564,  564,    0,    0,    0,  564,  564,    0,  566,
    0,    0,    0,  564,  564,  564,  564,  564,  564,    0,
    0,    0,    0,    0,  565,    0,    0,    0,    0,  565,
  564,  565,  565,  565,  565,  565,  565,  565,  565,  565,
  565,  565,    0,    0,    0,    0,  564,    0,    0,    0,
    0,    0,    0,  565,    0,  565,    0,  565,    0,  565,
  565,  565,    0,    0,    0,    0,    0,  565,  565,  565,
  565,    0,    0,    0,  565,  565,    0,  567,    0,    0,
    0,  565,  565,  565,  565,  565,  565,    0,    0,    0,
    0,    0,  566,    0,    0,    0,    0,  566,  565,  566,
  566,  566,  566,  566,  566,  566,  566,  566,  566,  566,
    0,    0,    0,    0,  565,    0,    0,    0,    0,    0,
    0,  566,    0,  566,    0,  566,    0,  566,  566,  566,
    0,    0,    0,    0,    0,  566,  566,  566,  566,    0,
    0,    0,  566,  566,    0,  568,    0,    0,    0,  566,
  566,  566,  566,  566,  566,    0,    0,    0,    0,    0,
  567,    0,    0,    0,    0,  567,  566,  567,  567,  567,
  567,  567,  567,  567,  567,  567,  567,  567,    0,    0,
    0,    0,  566,    0,    0,    0,    0,    0,    0,  567,
    0,  567,    0,  567,    0,  567,  567,  567,    0,    0,
    0,    0,    0,  567,  567,  567,  567,    0,    0,    0,
  567,  567,    0,  569,    0,    0,    0,  567,  567,  567,
  567,  567,  567,    0,    0,    0,    0,    0,  568,    0,
    0,    0,    0,  568,  567,  568,  568,  568,  568,  568,
  568,  568,  568,  568,  568,  568,    0,    0,    0,    0,
  567,    0,    0,    0,    0,    0,    0,  568,    0,  568,
    0,  568,    0,  568,  568,  568,    0,    0,    0,    0,
    0,    0,    0,  568,  568,    0,    0,    0,  568,  568,
    0,  570,    0,    0,    0,    0,    0,  568,  568,  568,
  568,    0,    0,    0,    0,    0,  569,    0,    0,    0,
    0,  569,  568,  569,  569,  569,  569,  569,  569,  569,
  569,  569,  569,  569,    0,    0,    0,    0,  568,    0,
    0,    0,    0,    0,    0,  569,    0,  569,    0,  569,
    0,  569,  569,  569,    0,    0,    0,    0,    0,    0,
    0,  569,  569,    0,    0,    0,  569,  569,    0,  571,
    0,    0,    0,    0,    0,  569,  569,  569,  569,    0,
    0,    0,    0,    0,  570,    0,    0,    0,    0,  570,
  569,  570,  570,  570,  570,  570,  570,  570,  570,  570,
  570,  570,    0,    0,    0,    0,  569,    0,    0,    0,
    0,    0,    0,  570,    0,  570,    0,  570,    0,  570,
  570,  570,    0,    0,    0,    0,    0,    0,    0,  570,
  570,    0,    0,    0,  570,  570,    0,  572,    0,    0,
    0,    0,    0,  570,  570,  570,  570,    0,    0,    0,
    0,    0,  571,    0,    0,    0,    0,  571,  570,  571,
  571,  571,  571,  571,  571,  571,  571,  571,  571,  571,
    0,    0,    0,    0,  570,    0,    0,    0,    0,    0,
    0,  571,    0,  571,    0,  571,    0,  571,  571,  571,
    0,    0,    0,    0,    0,    0,    0,  571,  571,    0,
    0,    0,  571,  571,    0,  573,    0,    0,    0,    0,
    0,    0,    0,  571,  571,    0,    0,    0,    0,    0,
  572,    0,    0,    0,    0,  572,  571,  572,  572,  572,
  572,  572,  572,  572,  572,  572,  572,  572,    0,    0,
    0,    0,  571,    0,    0,    0,    0,    0,    0,  572,
    0,  572,    0,  572,    0,  572,  572,  572,    0,    0,
    0,    0,    0,    0,    0,  572,  572,    0,    0,    0,
  572,  572,    0,  574,    0,    0,    0,    0,    0,    0,
    0,  572,  572,    0,    0,    0,    0,    0,  573,    0,
    0,    0,    0,  573,  572,  573,  573,  573,  573,  573,
  573,  573,  573,  573,  573,  573,    0,    0,    0,    0,
  572,    0,    0,    0,    0,    0,    0,  573,    0,  573,
    0,  573,    0,  573,  573,  573,    0,    0,    0,    0,
    0,    0,    0,    0,  573,    0,    0,    0,  573,  573,
    0,  575,    0,    0,    0,    0,    0,    0,    0,  573,
  573,    0,    0,    0,    0,    0,  574,    0,    0,    0,
    0,  574,  573,  574,  574,  574,  574,  574,  574,  574,
  574,  574,  574,  574,    0,    0,    0,    0,  573,    0,
    0,    0,    0,    0,    0,  574,    0,  574,    0,  574,
    0,  574,  574,  574,    0,    0,    0,    0,    0,    0,
    0,    0,  574,    0,    0,    0,  574,  574,    0,  576,
    0,    0,    0,    0,    0,    0,    0,  574,  574,    0,
    0,    0,    0,    0,  575,    0,    0,    0,    0,  575,
  574,  575,  575,  575,  575,  575,  575,  575,  575,  575,
  575,  575,    0,    0,    0,    0,  574,    0,    0,    0,
    0,    0,    0,  575,    0,  575,    0,  575,    0,  575,
  575,  575,    0,    0,    0,    0,    0,    0,    0,    0,
  575,    0,    0,    0,    0,  575,    0,  577,    0,    0,
    0,    0,    0,    0,    0,  575,  575,    0,    0,    0,
    0,    0,  576,    0,    0,    0,    0,  576,  575,  576,
  576,  576,  576,  576,  576,  576,  576,  576,  576,  576,
    0,    0,    0,    0,  575,    0,    0,    0,    0,    0,
    0,  576,    0,  576,    0,  576,    0,  576,  576,  576,
    0,    0,    0,    0,    0,    0,    0,    0,  576,    0,
    0,    0,    0,  576,    0,  578,    0,    0,    0,    0,
    0,    0,    0,  576,  576,    0,    0,    0,    0,    0,
  577,    0,    0,    0,    0,  577,  576,  577,  577,  577,
  577,  577,  577,  577,  577,  577,  577,  577,    0,    0,
    0,    0,  576,    0,    0,    0,    0,    0,    0,  577,
    0,  577,    0,  577,    0,  577,  577,  577,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  577,    0,  579,    0,    0,    0,    0,    0,    0,
    0,  577,  577,    0,    0,    0,    0,    0,  578,    0,
    0,    0,    0,  578,  577,  578,  578,  578,  578,  578,
  578,  578,  578,  578,  578,  578,    0,    0,    0,    0,
  577,    0,    0,    0,    0,    0,    0,  578,    0,  578,
    0,  578,    0,  578,  578,  578,    0,    0,    0,  580,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  578,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  578,
  578,    0,    0,    0,    0,    0,  579,    0,    0,    0,
    0,  579,  578,  579,  579,  579,  579,  579,  579,  579,
  579,  579,  579,  579,    0,    0,    0,    0,  578,    0,
    0,    0,    0,    0,    0,  579,    0,  579,    0,  579,
    0,  579,  579,  579,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  579,    0,    0,
    0,    0,  580,    0,    0,    0,    0,  580,  579,  580,
  580,  580,  580,  580,  580,  580,  580,  580,  580,  580,
  579,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  580,    0,  580,    0,  580,  579,  580,  580,  580,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   56,    0,  580,    0,    0,    0,    0,    0,   57,
   25,   58,   26,    0,  580,   27,   59,    0,   60,   61,
   28,   62,   63,   64,   29,    0,  580,    0,    0,    0,
   65,    0,   66,   31,   67,   68,   69,   70,    0,    0,
   33,    0,  580,    0,   71,   34,    0,   72,   73,   35,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   74,
    0,   37,    0,   38,   75,    0,    0,   39,    0,   76,
   77,   78,   79,   80,   81,   40,   41,   82,   83,   42,
   84,    0,   85,    0,    0,   86,   87,    0,    0,   88,
   89,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,   93,   94,    0,
    0,    0,   95,    0,    0,    0,   96,    0,    0,    0,
    0,   97,   98,   99,  100,  101,    0,    0,    0,  102,
    0,  103,    0,    0,    0,    0,    0,  104,  105,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  268,    0,
    0,    0,  106,  107,  108,  109,   57,   25,   58,   26,
    0,    0,   27,   59,    0,   60,   61,   28,   62,   63,
   64,   29,    0,    0,    0,    0,    0,   65,    0,   66,
   31,   67,   68,   69,   70,    0,    0,   33,    0,    0,
    0,   71,   34,    0,   72,   73,   35,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   74,    0,   37,    0,
   38,   75,    0,    0,   39,    0,   76,   77,   78,   79,
   80,   81,   40,   41,   82,   83,   42,   84,    0,   85,
    0,    0,   86,   87,    0,    0,   88,   89,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   90,   91,   92,   93,   94,    0,    0,    0,   95,
    0,    0,    0,   96,    0,    0,    0,    0,   97,   98,
   99,  100,  101,    0,    0,    0,  102,    0,  103,    0,
    0,    0,    0,    0,  104,  105,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  547,    0,    0,    0,  106,
  107,  108,  109,   57,   25,   58,   26,    0,    0,   27,
   59,    0,   60,   61,   28,   62,   63,   64,   29,    0,
    0,    0,    0,    0,   65,    0,   66,   31,   67,   68,
   69,   70,    0,    0,   33,    0,    0,    0,   71,   34,
    0,   72,   73,   35,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   74,    0,   37,    0,   38,   75,    0,
    0,   39,    0,   76,   77,   78,   79,   80,   81,   40,
   41,   82,   83,   42,   84,    0,   85,    0,    0,   86,
   87,    0,    0,   88,   89,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   90,   91,
   92,   93,   94,    0,    0,    0,   95,    0,    0,    0,
   96,    0,    0,    0,    0,   97,   98,   99,  100,  101,
    0,    0,    0,  102,    0,  103,    0,    0,    0,    0,
    0,  104,  105,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  916,    0,    0,    0,  106,  107,  108,  109,
  916,  916,  916,  916,    0,    0,  916,  916,    0,  916,
  916,  916,  916,  916,  916,  916,    0,    0,    0,    0,
    0,  916,    0,  916,  916,  916,  916,  916,  916,    0,
    0,  916,    0,    0,    0,  916,  916,    0,  916,  916,
  916,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  916,    0,  916,    0,  916,  916,    0,    0,  916,    0,
  916,  916,  916,  916,  916,  916,  916,  916,  916,  916,
  916,  916,    0,  916,    0,    0,  916,  916,    0,    0,
  916,  916,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  916,  916,  916,  916,  916,
    0,    0,    0,  916,    0,    0,    0,  916,    0,    0,
    0,    0,  916,  916,  916,  916,  916,    0,    0,    0,
  916,    0,  916,    0,    0,    0,    0,    0,  916,  916,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  780,
    0,    0,    0,  916,  916,  916,  916,  780,  780,  780,
  780,    0,    0,  780,  780,    0,  780,  780,  780,  780,
  780,  780,  780,    0,    0,    0,    0,    0,  780,    0,
  780,  780,  780,  780,  780,  780,    0,    0,  780,    0,
    0,    0,  780,  780,    0,  780,  780,  780,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  780,    0,  780,
    0,  780,  780,    0,    0,  780,    0,  780,  780,  780,
  780,  780,  780,  780,  780,  780,  780,  780,  780,    0,
  780,    0,    0,  780,  780,    0,    0,  780,  780,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  780,  780,  780,  780,  780,    0,    0,    0,
  780,    0,    0,    0,  780,    0,    0,    0,    0,  780,
  780,  780,  780,  780,    0,    0,    0,  780,    0,  780,
    0,    0,    0,    0,    0,  780,  780,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  725,    0,    0,    0,
  780,  780,  780,  780,   57,   25,    0,   26,    0,    0,
   27,  256,    0,    0,    0,   28,   62,   63,    0,   29,
    0,    0,  172,    0,  172,   65,    0,  172,   31,    0,
    0,    0,  172,    0,    0,   33,  172,    0,    0,    0,
   34,    0,   72,   73,   35,  172,    0,    0,    0,    0,
    0,    0,  172,    0,    0,    0,   37,  172,   38,   75,
    0,  172,   39,    0,    0,   77,    0,   79,    0,   81,
   40,   41,  257,  172,   42,  172,    0,    0,    0,  172,
    0,   87,    0,    0,   88,   89,    0,  172,  172,    0,
    0,  172,    0,    0,  172,    0,    0,    0,    0,   90,
   91,   92,   93,   94,    0,    0,    0,  509,  726,    0,
    0,   96,    0,    0,    0,    0,    0,   98,   99,  100,
  101,    0,    0,    0,  102,    0,  103,    0,    0,  940,
    0,    0,  104,  105,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  725,    0,    0,    0,  106,  301,  108,
  109,   57,   25,    0,   26,    0,    0,   27,  256,    0,
    0,    0,   28,   62,   63,  172,   29,    0,    0,  172,
    0,  172,   65,    0,  172,   31,    0,    0,    0,  172,
    0,    0,   33,  172,    0,    0,    0,   34,    0,   72,
   73,   35,  172,    0,    0,    0,    0,    0,    0,  172,
    0,    0,    0,   37,  172,   38,   75,  906,  172,   39,
    0,    0,   77,    0,   79,    0,   81,   40,   41,  257,
  172,   42,  172,    0,    0,    0,  172,    0,   87,    0,
    0,   88,   89,    0,  172,  172,    0,    0,  172,    0,
    0,  172,    0,    0,    0,    0,   90,   91,   92,   93,
   94,    0,    0,    0,  509,    0,    0,    0,   96,    0,
    0,    0,    0,    0,   98,   99,  100,  101,    0,    0,
    0,  102,    0,  103,  940,    0,    0,    0,    0,  104,
  105,    0,    0,    0,    0,    0,    0,   57,   25,    0,
   26,    0,    0,   27,  256,    0,    0,    0,   28,   62,
   63,    0,   29,    0,  106,  301,  108,  109,   65,    0,
    0,   31,    0,    0,    0,    0,    0,    0,   33,    0,
    0,    0,  172,   34,    0,   72,   73,   35,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   37,
    0,   38,   75,    0,    0,   39,    0,    0,   77,    0,
   79,    0,   81,   40,   41,  257,    0,   42,    0,    0,
    0,    0,    0,    0,   87,    0,    0,   88,   89,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   90,   91,   92,   93,   94,    0,    0,    0,
  712,  974,    0,    0,   96,    0,    0,    0,    0,    0,
   98,   99,  100,  101,    0,    0,    0,  102,    0,  103,
    0,    0,    0,    0,    0,  104,  105,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  695,    0,
  106,  713,  108,  109,    0,    0,   57,   25,    0,   26,
    0,  714,   27,  256,    0,    0,    0,   28,   62,   63,
    0,   29,    0,    0,   25,    0,   26,   65,    0,   27,
   31,    0,    0,    0,   28,    0,    0,   33,   29,    0,
    0,    0,   34,    0,   72,   73,   35,   31,    0,    0,
    0,    0,    0,    0,   33,    0,    0,    0,   37,   34,
   38,   75,    0,   35,   39,    0,    0,   77,    0,   79,
    0,   81,   40,   41,  257,   37,   42,   38,    0,   85,
    0,   39,    0,   87,    0,    0,   88,   89,    0,   40,
   41,    0,    0,   42,    0,    0,  319,    0,    0,    0,
    0,   90,   91,   92,   93,   94,    0,    0,    0,    0,
    0,    0,    0,   96,    0,    0,    0,    0,    0,   98,
   99,  100,  101,    0,    0,    0,  102,    0,  103,    0,
    0,    0,    0,    0,  104,  105,    0,    0,    0,    0,
    0,    0,   57,   25,    0,   26,    0,    0,   27,  256,
    0,    0,    0,   28,   62,   63,    0,   29,    0,  106,
  301,  108,  109,   65,    0,    0,   31,    0,    0,    0,
    0,    0,    0,   33,    0,    0,    0,  320,   34,    0,
   72,   73,   35,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   37,    0,   38,   75,    0,    0,
   39,    0,    0,   77,    0,   79,    0,   81,   40,   41,
  257,    0,   42,    0,    0,    0,    0,    0,    0,   87,
    0,    0,   88,   89,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   90,   91,   92,
   93,   94,    0,    0,    0,  712,    0,    0,    0,   96,
    0,    0,    0,    0,    0,   98,   99,  100,  101,    0,
    0,    0,  102,    0,  103,    0,    0,    0,    0,    0,
  104,  105,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  725,    0,  106,  713,  108,  109,    0,
    0,   57,   25,    0,   26,    0,  714,   27,  256,    0,
    0,    0,   28,   62,   63,    0,   29,    0,    0,   25,
    0,   26,   65,    0,   27,   31,    0,    0,    0,   28,
    0,    0,   33,   29,    0,    0,    0,   34,    0,   72,
   73,   35,   31,    0,    0,    0,    0,    0,    0,   33,
    0,    0,    0,   37,   34,   38,   75,    0,   35,   39,
    0,    0,   77,    0,   79,    0,   81,   40,   41,  257,
   37,   42,   38,    0,    0,    0,   39,    0,   87,    0,
    0,   88,   89,    0,   40,   41,    0,    0,   42,    0,
    0,  319,    0,    0,    0,    0,   90,   91,   92,   93,
   94,    0,    0,    0,  509,    0,    0,    0,   96,    0,
    0,    0,    0,    0,   98,   99,  100,  101,    0,    0,
    0,  102,    0,  103,    0,    0,    0,    0,    0,  104,
  105,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  894,    0,    0,    0,  106,  301,  108,  109,   57,   25,
    0,   26,    0,    0,   27,  256,    0,    0,    0,   28,
   62,   63,  326,   29,    0,    0,   25,    0,   26,   65,
    0,   27,   31,    0,    0,    0,   28,    0,    0,   33,
   29,    0,    0,    0,   34,    0,   72,   73,   35,   31,
    0,    0,    0,    0,    0,    0,   33,    0,    0,    0,
   37,   34,   38,   75,    0,   35,   39,    0,    0,   77,
    0,   79,    0,   81,   40,   41,  257,   37,   42,   38,
    0,    0,    0,   39,    0,   87,    0,    0,   88,   89,
    0,   40,   41,    0,    0,   42,    0,    0,  319,    0,
    0,    0,    0,   90,   91,   92,   93,   94,    0,    0,
    0,    0,    0,    0,    0,   96,    0,    0,    0,    0,
    0,   98,   99,  100,  101,    0,    0,    0,  102,    0,
  103,    0,    0,    0,    0,    0,  104,  105,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  605,    0,    0,
    0,  106,  301,  108,  109,  605,  605,    0,  605,    0,
    0,  605,  605,    0,    0,    0,  605,  605,  605,  354,
  605,    0,    0,    0,    0,    0,  605,    0,    0,  605,
    0,    0,    0,    0,    0,    0,  605,    0,    0,    0,
    0,  605,    0,  605,  605,  605,    0,    0,    0,    0,
    0,    0,    0,  332,    0,    0,    0,  605,    0,  605,
  605,    0,    0,  605,    0,    0,  605,    0,  605,    0,
  605,  605,  605,  605,    0,  605,    0,    0,    0,    0,
    0,    0,  605,    0,    0,  605,  605,    0,    0,  332,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  605,  605,  605,  605,  605,    0,    0,    0,    0,    0,
    0,    0,  605,    0,    0,    0,    0,    0,  605,  605,
  605,  605,    0,    0,    0,  605,    0,  605,    0,    0,
    0,    0,    0,  605,  605,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  605,  605,
  605,  605,  332,  332,  332,  332,    0,    0,    0,  332,
  332,    0,    0,  332,  332,  332,  332,  332,  332,  332,
  332,  332,    0,  332,  332,  332,  332,  332,  332,  332,
  332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
  332,  332,  332,  332,  332,    0,   48,    0,    0,    0,
   48,  332,   48,    0,  332,   48,    0,   48,   48,    0,
   48,    0,   48,    0,   48,    0,   48,   48,   48,   48,
    0,    0,   48,   48,    0,    0,    0,    0,   48,    0,
   48,   48,   48,    0,    0,   48,    0,   48,    0,   48,
    0,    0,   48,    0,   48,   48,   48,   48,    0,    0,
    0,   48,   48,   48,    0,    0,   48,   48,   48,    0,
    0,    0,    0,    0,    0,   48,   48,    0,   48,   48,
    0,   48,   48,   48,    0,    0,    0,   48,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   48,    0,   48,    0,   48,
    0,   48,    0,   81,   48,    0,   48,   48,    0,   48,
    0,   48,   48,   48,    0,   48,   48,   48,   48,    0,
    0,   48,   48,    0,    0,    0,    0,   48,    0,   48,
   48,   48,    0,    0,   48,    0,   48,    0,   48,    0,
    0,   48,    0,   48,   48,   48,   48,    0,    0,    0,
   48,   48,   48,   48,    0,   48,   48,   48,    0,    0,
    0,    0,    0,    0,   48,   48,    0,   48,   48,    0,
   48,   48,   48,    0,    0,    0,   48,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   48,    0,   48,    0,   48,    0,
   48,    0,   82,   48,    0,   48,   48,    0,   48,    0,
   48,   48,   48,    0,   48,   48,   48,   48,    0,    0,
   48,   48,    0,    0,    0,    0,   48,    0,   48,   48,
   48,    0,    0,   48,    0,   48,    0,   48,    0,    0,
   48,    0,   48,   48,   48,   48,    0,    0,    0,   48,
   48,   48,   48,    0,   48,   48,   48,    0,    0,    0,
    0,    0,    0,   48,   48,    0,   48,   48,    0,   48,
   48,   48,    0,    0,    0,   48,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   48,    0,
    0,    0,   48,    0,   48,   48,    0,   48,    0,   48,
   48,  212,   48,    0,   48,    0,   48,    0,   48,   48,
   48,   48,    0,    0,   48,   48,    0,    0,    0,    0,
   48,    0,   48,   48,   48,    0,    0,   48,    0,   48,
  332,   48,    0,    0,   48,    0,   48,   48,   48,   48,
    0,    0,    0,   48,   48,   48,    0,    0,   48,   48,
   48,   48,    0,  332,    0,    0,    0,   48,   48,    0,
   48,   48,  447,   48,   48,   48,  332,    0,    0,   48,
    0,  332,    0,    0,  332,    0,  332,    0,  332,  332,
  332,  332,    0,    0,    0,  448,  332,    0,    0,   48,
  332,    0,    0,    0,  332,  213,    0,    0,  449,    0,
  353,    0,  332,  451,    0,  332,    0,  332,  452,    0,
  453,  454,  455,  456,    0,    0,    0,    0,  457,    0,
    0,    0,  458,  353,    0,    0,  332,    0,    0,    0,
  447,  332,    0,    0,  459,    0,  353,  460,  332,  461,
  263,  353,  332,    0,  229,   48,  353,    0,  353,  353,
  353,  353,    0,  448,    0,  332,  353,    0,    0,    0,
  353,    0,    0,  462,  353,    0,  449,    0,    0,    0,
    0,  451,  353,    0,    0,  353,  452,  353,  453,  454,
  455,  456,    0,    0,    0,    0,  457,  332,    0,    0,
  458,    0,    0,    0, 1280,    0,    0,   57,   25,    0,
   26,  353,  459,   27,  256,  460,    0,  461,   28,   62,
   63,    0,   29,    0,    0,    0,    0,    0,   65,    0,
    0,   31,    0,    0,    0,    0,    0,    0,   33,    0,
    0,  462,    0,   34,    0,   72,   73,   35,    0,  582,
    0,    0,    0,    0,    0,    0,  583,    0,    0,   37,
    0,   38,   75,    0,    0,   39,    0,  353,   77,    0,
   79,    0,   81,   40,   41,  257,    0,   42,    0,    0,
    0,    0,    0,    0,  584,    0,    0,   88,   89,    0,
    0,    0,    0,    0,    0,    0,    0, 1281,    0,    0,
    0,    0,   90,   91,   92,   93,   94,    0,    0,    0,
    0,    0,    0,    0,   96,  901,    0,  585,    0,    0,
   98,   99,  100,  101,    0,    0,    0,  102,    0,  103,
    0,    0,    0,    0,    0,  104,  105,    0,    0,    0,
    0,    0,    0,   57,   25,    0,   26,    0,    0,   27,
  256,    0,    0,    0,   28,   62,   63,    0,   29,    0,
  106,  469,  108,  109,   65,    0,    0,   31,    0,    0,
    0,    0,    0,    0,   33,    0,    0,    0,    0,   34,
    0,   72,   73,   35,    0,  582,    0,    0,    0,    0,
    0,    0,  583,    0,    0,   37,    0,   38,   75,    0,
    0,   39,    0,    0,   77,    0,   79,    0,   81,   40,
   41,  257,    0,   42,    0,    0,    0,    0,    0,    0,
  584,    0,    0,   88,   89,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   90,   91,
   92,   93,   94,    0,    0,    0,    0,    0,    0,    0,
   96,    0,    0,  585,    0,    0,   98,   99,  100,  101,
    0,    0,    0,  102,    0,  103,    0,    0,    0,    0,
    0,  104,  105,    0,    0,    0,    0,    0,    0,   57,
   25,    0,   26,    0,    0,   27,  256,    0,    0,    0,
   28,   62,   63,    0,   29,    0,  106,  469,  108,  109,
   65,    0,    0,   31,    0,    0,    0,    0,    0,    0,
   33,    0,    0,    0,    0,   34,    0,   72,   73,   35,
    0,  582,    0,    0,    0,    0,    0,    0,  583,    0,
    0,   37,    0,   38,   75,    0,    0,   39,    0,    0,
   77,    0,   79,    0,   81,   40,   41,  257,    0,   42,
    0,    0,    0,    0,    0,    0,  584,    0,    0,   88,
   89,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,   93,   94,    0,
    0,    0,    0,    0,    0,    0,   96,    0,    0,    0,
    0,    0,   98,   99,  100,  101,    0,    0,    0,  102,
    0,  103,    0,    0,    0,    0,    0,  104,  105,    0,
    0,    0,    0,    0,    0,   57,   25,    0,   26,    0,
    0,   27,  256,    0,    0,    0,   28,   62,   63,    0,
   29,    0,  106,  469,  108,  109,   65,    0,    0,   31,
    0,    0,    0,    0,    0,    0,   33,    0,    0,    0,
    0,   34,    0,   72,   73,   35,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   37,    0,   38,
   75,    0,    0,   39,    0,    0,   77,    0,   79,    0,
   81,   40,   41,  257,    0,   42,    0,    0,   85,    0,
    0,    0,   87,    0,    0,   88,   89,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,   93,   94,    0,    0,    0,    0,    0,
    0,    0,   96,    0,    0,    0,    0,    0,   98,   99,
  100,  101,    0,    0,    0,  102,    0,  103,    0,    0,
    0,    0,    0,  104,  105,    0,    0,    0,    0,    0,
    0,   57,   25,    0,   26,    0,    0,   27,  256,    0,
    0,    0,   28,   62,   63,    0,   29,    0,  106,  301,
  108,  109,   65,    0,    0,   31,    0,    0,    0,    0,
    0,    0,   33,    0,    0,    0,    0,   34,    0,   72,
   73,   35,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   37,    0,   38,   75,    0,    0,   39,
    0,    0,   77,    0,   79,    0,   81,   40,   41,  257,
    0,   42,    0,    0,    0,    0,    0,    0,   87,    0,
    0,   88,   89,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,   93,
   94,    0,    0,    0,    0,  859,    0,    0,   96,    0,
    0,    0,    0,    0,   98,   99,  100,  101,    0,    0,
    0,  102,    0,  103,    0,    0,    0,    0,    0,  104,
  105,    0,    0,    0,    0,    0,    0,   57,   25,    0,
   26,    0,    0,   27,  256,    0,    0,    0,   28,   62,
   63,    0,   29,    0,  106,  301,  108,  109,   65,    0,
    0,   31,    0,    0,    0,    0,    0,    0,   33,    0,
    0,    0,    0,   34,    0,   72,   73,   35,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   37,
    0,   38,   75,    0,    0,   39,    0,    0,   77,    0,
   79,    0,   81,   40,   41,  257,    0,   42,    0,    0,
    0,    0,    0,    0,   87,    0,    0,   88,   89,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   90,   91,   92,   93,   94,    0,    0,    0,
  509,    0,    0,    0,   96,    0,    0,    0,    0,    0,
   98,   99,  100,  101,    0,    0,    0,  102,    0,  103,
    0,    0,    0,    0,    0,  104,  105,    0,    0,    0,
    0,    0,    0,   57,   25,    0,   26,    0,    0,   27,
  256,    0,    0,    0,   28,   62,   63,    0,   29,    0,
  106,  301,  108,  109,   65,    0,    0,   31,    0,    0,
    0,    0,    0,    0,   33,    0,    0,    0,    0,   34,
    0,   72,   73,   35,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   37,    0,   38,   75,    0,
    0,   39,    0,    0,   77,    0,   79,    0,   81,   40,
   41,  257,    0,   42,    0,    0,    0,    0,    0,    0,
   87,    0,    0,   88,   89,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   90,   91,
   92,   93,   94,    0,    0,    0,  503,    0,    0,    0,
   96,    0,    0,    0,    0,    0,   98,   99,  100,  101,
    0,    0,    0,  102,    0,  103,    0,    0,    0,    0,
    0,  104,  105,    0,    0,    0,    0,    0,    0,   57,
   25,    0,   26,    0,    0,   27,  256,    0,    0,    0,
   28,   62,   63,    0,   29,    0,  106,  301,  108,  109,
   65,    0,    0,   31,    0,    0,    0,    0,    0,    0,
   33,    0,    0,    0,    0,   34,    0,   72,   73,   35,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   37,    0,   38,   75,    0,    0,   39,    0,    0,
   77,    0,   79,    0,   81,   40,   41,  257,    0,   42,
    0,    0,    0,    0,    0,    0,   87,    0,    0,   88,
   89,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,   93,   94,    0,
    0,    0,    0,    0,    0,    0,   96,    0,    0,    0,
    0,    0,   98,   99,  100,  101,    0,    0,    0,  102,
    0,  103,    0,    0,    0,    0,    0,  104,  105,    0,
    0,    0,    0,    0,    0,   57,   25,    0,   26,    0,
    0,   27,  256,    0,    0,    0,   28,   62,   63,    0,
   29,    0,  106,  301,  108,  109,   65,    0,    0,   31,
    0,    0,    0,    0,    0,    0,   33,    0,    0,    0,
    0,   34,    0,   72,   73,   35,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   37,    0,   38,
   75,    0,    0,   39,    0,    0,   77,    0,   79,    0,
   81,   40,   41,  257,    0,   42,    0,    0,    0,    0,
    0,    0,   87,    0,    0,   88,   89,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,   93,   94,    0,    0,    0,    0,    0,
    0,    0,   96,    0,    0,    0,    0,    0,   98,   99,
  100,  101,    0,    0,    0,  102,    0,  103,    0,    0,
    0,    0,    0,  104,  105,    0,    0,    0,    0,    0,
    0,   57,   25,    0,   26,    0,    0,   27,  256,    0,
    0,    0,   28,   62,   63,    0,   29,    0,  106,  469,
  108,  109,   65,    0,    0,   31,    0,    0,    0,    0,
    0,    0,   33,    0,    0,    0,    0,   34,    0,   72,
   73,   35,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   37,    0,   38,   75,    0,    0,   39,
    0,    0,   77,    0,   79,    0,   81,   40,   41,  257,
    0,   42,    0,    0,    0,    0,    0,    0,   87,    0,
    0,   88,   89,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,   93,
   94,    0,    0,    0,    0,    0,    0,    0,   96,    0,
    0,    0,    0,    0,   98,   99,  100,  101,    0,    0,
    0,  102,    0,  103,    0,    0,    0,    0,    0,  104,
  105,    0,    0,    0,    0,    0,    0,   78,   78,    0,
   78,    0,    0,   78,   78,    0,    0,    0,   78,   78,
   78,    0,   78,    0,  106, 1009,  108,  109,   78,    0,
    0,   78,    0,    0,    0,    0,    0,    0,   78,    0,
    0,    0,    0,   78,    0,   78,   78,   78,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   78,
    0,   78,   78,    0,    0,   78,    0,    0,   78,    0,
   78,    0,   78,   78,   78,   78,    0,   78,    0,    0,
    0,    0,    0,    0,   78,    0,    0,   78,   78,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   78,   78,   78,   78,   78,    0,    0,    0,
    0,    0,    0,    0,   78,    0,    0,    0,    0,    0,
   78,   78,   78,   78,    0,    0,    0,   78,    0,   78,
    0,    0,    0,    0,    0,   78,   78,    0,    0,    0,
    0,    0,    0,  135,  135,    0,  135,    0,    0,  135,
  135,    0,    0,    0,  135,  135,  135,    0,  135,    0,
   78,   78,   78,   78,  135,    0,    0,  135,    0,    0,
    0,    0,    0,    0,  135,    0,    0,    0,    0,  135,
    0,  135,  135,  135,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  135,    0,  135,  135,    0,
    0,  135,    0,    0,  135,    0,  135,    0,  135,  135,
  135,  135,    0,  135,    0,    0,    0,    0,    0,    0,
  135,    0,    0,  135,  135,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  135,  135,
  135,  135,  135,    0,    0,    0,    0,    0,    0,    0,
  135,    0,    0,    0,    0,    0,  135,  135,  135,  135,
    0,    0,    0,  135,    0,  135,    0,    0,    0,    0,
    0,  135,  135,    0,    0,    0,    0,    0,    0,   57,
   25,    0,   26,    0,    0,   27,  256,    0,    0,    0,
   28,   62,   63,    0,   29,    0,  135,  135,  135,  135,
   65,    0,    0,   31,    0,    0,    0,    0,    0,    0,
   33,    0,   28,    0,   28,   34,    0,   72,   73,   35,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   37,    0,   38,   75,   28,    0,   39,    0,    0,
   77,    0,   79,    0,   81,   40,   41,  257,   28,   42,
    0,    0,    0,   28,    0,    0,    0,    0,   28,    0,
   28,   28,   28,   28,    0,    0,    0,    0,   28,    0,
    0,    0,   28,    0,   90,   91,   92,  258,   94,    0,
    0,    0,    0,    0,   28,    0,   96,   28,    0,   28,
    0,    0,   98,   99,  100,  101,    0,    0,    0,  102,
    0,  103,    0,   57,   25,    0,   26,  104,  105,   27,
  256,    0,    0,   28,   28,   62,   63,    0,   29,   28,
   28,    0,    0,    0,   65,    0,    0,   31,    0,    0,
    0,    0,  106,  259,   33,  109,    0,    0,    0,   34,
    0,   72,   73,   35,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   37,    0,   38,   75,    0,
    0,   39,    0,    0,   77,    0,   79,    0,   81,   40,
   41,  257,    0,   42,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   90,   91,
   92,  258,   94,    0,    0,    0,    0,    0,    0,    0,
   96,  638,    0,  638,    0,  638,   98,    0,  638,  101,
  638,  638,    0,  638,    0,  638,    0,  638,    0,  638,
  638,  638,    0,    0,    0,  638,  638,    0,    0,    0,
    0,  638,    0,  638,  638,    0,    0,    0,  638,    0,
    0,    0,  638,    0,    0,    0,  106,  259,    0,  109,
    0,    0,    0,  638,  638,    0,  638,    0,    0,    0,
  638,  638,    0,    0,    0,    0,    0,    0,  638,  638,
   57,   25,  638,   26,    0,  638,   27,  256,    0,    0,
  638,   28,   62,   63,    0,   29,    0,    0,    0,    0,
    0,   65,    0,    0,   31,    0,    0,    0,    0,    0,
    0,   33,  638,  638,    0,    0,   34,    0,   72,   73,
   35,    0,    0,    0,    0,  638,    0,    0,    0,    0,
    0,    0,   37,    0,   38,   75,    0,    0,   39,    0,
    0,   77,    0,   79,    0,   81,   40,   41,  257,    0,
   42,    0,    0,   85,    0,    0,    0,    0,    0,    0,
   25,    0,   26,    0,    0,   27,  638, 1189,    0,    0,
   28,    0,    0,    0,   29,   90,   91,   92,  258,    0,
    0,    0,    0,   31,  637,    0,  637,   96,    0,  637,
   33,  637,  637,    0,  637,   34,  637, 1190,  637,   35,
  637,  637,  637,    0,    0,    0,  637,  637,    0,    0,
    0,   37,  637,   38,  637,  637,    0,   39, 1191,  637,
    0,    0,    0,  637,    0,   40,   41,    0,    0,   42,
    0,    0,  319,  106,  259,  637,    0,  637,    0,    0,
    0,  637,  637,    0,    0,    0,    0,    0,    0,  637,
  637,    0,  637,  637,  637,    0,  637,  637,    0,  637,
  637,  637,  637,    0,  637,    0,  637,    0,  637,  637,
  637,    0,    0,    0,  637,  637,    0,    0,    0,    0,
  637,    0,  637,  637,    0,    0,    0,  637,    0,    0,
    0,  637,    0,    0,    0,    0,  637,    0,    0,    0,
    0,    0,    0,  637,    0,  637,    0,    0,    0,  637,
  637,    0,    0,  354,    0,    0,    0,  637,  637,    0,
    0,  637,    0,    0,  637,    0,   25,    0,   26,  637,
    0,   27,    0,    0, 1250,    0,   28,  637,  671,    0,
   29,    0,  672, 1251, 1252,    0,    0,    0, 1253,   31,
    0,    0,    0,    0, 1254,    0,   33,    0,   25,    0,
   26,   34,    0,   27,    0,   35, 1250,    0,   28,    0,
  671,    0,   29,    0,  672, 1251, 1252,   37,    0,   38,
 1253,   31,    0,   39,    0,    0, 1254,    0,   33,    0,
    0,   40,   41,   34,    0,   42,    0,   35, 1255,    0,
    0,    0,   48, 1256,   48,  637,    0,   48,    0,   37,
    0,   38,   48,    0,    0,   39,   48,    0,    0,    0,
    0,    0,    0,   40,   41,   48,    0,   42,    0,    0,
 1255,    0,   48,    0,   48, 1256,   48,   48, 1257,   48,
    0,   48,    0,   48,   48,   48,    0,    0,   48,    0,
   48,    0,    0,   48,    0,   48,    0,   48,    0,   48,
    0,    0,   48,    0,   48,    0,    0,   48,   48,   48,
    0,   48,    0,   48,   48,   48,    0,   48,   48, 1258,
   48,    0,   48,   48,    0,   48,    0,   48,   48,    0,
    0,   48,   48,    0,   48,    0,    0,    0,    0,   48,
   48,   48,    0,   48,    0,    0,   48,    0,   48,  153,
   25, 1258,   26,   48,    0,   27,    0,   48,    0,   48,
   28,   48,    0,    0,   29,    0,   48,    0,    0,   48,
    0,   48,    0,   31,    0,   48,    0,    0,   48,  153,
   33,    0,    0,   48,   48,   34,    0,   48,    0,   35,
   48,  563,    0,    0,    0,   48,    0,    0,  564,    0,
    0,   37,    0,   38,    0,    0,    0,   39,    0,    0,
  565,    0,    0,    0,    0,   40,   41,    0,    0,   42,
    0,   25,  566,   26,    0,    0,   27,   48,    0,    0,
    0,   28,    0,    0,    0,   29,    0,    0,    0,   30,
   25,    0,   26,    0,   31,   27,    0,    0,    0,   32,
   28,   33,    0,    0,   29,    0,   34,    0,    0,    0,
   35,   36,    0,   31,    0,    0,    0,    0,    0,    0,
   33,   48,   37,    0,   38,   34,    0,    0,   39,   35,
    0,    0,    0,    0,    0,    0,   40,   41,    0,    0,
   42,   37,    0,   38,   25,    0,   26,   39,    0,   27,
    0,    0,    0,  567,   28,   40,   41,    0,   29,   42,
    0,   25,  511,   26,    0,    0,   27,   31,    0,    0,
    0,   28,    0,    0,   33,   29,    0,    0,    0,   34,
    0,    0,    0,   35,   31,    0,    0,    0,    0,    0,
    0,   33,    0,    0,    0,   37,   34,   38,    0,    0,
   35,   39,    0,    0,    0,    0,    0,    0,    0,   40,
   41,    0,   37,   42,   38,   25,  319,   26,   39,    0,
   27,    0,    0,    0,   43,   28,   40,   41,    0,   29,
   42,    0,    0,  319,    0,    0,    0,    0,   31,   25,
    0,   26,    0,  354,   27,   33,    0,    0,    0,   28,
   34,    0,    0,   29,   35,    0,    0,    0,    0,    0,
    0,    0,   31,    0,    0,    0,   37,    0,   38,   33,
    0,    0,   39,    0,   34,    0,    0,    0,   35,    0,
   40,   41,    0,    0,   42,    0,    0,  566,    0,  484,
   37,  484,   38,    0,  484,    0,   39,  630,    0,  484,
    0,    0,    0,  484,   40,   41,    0,    0,   42,    0,
    0,  739,  484,  173,  632,  173,    0,    0,  173,  484,
    0,    0,    0,  173,  484,    0,    0,  173,  484,    0,
    0,    0,    0,    0,    0,    0,  173,    0,    0,    0,
  484,    0,  484,  173,    0,    0,  484,    0,  173,    0,
    0,    0,  173,    0,  484,  484,    0,    0,  484,    0,
    0,  484,    0,    0,  173,    0,  173,  172,  354,  172,
  173,    0,  172,    0,    0,    0,    0,  172,  173,  173,
    0,  172,  173,    0,  182,  173,  182,    0,    0,  182,
  172,    0,  354,    0,  182,    0,    0,  172,  182,    0,
    0,    0,  172,    0,    0,    0,  172,  182,    0,    0,
    0,   35,    0,    0,  182,    0,    0,    0,  172,  182,
  172,    0,   35,  182,  172,    0,    0,   35,    0,    0,
    0,   35,  172,  172,   35,  182,  172,  182,    0,  172,
    0,  182,  484,    0,    0,    0,   35,   35,    0,  182,
  182,   35,   35,  182,   33,    0,  182,   35,    0,   35,
   35,   35,   35,    0,    0,   33,  173,   35,    0,    0,
   33,   35,    0,   35,   33,    0,    0,   33,    0,    0,
    0,    0,    0,   35,    0,   35,   35,    0,   35,   33,
   33,    0,   35,    0,   33,   33,    0,    0,    0,    0,
   33,    0,   33,   33,   33,   33,    0,    0,    0,    0,
   33,    0,   35,    0,   33,    0,   33,    0,   35,   35,
  172,    0,    0,   48,    0,    0,   33,    0,    0,   33,
    0,   33,    0,    0,   48,   33,    0,  182,    0,   48,
    0,    0,    0,   48,    0,    0,   48,    0,    0,    0,
    0,    0,    0,    0,    0,   33,    0,    0,   48,   48,
    0,   33,   33,   48,   48,    0,   48,    0,    0,   48,
    0,   48,   48,   48,   48,    0,    0,   48,    0,   48,
    0,    0,   48,   48,    0,   48,   48,    0,    0,   48,
    0,    0,    0,    0,    0,   48,    0,    0,   48,    0,
   48,   48,   48,    0,   48,    0,   48,   48,   48,    0,
    0,    0,   48,    0,   48,   48,   48,   48,    0,    0,
    0,    0,   48,    0,   48,    0,   48,    0,   48,    0,
   37,   48,    0,    0,    0,    0,    0,    0,   48,    0,
    0,   48,    0,   48,   48,    0,   48,   48,    0,   48,
    0,    0,    0,    0,   48,    0,   48,   48,   48,   48,
    0,    0,    0,    0,   48,    0,    0,   48,   48,   48,
    0,    0,    0,   38,    0,    0,    0,    0,    0,    0,
   48,    0,   48,   48,   48,   48,   48,   48,    0,    0,
    0,    0,   48,    0,   48,   48,   48,   48,    0,    0,
    0,    0,   48,    0,    0,    0,   48,   48,    0,   48,
    0,   48,   48,    0,    0,  194,    0,    0,   48,    0,
   48,   48,   48,   48,    0,   48,    0,    0,    0,    0,
   48,    0,   48,   48,   48,   48,    0,    0,    0,    0,
   48,    0,    0,    0,   48,   48,    0,   48,    0,   48,
   48,    0,   48,  196,   48,    0,   48,    0,   48,   48,
    0,   48,    0,   48,    0,    0,    0,    0,   48,    0,
   48,   48,   48,   48,    0,   48,    0,    0,   48,    0,
    0,    0,   48,    0,    0,   48,    0,    0,   48,    0,
    0,  297,  447,   48,   48,    0,    0,   48,   48,   48,
   48,   48,   48,   48,    0,    0,   48,    0,   48,    0,
    0,    0,   48,    0,    0,  448,    0,    0,    0,    0,
    0,    0,    0,   48,   48,   48,   48,   48,  449,   48,
    0,    0,  450,  451,    0,    0,    0,    0,  452,    0,
  453,  454,  455,  456,    0,    0,    0,    0,  457,    0,
    0,    0,  458,   48,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  459,    0,    0,  460,    0,  461,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  462,
  };
  protected static readonly short [] yyCheck = {            17,
   17,   52,    4,   17,   20,   18,  300,  299,  507,   17,
  291,  191,  235,  353,  250,  509,   20,    6,  464,  190,
   85,   60,  549,  298,  159,  483,  353,  318,  328,  335,
 1077,   60,  559,  296,  906,  759,  730,   78,  237,  107,
  705,  706,  256,  268,  569,   59,    0,  256,  113,  324,
  115,    0, 1114, 1115,  268, 1196,   74,  277,   17,  113,
   78,  115,  268,  256,  256,  256,   80,   17,   82,   17,
  256, 1212,   88,   89,  256,  325,   17,  256,   96,   88,
   89,  256,  256,  748,  256,  750,   48,  335,  256,  282,
  911,  294,   17,  109,  256, 1157,  349,  350,  371,  256,
  109,  268,  256,  256,  294,   17,  368,   21,  277,  276,
  256,  256,  281,  372,  263,   60,  306,  256,  367,  374,
   17,  314,  367,  357,   17,  650,   17,  376,  257,  365,
  339,  376,  407,  256,    0,  344,  358,  346,   17,   53,
  191,  159,  159,  352,  353,  159,  256,  420,  256,   94,
   17,  159,  386,   98,   99,  100,  101,  102,  103,  104,
  105,  416,  368,  257,  339,  256,  315,  429,  418,  344,
  429,  346,  358,  342,   17,  256,  429,  352,  353,  341,
  256,  429,  305,  523,  235,  339,  202,  203,  370,  381,
  372,  259,  374,  202,  203,  305,  256,  422,  418,  419,
  159,  294,  381,  503,  256,  428,  546,  369,  422,  159,
  294,  159, 1033,  707,  506,  418,  422,   60,  159,  546,
  429,   64,  367,  369,  369,  418,  371,  418,  418,  569,
  429, 1372,  250,  301,  159,  374,  418,  255,  424,  425,
  426,  427,  231,  549,  418,  294,  418,  159,  264,  288,
  418,  418,  317,  559,  429,  264,  321,  296, 1399,  288,
  325,  418,  159, 1070,  226,  418,  159,  375,  159,  993,
 1411,  325, 1413,  291,  290,  420,  294,  295,  423,  370,
  159,  290,  256,  374,  300,  314,  367,  339,  356,  307,
  306,  418,  159,  369,  312,  376,  314,  306,  391,  313,
  318,  428,  256,  372,  969,  346,  368,  391,  257,  369,
  650,  329,  330,  294, 1008,  367,  159,  842,  335, 1366,
  335,  414, 1401, 1402,  651,  325,  401,  335,  346, 1053,
  414,  671,  369,  369,  350,  266,  373,  353,  413,  272,
  256,  350,  391,  288,  882,  418,  264,  365,  366,  418,
  305,  296,  370,  371,  372,  373,  374,  375,  376,  377,
  378,  379,  380,  296,  256,  414,  434,  429,  384,  385,
 1432,  368,  256,  368, 1156,  384,  385,  428, 1457,  873,
  376, 1253,  418,  314,  402,  339,  423,  438,  349,  350,
  323,  257,  349,  350,  852,  369,  412,  413,  368, 1461,
  468,  469,  693,  412,  413, 1187,  272,  325,  368,  372,
  391,  277,  343,  367,  430,  281,  305,  371,  418,  373,
  374,  375,  376, 1088,  369,  493,  430,  381,  444,  262,
  296,  368,  429,  414,  429,  775,  381,  382,  383,  256,
  444,  386,  387,  679,  375,  288,  709,  339,  775,  987,
  376,  989,  368,  343,  483, 1120, 1121,  323,  374,  429,
  391,  372, 1127,  374,  478,  298,  429,  961,  429,  429,
  376,  314,  429,  435,  436,  367,  342,  372,  376,  441,
  256,  418, 1264,  414,  368,  375, 1268,  505,  357,  507,
  374,  509,  335, 1180, 1180,  367,  369,  428, 1305,  371,
  369,  391,  842,  429,  373,  519,  520,  523,  576,  306,
  578, 1293,  580,  531,  841,  372,  313,  386,  429,  523,
  538,  368,  376,  429,  414,  343, 1333, 1334,  263, 1336,
  546,  343,  549,  372,  429,  374, 1223, 1223,  428,  369,
 1347,  549,  559, 1350,  558,  378,  379,  839,  420,  418,
  367,  559,  369,  569,  371,  372,  792,  374, 1365,  376,
  851,  343, 1180,  339,  582,  583,  866,  272,  344,  381,
  346,  418,  429,  391,  642,  256,  352,  353, 1036,  391,
  315,  861, 1389,  718,  265, 1180,  267, 1180,  418,  270,
  429,  296,  872,  375,  275,  870,  414, 1124,  279,  381,
  371,  418,  414,  420, 1180, 1223,  423,  288, 1180,  391,
  428,  629,  906,  386,  295,  272,  428,  635,  323,  300,
  374,  381,  371,  304,  373,  391, 1180,    6, 1223,  574,
 1223,  391,  414,  367,  650,  316,  962,  318,   17,  296,
  483,  322,  261,  392,  393,  713,  428, 1223,  414,  330,
  331, 1223,  414,  334,  414,  671,  337,  418,  371,  421,
  373,  679,  416,  412,  990,  284,  323,  428,  428, 1223,
  709,  420,  341,  367,  423,  693,  741,  371,  297,  373,
  374,   60,  376,  302,  702,   64,  978,  381,  307,  707,
  309,  310,  311,  312,  712,  931,  315,  357,  317,  371,
  369,  391,  321,  272,  306,  371,  549,  373,  277,   88,
   89,  313,  281,  373,  333, 1271,  559,  336,  734,  338,
  367,  415,  736,  325,  414,  734,  386,  296, 1284,  376,
  109,  269, 1179, 1180,  752,  339,  754,  418,  428,  755,
  367,  357,  369,  362,  758,  759,  755, 1303,  286,  368,
  369,  769, 1199,  369,  323,  771,  372,  373,  374,  775,
  391, 1042,  771,  367,  709,  816,  394,  395,  414,  787,
  386,  381,  376,  342,  792,  793, 1223,  795, 1225,  414,
  159,  391,  428,  414,  256, 1077, 1092,  379,  806,  807,
  421,  367,  372,  428,  374,  371,  339,  373,  374, 1080,
  376,  344,  418,  346,  414,  381,  349,  350,  824,  352,
  353,  418,  357,  294,  882,  374,  256,  376, 1124,  837,
  824,  839,  381,  202,  203,  306,  842,  843,  373,  269,
  384,  374, 1068,  851,  843, 1006,  854, 1118, 1284,  415,
  829,  386,  831,  861,  400, 1151,  286,  306,  389,  308,
  367,  369,  368,  871,  313,  873,  382,  383,  374,  376,
 1354,  369,  705,  706,  385,  381,  325,  339,  386,  387,
  396,  397,  344,  381,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,  264,  429,  390,  370,  371,
  906,  373,  374,  375, 1234,  913,  368,  915,  370,  917,
  372, 1241,  374,  375,  376,  748,  367,  750,  418,  288,
 1133,  290,  928,  931,  367,  376,  357,  373,  390,  987,
  376,  300, 1416,  376,  928,  367,  339,  306,  372, 1109,
  374,  344,  373,  346,  376,  314,  349,  350,  369,  352,
  353, 1009,  261,  961,  373,  386,  373,  376,  937, 1230,
  939,  357,  941,  398,  399,  339,  335,  429, 1452, 1253,
  344,  374,  346,  369,  376,  284,  372,  373,  352,  353,
  374,  350,  376,  370,  353, 1474, 1475,  374,  297,  993,
  386,  418, 1000,  302, 1002,  372, 1004,  374,  307,  376,
  309,  310,  311,  312,  371,  370,  371,  415,  317,  374,
  370, 1017,  321,  418,  374,  384,  385,  372, 1017,  374,
  370,  376,  372, 1015,  333,  339,  429,  336,  369,  338,
  344,  372,  346,  370, 1042,  349,  350,  374,  352,  353,
  256,  370,  370,  412,  413,  374,  374, 1055, 1056, 1053,
  370,  339,  372,  362,  374, 1063,  344,  418,  346,  370,
 1068,  349,  350,  374,  352,  353, 1069,  277, 1109, 1077,
  418,  370, 1080,  372,  340,  374,  339,  390,  391,  392,
  393,  344,  376,  346, 1366, 1092,  349,  350,  373,  352,
  353, 1099, 1133,  367, 1092, 1136,  368,  376, 1106,  371,
  376,  373,  374,  386,  387,  388, 1112,  354,  355,  418,
 1118,  370,  376,  372,  483,  429,  374, 1124,  376,  376,
  392,  393, 1130, 1131,  343,  370, 1124,  372,  370,  372,
  372,  374,  372,  372,  374, 1176,  969,  418, 1179, 1180,
  412,  429,  369,  367, 1151,  354,  355,  371,  420,  373,
  374,  423,  376, 1151,  523,  372, 1162,  381, 1199,  414,
  415, 1169,  368,  349,  350,  371,  429,  373,  374,  370,
  418,  372, 1178,  370,  418,  372, 1184,  546,  414, 1178,
  549,  374, 1223,  376, 1225,  418,  392,  393,  418,  374,
  559,  376,   98,   99,  100,  101,  102,  103,  104,  105,
  569,  374,  374,  376,  376,  418,  412,  364,  365,  372,
  373,  364,  365,  372,  420, 1075, 1076,  423,  388,  389,
  394,  395, 1230, 1281,  418,  376,  372, 1233, 1234,  372,
  368,  256,  374, 1237, 1233, 1241,  372, 1295,  372,  372,
  372,  418,  372,  294, 1250, 1251,  294, 1253,  374,  372,
  372, 1250, 1251, 1259, 1312, 1088, 1314,  376,  418, 1092,
  374,  372,  371,  256,  374, 1271,  418, 1273,  375,  418,
 1276,  356,  372,  381, 1273,  374,  373, 1276, 1284,  375,
  374,  650,    0,  381,  372, 1289,  381, 1120, 1121,  418,
  374, 1124,  374,  374, 1127,  374,  376, 1303,  294,  423,
  372,  429,  671, 1344,  402,  403,  404,  405,  406,  407,
  408,  409,  410,  411,  339,  374,  418,  367, 1151,  344,
 1361,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  372, 1374, 1375,  373,  705,  706,  372,  343,
  418,  374,  294,  368,  294,  370, 1354,  372, 1352,  374,
  375,  376,  374,  418,  418,  370,  418,  371, 1366,  367,
 1401, 1402,  418,   62,  256,  734,  256,   66,   67,   68,
  256,   70,   71,  374,  256, 1383,   75,   76,  372,  748,
  372,  750,  381,   82,  280,   84,  755,   86,  256,  256,
  367,  418,   91,   92,  368,  262,  372,  418,  418,  343,
  418,  376,  771,  370,  429,  371,  775,  375, 1416,  418,
  374,  376,  374,  376,  372,  114, 1457,  376,  372,  370,
  423,  421,  328,  347,  381,  351,  381,  256,  381,  256,
  372,  298,  368,  372,  347,  370,  374,  367,  375,  370,
  372,  375,  367,  370, 1452,  348,  368,  418,  339,  372,
  348,  368,  381,  374, 1458, 1459,  376,  418,  374,  367,
  375, 1465, 1466,  369,  368,  367, 1474, 1475,  367,  356,
  371,  376,  418,  842,  843,  381,  382,  383,  372,  374,
  386,  387,  388,  389,  390,  391,  392,  393,  394,  395,
  396,  397,  398,  399,  400,  401,  256,  368,  368,  368,
  337,  368,  305,  367,  371,  371,  373,  374,  418,  418,
  371,  378,  379,  369,  371,  382,  383,  384,  385,  386,
  387,  388,  389,  390,  376,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  418,  371,  906,  256,  418,
  418,    0,  381,  371,  262,  412,  413,  373,  371,  367,
  371,  381,  369,  420,  374,  371,  423,  372,  257,  372,
  374,  260,  429,  373,  373,  256,  374,  374,  418,  418,
  376,  372,  372,  370,  376,  418,  294,  376,  372,  339,
  298,  376,  418,  372,  344,  381,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  367,  503,  372,  298,
  969,  368,  381,  372,  370,  368,  315,  263,  368,  371,
  370,  310,  372,  371,  374,  375,  376,  368,  372,  372,
    0,  339,    0,  367,  376,  418,  344,  376,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,  368,
  372,    0,  376,  368,  372,  372,  418,  370, 1017,  367,
  368,  367,  370,  371,  372,  376,  374,  375,  376,  372,
  378,  379,  368,  368,  382,  383,  384,  385,  574,  429,
  370,  389,  390,  376,  376,  418,  394,  395,  396,  397,
  398,  399,  400,  401,  376,  418,  368,  372,  376,  367,
  376,  372,  368,  372,  256,  413,  368,  372,  416,  367,
  418,  368,  376,  265,  368,  267,  367,  373,  270,    0,
  315,  429,  263,  275,  376,   51,  376,  279,  376, 1088,
   52,  376,  376, 1092,  376,  376,  288,  376,   12,    5,
  928,  824, 1068,  295, 1068, 1225, 1199, 1406,  300, 1369,
  261, 1422,  304, 1112, 1357, 1386, 1259, 1352, 1271,  841,
 1466, 1120, 1121,  671,  316, 1124,  318,  685, 1127,  845,
  322, 1290,  845,  284, 1223, 1379, 1211, 1460,  330,  331,
  845, 1375,  334, 1374, 1459,  337,  297, 1176, 1314, 1259,
  479,  302, 1151,  523,  816,  787,  307, 1162,  309,  310,
  311,  312,  866, 1162,  315,  792,  317,  256,  712,  583,
  321,  365,  261,  262,  679,   72,  331,  978,   94, 1178,
  396,  398,  333,  397,  399,  336,  709,  338,  400,  775,
  519,  401,  546, 1144, 1233,  284, 1151, 1092,  159,  990,
 1035, 1056,  963,  948, 1045,  294, 1036,  521,  297,  298,
 1047,  362,  886,  302,  420, 1228,  305,  368,  307, 1131,
  309,  310,  311,  312,   -1,   -1,  418,   -1,  317,   -1,
   -1,  821,  321,   -1, 1233, 1234,  325,   -1,   -1,   -1,
   -1,   -1, 1241,  822,  333,   -1,    0,  336,   -1,  338,
  339, 1250, 1251,   -1, 1253,  344,   -1,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,   -1,  362, 1273,   -1,   -1, 1276,  367,  368,
   -1,  370,  371,  372,  373,  374,  375,  376,   -1,  378,
  379,   -1,  381,  382,  383,  384,  385,  386,  387,  388,
  389,  390,   -1,  392,  393,  394,  395,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,   -1,   -1,  416,   -1,  418,
  866,  420,   -1,   -1,  423,  256,  257,   -1,   -1,   -1,
  429,   -1,   -1,  264,  265,  266,  267,  268,   -1,  270,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,  280,
   -1,   -1,   -1,   -1,  285,   -1,  287,  288,  289,  290,
  291,  292,   -1,   -1,  295,    0,   -1,   -1,  299,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,  324,  325,  326,  327,  328,  329,  330,
  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,  340,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,  367,  368,   -1,   -1,
  371,   -1,   -1,   -1,   -1,  376,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  417,  418,  419,  420,
   -1,  422,  256,  257,   -1,   -1,   -1,   -1,  429,   -1,
  264,  265,  266,  267,  268,   -1,  270,  271,   -1,  273,
  274,  275,  276,  277,  278,  279,   -1,   -1,    0,   -1,
   -1,  285,   -1,  287,  288,  289,  290,  291,  292,   -1,
   -1,  295,   -1,   -1,   -1,  299,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
  324,  325,  326,  327,  328,  329,  330,  331,  332,  333,
  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,  367,  368,   -1,   -1,  371,   -1,   -1,
   -1,   -1,  376,  377,  378,  379,  380,   -1,   -1,   -1,
  384,  256,  386,   -1,   -1,   -1,  261,  262,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,  284,
   -1,   -1,   -1,  417,  418,  419,  420,   -1,  422,  294,
   -1,   -1,  297,  298,   -1,  429,   -1,  302,   -1,   -1,
  305,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,
  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
   -1,  336,   -1,  338,  339,   -1,   -1,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  357,   -1,   -1,   -1,   -1,  362,   -1,   -1,
   -1,   -1,  367,  368,  369,  370,  371,  372,  373,  374,
  375,  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,
  385,  386,   -1,   -1,  389,  390,   -1,   -1,   -1,  394,
  395,  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  413,  261,
  262,  416,   -1,  418,   -1,  420,   -1,   -1,  423,   -1,
   -1,   -1,   -1,   -1,  429,    0,   -1,   -1,   -1,   -1,
   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  294,   -1,   -1,  297,  298,   -1,   -1,   -1,
  302,   -1,   -1,  305,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,
   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,  336,   -1,  338,  339,   -1,   -1,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,
  362,   -1,   -1,   -1,   -1,  367,  368,  369,  370,  371,
  372,   -1,  374,  375,  376,   -1,  378,  379,   -1,   -1,
  382,  383,  384,  385,  256,   -1,   -1,  389,  390,  261,
  262,   -1,  394,  395,  396,  397,  398,  399,  400,  401,
    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  413,  284,   -1,  416,   -1,  418,   -1,  420,   -1,
   -1,  423,  294,   -1,   -1,  297,  298,  429,   -1,   -1,
  302,   -1,   -1,  305,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,
   -1,   -1,   -1,  325,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,  336,   -1,  338,  339,   -1,   -1,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,
  362,   -1,   -1,   -1,   -1,  367,  368,  369,  370,  371,
  372,   -1,  374,  375,  376,   -1,  378,  379,   -1,   -1,
  382,  383,  384,  385,   -1,   -1,   -1,  389,  390,   -1,
   -1,   -1,  394,  395,  396,  397,  398,  399,  400,  401,
   -1,  256,   -1,   -1,   -1,   -1,  261,  262,   -1,   -1,
   -1,  413,   -1,   -1,  416,   -1,  418,   -1,  420,   -1,
   -1,  423,   -1,   -1,   -1,   -1,   -1,  429,   -1,  284,
   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,  294,
   -1,   -1,  297,  298,   -1,   -1,   -1,  302,   -1,   -1,
  305,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,
  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
   -1,  336,   -1,  338,  339,   -1,   -1,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,
   -1,   -1,  367,  368,   -1,  370,  371,  372,   -1,  374,
  375,  376,   -1,  378,  379,   -1,  256,  382,  383,  384,
  385,   -1,  262,   -1,  389,  390,   -1,   -1,   -1,  394,
  395,  396,  397,  398,  399,  400,  401,   -1,    0,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  413,   -1,
   -1,  416,   -1,  418,  294,   -1,   -1,   -1,  298,   -1,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,
   -1,    0,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  357,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  367,  368,  369,
  370,  371,  372,  373,  374,  375,  376,   -1,  378,  379,
   -1,   -1,  382,  383,  384,  385,  386,   -1,   -1,  389,
  390,   -1,   -1,   -1,  394,  395,  396,  397,  398,  399,
  400,  401,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
    0,   -1,   -1,  413,   -1,   -1,  416,   -1,  418,   -1,
  420,   -1,  257,  423,   -1,   -1,  261,   -1,  263,  429,
  265,   -1,  267,   -1,   -1,  270,   -1,  272,  273,   -1,
  275,   -1,  277,   -1,  279,   -1,  281,  282,  283,  284,
   -1,   -1,  287,  288,   -1,   -1,   -1,    0,  293,  294,
  295,  296,  297,   -1,   -1,  300,  301,  302,   -1,  304,
   -1,  306,  307,  308,  309,  310,  311,  312,  313,   -1,
  315,  316,  317,  318,   -1,   -1,  321,  322,  323,   -1,
  325,   -1,   -1,   -1,   -1,  330,  331,   -1,  333,  334,
   -1,  336,  337,  338,   -1,   -1,   -1,  342,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
    0,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,  364,
  365,   -1,   -1,   -1,  256,  257,   -1,   -1,   -1,  261,
   -1,   -1,  377,  265,   -1,  267,   -1,   -1,  270,   -1,
  272,  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,
  282,  283,  284,    0,   -1,  287,  288,   -1,   -1,   -1,
   -1,  293,   -1,  295,  296,  297,   -1,   -1,  300,  301,
  302,   -1,  304,  418,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,   -1,  316,  317,  318,   -1,  257,  321,
  322,  323,  261,   -1,   -1,   -1,    0,   -1,  330,  331,
   -1,  333,  334,  272,  336,  337,  338,   -1,  277,   -1,
  342,   -1,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  296,  297,   -1,
  362,   -1,  301,  302,   -1,   -1,  368,  369,  307,    0,
  309,  310,  311,  312,   -1,  377,   -1,   -1,  317,   -1,
   -1,   -1,  321,   -1,  323,   -1,   -1,  257,   -1,   -1,
   -1,  261,   -1,   -1,  333,   -1,  335,  336,   -1,  338,
   -1,   -1,  272,  342,   -1,   -1,   -1,  277,   -1,   -1,
   -1,  281,    0,   -1,  284,   -1,  418,   -1,   -1,   -1,
   -1,   -1,   -1,  362,   -1,   -1,  296,  297,   -1,  368,
  369,  301,  302,   -1,  257,   -1,   -1,  307,  261,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,  272,
   -1,  321,   -1,  323,  277,    0,   -1,   -1,  281,   -1,
   -1,  284,   -1,  333,   -1,  335,  336,   -1,  338,   -1,
   -1,   -1,  342,  296,  297,   -1,   -1,   -1,  301,  302,
   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,  362,   -1,  317,   -1,   -1,  257,  321,  369,
  323,  261,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,  272,  336,   -1,  338,   -1,  277,    0,  342,
   -1,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  296,  297,   -1,  362,
  257,  301,  302,   -1,  261,  368,  369,  307,   -1,  309,
  310,  311,  312,   -1,   -1,  272,   -1,  317,   -1,   -1,
  277,  321,   -1,  323,  281,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  296,
  297,   -1,  342,  257,  301,  302,   -1,  261,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,  272,   -1,
  317,   -1,  362,  277,  321,   -1,  323,  281,  368,  369,
  284,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,  296,  297,   -1,  342,  257,  301,  302,   -1,
  261,   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,  272,   -1,  317,   -1,  362,  277,  321,   -1,  323,
  281,   -1,  369,  284,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,  336,   -1,  338,  296,  297,   -1,  342,  257,
  301,  302,   -1,  261,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,  272,   -1,  317,   -1,  362,  277,
  321,   -1,  323,  281,   -1,   -1,  284,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  296,  297,
   -1,  342,  257,  301,  302,   -1,  261,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,  272,   -1,  317,
   -1,  362,  277,  321,   -1,  323,  281,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,
  338,  296,  297,   -1,  342,   -1,  301,  302,   -1,   -1,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,  362,  257,  321,   -1,  323,  261,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
  272,  336,   -1,  338,   -1,  277,   -1,  342,   -1,  281,
   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  296,  297,   -1,  362,   -1,  301,
  302,   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,
   -1,  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  333,   -1,  256,  336,   -1,  338,   -1,   -1,   -1,
  342,  264,  265,  266,  267,   -1,   -1,  270,  271,   -1,
  273,  274,  275,  276,  277,  278,  279,   -1,   -1,   -1,
  362,   -1,  285,   -1,  287,  288,  289,  290,  291,  292,
   -1,   -1,  295,   -1,   -1,   -1,  299,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,  324,  325,  326,  327,  328,  329,  330,  331,  332,
  333,  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,
  256,  344,  345,   -1,   -1,   -1,  262,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,  376,  377,  378,  379,  380,   -1,   -1,
   -1,  384,  298,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  262,   -1,  417,  418,  419,  420,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,  429,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,  357,   -1,   -1,   -1,   -1,   -1,   -1,  298,   -1,
   -1,   -1,  368,  369,  370,  371,  372,  373,  374,  375,
  376,   -1,  378,  379,   -1,  381,  382,  383,  384,  385,
  386,  387,  388,  389,  390,   -1,  392,  393,  394,  395,
  396,  397,  398,  399,  400,  401,  402,  403,  404,  405,
  406,  407,  408,  409,  410,  411,  412,  413,   -1,  256,
   -1,   -1,  418,   -1,  420,  262,   -1,  423,   -1,   -1,
   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,  369,
   -1,  371,  372,  373,  374,   -1,  376,   -1,  378,  379,
   -1,  381,  382,  383,  384,  385,   -1,  387,  388,  389,
  390,  298,  392,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,   -1,   -1,   -1,   -1,  418,   -1,
  420,  262,   -1,  423,   -1,   -1,   -1,   -1,   -1,  429,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,   -1,   -1,
  367,  368,  369,  370,  371,  372,  373,  374,  375,  376,
   -1,  378,  379,   -1,  381,  382,  383,  384,  385,  386,
  387,  388,  389,  390,   -1,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,  413,   -1,  256,   -1,
   -1,   -1,   -1,  420,  262,   -1,  357,   -1,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,  369,   -1,
  371,   -1,  373,   -1,   -1,  376,   -1,  378,  379,   -1,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
  298,  392,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,  413,   -1,   -1,   -1,   -1,  418,   -1,  420,
  262,   -1,  423,   -1,   -1,   -1,   -1,   -1,  429,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  298,   -1,   -1,  367,
  368,   -1,  370,  371,  372,  373,  374,  375,  376,   -1,
  378,  379,   -1,  381,  382,  383,  384,  385,  386,  387,
  388,  389,  390,   -1,  392,  393,  394,  395,  396,  397,
  398,  399,  400,  401,  402,  403,  404,  405,  406,  407,
  408,  409,  410,  411,  412,  413,   -1,  256,   -1,   -1,
   -1,   -1,  420,  262,   -1,  423,   -1,   -1,   -1,   -1,
   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  370,  371,
  372,  373,  374,   -1,   -1,   -1,  378,  379,   -1,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,  298,
  392,  393,  394,  395,  396,  397,  398,  399,  400,  401,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  411,
  412,  413,   -1,   -1,   -1,   -1,   -1,   -1,  420,   -1,
   -1,  423,   -1,   -1,   -1,   -1,   -1,  429,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,  371,  372,  373,  374,  375,  376,   -1,  378,
  379,   -1,  381,  382,  383,  384,  385,  386,  387,  388,
  389,  390,   -1,  392,  393,  394,  395,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,   -1,  256,  256,   -1,   -1,
   -1,  420,  262,   -1,  423,   -1,  265,   -1,  267,   -1,
  429,  270,   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,
  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,  298,   -1,
   -1,  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
   -1,   -1,   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,
  370,  371,  372,  373,  374,  375,  376,   -1,  378,  379,
   -1,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  390,   -1,  392,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  413,   -1,  256,  256,   -1,   -1,  418,
  420,  262,   -1,  423,   -1,  265,   -1,  267,   -1,  429,
  270,   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,  279,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,  298,   -1,   -1,
  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,
   -1,   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
  371,  372,  373,  374,  375,  376,   -1,  378,  379,   -1,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
   -1,  392,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,  413,   -1,  256,  256,   -1,   -1,  418,  420,
  262,   -1,  423,   -1,  265,   -1,  267,   -1,  429,  270,
   -1,   -1,   -1,   -1,  275,   -1,   -1,   -1,  279,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,  298,   -1,   -1,  300,
   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,   -1,
   -1,  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,
  331,   -1,   -1,  334,   -1,   -1,  337,  339,   -1,   -1,
   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,  371,
  372,  373,  374,  375,  376,   -1,  378,   -1,   -1,  381,
  382,  383,  384,  385,  386,  387,  388,  389,  390,   -1,
  392,  393,  394,  395,  396,  397,  398,  399,  400,  401,
  402,  403,  404,  405,  406,  407,  408,  409,  410,  411,
  412,  413,   -1,  256,   -1,  256,   -1,  418,  420,  262,
   -1,  423,   -1,  264,  265,   -1,  267,  429,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,   -1,   -1,   -1,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,  298,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,
  371,  374,  375,  376,   -1,  378,  379,   -1,  381,  382,
  383,  384,  385,  386,  387,  388,  389,  390,  261,   -1,
   -1,  394,  395,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  256,
  413,  284,   -1,   -1,   -1,  262,  417,  418,   -1,   -1,
   -1,   -1,   -1,   -1,  297,   -1,  429,   -1,   -1,  302,
   -1,   -1,  305,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,
   -1,  298,  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,   -1,  336,   -1,  338,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,   -1,  362,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,  386,
  387,  388,  389,  390,   -1,  418,   -1,  394,  395,  396,
  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,  256,  429,   -1,   -1,   -1,   -1,  262,   -1,  368,
   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,  378,
  379,   -1,   -1,  382,  383,  384,  385,   -1,   -1,   -1,
  389,  390,   -1,   -1,   -1,  394,  395,  396,  397,  398,
  399,  400,  401,  298,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  413,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
  429,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  298,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,  378,  379,   -1,   -1,  382,  383,  384,
  385,   -1,   -1,   -1,  389,  390,  285,   -1,   -1,  394,
  395,  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,  256,  429,   -1,   -1,   -1,  327,  262,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,  378,  379,   -1,   -1,  382,  383,  384,  385,   -1,
   -1,   -1,  389,  390,   -1,   -1,   -1,  394,  395,  396,
  397,  398,  399,  400,  401,  298,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  413,   -1,  377,  378,
  379,  380,   -1,  382,  383,  384,  385,  386,  387,  388,
  389,  256,  429,  392,  393,  394,  395,  396,  397,  398,
  399,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,  378,  379,   -1,   -1,  382,
  383,  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,
   -1,  394,  395,  396,  397,  398,  399,  400,  401,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  413,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,
   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,   -1,   -1,   -1,   -1,  382,  383,  384,
  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,  394,
  395,  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,   -1,   -1,   -1,   -1,  382,  383,  384,  385,   -1,
   -1,   -1,  389,  390,   -1,  256,   -1,  394,  395,  396,
  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,
   -1,   -1,   -1,  382,  383,  384,  385,   -1,   -1,   -1,
  389,  390,   -1,  256,   -1,  394,  395,  396,  397,  398,
  399,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,
   -1,  382,  383,  384,  385,   -1,   -1,   -1,  389,  390,
   -1,  256,   -1,   -1,   -1,  396,  397,  398,  399,  400,
  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  413,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,  382,
  383,  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,
   -1,   -1,   -1,  396,  397,  398,  399,  400,  401,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  413,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,
   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,   -1,   -1,   -1,   -1,  382,  383,  384,
  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,   -1,
   -1,  396,  397,  398,  399,  400,  401,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,   -1,   -1,   -1,   -1,  382,  383,  384,  385,   -1,
   -1,   -1,  389,  390,   -1,  256,   -1,   -1,   -1,  396,
  397,  398,  399,  400,  401,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,
   -1,   -1,   -1,  382,  383,  384,  385,   -1,   -1,   -1,
  389,  390,   -1,  256,   -1,   -1,   -1,  396,  397,  398,
  399,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  384,  385,   -1,   -1,   -1,  389,  390,
   -1,  256,   -1,   -1,   -1,   -1,   -1,  398,  399,  400,
  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  413,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  384,  385,   -1,   -1,   -1,  389,  390,   -1,  256,
   -1,   -1,   -1,   -1,   -1,  398,  399,  400,  401,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  413,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,
   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  384,
  385,   -1,   -1,   -1,  389,  390,   -1,  256,   -1,   -1,
   -1,   -1,   -1,  398,  399,  400,  401,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  384,  385,   -1,
   -1,   -1,  389,  390,   -1,  256,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  400,  401,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  384,  385,   -1,   -1,   -1,
  389,  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  385,   -1,   -1,   -1,  389,  390,
   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  400,
  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  413,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  385,   -1,   -1,   -1,  389,  390,   -1,  256,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  400,  401,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  413,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,
   -1,   -1,   -1,  368,   -1,  370,   -1,  372,   -1,  374,
  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  385,   -1,   -1,   -1,   -1,  390,   -1,  256,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  400,  401,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  413,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,
   -1,  368,   -1,  370,   -1,  372,   -1,  374,  375,  376,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  385,   -1,
   -1,   -1,   -1,  390,   -1,  256,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  400,  401,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  413,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,   -1,  372,   -1,  374,  375,  376,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  390,   -1,  256,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  400,  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  413,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  429,   -1,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
   -1,  372,   -1,  374,  375,  376,   -1,   -1,   -1,  256,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  390,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  400,
  401,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  413,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  429,   -1,
   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,   -1,  372,
   -1,  374,  375,  376,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  390,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  401,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  413,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  368,   -1,  370,   -1,  372,  429,  374,  375,  376,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,   -1,  390,   -1,   -1,   -1,   -1,   -1,  264,
  265,  266,  267,   -1,  401,  270,  271,   -1,  273,  274,
  275,  276,  277,  278,  279,   -1,  413,   -1,   -1,   -1,
  285,   -1,  287,  288,  289,  290,  291,  292,   -1,   -1,
  295,   -1,  429,   -1,  299,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,
  335,   -1,  337,   -1,   -1,  340,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,  376,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  417,  418,  419,  420,  264,  265,  266,  267,
   -1,   -1,  270,  271,   -1,  273,  274,  275,  276,  277,
  278,  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,
  288,  289,  290,  291,  292,   -1,   -1,  295,   -1,   -1,
   -1,  299,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,  324,  325,  326,  327,
  328,  329,  330,  331,  332,  333,  334,  335,   -1,  337,
   -1,   -1,  340,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,  367,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,  376,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,
  418,  419,  420,  264,  265,  266,  267,   -1,   -1,  270,
  271,   -1,  273,  274,  275,  276,  277,  278,  279,   -1,
   -1,   -1,   -1,   -1,  285,   -1,  287,  288,  289,  290,
  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,  324,  325,  326,  327,  328,  329,  330,
  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,  340,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,  376,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,  420,
  264,  265,  266,  267,   -1,   -1,  270,  271,   -1,  273,
  274,  275,  276,  277,  278,  279,   -1,   -1,   -1,   -1,
   -1,  285,   -1,  287,  288,  289,  290,  291,  292,   -1,
   -1,  295,   -1,   -1,   -1,  299,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
  324,  325,  326,  327,  328,  329,  330,  331,  332,  333,
  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,
   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,   -1,
   -1,   -1,  376,  377,  378,  379,  380,   -1,   -1,   -1,
  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,   -1,   -1,  417,  418,  419,  420,  264,  265,  266,
  267,   -1,   -1,  270,  271,   -1,  273,  274,  275,  276,
  277,  278,  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,
  287,  288,  289,  290,  291,  292,   -1,   -1,  295,   -1,
   -1,   -1,  299,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,  324,  325,  326,
  327,  328,  329,  330,  331,  332,  333,  334,  335,   -1,
  337,   -1,   -1,  340,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,  376,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
  417,  418,  419,  420,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,
   -1,   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,
   -1,  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,
   -1,  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,
   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  359,
  360,  361,  362,  363,   -1,   -1,   -1,  367,  368,   -1,
   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,
  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,  372,
   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,   -1,   -1,  417,  418,  419,
  420,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,  418,  279,   -1,   -1,  265,
   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,
   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,  316,  300,  318,  319,  320,  304,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,
   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,  370,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,
   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,  418,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
  367,  368,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
  417,  418,  419,  420,   -1,   -1,  264,  265,   -1,  267,
   -1,  428,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,   -1,  265,   -1,  267,  285,   -1,  270,
  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,  300,
  318,  319,   -1,  304,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,  316,  334,  318,   -1,  337,
   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,  330,
  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,
   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,
  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,
   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,
   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,
  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,  418,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,
  362,  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,
   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,
   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,
  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,  417,  418,  419,  420,   -1,
   -1,  264,  265,   -1,  267,   -1,  428,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,   -1,  265,
   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,
   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,  316,  300,  318,  319,   -1,  304,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,
   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  417,  418,  419,  420,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,  418,  279,   -1,   -1,  265,   -1,  267,  285,
   -1,  270,  288,   -1,   -1,   -1,  275,   -1,   -1,  295,
  279,   -1,   -1,   -1,  300,   -1,  302,  303,  304,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
  316,  300,  318,  319,   -1,  304,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,  316,  334,  318,
   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,  344,  345,
   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,
   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,
   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,
  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,
   -1,  417,  418,  419,  420,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,  418,
  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  262,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,  298,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  417,  418,
  419,  420,  371,  372,  373,  374,   -1,   -1,   -1,  378,
  379,   -1,   -1,  382,  383,  384,  385,  386,  387,  388,
  389,  390,   -1,  392,  393,  394,  395,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,  413,   -1,  261,   -1,   -1,   -1,
  265,  420,  267,   -1,  423,  270,   -1,  272,  273,   -1,
  275,   -1,  277,   -1,  279,   -1,  281,  282,  283,  284,
   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,  293,   -1,
  295,  296,  297,   -1,   -1,  300,   -1,  302,   -1,  304,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,  316,  317,  318,   -1,   -1,  321,  322,  323,   -1,
   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,  333,  334,
   -1,  336,  337,  338,   -1,   -1,   -1,  342,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  261,   -1,  362,   -1,  265,
   -1,  267,   -1,  368,  270,   -1,  272,  273,   -1,  275,
   -1,  277,  377,  279,   -1,  281,  282,  283,  284,   -1,
   -1,  287,  288,   -1,   -1,   -1,   -1,  293,   -1,  295,
  296,  297,   -1,   -1,  300,   -1,  302,   -1,  304,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
  316,  317,  318,  418,   -1,  321,  322,  323,   -1,   -1,
   -1,   -1,   -1,   -1,  330,  331,   -1,  333,  334,   -1,
  336,  337,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  261,   -1,  362,   -1,  265,   -1,
  267,   -1,  368,  270,   -1,  272,  273,   -1,  275,   -1,
  277,  377,  279,   -1,  281,  282,  283,  284,   -1,   -1,
  287,  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,
  297,   -1,   -1,  300,   -1,  302,   -1,  304,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,  316,
  317,  318,  418,   -1,  321,  322,  323,   -1,   -1,   -1,
   -1,   -1,   -1,  330,  331,   -1,  333,  334,   -1,  336,
  337,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  261,   -1,
   -1,   -1,  265,   -1,  267,  362,   -1,  270,   -1,  272,
  273,  368,  275,   -1,  277,   -1,  279,   -1,  281,  282,
  283,  284,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,
  293,   -1,  295,  296,  297,   -1,   -1,  300,   -1,  302,
  261,  304,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,  316,  317,  318,   -1,   -1,  321,  322,
  323,  418,   -1,  284,   -1,   -1,   -1,  330,  331,   -1,
  333,  334,  261,  336,  337,  338,  297,   -1,   -1,  342,
   -1,  302,   -1,   -1,  305,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,  284,  317,   -1,   -1,  362,
  321,   -1,   -1,   -1,  325,  368,   -1,   -1,  297,   -1,
  261,   -1,  333,  302,   -1,  336,   -1,  338,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,   -1,  321,  284,   -1,   -1,  357,   -1,   -1,   -1,
  261,  362,   -1,   -1,  333,   -1,  297,  336,  369,  338,
  371,  302,  373,   -1,  305,  418,  307,   -1,  309,  310,
  311,  312,   -1,  284,   -1,  386,  317,   -1,   -1,   -1,
  321,   -1,   -1,  362,  325,   -1,  297,   -1,   -1,   -1,
   -1,  302,  333,   -1,   -1,  336,  307,  338,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,  418,   -1,   -1,
  321,   -1,   -1,   -1,  325,   -1,   -1,  264,  265,   -1,
  267,  362,  333,  270,  271,  336,   -1,  338,  275,  276,
  277,   -1,  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,
   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,  362,   -1,  300,   -1,  302,  303,  304,   -1,  306,
   -1,   -1,   -1,   -1,   -1,   -1,  313,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,  418,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  418,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,  372,   -1,  374,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,  306,   -1,   -1,   -1,   -1,
   -1,   -1,  313,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  371,   -1,   -1,  374,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  417,  418,  419,  420,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,  306,   -1,   -1,   -1,   -1,   -1,   -1,  313,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  417,  418,  419,  420,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,  337,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,  418,
  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,  368,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,
   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
  367,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,  367,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  417,  418,  419,  420,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  417,  418,  419,  420,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,  360,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,  377,  378,
  379,  380,   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,
   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,
   -1,  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,
   -1,   -1,  275,  276,  277,   -1,  279,   -1,  417,  418,
  419,  420,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,  302,
  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,
   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,
   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,
   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,  361,  362,
  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  371,   -1,
   -1,   -1,   -1,   -1,  377,  378,  379,  380,   -1,   -1,
   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,   -1,  392,
  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,
  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,  276,
  277,   -1,  279,   -1,  417,  418,  419,  420,  285,   -1,
   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,   -1,
  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,   -1,
   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,  360,  361,  362,  363,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  371,   -1,   -1,   -1,   -1,   -1,
  377,  378,  379,  380,   -1,   -1,   -1,  384,   -1,  386,
   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1,   -1,
   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,  270,
  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,   -1,
  417,  418,  419,  420,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  371,   -1,   -1,   -1,   -1,   -1,  377,  378,  379,  380,
   -1,   -1,   -1,  384,   -1,  386,   -1,   -1,   -1,   -1,
   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  417,  418,  419,  420,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,  261,   -1,  263,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,  284,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,  297,  334,
   -1,   -1,   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,   -1,  321,   -1,  359,  360,  361,  362,  363,   -1,
   -1,   -1,   -1,   -1,  333,   -1,  371,  336,   -1,  338,
   -1,   -1,  377,  378,  379,  380,   -1,   -1,   -1,  384,
   -1,  386,   -1,  264,  265,   -1,  267,  392,  393,  270,
  271,   -1,   -1,  362,  275,  276,  277,   -1,  279,  368,
  369,   -1,   -1,   -1,  285,   -1,   -1,  288,   -1,   -1,
   -1,   -1,  417,  418,  295,  420,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,   -1,
   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  360,
  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  371,  263,   -1,  265,   -1,  267,  377,   -1,  270,  380,
  272,  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,
  282,  283,   -1,   -1,   -1,  287,  288,   -1,   -1,   -1,
   -1,  293,   -1,  295,  296,   -1,   -1,   -1,  300,   -1,
   -1,   -1,  304,   -1,   -1,   -1,  417,  418,   -1,  420,
   -1,   -1,   -1,  315,  316,   -1,  318,   -1,   -1,   -1,
  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,
  264,  265,  334,  267,   -1,  337,  270,  271,   -1,   -1,
  342,  275,  276,  277,   -1,  279,   -1,   -1,   -1,   -1,
   -1,  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,  364,  365,   -1,   -1,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,   -1,   -1,
  265,   -1,  267,   -1,   -1,  270,  418,  272,   -1,   -1,
  275,   -1,   -1,   -1,  279,  359,  360,  361,  362,   -1,
   -1,   -1,   -1,  288,  265,   -1,  267,  371,   -1,  270,
  295,  272,  273,   -1,  275,  300,  277,  302,  279,  304,
  281,  282,  283,   -1,   -1,   -1,  287,  288,   -1,   -1,
   -1,  316,  293,  318,  295,  296,   -1,  322,  323,  300,
   -1,   -1,   -1,  304,   -1,  330,  331,   -1,   -1,  334,
   -1,   -1,  337,  417,  418,  316,   -1,  318,   -1,   -1,
   -1,  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,
  331,   -1,  265,  334,  267,   -1,  337,  270,   -1,  272,
  273,  342,  275,   -1,  277,   -1,  279,   -1,  281,  282,
  283,   -1,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,
  293,   -1,  295,  296,   -1,   -1,   -1,  300,   -1,   -1,
   -1,  304,   -1,   -1,   -1,   -1,  377,   -1,   -1,   -1,
   -1,   -1,   -1,  316,   -1,  318,   -1,   -1,   -1,  322,
  323,   -1,   -1,  418,   -1,   -1,   -1,  330,  331,   -1,
   -1,  334,   -1,   -1,  337,   -1,  265,   -1,  267,  342,
   -1,  270,   -1,   -1,  273,   -1,  275,  418,  277,   -1,
  279,   -1,  281,  282,  283,   -1,   -1,   -1,  287,  288,
   -1,   -1,   -1,   -1,  293,   -1,  295,   -1,  265,   -1,
  267,  300,   -1,  270,   -1,  304,  273,   -1,  275,   -1,
  277,   -1,  279,   -1,  281,  282,  283,  316,   -1,  318,
  287,  288,   -1,  322,   -1,   -1,  293,   -1,  295,   -1,
   -1,  330,  331,  300,   -1,  334,   -1,  304,  337,   -1,
   -1,   -1,  265,  342,  267,  418,   -1,  270,   -1,  316,
   -1,  318,  275,   -1,   -1,  322,  279,   -1,   -1,   -1,
   -1,   -1,   -1,  330,  331,  288,   -1,  334,   -1,   -1,
  337,   -1,  295,   -1,  265,  342,  267,  300,  377,  270,
   -1,  304,   -1,  306,  275,  308,   -1,   -1,  279,   -1,
  313,   -1,   -1,  316,   -1,  318,   -1,  288,   -1,  322,
   -1,   -1,  325,   -1,  295,   -1,   -1,  330,  331,  300,
   -1,  334,   -1,  304,  337,  306,   -1,  308,  265,  418,
  267,   -1,  313,  270,   -1,  316,   -1,  318,  275,   -1,
   -1,  322,  279,   -1,  325,   -1,   -1,   -1,   -1,  330,
  331,  288,   -1,  334,   -1,   -1,  337,   -1,  295,  372,
  265,  418,  267,  300,   -1,  270,   -1,  304,   -1,  306,
  275,  308,   -1,   -1,  279,   -1,  313,   -1,   -1,  316,
   -1,  318,   -1,  288,   -1,  322,   -1,   -1,  325,  370,
  295,   -1,   -1,  330,  331,  300,   -1,  334,   -1,  304,
  337,  306,   -1,   -1,   -1,  418,   -1,   -1,  313,   -1,
   -1,  316,   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,
  325,   -1,   -1,   -1,   -1,  330,  331,   -1,   -1,  334,
   -1,  265,  337,  267,   -1,   -1,  270,  418,   -1,   -1,
   -1,  275,   -1,   -1,   -1,  279,   -1,   -1,   -1,  283,
  265,   -1,  267,   -1,  288,  270,   -1,   -1,   -1,  293,
  275,  295,   -1,   -1,  279,   -1,  300,   -1,   -1,   -1,
  304,  305,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,  418,  316,   -1,  318,  300,   -1,   -1,  322,  304,
   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,   -1,
  334,  316,   -1,  318,  265,   -1,  267,  322,   -1,  270,
   -1,   -1,   -1,  418,  275,  330,  331,   -1,  279,  334,
   -1,  265,  337,  267,   -1,   -1,  270,  288,   -1,   -1,
   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,
   -1,   -1,   -1,  304,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,  316,  300,  318,   -1,   -1,
  304,  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,
  331,   -1,  316,  334,  318,  265,  337,  267,  322,   -1,
  270,   -1,   -1,   -1,  418,  275,  330,  331,   -1,  279,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,  288,  265,
   -1,  267,   -1,  418,  270,  295,   -1,   -1,   -1,  275,
  300,   -1,   -1,  279,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  288,   -1,   -1,   -1,  316,   -1,  318,  295,
   -1,   -1,  322,   -1,  300,   -1,   -1,   -1,  304,   -1,
  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,  265,
  316,  267,  318,   -1,  270,   -1,  322,  418,   -1,  275,
   -1,   -1,   -1,  279,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,  288,  265,  418,  267,   -1,   -1,  270,  295,
   -1,   -1,   -1,  275,  300,   -1,   -1,  279,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,   -1,   -1,
  316,   -1,  318,  295,   -1,   -1,  322,   -1,  300,   -1,
   -1,   -1,  304,   -1,  330,  331,   -1,   -1,  334,   -1,
   -1,  337,   -1,   -1,  316,   -1,  318,  265,  418,  267,
  322,   -1,  270,   -1,   -1,   -1,   -1,  275,  330,  331,
   -1,  279,  334,   -1,  265,  337,  267,   -1,   -1,  270,
  288,   -1,  418,   -1,  275,   -1,   -1,  295,  279,   -1,
   -1,   -1,  300,   -1,   -1,   -1,  304,  288,   -1,   -1,
   -1,  261,   -1,   -1,  295,   -1,   -1,   -1,  316,  300,
  318,   -1,  272,  304,  322,   -1,   -1,  277,   -1,   -1,
   -1,  281,  330,  331,  284,  316,  334,  318,   -1,  337,
   -1,  322,  418,   -1,   -1,   -1,  296,  297,   -1,  330,
  331,  301,  302,  334,  261,   -1,  337,  307,   -1,  309,
  310,  311,  312,   -1,   -1,  272,  418,  317,   -1,   -1,
  277,  321,   -1,  323,  281,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,  333,   -1,  335,  336,   -1,  338,  296,
  297,   -1,  342,   -1,  301,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,  362,   -1,  321,   -1,  323,   -1,  368,  369,
  418,   -1,   -1,  261,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,   -1,   -1,  272,  342,   -1,  418,   -1,  277,
   -1,   -1,   -1,  281,   -1,   -1,  284,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,  296,  297,
   -1,  368,  369,  301,  302,   -1,  261,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,  272,   -1,  317,
   -1,   -1,  277,  321,   -1,  323,  281,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,
  338,  296,  297,   -1,  342,   -1,  301,  302,  261,   -1,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,  362,   -1,  321,   -1,  323,   -1,
  368,  284,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
   -1,  336,   -1,  338,  297,   -1,  261,  342,   -1,  302,
   -1,   -1,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,   -1,  317,   -1,   -1,  362,  321,  284,
   -1,   -1,   -1,  368,   -1,   -1,   -1,   -1,   -1,   -1,
  333,   -1,  297,  336,  261,  338,  263,  302,   -1,   -1,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,  284,   -1,  362,
   -1,  364,  365,   -1,   -1,  368,   -1,   -1,  333,   -1,
  297,  336,  261,  338,   -1,  302,   -1,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,  284,   -1,  362,   -1,  364,
  365,   -1,  261,  368,  263,   -1,  333,   -1,  297,  336,
   -1,  338,   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,  284,   -1,   -1,  317,   -1,
   -1,   -1,  321,   -1,   -1,  362,   -1,   -1,  297,   -1,
   -1,  368,  261,  302,  333,   -1,   -1,  336,  307,  338,
  309,  310,  311,  312,   -1,   -1,  315,   -1,  317,   -1,
   -1,   -1,  321,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  362,  333,  364,  365,  336,  297,  338,
   -1,   -1,  301,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,
   -1,   -1,  321,  362,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  362,
  };

#line 6336 "cs-parser.jay"

// <summary>
//  A class used to hold info about an operator declarator
// </summary>
class OperatorDeclaration {
	public readonly Operator.OpType optype;
	public readonly FullNamedExpression ret_type;
	public readonly Location location;

	public OperatorDeclaration (Operator.OpType op, FullNamedExpression ret_type, Location location)
	{
		optype = op;
		this.ret_type = ret_type;
		this.location = location;
	}
}

void Error_ExpectingTypeName (Expression expr)
{
	if (expr is Invocation){
		report.Error (1002, expr.Location, "Expecting `;'");
	} else {
		Expression.Error_InvalidExpressionStatement (report, expr.Location);
	}
}

void Error_ParameterModifierNotValid (string modifier, Location loc)
{
	report.Error (631, loc, "The parameter modifier `{0}' is not valid in this context",
			              modifier);
}

void Error_DuplicateParameterModifier (Location loc, Parameter.Modifier mod)
{
	report.Error (1107, loc, "Duplicate parameter modifier `{0}'",
  		Parameter.GetModifierSignature (mod));
}

void Error_TypeExpected (Location loc)
{
	report.Error (1031, loc, "Type expected");
}

void Error_UnsafeCodeNotAllowed (Location loc)
{
	report.Error (227, loc, "Unsafe code requires the `unsafe' command line option to be specified");
}

void Warning_EmptyStatement (Location loc)
{
	report.Warning (642, 3, loc, "Possible mistaken empty statement");
}

void Error_NamedArgumentExpected (NamedArgument a)
{
	report.Error (1738, a.Location, "Named arguments must appear after the positional arguments");
}

void Error_MissingInitializer (Location loc)
{
	report.Error (210, loc, "You must provide an initializer in a fixed or using statement declaration");
}

void push_current_class (TypeContainer tc, object partial_token)
{
	if (module.Evaluator != null && current_container is ModuleContainer){
		tc.Definition.Modifiers = tc.ModFlags = (tc.ModFlags & ~Modifiers.AccessibilityMask) | Modifiers.PUBLIC;
		if (undo == null)
			undo = new Undo ();
		undo.AddTypeContainer (current_container, tc);
	}

	if (partial_token != null)
		current_container = current_container.AddPartial (tc);
	else
		current_container = current_container.AddTypeContainer (tc);

	++lexer.parsing_declaration;
	current_class = tc;
	ubag.PushTypeDeclaration (tc);
}

DeclSpace pop_current_class ()
{
	DeclSpace retval = current_class;

	current_class = current_class.Parent;
	current_container = current_class.PartialContainer;
	ubag.PopTypeDeclaration ();
	
	return retval;
}

// <summary>
//   Given the @class_name name, it creates a fully qualified name
//   based on the containing declaration space
// </summary>
MemberName
MakeName (MemberName class_name)
{
	Namespace ns = current_namespace.NS;

	if (current_container == module) {
		if (ns.Name.Length != 0)
			return new MemberName (ns.MemberName, class_name);
		else
			return class_name;
	} else {
		return new MemberName (current_container.MemberName, class_name);
	}
}

[System.Diagnostics.Conditional ("FULL_AST")]
void StoreModifierLocation (object token, Location loc)
{
	if (lbag == null)
		return;

	if (mod_locations == null)
  		mod_locations = new List<Tuple<Modifiers, Location>> ();

	mod_locations.Add (Tuple.Create ((Modifiers) token, loc));
}

List<Tuple<Modifiers, Location>> GetModifierLocations ()
{
	var result = mod_locations;
	mod_locations = null;
	return result;
}

string CheckAttributeTarget (string a, Location l)
{
	switch (a) {
	case "assembly" : case "module" : case "field" : case "method" : case "param" : case "property" : case "type" :
			return a;
	}

	report.Warning (658, 1, l,
		 "`{0}' is invalid attribute target. All attributes in this attribute section will be ignored", a);
	return string.Empty;
}

static bool IsUnaryOperator (Operator.OpType op)
{
	switch (op) {
		
	case Operator.OpType.LogicalNot: 
	case Operator.OpType.OnesComplement: 
	case Operator.OpType.Increment:
	case Operator.OpType.Decrement:
	case Operator.OpType.True: 
	case Operator.OpType.False: 
	case Operator.OpType.UnaryPlus: 
	case Operator.OpType.UnaryNegation:
		return true;
	}
	return false;
}

void syntax_error (Location l, string msg)
{
	report.Error (1003, l, "Syntax error, " + msg);
}

Tokenizer lexer;

public Tokenizer Lexer {
	get {
		return lexer;
	}
}		   

static CSharpParser ()
{
	oob_stack = new Stack<object> ();
}

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file)
	: this (reader, file, file.NamespaceContainer.Module.Compiler.Report)
{
}

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, Report report)
{
	this.file = file;
	current_namespace = file.NamespaceContainer;
	
	this.module = current_namespace.Module;
	this.compiler = module.Compiler;
	this.settings = compiler.Settings;
	this.report = report;
	
	lang_version = settings.Version;
	doc_support = settings.DocumentationFile != null;
	current_class = current_namespace.SlaveDeclSpace;
	current_container = current_class.PartialContainer; // == RootContest.ToplevelTypes
	oob_stack.Clear ();
	lexer = new Tokenizer (reader, file, compiler);
	
	use_global_stacks = true;
}

public void parse ()
{
	eof_token = Token.EOF;
	Tokenizer.LocatedToken.Initialize ();
	
	try {
		if (yacc_verbose_flag > 1)
			yyparse (lexer, new yydebug.yyDebugSimple ());
		else
			yyparse (lexer);
			
		Tokenizer tokenizer = lexer as Tokenizer;
		tokenizer.cleanup ();		
	} catch (Exception e){
	  	if (e is yyParser.yyUnexpectedEof) {
			Error_SyntaxError (yyToken);
			UnexpectedEOF = true;
			return;
		}
			
		if (e is yyParser.yyException) {
			report.Error (-25, lexer.Location, "Parsing error");
		} else {
			// Used by compiler-tester to test internal errors
			if (yacc_verbose_flag > 0)
				throw;
		
			report.Error (589, lexer.Location, "Internal compiler error during parsing");
		}
	}
}

void CheckToken (int error, int yyToken, string msg, Location loc)
{
	if (yyToken >= Token.FIRST_KEYWORD && yyToken <= Token.LAST_KEYWORD)
		report.Error (error, loc, "{0}: `{1}' is a keyword", msg, GetTokenName (yyToken));
	else
		report.Error (error, loc, msg);
}

string ConsumeStoredComment ()
{
	string s = tmpComment;
	tmpComment = null;
	Lexer.doc_state = XmlCommentState.Allowed;
	return s;
}

void FeatureIsNotAvailable (Location loc, string feature)
{
	report.FeatureIsNotAvailable (compiler, loc, feature);
}

Location GetLocation (object obj)
{
	var lt = obj as Tokenizer.LocatedToken;
	if (lt != null)
		return lt.Location;
		
	var mn = obj as MemberName;
	if (mn != null)
		return mn.Location;
		
	var expr = obj as Expression;
	if (expr != null)
		return expr.Location;

	return lexer.Location;
}

public LocationsBag LocationsBag {
	get {
		return lbag;
	}
	set {
		lbag = value;
	}
}

public UsingsBag UsingsBag {
	get {
		return ubag;
	}
	set {
		ubag = value;
	}
}

void start_block (Location loc)
{
	if (current_block == null) {
		current_block = new ToplevelBlock (compiler, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else if (parsing_anonymous_method) {
		current_block = new ParametersBlock (current_block, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else {
		current_block = new ExplicitBlock (current_block, loc, Location.Null);
	}
}

Block
end_block (Location loc)
{
	Block retval = current_block.Explicit;
	retval.SetEndLocation (loc);
	current_block = retval.Parent;
	return retval;
}

void start_anonymous (bool isLambda, ParametersCompiled parameters, bool isAsync, Location loc)
{
	oob_stack.Push (current_anonymous_method);
	oob_stack.Push (current_local_parameters);
	oob_stack.Push (current_variable);
	oob_stack.Push (lexer.async_block);

	current_local_parameters = parameters;
	if (isLambda) {
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (loc, "lambda expressions");

		current_anonymous_method = new LambdaExpression (isAsync, loc);
	} else {
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (loc, "anonymous methods");
			
		current_anonymous_method = new AnonymousMethodExpression (isAsync, loc);
	}

	lexer.async_block = isAsync;
	// Force the next block to be created as a ToplevelBlock
	parsing_anonymous_method = true;
}

/*
 * Completes the anonymous method processing, if lambda_expr is null, this
 * means that we have a Statement instead of an Expression embedded 
 */
AnonymousMethodExpression end_anonymous (ParametersBlock anon_block)
{
	AnonymousMethodExpression retval;

	current_anonymous_method.Block = anon_block;
	retval = current_anonymous_method;

	lexer.async_block = (bool) oob_stack.Pop ();
	current_variable = (BlockVariableDeclaration) oob_stack.Pop ();
	current_local_parameters = (ParametersCompiled) oob_stack.Pop ();
	current_anonymous_method = (AnonymousMethodExpression) oob_stack.Pop ();

	return retval;
}

void Error_SyntaxError (int token)
{
	Error_SyntaxError (0, token, "Unexpected symbol");
}

void Error_SyntaxError (int error_code, int token, string msg)
{
	Lexer.CompleteOnEOF = false;

	// An error message has been reported by tokenizer
	if (token == Token.ERROR)
		return;

	string symbol = GetSymbolName (token);
	string expecting = GetExpecting ();
	var loc = lexer.Location - symbol.Length;
	
	if (error_code == 0) {
		if (expecting == "`identifier'") {
			if (token > Token.FIRST_KEYWORD && token < Token.LAST_KEYWORD) {
				report.Error (1041, loc, "Identifier expected, `{0}' is a keyword", symbol);
				return;
			}
			
			error_code = 1001;
			expecting = "identifier";
		} else if (expecting == "`)'") {
			error_code = 1026;
		} else {
			error_code = 1525;
		}
	}
	
	if (string.IsNullOrEmpty (expecting))
		report.Error (error_code, loc, "{1} `{0}'", symbol, msg);
	else
		report.Error (error_code, loc, "{2} `{0}', expecting {1}", symbol, expecting, msg);	  
}

string GetExpecting ()
{
	int [] tokens = yyExpectingTokens (yyExpectingState);
	var names = new List<string> (tokens.Length);
	bool has_type = false;
	bool has_identifier = false;
	for (int i = 0; i < tokens.Length; i++){
		int token = tokens [i];
		has_identifier |= token == Token.IDENTIFIER;
		
		string name = GetTokenName (token);
		if (name == "<internal>")
			continue;
			
		has_type |= name == "type";
		if (names.Contains (name))
			continue;
		
		names.Add (name);
	}

	//
	// Too many tokens to enumerate
	//
	if (names.Count > 8)
		return null;

	if (has_type && has_identifier)
		names.Remove ("identifier");

	if (names.Count == 1)
		return "`" + GetTokenName (tokens [0]) + "'";
	
	StringBuilder sb = new StringBuilder ();
	names.Sort ();
	int count = names.Count;
	for (int i = 0; i < count; i++){
		bool last = i + 1 == count;
		if (last)
			sb.Append ("or ");
		sb.Append ('`');
		sb.Append (names [i]);
		sb.Append (last ? "'" : count < 3 ? "' " : "', ");
	}
	return sb.ToString ();
}


string GetSymbolName (int token)
{
	switch (token){
	case Token.LITERAL:
		return ((Constant)lexer.Value).GetValue ().ToString ();
	case Token.IDENTIFIER:
		return ((Tokenizer.LocatedToken)lexer.Value).Value;

	case Token.BOOL:
		return "bool";
	case Token.BYTE:
		return "byte";
	case Token.CHAR:
		return "char";
	case Token.VOID:
		return "void";
	case Token.DECIMAL:
		return "decimal";
	case Token.DOUBLE:
		return "double";
	case Token.FLOAT:
		return "float";
	case Token.INT:
		return "int";
	case Token.LONG:
		return "long";
	case Token.SBYTE:
		return "sbyte";
	case Token.SHORT:
		return "short";
	case Token.STRING:
		return "string";
	case Token.UINT:
		return "uint";
	case Token.ULONG:
		return "ulong";
	case Token.USHORT:
		return "ushort";
	case Token.OBJECT:
		return "object";
		
	case Token.PLUS:
		return "+";
	case Token.UMINUS:
	case Token.MINUS:
		return "-";
	case Token.BANG:
		return "!";
	case Token.BITWISE_AND:
		return "&";
	case Token.BITWISE_OR:
		return "|";
	case Token.STAR:
		return "*";
	case Token.PERCENT:
		return "%";
	case Token.DIV:
		return "/";
	case Token.CARRET:
		return "^";
	case Token.OP_INC:
		return "++";
	case Token.OP_DEC:
		return "--";
	case Token.OP_SHIFT_LEFT:
		return "<<";
	case Token.OP_SHIFT_RIGHT:
		return ">>";
	case Token.OP_LT:
		return "<";
	case Token.OP_GT:
		return ">";
	case Token.OP_LE:
		return "<=";
	case Token.OP_GE:
		return ">=";
	case Token.OP_EQ:
		return "==";
	case Token.OP_NE:
		return "!=";
	case Token.OP_AND:
		return "&&";
	case Token.OP_OR:
		return "||";
	case Token.OP_PTR:
		return "->";
	case Token.OP_COALESCING:	
		return "??";
	case Token.OP_MULT_ASSIGN:
		return "*=";
	case Token.OP_DIV_ASSIGN:
		return "/=";
	case Token.OP_MOD_ASSIGN:
		return "%=";
	case Token.OP_ADD_ASSIGN:
		return "+=";
	case Token.OP_SUB_ASSIGN:
		return "-=";
	case Token.OP_SHIFT_LEFT_ASSIGN:
		return "<<=";
	case Token.OP_SHIFT_RIGHT_ASSIGN:
		return ">>=";
	case Token.OP_AND_ASSIGN:
		return "&=";
	case Token.OP_XOR_ASSIGN:
		return "^=";
	case Token.OP_OR_ASSIGN:
		return "|=";
	}

	return GetTokenName (token);
}

static string GetTokenName (int token)
{
	switch (token){
	case Token.ABSTRACT:
		return "abstract";
	case Token.AS:
		return "as";
	case Token.ADD:
		return "add";
	case Token.ASYNC:
		return "async";
	case Token.AWAIT:
		return "await";		
	case Token.BASE:
		return "base";
	case Token.BREAK:
		return "break";
	case Token.CASE:
		return "case";
	case Token.CATCH:
		return "catch";
	case Token.CHECKED:
		return "checked";
	case Token.CLASS:
		return "class";
	case Token.CONST:
		return "const";
	case Token.CONTINUE:
		return "continue";
	case Token.DEFAULT:
		return "default";
	case Token.DELEGATE:
		return "delegate";
	case Token.DO:
		return "do";
	case Token.ELSE:
		return "else";
	case Token.ENUM:
		return "enum";
	case Token.EVENT:
		return "event";
	case Token.EXPLICIT:
		return "explicit";
	case Token.EXTERN:
	case Token.EXTERN_ALIAS:
		return "extern";
	case Token.FALSE:
		return "false";
	case Token.FINALLY:
		return "finally";
	case Token.FIXED:
		return "fixed";
	case Token.FOR:
		return "for";
	case Token.FOREACH:
		return "foreach";
	case Token.GOTO:
		return "goto";
	case Token.IF:
		return "if";
	case Token.IMPLICIT:
		return "implicit";
	case Token.IN:
		return "in";
	case Token.INTERFACE:
		return "interface";
	case Token.INTERNAL:
		return "internal";
	case Token.IS:
		return "is";
	case Token.LOCK:
		return "lock";
	case Token.NAMESPACE:
		return "namespace";
	case Token.NEW:
		return "new";
	case Token.NULL:
		return "null";
	case Token.OPERATOR:
		return "operator";
	case Token.OUT:
		return "out";
	case Token.OVERRIDE:
		return "override";
	case Token.PARAMS:
		return "params";
	case Token.PRIVATE:
		return "private";
	case Token.PROTECTED:
		return "protected";
	case Token.PUBLIC:
		return "public";
	case Token.READONLY:
		return "readonly";
	case Token.REF:
		return "ref";
	case Token.RETURN:
		return "return";
	case Token.REMOVE:
		return "remove";
	case Token.SEALED:
		return "sealed";
	case Token.SIZEOF:
		return "sizeof";
	case Token.STACKALLOC:
		return "stackalloc";
	case Token.STATIC:
		return "static";
	case Token.STRUCT:
		return "struct";
	case Token.SWITCH:
		return "switch";
	case Token.THIS:
		return "this";
	case Token.THROW:
		return "throw";
	case Token.TRUE:
		return "true";
	case Token.TRY:
		return "try";
	case Token.TYPEOF:
		return "typeof";
	case Token.UNCHECKED:
		return "unchecked";
	case Token.UNSAFE:
		return "unsafe";
	case Token.USING:
		return "using";
	case Token.VIRTUAL:
		return "virtual";
	case Token.VOLATILE:
		return "volatile";
	case Token.WHERE:
		return "where";
	case Token.WHILE:
		return "while";
	case Token.ARGLIST:
		return "__arglist";
	case Token.REFVALUE:
		return "__refvalue";
	case Token.REFTYPE:
		return "__reftype";
	case Token.MAKEREF:
		return "__makeref";
	case Token.PARTIAL:
		return "partial";
	case Token.ARROW:
		return "=>";
	case Token.FROM:
	case Token.FROM_FIRST:
		return "from";
	case Token.JOIN:
		return "join";
	case Token.ON:
		return "on";
	case Token.EQUALS:
		return "equals";
	case Token.SELECT:
		return "select";
	case Token.GROUP:
		return "group";
	case Token.BY:
		return "by";
	case Token.LET:
		return "let";
	case Token.ORDERBY:
		return "orderby";
	case Token.ASCENDING:
		return "ascending";
	case Token.DESCENDING:
		return "descending";
	case Token.INTO:
		return "into";
	case Token.GET:
		return "get";
	case Token.SET:
		return "set";
	case Token.OPEN_BRACE:
		return "{";
	case Token.CLOSE_BRACE:
		return "}";
	case Token.OPEN_BRACKET:
	case Token.OPEN_BRACKET_EXPR:
		return "[";
	case Token.CLOSE_BRACKET:
		return "]";
	case Token.OPEN_PARENS_CAST:
	case Token.OPEN_PARENS_LAMBDA:
	case Token.OPEN_PARENS:
		return "(";
	case Token.CLOSE_PARENS:
		return ")";
	case Token.DOT:
		return ".";
	case Token.COMMA:
		return ",";
	case Token.DEFAULT_COLON:
		return "default:";
	case Token.COLON:
		return ":";
	case Token.SEMICOLON:
		return ";";
	case Token.TILDE:
		return "~";
		
	case Token.PLUS:
	case Token.UMINUS:
	case Token.MINUS:
	case Token.BANG:
	case Token.OP_LT:
	case Token.OP_GT:
	case Token.BITWISE_AND:
	case Token.BITWISE_OR:
	case Token.STAR:
	case Token.PERCENT:
	case Token.DIV:
	case Token.CARRET:
	case Token.OP_INC:
	case Token.OP_DEC:
	case Token.OP_SHIFT_LEFT:
	case Token.OP_SHIFT_RIGHT:
	case Token.OP_LE:
	case Token.OP_GE:
	case Token.OP_EQ:
	case Token.OP_NE:
	case Token.OP_AND:
	case Token.OP_OR:
	case Token.OP_PTR:
	case Token.OP_COALESCING:	
	case Token.OP_MULT_ASSIGN:
	case Token.OP_DIV_ASSIGN:
	case Token.OP_MOD_ASSIGN:
	case Token.OP_ADD_ASSIGN:
	case Token.OP_SUB_ASSIGN:
	case Token.OP_SHIFT_LEFT_ASSIGN:
	case Token.OP_SHIFT_RIGHT_ASSIGN:
	case Token.OP_AND_ASSIGN:
	case Token.OP_XOR_ASSIGN:
	case Token.OP_OR_ASSIGN:
		return "<operator>";

	case Token.BOOL:
	case Token.BYTE:
	case Token.CHAR:
	case Token.VOID:
	case Token.DECIMAL:
	case Token.DOUBLE:
	case Token.FLOAT:
	case Token.INT:
	case Token.LONG:
	case Token.SBYTE:
	case Token.SHORT:
	case Token.STRING:
	case Token.UINT:
	case Token.ULONG:
	case Token.USHORT:
	case Token.OBJECT:
		return "type";
	
	case Token.ASSIGN:
		return "=";
	case Token.OP_GENERICS_LT:
	case Token.GENERIC_DIMENSION:
		return "<";
	case Token.OP_GENERICS_GT:
		return ">";
	case Token.INTERR:
	case Token.INTERR_NULLABLE:
		return "?";
	case Token.DOUBLE_COLON:
		return "::";
	case Token.LITERAL:
		return "value";
	case Token.IDENTIFIER:
		return "identifier";

	case Token.EOF:
		return "end-of-file";

		// All of these are internal.
	case Token.NONE:
	case Token.ERROR:
	case Token.FIRST_KEYWORD:
	case Token.EVAL_COMPILATION_UNIT_PARSER:
	case Token.EVAL_USING_DECLARATIONS_UNIT_PARSER:
	case Token.EVAL_STATEMENT_PARSER:
	case Token.LAST_KEYWORD:
	case Token.GENERATE_COMPLETION:
	case Token.COMPLETE_COMPLETION:
		return "<internal>";

		// A bit more robust.
	default:
		return yyNames [token];
        }
}

/* end end end */
}
#line default
namespace yydebug {
        using System;
	 internal interface yyDebug {
		 void push (int state, Object value);
		 void lex (int state, int token, string name, Object value);
		 void shift (int from, int to, int errorFlag);
		 void pop (int state);
		 void discard (int state, int token, string name, Object value);
		 void reduce (int from, int to, int rule, string text, int len);
		 void shift (int from, int to);
		 void accept (Object value);
		 void error (string message);
		 void reject ();
	 }
	 
	 class yyDebugSimple : yyDebug {
		 void println (string s){
			 Console.Error.WriteLine (s);
		 }
		 
		 public void push (int state, Object value) {
			 println ("push\tstate "+state+"\tvalue "+value);
		 }
		 
		 public void lex (int state, int token, string name, Object value) {
			 println("lex\tstate "+state+"\treading "+name+"\tvalue "+value);
		 }
		 
		 public void shift (int from, int to, int errorFlag) {
			 switch (errorFlag) {
			 default:				// normally
				 println("shift\tfrom state "+from+" to "+to);
				 break;
			 case 0: case 1: case 2:		// in error recovery
				 println("shift\tfrom state "+from+" to "+to
					     +"\t"+errorFlag+" left to recover");
				 break;
			 case 3:				// normally
				 println("shift\tfrom state "+from+" to "+to+"\ton error");
				 break;
			 }
		 }
		 
		 public void pop (int state) {
			 println("pop\tstate "+state+"\ton error");
		 }
		 
		 public void discard (int state, int token, string name, Object value) {
			 println("discard\tstate "+state+"\ttoken "+name+"\tvalue "+value);
		 }
		 
		 public void reduce (int from, int to, int rule, string text, int len) {
			 println("reduce\tstate "+from+"\tuncover "+to
				     +"\trule ("+rule+") "+text);
		 }
		 
		 public void shift (int from, int to) {
			 println("goto\tfrom state "+from+" to "+to);
		 }
		 
		 public void accept (Object value) {
			 println("accept\tvalue "+value);
		 }
		 
		 public void error (string message) {
			 println("error\t"+message);
		 }
		 
		 public void reject () {
			 println("reject");
		 }
		 
	 }
}
// %token constants
 class Token {
  public const int EOF = 257;
  public const int NONE = 258;
  public const int ERROR = 259;
  public const int FIRST_KEYWORD = 260;
  public const int ABSTRACT = 261;
  public const int AS = 262;
  public const int ADD = 263;
  public const int BASE = 264;
  public const int BOOL = 265;
  public const int BREAK = 266;
  public const int BYTE = 267;
  public const int CASE = 268;
  public const int CATCH = 269;
  public const int CHAR = 270;
  public const int CHECKED = 271;
  public const int CLASS = 272;
  public const int CONST = 273;
  public const int CONTINUE = 274;
  public const int DECIMAL = 275;
  public const int DEFAULT = 276;
  public const int DELEGATE = 277;
  public const int DO = 278;
  public const int DOUBLE = 279;
  public const int ELSE = 280;
  public const int ENUM = 281;
  public const int EVENT = 282;
  public const int EXPLICIT = 283;
  public const int EXTERN = 284;
  public const int FALSE = 285;
  public const int FINALLY = 286;
  public const int FIXED = 287;
  public const int FLOAT = 288;
  public const int FOR = 289;
  public const int FOREACH = 290;
  public const int GOTO = 291;
  public const int IF = 292;
  public const int IMPLICIT = 293;
  public const int IN = 294;
  public const int INT = 295;
  public const int INTERFACE = 296;
  public const int INTERNAL = 297;
  public const int IS = 298;
  public const int LOCK = 299;
  public const int LONG = 300;
  public const int NAMESPACE = 301;
  public const int NEW = 302;
  public const int NULL = 303;
  public const int OBJECT = 304;
  public const int OPERATOR = 305;
  public const int OUT = 306;
  public const int OVERRIDE = 307;
  public const int PARAMS = 308;
  public const int PRIVATE = 309;
  public const int PROTECTED = 310;
  public const int PUBLIC = 311;
  public const int READONLY = 312;
  public const int REF = 313;
  public const int RETURN = 314;
  public const int REMOVE = 315;
  public const int SBYTE = 316;
  public const int SEALED = 317;
  public const int SHORT = 318;
  public const int SIZEOF = 319;
  public const int STACKALLOC = 320;
  public const int STATIC = 321;
  public const int STRING = 322;
  public const int STRUCT = 323;
  public const int SWITCH = 324;
  public const int THIS = 325;
  public const int THROW = 326;
  public const int TRUE = 327;
  public const int TRY = 328;
  public const int TYPEOF = 329;
  public const int UINT = 330;
  public const int ULONG = 331;
  public const int UNCHECKED = 332;
  public const int UNSAFE = 333;
  public const int USHORT = 334;
  public const int USING = 335;
  public const int VIRTUAL = 336;
  public const int VOID = 337;
  public const int VOLATILE = 338;
  public const int WHERE = 339;
  public const int WHILE = 340;
  public const int ARGLIST = 341;
  public const int PARTIAL = 342;
  public const int ARROW = 343;
  public const int FROM = 344;
  public const int FROM_FIRST = 345;
  public const int JOIN = 346;
  public const int ON = 347;
  public const int EQUALS = 348;
  public const int SELECT = 349;
  public const int GROUP = 350;
  public const int BY = 351;
  public const int LET = 352;
  public const int ORDERBY = 353;
  public const int ASCENDING = 354;
  public const int DESCENDING = 355;
  public const int INTO = 356;
  public const int INTERR_NULLABLE = 357;
  public const int EXTERN_ALIAS = 358;
  public const int REFVALUE = 359;
  public const int REFTYPE = 360;
  public const int MAKEREF = 361;
  public const int ASYNC = 362;
  public const int AWAIT = 363;
  public const int GET = 364;
  public const int SET = 365;
  public const int LAST_KEYWORD = 366;
  public const int OPEN_BRACE = 367;
  public const int CLOSE_BRACE = 368;
  public const int OPEN_BRACKET = 369;
  public const int CLOSE_BRACKET = 370;
  public const int OPEN_PARENS = 371;
  public const int CLOSE_PARENS = 372;
  public const int DOT = 373;
  public const int COMMA = 374;
  public const int COLON = 375;
  public const int SEMICOLON = 376;
  public const int TILDE = 377;
  public const int PLUS = 378;
  public const int MINUS = 379;
  public const int BANG = 380;
  public const int ASSIGN = 381;
  public const int OP_LT = 382;
  public const int OP_GT = 383;
  public const int BITWISE_AND = 384;
  public const int BITWISE_OR = 385;
  public const int STAR = 386;
  public const int PERCENT = 387;
  public const int DIV = 388;
  public const int CARRET = 389;
  public const int INTERR = 390;
  public const int DOUBLE_COLON = 391;
  public const int OP_INC = 392;
  public const int OP_DEC = 393;
  public const int OP_SHIFT_LEFT = 394;
  public const int OP_SHIFT_RIGHT = 395;
  public const int OP_LE = 396;
  public const int OP_GE = 397;
  public const int OP_EQ = 398;
  public const int OP_NE = 399;
  public const int OP_AND = 400;
  public const int OP_OR = 401;
  public const int OP_MULT_ASSIGN = 402;
  public const int OP_DIV_ASSIGN = 403;
  public const int OP_MOD_ASSIGN = 404;
  public const int OP_ADD_ASSIGN = 405;
  public const int OP_SUB_ASSIGN = 406;
  public const int OP_SHIFT_LEFT_ASSIGN = 407;
  public const int OP_SHIFT_RIGHT_ASSIGN = 408;
  public const int OP_AND_ASSIGN = 409;
  public const int OP_XOR_ASSIGN = 410;
  public const int OP_OR_ASSIGN = 411;
  public const int OP_PTR = 412;
  public const int OP_COALESCING = 413;
  public const int OP_GENERICS_LT = 414;
  public const int OP_GENERICS_LT_DECL = 415;
  public const int OP_GENERICS_GT = 416;
  public const int LITERAL = 417;
  public const int IDENTIFIER = 418;
  public const int OPEN_PARENS_LAMBDA = 419;
  public const int OPEN_PARENS_CAST = 420;
  public const int GENERIC_DIMENSION = 421;
  public const int DEFAULT_COLON = 422;
  public const int OPEN_BRACKET_EXPR = 423;
  public const int EVAL_STATEMENT_PARSER = 424;
  public const int EVAL_COMPILATION_UNIT_PARSER = 425;
  public const int EVAL_USING_DECLARATIONS_UNIT_PARSER = 426;
  public const int DOC_SEE = 427;
  public const int GENERATE_COMPLETION = 428;
  public const int COMPLETE_COMPLETION = 429;
  public const int UMINUS = 430;
  public const int yyErrorCode = 256;
 }
 namespace yyParser {
  using System;
  /** thrown for irrecoverable syntax errors and stack overflow.
    */
  internal class yyException : System.Exception {
    public yyException (string message) : base (message) {
    }
  }
  internal class yyUnexpectedEof : yyException {
    public yyUnexpectedEof (string message) : base (message) {
    }
    public yyUnexpectedEof () : base ("") {
    }
  }

  /** must be implemented by a scanner object to supply input to the parser.
    */
  internal interface yyInput {
    /** move on to next token.
        @return false if positioned beyond tokens.
        @throws IOException on input error.
      */
    bool advance (); // throws java.io.IOException;
    /** classifies current token.
        Should not be called if advance() returned false.
        @return current %token or single character.
      */
    int token ();
    /** associated with current token.
        Should not be called if advance() returned false.
        @return value for token().
      */
    Object value ();
  }
 }
} // close outermost namespace, that MUST HAVE BEEN opened in the prolog
