//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Core
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef DISKBACKUP_H
#define DISKBACKUP_H

#include <QList>

class QDir;

struct BackUp
{
	QString content;
	QString filePath;
	QString date;
	QString time;
};

class DiskBackUp
{
	private:
		QList<BackUp *> backupsList;
		QString backupDirPath;
		QDir *backupDir;

		bool validBackUpPath;
		QString backupFileName();
		void parseBackUpDirectory();
	public:
		DiskBackUp(const QString &backupPath = QString());
		~DiskBackUp();

		BackUp *createBackUp(const QString& backupText);
		bool removeBackUp(BackUp *backup);

		BackUp *backUp(int index) const;
		
		void setBackUpPath(const QString &backupPath);

		QString& backupPath();
		const QString& backupPath() const;
		
		bool isValidBackUpPath();

		QList<BackUp *>& backups();
		const QList<BackUp *>& backups() const;
};

#endif
