//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Core
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QFile>
#include <QXmlInputSource>
#include <QXmlSimpleReader>
#include <QDebug>
#include "diskoptionsparser.h"
#include "diskoptionscenter.h"
#include "../gui/const.h"

DiskOptionsCenter::DiskOptionsCenter(const QString &fileSystem,QString lang) {

	optionsReader = new QXmlSimpleReader;
	optionsParser = new DiskOptionsParser(lang);

	optionsReader->setContentHandler(optionsParser);
	optionsReader->setErrorHandler(optionsParser);

	inputFile = new QFile;
	inputSource = new QXmlInputSource(inputFile);

	if (!fileSystem.isEmpty()) setSourcePath(QString(OPTIONS_PATH) + fileSystem + ".xml");
}

DiskOptionsCenter::~DiskOptionsCenter() {
	delete inputFile;
	delete inputSource;
	delete optionsParser;
	delete optionsReader;
}

void DiskOptionsCenter::setSourcePath(const QString& sourcePath) {
	inputFile->setFileName(sourcePath);
	optionsReader->parse(inputSource);
	inputFile->close();
	if (optionsParser->isValid())
		qDebug() << "[G] Parsing of " << sourcePath << " was successful";
	else
		qDebug() << "[W] Parsing of " << sourcePath << " was unsuccsessful";
}

void DiskOptionsCenter::setLanguage(const QString& language) {
	optionsParser->setLanguage(language);
}

QString& DiskOptionsCenter::language() {
	return optionsParser->language();
}

const QString& DiskOptionsCenter::language() const {
	return optionsParser->language();
}

const QList<Option *>& DiskOptionsCenter::fileSystemOptions(const QString& fileSystem) {
	if (fileSystem.isEmpty())
		return emptyOptions;
	if (!cache.keys().contains(fileSystem)) {
		setSourcePath(QString(OPTIONS_PATH) + fileSystem + ".xml");
		cache.insert(fileSystem,optionsParser->options());
	}
	return cache[fileSystem];
}
