//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QVBoxLayout>
#include "swapwidget.h"
#include "../core/diskdevice.h"

SwapWidget::SwapWidget(DiskDevice *dev) {
	device = dev;

	autoMountCheckBox = new QCheckBox(tr("Mount swap during start of the operating system"));
	autoMountCheckBox->setChecked(true);
	
	foreach (QString fstabOption,device->fstabOptions().split(","))
		if (fstabOption == "noauto") {
			autoMountCheckBox->setChecked(false);
			break;
		}
	
	connect(autoMountCheckBox,SIGNAL(toggled(bool)),this,SIGNAL(optionsChanged()));
			
	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addWidget(autoMountCheckBox);
	mainLayout->addStretch();

	setLayout(mainLayout);
}

SwapWidget::~SwapWidget() {
	delete autoMountCheckBox;
}

QString SwapWidget::fstabLine(const QString &format) {
	QString mainLine;
	if (format == "name")
		mainLine += device->blockName() + '\t';
	else if (format == "uuid")
		mainLine += "UUID=" + device->uuid() + '\t';
	else if (format == "label") {
		if (device->label().isEmpty())
			mainLine += "UUID=" + device->uuid() + '\t';
		else
			mainLine += "LABEL=" + device->label() + '\t';
	}
	mainLine += "swap\tswap\t";
	QString optionsString = "sw";
	if (!autoMountCheckBox->isChecked())
		optionsString += ",noauto";
	mainLine += optionsString + '\t' + "0\t0";
	return mainLine;
}
