#include "multilinelistviewitem.h"
#include <qpainter.h>

MultiLineListViewItem::MultiLineListViewItem(QListView *parent)
	: QListViewItem(parent)
{
}

MultiLineListViewItem::MultiLineListViewItem(QListView *parent, QListViewItem *sibling)
	: QListViewItem(parent, sibling)
{
}


MultiLineListViewItem::MultiLineListViewItem(QListView *parent, QString string)
	: QListViewItem(parent, string)
{
}

MultiLineListViewItem::~MultiLineListViewItem()
{
}

void MultiLineListViewItem::set_height(int height)
{
	_height = height;
	
	setHeight(_height);
}

void MultiLineListViewItem::setup()
{
	QListViewItem::setup();

	setHeight(_height);
}

void MultiLineListViewItem::paintCell(QPainter *z,const QColorGroup &color,int column,int width,int alignment)
{
	QListViewItem::paintCell(z,color,column,width,alignment );

	 int x = width - 1;
	 int y = height() - 1;

	 z->setPen(Qt::black);
	 z->setPen(QPen(QColor(210,210,210),1));
	 z->drawLine(0, 0, 0, height());         
	 z->drawLine(0, y, x, y);
}

void MultiLineListViewItem::slot_row_height(QListViewItem *value)
{
	int height = 1;

	int c = value->listView()->columns();

	for(int z = 0; z < c; z++)
	{
		int s = newline_number(value->text(z));

		if(s > height)
		{
			height = s;
		}
	}

	((MultiLineListViewItem *)value)->set_height(18 * height);
}

int MultiLineListViewItem::newline_number(const QString &value)
{
	int total = 0;

	unsigned int z = value.length();

	for(unsigned int s = 0; s < z; s++)
	{
		if(value.at(s) == '\n')
		{
			total++;
		}
	}

	return ++total;
}
