/* $Id: Pub.cpp 133482 2008-07-10 20:16:54Z kans $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'pub.asn'.
 */

#include <ncbi_pch.hpp>

#include <objects/pub/Pub.hpp>
#include <objects/pub/Pub_equiv.hpp>

#include <objects/biblio/Author.hpp>
#include <objects/biblio/Auth_list.hpp>
#include <objects/biblio/PubMedId.hpp>
#include <objects/biblio/Cit_art.hpp>
#include <objects/biblio/Cit_jour.hpp>
#include <objects/biblio/Cit_book.hpp>
#include <objects/biblio/Cit_proc.hpp>
#include <objects/biblio/Cit_let.hpp>
#include <objects/biblio/Cit_sub.hpp>
#include <objects/biblio/Cit_pat.hpp>
#include <objects/biblio/Id_pat.hpp>
#include <objects/biblio/Cit_gen.hpp>
#include <objects/medline/Medline_entry.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CPub::~CPub(void)
{
}


// Appends a label to "label"
void CPub::GetLabel(string*    label,
                    ELabelType type,
                    bool       unique) const
{
    static const char* s_PubTypes[14] = {
        "Unknown",
        "Generic",
        "Submit",
        "Medline",
        "MUID",
        "Article",
        "Journal",
        "Book",
        "Proceedings",
        "Patent",
        "PatID",
        "Manuscript",
        "Equiv",
        "PMID" };

    // Check that label exists
    if (!label) {
        return;
    }

    // Get the index into the s_PubTypes array corresponding to pub type
    int idx = static_cast<int>(Which());
    idx = idx >= 0 && idx < 14 ? idx : 0;

    if (type == eType) {
        // Append pub type to label and return
        *label += s_PubTypes[idx];
        return;
    }

    if (type == eBoth) {
        // Append pub type to label
        *label += string(s_PubTypes[idx]) + ": ";
    }

    switch (Which()) {
    case e_Muid:
        *label += "NLM" + NStr::IntToString(GetMuid());
        break;
    case e_Pmid:
        *label += "PM" + NStr::IntToString(GetPmid().Get());
        break;
    case e_Equiv:
        GetEquiv().GetLabel(label);
        break;
    case e_Medline:
        GetMedline().GetLabel(label, unique);
        break;   
    case e_Article:
        GetArticle().GetLabel(label, unique);
        break;
    case e_Journal:
        GetJournal().GetLabel(label);
        break;
    case e_Book:
        GetBook().GetLabel(label);
        break;
    case e_Proc:
        GetProc().GetLabel(label);
        break;
    case e_Man:
        GetMan().GetLabel(label);
        break;
    case e_Sub:
        GetSub().GetLabel(label, unique);
        break;
    case e_Patent:
        GetPatent().GetLabel(label);
        break;
    case e_Pat_id:
    {
        GetPat_id().GetLabel(label);
        break;
    }
    case e_Gen:
        GetGen().GetLabel(label, unique);
        break;       
    default:
        break;
    }
}


bool CPub::IsSetAuthors(void) const
{
    switch (Which()) {
    case CPub::e_Gen :
        return (GetGen().IsSetAuthors());
    case CPub::e_Sub :
        return (GetSub().IsSetAuthors());
    case CPub::e_Article :
        return (GetArticle().IsSetAuthors());
    case CPub::e_Book :
        return (GetBook().IsSetAuthors());
    case CPub::e_Proc :
        return (GetProc().IsSetBook() && GetProc().GetBook().IsSetAuthors());
    case CPub::e_Patent :
        return (GetPatent().IsSetAuthors());
    case CPub::e_Man :
        return (GetMan().IsSetCit() && GetMan().GetCit().IsSetAuthors());
    default :
      break;
  }
  
  return false;
}

const CAuth_list& CPub::GetAuthors (void) const
{
  switch (Which()) {
    case CPub::e_Gen :
        return (GetGen().GetAuthors());
    case CPub::e_Sub :
        return (GetSub().GetAuthors());
    case CPub::e_Article :
        return (GetArticle().GetAuthors());
    case CPub::e_Book :
        return (GetBook().GetAuthors());
    case CPub::e_Proc :
        return (GetProc().GetBook().GetAuthors());
    case CPub::e_Patent :
        return (GetPatent().GetAuthors());
    case CPub::e_Man :
        return (GetMan().GetCit().GetAuthors());
    default :
        NCBI_THROW(CSerialException, eNotImplemented,
                   "CPub::GetAuthors: unsupported entry type "
                   + SelectionName(Which()));
  }
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 61, chars: 1862, CRC32: d27bbf43 */
