--
-- PostgreSQL database dump
-- $Id: postgresql_schema.sql,v 1.3 2006-03-02 11:09:21 anton Exp $

SET client_encoding = 'SQL_ASCII';
SET check_function_bodies = false;

SET SESSION AUTHORIZATION 'root';

SET search_path = public, pg_catalog;

--
-- TOC entry 35 (OID 25440)
-- Name: plpgsql_call_handler(); Type: FUNC PROCEDURAL LANGUAGE; Schema: public; Owner: root
--

CREATE FUNCTION plpgsql_call_handler() RETURNS language_handler
    AS '$libdir/plpgsql', 'plpgsql_call_handler'
    LANGUAGE c;


SET SESSION AUTHORIZATION DEFAULT;

--
-- TOC entry 34 (OID 25441)
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: public; Owner: 
--

CREATE TRUSTED PROCEDURAL LANGUAGE plpgsql HANDLER plpgsql_call_handler;


SET SESSION AUTHORIZATION 'postgres';

--
-- TOC entry 4 (OID 2200)
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
GRANT ALL ON SCHEMA public TO PUBLIC;


SET SESSION AUTHORIZATION 'root';

--
-- TOC entry 5 (OID 25401)
-- Name: billing; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE billing (
    account_oid integer NOT NULL,
    name character varying(32),
    description character varying(254),
    balance double precision,
    units text,
    plan integer,
    plan_ch integer,
    nextplan integer,
    nextplan_ch integer,
    blocked integer,
    created integer,
    changed integer,
    last_fee_ch integer,
    email character varying(32),
    passwd character varying(32),
    status integer
);


--
-- TOC entry 6 (OID 25408)
-- Name: summary; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE summary (
    prefix character(1) NOT NULL,
    unit_oid integer NOT NULL,
    policy_oid integer NOT NULL,
    t_from integer NOT NULL,
    bytes_in bigint,
    bytes_out bigint
);


--
-- TOC entry 7 (OID 25415)
-- Name: login; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE login (
    unit_oid integer NOT NULL,
    "password" character varying(32),
    inact integer,
    abs integer,
    last_changed integer,
    last_opened_time integer,
    ip bigint,
    mac character varying(18),
    flags integer
);


--
-- TOC entry 8 (OID 25417)
-- Name: quota; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE quota (
    unit_oid integer NOT NULL,
    policy_oid integer NOT NULL,
    syspolicy_oid integer,
    soft_treshold integer,
    flags integer,
    last_blocked_time integer,
    notify_soft_oid integer,
    notify_hard_oid integer,
    notify_return_oid integer,
    h_in bigint,
    h_out bigint,
    h_sum bigint,
    d_in bigint,
    d_out bigint,
    d_sum bigint,
    w_in bigint,
    w_out bigint,
    w_sum bigint,
    m_in bigint,
    m_out bigint,
    m_sum bigint
);


--
-- TOC entry 9 (OID 25425)
-- Name: oids; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE "oids" (
    object_oid integer NOT NULL,
    name character varying(32)
);


--
-- TOC entry 10 (OID 25431)
-- Name: events; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE events (
    "time" integer,
    "type" character varying(8),
    unit_oid integer,
    user_oid integer,
    account_oid integer,
    param character varying(254)
);


--
-- TOC entry 36 (OID 25442)
-- Name: netams_tr_oids(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION netams_tr_oids() RETURNS "trigger"
    AS '
DECLARE
cnt int;    
BEGIN

cnt := (select count(*) from OIDS where object_oid=NEW.object_oid);
        if cnt <> 0 then
            update OIDS set object_oid=NEW.object_oid, name=NEW.name WHERE object_oid=NEW.object_oid;
    RETURN NULL;
        end if;

RETURN NEW;
END;
'
    LANGUAGE plpgsql;


--
-- TOC entry 37 (OID 25444)
-- Name: netams_tr_quota(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION netams_tr_quota() RETURNS "trigger"
    AS '
DECLARE
cnt int;    
BEGIN

cnt := (select count(*) from QUOTA where unit_oid=NEW.unit_oid AND policy_oid=NEW.policy_oid);
        if cnt <> 0 then
            DELETE from QUOTA where unit_oid=NEW.unit_oid AND policy_oid=NEW.policy_oid;
        end if;

RETURN NEW;
END;
'
    LANGUAGE plpgsql;


--
-- TOC entry 38 (OID 25446)
-- Name: netams_tr_summary(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION netams_tr_summary() RETURNS "trigger"
    AS '
DECLARE
cnt int;    
BEGIN

cnt := (select count(*) from SUMMARY where prefix=NEW.prefix AND unit_oid=NEW.unit_oid AND policy_oid=NEW.policy_oid AND t_from=NEW.t_from);
        if cnt <> 0 then
            DELETE from SUMMARY where prefix=NEW.prefix AND unit_oid=NEW.unit_oid AND policy_oid=NEW.policy_oid AND t_from=NEW.t_from;
        end if;

RETURN NEW;
END;
'
    LANGUAGE plpgsql;


--
-- TOC entry 39 (OID 25448)
-- Name: netams_tr_login(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION netams_tr_login() RETURNS "trigger"
    AS '
DECLARE
cnt int;    
BEGIN

cnt := (select count(*) from SUMMARY where unit_oid=NEW.unit_oid);
        if cnt <> 0 then
            DELETE from SUMMARY where unit_oid=NEW.unit_oid;
        end if;

RETURN NEW;
END;
'
    LANGUAGE plpgsql;


--
-- TOC entry 40 (OID 25450)
-- Name: netams_tr_billing(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION netams_tr_billing() RETURNS "trigger"
    AS '
DECLARE
cnt int;    
BEGIN

cnt := (select count(*) from SUMMARY where account_oid=NEW.account_oid);
        if cnt <> 0 then
            DELETE from SUMMARY where account_oid=NEW.account_oid;
        end if;

RETURN NEW;
END;
'
    LANGUAGE plpgsql;


--
-- TOC entry 11 (OID 25452)
-- Name: bdata; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE bdata (
    prefix character(1) NOT NULL,
    account_oid integer NOT NULL,
    subplan_oid integer NOT NULL,
    t_from integer NOT NULL,
    bytes_in bigint,
    bytes_out bigint,
    pay_in double precision,
    pay_out double precision
);


--
-- TOC entry 41 (OID 25459)
-- Name: netams_tr_bdata(); Type: FUNCTION; Schema: public; Owner: root
--

CREATE FUNCTION netams_tr_bdata() RETURNS "trigger"
    AS '
DECLARE
cnt int;    
BEGIN

cnt := (select count(*) from BDATA where prefix=NEW.prefix AND account_oid=NEW.account_oid AND subplan_oid=NEW.subplan_oid AND t_from=NEW.t_from);
        if cnt <> 0 then
            DELETE from BDATA where prefix=NEW.prefix AND account_oid=NEW.account_oid AND subplan_oid=NEW.subplan_oid AND t_from=NEW.t_from;
        end if;

RETURN NEW;
END;
'
    LANGUAGE plpgsql;


--
-- TOC entry 12 (OID 25461)
-- Name: raw; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE raw (
    unit_oid integer NOT NULL,
    policy_oid integer NOT NULL,
    t_from integer,
    t_to integer,
    bytes_in bigint,
    bytes_out bigint
);


--
-- TOC entry 13 (OID 25467)
-- Name: monitor; Type: TABLE; Schema: public; Owner: root
--

CREATE TABLE monitor (
    "time" integer NOT NULL,
    flowt integer,
    unit_oid integer,
    proto smallint,
    src bigint NOT NULL,
    srcport integer,
    dst bigint NOT NULL,
    dstport integer,
    dpkts bigint,
    len bigint
    layer7 character varying(80),
);


--
-- TOC entry 18 (OID 25412)
-- Name: summary_unit_oid_idx; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX summary_unit_oid_idx ON summary USING btree (unit_oid);


--
-- TOC entry 16 (OID 25413)
-- Name: summary_policy_oid_idx; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX summary_policy_oid_idx ON summary USING btree (policy_oid);


--
-- TOC entry 17 (OID 25414)
-- Name: summary_t_from_idx; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX summary_t_from_idx ON summary USING btree (t_from);


--
-- TOC entry 22 (OID 25423)
-- Name: quota_unit_oid_idx; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX quota_unit_oid_idx ON quota USING btree (unit_oid);


--
-- TOC entry 21 (OID 25424)
-- Name: quota_policy_oid_idx; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX quota_policy_oid_idx ON quota USING btree (policy_oid);


--
-- TOC entry 24 (OID 25454)
-- Name: bdata_account__oid_idx; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX bdata_account__oid_idx ON bdata USING btree (account_oid);


--
-- TOC entry 26 (OID 25455)
-- Name: bdata_subplan_oid_idx; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX bdata_subplan_oid_idx ON bdata USING btree (subplan_oid);


--
-- TOC entry 27 (OID 25456)
-- Name: bdata_t_from_idx; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX bdata_t_from_idx ON bdata USING btree (t_from);


--
-- TOC entry 31 (OID 25463)
-- Name: raw_unit_oid_idx; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX raw_unit_oid_idx ON raw USING btree (unit_oid);


--
-- TOC entry 28 (OID 25464)
-- Name: raw_policy_oid_idx; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX raw_policy_oid_idx ON raw USING btree (policy_oid);


--
-- TOC entry 29 (OID 25465)
-- Name: raw_t_from_idx; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX raw_t_from_idx ON raw USING btree (t_from);


--
-- TOC entry 30 (OID 25466)
-- Name: raw_t_to_idx; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX raw_t_to_idx ON raw USING btree (t_to);


--
-- TOC entry 32 (OID 25469)
-- Name: monitor_time_idx; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX monitor_time_idx ON monitor USING btree ("time");


--
-- TOC entry 33 (OID 25470)
-- Name: monitor_unit_oid_idx; Type: INDEX; Schema: public; Owner: root
--

CREATE INDEX monitor_unit_oid_idx ON monitor USING btree (unit_oid);


--
-- TOC entry 14 (OID 25406)
-- Name: billing_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY billing
    ADD CONSTRAINT billing_pkey PRIMARY KEY (account_oid);


--
-- TOC entry 15 (OID 25410)
-- Name: summary_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY summary
    ADD CONSTRAINT summary_pkey PRIMARY KEY (prefix, unit_oid, policy_oid, t_from);


--
-- TOC entry 19 (OID 25419)
-- Name: login_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY login
    ADD CONSTRAINT login_pkey PRIMARY KEY (unit_oid);


--
-- TOC entry 20 (OID 25421)
-- Name: quota_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY quota
    ADD CONSTRAINT quota_pkey PRIMARY KEY (unit_oid, policy_oid);


--
-- TOC entry 23 (OID 25427)
-- Name: oids_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY "oids"
    ADD CONSTRAINT oids_pkey PRIMARY KEY (object_oid);


--
-- TOC entry 25 (OID 25457)
-- Name: bdata_pkey; Type: CONSTRAINT; Schema: public; Owner: root
--

ALTER TABLE ONLY bdata
    ADD CONSTRAINT bdata_pkey PRIMARY KEY (prefix, account_oid, subplan_oid, t_from);


--
-- TOC entry 46 (OID 25443)
-- Name: netams_tr_oids; Type: TRIGGER; Schema: public; Owner: root
--

CREATE TRIGGER netams_tr_oids
    BEFORE INSERT ON "oids"
    FOR EACH ROW
    EXECUTE PROCEDURE netams_tr_oids();


--
-- TOC entry 45 (OID 25445)
-- Name: netams_tr_quota; Type: TRIGGER; Schema: public; Owner: root
--

CREATE TRIGGER netams_tr_quota
    BEFORE INSERT ON quota
    FOR EACH ROW
    EXECUTE PROCEDURE netams_tr_quota();


--
-- TOC entry 43 (OID 25447)
-- Name: netams_tr_summary; Type: TRIGGER; Schema: public; Owner: root
--

CREATE TRIGGER netams_tr_summary
    BEFORE INSERT ON summary
    FOR EACH ROW
    EXECUTE PROCEDURE netams_tr_summary();


--
-- TOC entry 44 (OID 25449)
-- Name: netams_tr_login; Type: TRIGGER; Schema: public; Owner: root
--

CREATE TRIGGER netams_tr_login
    BEFORE INSERT ON login
    FOR EACH ROW
    EXECUTE PROCEDURE netams_tr_login();


--
-- TOC entry 42 (OID 25451)
-- Name: netams_tr_billing; Type: TRIGGER; Schema: public; Owner: root
--

CREATE TRIGGER netams_tr_billing
    BEFORE INSERT ON billing
    FOR EACH ROW
    EXECUTE PROCEDURE netams_tr_billing();


--
-- TOC entry 47 (OID 25460)
-- Name: netams_tr_bdata; Type: TRIGGER; Schema: public; Owner: root
--

CREATE TRIGGER netams_tr_bdata
    BEFORE INSERT ON bdata
    FOR EACH ROW
    EXECUTE PROCEDURE netams_tr_bdata();


SET SESSION AUTHORIZATION 'postgres';

--
-- TOC entry 3 (OID 2200)
-- Name: SCHEMA public; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA public IS 'Standard public schema';


