#!/usr/bin/perl -w
#
# $Id: rrdgraph.cgi,v 1.4 2008-01-02 13:29:35 anton Exp $
#################################################################################         

use RRDs;
use DBI;
use CGI qw/:standard/;
use GD;

sub showError($);
$query = new CGI;

print $query->header("image/png");
binmode STDOUT;

#RRDs::graph("-", 
#	"--start", "920804400", 
#	"--end", "920808000", 
#	"DEF:myspeed=../rrd/test.rrd:speed:AVERAGE",
#	"--width", "760", "--height", "260",
#	"LINE2:myspeed#FF0000");

#################################################################################         
# ITEM 1: obtain input parameters
$oid	= $query->param('oid');
$policy	= $query->param('policy'); %policy = split (/,/, $policy);
$period	= $query->param('period');

$time_2 = time();
if ($period eq 'day' ) { $shift = 60*60*24; }
elsif ($period eq 'week' ) { $shift = 7*60*60*24; }
elsif ($period eq 'month' ) { $shift = 31*60*60*24; }
elsif ($period eq 'total' ) { $shift = $time_2; }
else { $shift=0; }
$time_1 = $time_2 - $shift; 

if ($oid eq '' or (keys %policy)==0 or $shift==0) { showError("query parameters"); }

#################################################################################         
# ITEM 2: check for RRD file
$rrd_filename = "../rrd/unit-".$oid."-".$period.".rrd";
if ( -e $rrd_filename ) {
 	unlink $rrd_filename;
}

#create RRD database
push @t, $rrd_filename;
push @t, "--step=3600";
push @t, "--start=-".(12*31*60*60*24);
foreach $i (keys %policy) {
	push @t, "DS:".$policy{$i}."_in:GAUGE:3600:U:U";
	push @t, "DS:".$policy{$i}."_out:GAUGE:3600:U:U";
}
push @t, "RRA:AVERAGE:0.5:1:8760";
RRDs::create(@t);
$rrd_error=RRDs::error; if (defined $rrd_error) { 
	print STDERR $rrd_filename."  ".@t.$rrd_error."\n";
}

#################################################################################         
# ITEM 3: check for RRD data

# not implemented, go to SQL


#################################################################################         
# ITEM 4: construct SQL query
ITEM4: 

print STDERR "Last update: ".RRDs::last($rrd_filename)."\n";

	DBI->install_driver($sql_type);
	$dbh = DBI->connect("DBI:$sql_type:netams","root", "", { RaiseError=>0,AutoCommit=>1 });
	if (not defined $dbh) { showError("database connect"); }
	
	$dbs = $dbh->prepare("SELECT hex(policy_oid),t_from,bytes_in,bytes_out from summary WHERE prefix='H' AND unit_oid=0x0".$oid." AND t_from >=".$time_1." AND t_from <=".$time_2." ORDER BY t_from,policy_oid"); 
	
	$dbs->execute();
	
	while ( @row = $dbs->fetchrow_array ) {
			if (length($row[0])==5) { $row[0]='0'.$row[0]; }
			$row[0]=$policy{$row[0]};
			if (not defined $data{$row[1]} ) {
				my @t;
				$data{$row[1]} = \@t;
			}
			$thisref=$data{$row[1]};
			push @$thisref, $row[0]."_in:".$row[2];
			push @$thisref, $row[0]."_out:".$row[3];
#			print STDERR $row[1]." - ".$thisref." - ".@$thisref."\n";
	}
	
	foreach $i (sort keys %data) {
			$thisref=$data{$i};
			@thisvalue=@$thisref;
			$template='--template=';
			$values=$i.':';
			foreach $j (@thisvalue) {
				@a=split (/:/, $j);
				$template.=$a[0].':';
				$values.=$a[1].':';
			}
			chop $template;
			chop $values;
			RRDs::update($rrd_filename, $template, $values);
			$rrd_error=RRDs::error; if (defined $rrd_error) { 
				print STDERR $i." - ". @thisvalue." - ".$rrd_error."\n";
				}
	}
	
#################################################################################         
# ITEM 5: run SQL query

#################################################################################         
# ITEM 6: put data to RRD

#################################################################################         
# ITEM 7: query RRD to get an image

#################################################################################         
# ITEM 8: print image at STDOUT

exit 0;
         
#################################################################################         
sub showError($) {
	$param  = shift;
	$im = new GD::Image(200,100);
	$im -> transparent($im->colorAllocate(255,255,255));
	$im -> rectangle(0,0,199,99, $im->colorAllocate(0,0,128)); 
	$im -> string(gdSmallFont, 5, 20, "Error", $im->colorAllocate(0,0,0));
	$im -> string(gdSmallFont, 5, 40, $param, $im->colorAllocate(0,0,0));
	print $im->png;
	exit;
	}         
#################################################################################         
	
