#!/usr/bin/perl -w
#
#-----------------------------------------------------------------------------
# $Id: netams_html.cgi,v 1.10 2006-12-17 17:59:26 rav Exp $
# Contributed to NeTAMS project by A.Rudenko aka RAV (2006/10/21)
#-----------------------------------------------------------------------------

my $insert_href	= "yes";		# insert href
my $show_null	= "no";   		# show zero data
my $KiloByte	= 1024;			# 1024 or 1000
$topN		= 3;			# to show color the maximal traffic
$dir_stat	= "/var/www/html/stat"; # path for files  
$dir_html	= "/stat";		# URL to file
$images 	= "/stat/images";	# URL to images
$url		= "/stat/netams_html.cgi";
push(@INC,	  "/var/www/html/stat"); # path to config.cgi and statistic.pl

require "config.cgi";
require "statistic.pl";

# Global
@month_name 	= (	'january',	'february',	'march',	'april',
			'may',		'june',	   	'july',		'august',
			'september',	'october',	'november', 	'december');
@week_name	= ( 'mon', 'tue', 'wed', 'thu', 'fri', 'sat', 'sun');
$day = $week = $month = $year = "";
my ( $key, @v, %par, $str, $p, $name );

if ( defined $ARGV[0] ) {
	foreach $str ( @ARGV ) {
		($key,$str) = split(/=/,$str);
		next if !defined $key or $key eq "";
		$str = "" if !defined $str;
		$par{$key}  = "".$str }
} else {
	use 	CGI;
	$cgi 	= new CGI;
	foreach $key ( $cgi->param ) {
		@v = $cgi->param($key);
		$par{$key} = join(",",@v) }
}
$par{detail}   	= $insert_href ne "yes"?0:1 if !defined $par{detail};
$par{show_null}	= $show_null   eq "yes"?1:0 if !defined $par{show_null};
$par{KiloByte}	= $KiloByte		    if !defined $par{KiloByte};
$par{images}	= $images		    if !defined $par{images};
$par{url}	= $url		 	    if !defined $par{url};
$par{topN}	= $topN		 	    if !defined $par{topN};
if     ( defined $cgi ) {
	$par{cgi} = 1;
	$p  = 	"<html><head><title> NeTAMS Traffic information </title></head>";
	$p .=	html_param_data(\%par);
	print 	$cgi->header(-type=>'text/html',-expires=>'now', -charset=>'windows-1251') if ! defined $connect_netams or ! defined $connect_netams; 
	print	$p."</html>";
}elsif ( defined $par{action} and $par{action} eq "file" ) {		# create html files
	$par{cgi} 	= 0;
	$par{oids}	= "policy" if !defined $par{oids} or $par{oids} ne "tree";
	$par{detail}	= 0;
	$par{show_null}	= 0;
	($par{year}, $par{month}, $par{week}, $par{day}) = set_date($par{year}, $par{month}, $par{week}, $par{day}, $par{oids});
	get_tree() if !defined %tree;
	if ( $par{oids} eq "policy" ) {					# create html files for users
		my (@period, $y, $w, $m, $d);
		@v = ();
		@v = set_oid( $par{oid}, 0 ) if defined $par{oid};
		if ( scalar( @v ) == 0 ) { print "No oid set\n"; exit } 
		opendir(D,$dir_stat."/clients") || mkdir($dir_stat."/clients"); closedir D;
		$d = $w = $m = $y = 0;	# set 'new' if not defined
		if ( $par{year}   ne "" ) { @period = ('year'); $y = $par{year};  $par{year}="" }
		if ( $par{month}  ne "" ) { @period = ('month');$m = $par{month}; $par{month}=""}
		if ( $par{week}   ne "" ) { @period = ('week'); $w = $par{week};  $par{week}="" }
		if ( $par{day}    ne "" ) { @period = ('day');  $d = $par{day};   $par{day}=""  }
		if ( defined $par{period} and $par{period} ne "" ) 
			{ @period = split( /,/, $par{period} ); @period=('day','week','month','year') if $period[0] eq "all" }
		for $str ( @v ) {
			$name = $tree{OID_NAME}{$str};
			next if !defined $name or $name eq "";
			$par{oid} = $str;
			for $str (@period) {
				if    ($str eq "day") 	{ $par{day} = $d; $par{week} = ""; $par{month} = $m; $par{year} = $y }
				elsif ($str eq "week") 	{ $par{day} = ""; $par{week} = $w; $par{month} = ""; $par{year} = $y }
				elsif ($str eq "month")	{ $par{day} = ""; $par{week} = ""; $par{month} = $m; $par{year} = $y }
				elsif ($str eq "year")	{ $par{day} = ""; $par{week} = ""; $par{month} = ""; $par{year} = $y }
				else  { next }
				$p = html_param_data(\%par);
				next if !defined $p or index($p, "table") <= 0; # no data
				create_user_file($p, $dir_stat."/clients/".$name, $dir_html."/clients/".$name);
		}	}
	} elsif ( $par{oids} eq "tree") {					# create html files for admin
		my (@oid_s, $oid, @pol_s, $pol, %data);
		$year = $par{year}; $month = $par{month}; $day = $par{day};
		if ( defined $par{oid} ) {
			@oid_s = set_oid( $par{oid}, 1 ) ;
			@pol_s = unic( split(/,/,$par{policy}) ) if defined $par{policy};
			@pol_s = ("") if scalar(@pol_s)==0;
			$i = 0;
			for $pol ( @pol_s ) {
				if ( $pol eq "all" or $pol eq "" ) { $pol = ""; $name = "All_Policys" }
				if ( $pol eq "name" ) { $i = 1; next }
				if ( $i and $pol ne "" ) { $name = $pol; $pol = $tree{POLICY_OID}{$name} }
				elsif ( $pol ne "" ) { $name = $tree{POLICY_NAME}{$pol} }
				next if !defined $name or $name eq "";
				$par{policy} = $pol;
				for $oid ( @oid_s ) { 
					$par{oid} = $oid;
					$p = html_param_data(\%par);
					next if !defined $p or index($p, "nbsp;") <= 0;
					$data{"stat_".$name} .= $p;
		}	}	}
		if ( defined $par{show_command} and $par{show_command} ne "" ) {
			my @c = split( /,/, $par{show_command} );
			for ( $i = scalar(@c)-1; $i >= 0; $i-- ) 
				{ $c[$i] =~ tr/A-Za-z0-9_//cd; if ( $c[$i] eq "" ) { splice(@c, $i, 1); next } $c[$i] = "show ".$c[$i] }
			@v = netams_command( @c );
			for ( $i = scalar(@v)-1; $i >= 0; $i-- ) {
				$c[$i] =~ s/ /_/g;;
				$v[$i] =~ s/\r\n/<br>\n/g;
				$data{$c[$i]} = $v[$i] }
		}
		if ( defined $par{clients} or defined $par{Clients} )
			{ $data{"Clients"} = clients_table( $dir_stat."/clients", $dir_html."/clients" ) }
		create_admin_file($dir_stat, $dir_html, \%data);
	}
} else {
	print "To use this cgi in command line: netams_html.cgi action=file oid=all(OR OID,....) period=all(OR day,week,month,year)";
}
exit;

########################################################################
sub set_oid {
	my ($oid, $gr ) = @_;
	my ( $i, @oid_s, @v, $k );
	$gr = 0 if !defined $gr;
	get_tree() if !defined %tree;
	@oid_s = unic( split(/,/,$oid) );
	if ( defined $oid_s[0] and $oid_s[0] eq "all" ) {
		if ( $gr ) { 
			@oid_s = ( "", split( /,/,$tree{GROUPS}{name} ) );
			for ( $i = scalar(@oid_s)-1; $i > 0; $i-- ) { $oid_s[$i] = $tree{NAME_OID}{$oid_s[$i]} } }
		else { @oid_s = keys %{$tree{OID_NAME}} } }
	elsif ( defined $oid_s[0] ) {
		my $child = 1; $oid = 1; $i = 0;
		if   ($oid_s[0] eq "childrens")	{ $k = 1000; 		 shift @oid_s }
		elsif ($oid_s[0] eq "children")	{ $k = scalar(@oid_s)-2; shift @oid_s }
		else				{ $k = scalar(@oid_s)-1; $child =0 }
		while ( defined $oid_s[$i] and $i <= $k ) {
			if ( $oid_s[$i] eq "name" ) { $oid = 0; splice(@oid_s,$i,1); $k--;  next }
			if ( ! $oid )
				{ $oid_s[$i] = $tree{NAME_OID}{$oid_s[$i]} if defined $tree{NAME_OID}{$oid_s[$i]} }
			if ( defined $tree{OID_NAME}{$oid_s[$i]} ) {
				push( @v, $oid_s[$i] );
				if ( $child ) {
					$name = $tree{OID_NAME}{$oid_s[$i]}; $str = "";
					if ( $gr and defined $tree{$name}{childrens}{goid} )
						{ $str = $tree{$name}{childrens}{goid} }
					elsif ( !$gr and defined $tree{$name}{childrens}{oid} )
						{ $str = $tree{$name}{childrens}{oid} }
					if ( $str ne "" ) {
						@oid_s	= ( @oid_s, split(/,/,$str) ) if $k == 1000;
						@v = ( @v, split(/,/,$str) ) }
				}
				$i ++;
			} else { splice(@oid_s,$i,1); $k-- }
		}
		@oid_s = unic( @v );
	}
	return @oid_s;
}

########################################################################
sub clients_table {
	my ($dir_clients, $dir_html) = @_;
	my ($str, @v, $p1, $p2, $type, $oid, $name, @unit_s, $i);
	$str = (netams_command( ("show conf | grep ^unit") ))[0];
	@unit_s = split(/\r\n/, $str);
	get_tree() if !defined %tree;
	$images = "/stat/images" if !defined $images;
	$url	= "/stat/netams_html.cgi" if !defined $url;
	$p1 	= "<div style='margin-left : 2%;'><table cellpadding=1 cellspacing=1 border=1>\n";
		$p1 .= "<tr align=center bgcolor=navy><td width=200><font color=yellow>Name</font></td>";
		$p1 .= "<td width=100><font color=yellow>OID/Html</font></td>";
		$p1 .= "<td width=100><font color=yellow>Type</font></td>";
		$p1 .= "<td width=200><font color=yellow>IP</font></td>";
		$p1 .= "<td width=400><font color=yellow>Description</font></td>";
		$p1 .= "<td width=100><font color=yellow>Parents</font></td>";
		$p1 .= "<td width=100><font color=yellow>Childrens/Stat</font></td>";
		$p2  = "</tr>";	
	for $str ( @unit_s ) {
			( $str, $type, $str, $oid, $str, $name, @v ) = split( /\s+/, $str );
		$p2 .= "<tr align=center><td align=left bgcolor=#ffffaa>$name</td>";
			if ( opendir(D, $dir_clients."/".$name ) ) {
				$str = "<A href=$dir_html/$name/$year>";
				$str.= "$oid</A>";
				closedir D;
			} else { $str = $oid }
		$p2 .= "<td>$str</td>";
		$p2 .= "<td>$type</td>";
			$i=0; $str = "";
			while ( defined $v[$i] and $v[$i] eq "ip" ) { $str .= $v[$i+1]." "; $i += 2 }
			$str = "-" if $str eq ""; 
		$p2 .= "<td>$str</td>";
			$i=0; $str = "";
			while ( defined $v[$i] ) { if ( $v[$i] eq "description" ) 
							{ $str = $v[$i+1]; $i+=2; last if substr($str,0,1) ne "\"";  next; }
							$str .= " ".$v[$i] if $str ne ""; last if substr($str,length($str)-1,1) eq "\"";
						$i ++ }
			$str = "-" if $str eq ""; 
		$p2 .= "<td align=left>$str</td>";
			if ( defined $tree{$name}{parents}{name} ) { $str = $tree{$name}{parents}{name} } else { $str = "-" }
		$p2 .= "<td>$str</td>";
			if ( defined $tree{$name}{childrens}{name} ) {
				$str = "<A href=$url?oids=tree&oid=$oid&year=$year&month=$month&day=$day>";
				$str.="<img src='$images/admintool-logo.gif' width=15 high=15";
				$str.= " alt='Childrens: $tree{$name}{childrens}{name}'></A>&nbsp;" } else { $str = "" }
			$str.= "<A href=$url?&oid=$oid&year=$year&month=$month&day=$day>";
			$str.="<img src='$images/showtable-logo.gif' width=15 high=15";
			$str.= " alt='Statistics'></A>";
		$p2 .= "<td>$str</td>";
	}
	$p2.="</table></div><br>\n";
	return $p1.$p2;
}

########################################################################
sub create_admin_file {
	my ($dir_clients, $dir_html, $data) = @_;
	my ($path, $html, $p1, $p3, $p4, $p5, $p6, $y, $m, $h, @v);
	$p1 	= "<html><head><title>NeTAMS - Unit Tree Statistics </title><META http-equiv=\"Pragma\" content=\"no-cache\">
		<META http-equiv=\"Expires\" content=\"-1\"><META http-equiv=\"Cache-Control\" content=\"no-cache\">
		<META http-equiv=\"Content-type\" content=\"text/html; charset=en\"></HEAD><body>";
	$p3	= "</body></html>";
	$p2 	= "No data.";

	opendir(D,$dir_clients) 		|| mkdir($dir_clients);	closedir D;
	$path = $dir_clients.sprintf("/%04d",$year);
	opendir(D,$path)			|| mkdir($path);	closedir D;
	$path = $dir_clients.sprintf("/%04d/%02d",$year,$month);
	$html = sprintf("%02d",$month);
	opendir(D,$path) 			|| mkdir($path); 	closedir D;
	$y = `date +%Y`+ 0;
	$m = `date +%m`+ 0;
	$h = sprintf("%02d",`date +%H`);
	if ( $year == $y and $month == $m ) {
		open(F,"> ".$dir_clients."/index.html")	  || return;
			print F $p1."<h1>Redirecting to this index to month...</h1><script> document.location.href='$year/$html/index.html'</script>".$p3;
		close F;
		open(F,"> $dir_clients/$year/index.html") || return;
			print F $p1."<h1>Redirecting to this index to month...</h1><script> document.location.href='$html/index.html'</script>".$p3;
		close F;
		open(F,"> $dir_clients/$year/calendar.html") || return;
			print F $p1."<h1>Redirecting to this index to month...</h1><script> document.location.href='$html/calendar.html'</script>".$p3;
		close F;
	}
	open (F,"> $path/index.html") 		|| return; print F $p1.$p2.$p3; close F;
	$path .= sprintf("/%02d",$day);
	opendir(D,$path) 			|| mkdir($path);	closedir D;
	$path.= "/$h";
	opendir(D,$path) 			|| mkdir($path);	closedir D;
	open (F,"> $path/index.html") 		|| return; print F $p1.$p2.$p3; close F;
	if ( defined $data ) {
		@v = keys %{$data};
		for $p4 (@v) {
			if ( defined $data->{$p4} and $data->{$p4} ne "" ) {
				$p2 = $data->{$p4};
				open (F,"> $path/$p4.html") || next; print F $p1.$p2.$p3; close F } }
	}
	$data = set_href( "tree", $dir_clients, $dir_html );
	$p4 = calendar(\%{$data},"month");
	$path = $dir_clients.sprintf("/%04d/%02d",$year,$month);
	$html = sprintf("%02d",$day);
	$p6 = "<IFRAME width='30%' height='250' name='calendar' src='calendar.html' scrolling='no' frameborder='0'></IFRAME>";
	$p6.= "<IFRAME width='70%' height='250' name='data' src='$html/index.html' frameborder='0'></IFRAME>";
	$p6.= "<IFRAME width='100%' height='70%' name='detail' src='$html/$h/index.html'></IFRAME>";
	open (F,"> $path/calendar.html") 	|| return; print F $p1.$p4.$p3; close F;
	open (F,"> $path/index.html") 		|| return; print F $p1.$p6.$p3; close F;
	$path.= sprintf("/%02d",$day);
	$html.= sprintf("/%02d/$h", $day);
	$p5 = calendar(\%{$data},"hour");
	open (F,"> $path/index.html") 		|| return; print F $p1.$p5.$p3; close F;
	open (F,"> $path/$h/index.html") 	|| return; print F $p1.$p2.$p3; close F;
}

########################################################################
sub create_user_file {
	my ($p2, $dir_clients, $dir_html) = @_;
	my ($key, $str, $p1, $p3, $p4);
	$p1 	= "<html><head><title>NeTAMS - Traffic information for selected unit</title><META http-equiv=\"Pragma\" content=\"no-cache\">
		<META http-equiv=\"Expires\" content=\"-1\"><META http-equiv=\"Cache-Control\" content=\"no-cache\">
		<META http-equiv=\"Content-type\" content=\"text/html; charset=en\"></HEAD><body>";
	$p3	= "</body></html>";
	if	( $step == 12 ) { $key = $dir_clients."/".$year."/"; 			   $str="index-year-".$year.".html" }
	elsif	( $step >  24 ) { $key = $dir_clients.sprintf("/%04d/%02d/",$year,$month); $str=sprintf("index-month-%02d.html",$month) }
	elsif	( $step == 7  ) { $key = $dir_clients.sprintf("/%04d/week/",$year); 	   $str=sprintf("index-week-%02d.html",$week) }
	elsif	( $step == 24 ) { $key = $dir_clients.sprintf("/%04d/%02d/",$year,$month); $str=sprintf("index-day-%02d.html",$day) }
	else	{ return }
	opendir(D,$dir_clients) 		|| mkdir($dir_clients);		closedir D;
	opendir(D,$dir_clients."/".$year)	|| mkdir($dir_clients."/".$year);closedir D;
	opendir(D,$key) 			|| mkdir($key); 		closedir D;
	open(F,"> $key$str") 			|| return; print F $p1.$p2.$p3;	close F;
	open(F,"> ".$dir_clients."/index.html")	|| return;
		print F $p1."<h1>Redirecting to this Client index...</h1><script> document.location.href='$year/index.html'</script>".$p3;
	close F;
	$href = set_href( "policy", $dir_clients, $dir_html );
	if ( $step >= 24 ) {
		$p4 = calendar(\%{$href},"month");
		$p2 = "<IFRAME width='100%' height='70%' name='data' src='$str'></IFRAME>";
		open (F,"> ".$key."index.html") || return; print F $p1.$p4.$p2.$p3; close F;
	}
	$p4 = calendar(\%{$href},"year");
	$p2 = "<IFRAME width='100%' height='55%' name='data' src='".($step==7?"week/":($step>=24?sprintf("%02d/",$month):"")).$str."'>";
	open (F,"> ".$dir_clients."/".$year."/index.html") || return; print F $p1.$p4.$p2.$p3; close F;
}

########################################################################
sub set_href {
	my ($oids, $path, $html) = @_;
	my %href = ();
	my ($i, $n, $j);
	opendir(D, $path) || return \%href;
	for ( $i = -1; $i <=1; $i++ ) {
		open(F, "< $path".sprintf("/%04d/index.html",$year + $i)) || next;
			$href{year}[$i+1]="<A href=".$html.sprintf("/%04d/",$year + $i).($oids eq "tree"?"calendar":"index").".html>";
		close(F);
	}
	for ( $i = 1; $i <= 12; $i++ ) {
		opendir(D, $path.sprintf("/%04d/%02d",$year,$i)) || next;
			$href{month}[$i]="<A href=".$html.sprintf("/%04d/%02d/", $year, $i).($oids eq "tree"?"calendar":"index").".html>";
		closedir(D);
	}
	if ( $oids eq "tree" or ( defined $step and $step >= 24 ) ) {
		if ( opendir(D, $path.sprintf("/%04d/%02d",$year,$month)) ) {
			if ( $oids eq "policy" ) {
				while ( $n = readdir(D) ) {
					if (  $n =~ "index-day-") {
						$i = substr( $n, 10, 2);
						$href{day}[$i]="<A href=".$html.sprintf("/%04d/%02d/$n target='data'>",$year,$month);
				}	}
			} elsif ( $oids eq "tree" ) {
				for ( $i = last_day( $month, $year ); $i > 0; $i--) {
					opendir(Di, $path.sprintf("/%04d/%02d/%02d",$year,$month,$i)) || next;
						$href{day}[$i]="<A href=".$html.sprintf("/%04d/%02d/%02d/index.html target='data'>", $year, $month, $i);
					closedir Di;
				}
				for ( $i = 0; $i < 24; $i++ ) {
					opendir(Di, $path.sprintf("/%04d/%02d/%02d/%02d", $year, $month, $day, $i)) || next;
						while ( $n = readdir(Di) )  {
							next if $n eq "index.html";
							$j = rindex ( $n, ".html" );
							next if $j <= 0;
							$n = substr( $n, 0, $j );
							$href{hour}{$n}[$i]="<A href=".$html.sprintf("/%04d/%02d/%02d/%02d/$n.html target='detail'>", $year, $month, $day, $i);
						}
					closedir(Di);
			}	}
			closedir(D);
	}	}
	if ( $oids eq "policy" ) {
		opendir(D, $path.sprintf("/%04d/week", $year)) || return \%href;
			while ( $n = readdir(D) )  {
				if ( $n =~ "index-week-") {
					$i = substr( $n, 11, 2);
					$href{week}[$i]="<A href=$html/$year/week/$n target='data'>";
			}	}
		closedir(D);
	}
	return \%href;
}

########################################################################
sub calendar {
	my ($p1,$p2,$i,$k,$y,$m,$d,$w);
	my $href = shift;
	my $type = shift; $type = "year" if !defined $type;
	# Global - $step $year $month $week $day
	if ($type eq "month") {
		$p1.="<div style='margin-left : 10%;'><table cellpadding=1 cellspacing=1 border=1>\n";
		$p1.="<tr bgcolor=silver><td colspan=2><b>Year:</b></td>";
		$p1.="<td align=right>";
		$p1.=$href->{year}[0]."<</A>" 	if defined $href->{year}[0];
		$p1.="</td>\n<td align=center colspan=4><font face=monospace size=+1 color=red>";
		$p1.=$href->{year}[1] 		if defined $href->{year}[1];
		$p1.=$year;
		$p1.="</A>" 			if defined $href->{year}[1];
		$p1.="</font></td>\n<td>";
		$p1.=$href->{year}[2]."></A>" 	if defined $href->{year}[2];
		$p1.="</td></tr>\n<tr bgcolor=silver><td colspan=2><b> Month:</b></td>";
		$p1.="<td align=right>";
		for ( $i = $month-1; $i > 0; $i-- )
			{ next if !defined $href->{month}[$i]; $href->{month}[0] = $href->{month}[$i]; last}
		$p1.=$href->{month}[0]."<</A>" 	if defined $href->{month}[0];
		$p1.="</td>\n<td align=center colspan=4><font face=monospace size=+1 color=red>";
		$p1.=$href->{month}[$month] 	if defined $href->{month}[$month];
		$p1.=$month_name[$month-1];
		$p1.="</A>" 			if defined $href->{month}[$month];
		$p1.="<td>";
		for ( $i = $month+1; $i <= 12; $i++ )
			{ next if !defined $href->{month}[$i]; $href->{month}[13] = $href->{month}[$i]; last}
		$p1.=$href->{month}[13]."></A>" if defined $href->{month}[13];
		$p1.="</td></tr>";
		$p2.="<tr align=center bgcolor=navy> <td width=50><font color=yellow><b> week </b></font></td>\n";
		for ( $i = 0; $i < 7; $i++ ) { $p2.="<td width=50><font color=yellow> ".$week_name[$i]." </font></td>\n" }
		$w = day2week($year, $month, 1);
		for ( $k = 1; $k <= 7; $k++ ) { ($y,$m,$d) = dn_week( $year, $w, $k ); last if $m == $month }
		$d = 1; $j = last_day( $month, $year );
		while ( $d > 0 ) {
			$p2 .= "<tr bgcolor=#ffffaa align=center><td bgcolor=navy><font color=silver>";
			$p2 .= $href->{week}[$w] if defined $href->{week}[$w];
			$p2 .= $w;
			$p2 .= "</A>" 		 if defined $href->{week}[$w];
			$p2 .= "</font></td>\n";
			$d   = 0 if $k > 1;
			for ( $i = 0; $i < 7; $i++ ) { 
				$d   = 1 if $i + 1 == $k; $d = 0 if $d > $j;
				$p2 .= "<td>";
				$p2 .= $href->{day}[$d] if $d > 0 and defined $href->{day}[$d];
				$p2 .= $d > 0 ? $d : "-";
				$p2 .= "</A>" 		if $d > 0 and defined $href->{day}[$d];
				$p2 .= "</td>\n";
				$d++ if $d > 0;
			}
			last if $d >= $j;
			$w++; $k = -1;
		}
		$p2.="</tr></table></div><br>\n";
	} elsif ( $type eq "year") {
		$p1.="<div style='margin-left : 10%;'><table cellpadding=1 cellspacing=1 border=1>\n";
		$p1.="<tr bgcolor=silver><td width=100><b>Year:</b></td>";
		$p1.="<td align=right width=50>";
		$p1.=$href->{year}[0]."<</A>" 	if defined $href->{year}[0];
		$p1.="</td>\n<td width=220 align=center colspan=4><font face=monospace size=+1 color=red>";
		$p1.=$href->{year}[1] 		if defined $href->{year}[1];
		$p1.=$year;
		$p1.="</A>" 			if defined $href->{year}[1];
		$p1.="</font></td>\n<td width=50>";
		$p1.=$href->{year}[2]."></A>" 	if defined $href->{year}[2];
		$p1.="</td></tr>\n";
		$p1.="<tr bgcolor=navy><td align=center><font color=yellow>Months</font></td>\n";
		$p1.="<td colspan=6 align=center><font color=yellow> Weeks </font></td></tr>";
		for ( $i = 1; $i <= 12; $i++ ) {
			$p2.="<tr align=center bgcolor=#ffffaa><td align=left bgcolor=navy><font color=silver>";
			$p2.=$href->{month}[$i] if defined $href->{month}[$i];
			$p2.="&nbsp;".$month_name[$i-1];
			$p2.="</A>" 		if defined $href->{month}[$i];
			$p2.="</font></td>\n";
			$d  = day2week($year, $i, last_day($i, $year));
			$w  = day2week($year, $i, 1) - 1;
			for ( $k = 0; $k < 6; $k++ ) {
				if ( $w ne "-" ) { $w++; $w = "-" if $w > $d } 
				$p2.="<td>";
				$p2.=$href->{week}[$w] 	if $w ne "-" and defined $href->{week}[$w];
				$p2.=$w;
				$p2.="</A>" 		if $w ne "-" and defined $href->{week}[$w];
				$p2.="</td>";
			}
			$p2.="</tr>\n";
		}
		$p2.="</table></div><br>\n";
	} elsif ( $type eq "hour" ) {
		$p1 ="<div style='margin-left : 2%;'><table cellpadding=1 cellspacing=1 border=1>\n";
		$p1.="<tr bgcolor=navy align=center><td><font color=yellow size=-1>&nbsp;";
		$p1.=sprintf("%02d.%02d.%04d",$day,$month,$year)."&nbsp;</font></td>";
		for ( $i = 0; $i < 24; $i++) {
			$p1 .= "<td><font face=monospace size=-2 color=yellow>";
			$p1 .= sprintf("%02d-%02d",$i,$i+1);
			$p1 .= "</font></td>";
		}
		$p2 ="</tr>";
		my @keys = sort keys(%{$href->{hour}});
		for $d ( @keys ) {
			$p2.="<tr align=center bgcolor=#ffffaa><td align=left bgcolor=navy><font color=yellow>&nbsp;$d&nbsp;</font></td>";
			for ( $i = 0; $i < 24; $i++) {
				$p2 .= "<td>";
				if ( defined $href->{hour}{$d}[$i] ) { $p2 .= $href->{hour}{$d}[$i]."+"."</A>" }
				else { $p2 .= "." }
				$p2 .= "</td>";
		}	}
		$p2.="</tr></table></div><br>\n";
	}
	return $p1.$p2;
}

