/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: lib.c,v 1.5 2008-02-23 08:35:05 anton Exp $ */

#include "config.h"
#include "lib.h"

//stuff for my_fw_*()
fd_set allsocks;
struct timeval fd_tv;

#ifdef SOLARIS
//////////////////////////////////////////////////////////////////////////////////////////
// obtained from FreeBSD: /usr/src/lib/libc/gen/daemon.c 
int
daemon(int nochdir, int noclose)
{
        int fd;

        switch (fork()) {
        case -1:
                return (-1);
        case 0:
                break;
        default:
                _exit(0);
        }

        if (setsid() == -1)
                return (-1);

        if (!nochdir)
                (void)chdir("/");

        if (!noclose && (fd = open("/dev/null", O_RDWR, 0)) != -1) {
                (void)dup2(fd, STDIN_FILENO);
                (void)dup2(fd, STDOUT_FILENO);
                (void)dup2(fd, STDERR_FILENO);
                if (fd > 2)
                        (void)close(fd);
        }
        return (0);
}

int vasprintf(char **ret, const char *format, va_list ap)
{
  va_list ap2;
  int len= 100;        /* First guess at the size */
  if ((*ret= (char *)malloc(len)) == NULL) return -1;
  while (1)
  {
      int nchar;
      va_copy(ap2, ap);
      nchar= vsnprintf(*ret, len, format, ap2);
      if (nchar > -1 && nchar < len) return nchar;
      if (nchar > len)
          len= nchar+1;
      else
          len*= 2;
      if ((*ret= (char *)realloc(*ret, len)) == NULL)
      {
	free(*ret);
	return -1;
  }
  }
}

int asprintf(char **str, char const *fmt, ...)
{
        int ret;
        va_list ap;

	va_start(ap, fmt);
	ret = vasprintf(str, fmt, ap);
	va_end(ap);

        return (ret);
}

//obtained from FreeBSD /usr/src/lib/libc/net/ether_addr.c
/*
 * Convert an ASCII representation of an ethernet address to
 * binary form.
 */
struct ether_addr *ether_aton(const char *a)
{
        int i;
        static struct ether_addr o;
        unsigned int o0, o1, o2, o3, o4, o5;

        i = sscanf(a, "%x:%x:%x:%x:%x:%x", &o0, &o1, &o2, &o3, &o4, &o5);

        if (i != 6)
                return (NULL);

        o.ether_addr_octet[0]=o0;
        o.ether_addr_octet[1]=o1;
        o.ether_addr_octet[2]=o2;
        o.ether_addr_octet[3]=o3;
        o.ether_addr_octet[4]=o4;
        o.ether_addr_octet[5]=o5;

        return ((struct ether_addr *)&o);
}

/*
 * Convert a binary representation of an ethernet address to
 * an ASCII string.
 */
char *ether_ntoa(const struct ether_addr *n)
{
        int i;
        static char a[18];

        i = sprintf(a, "%02x:%02x:%02x:%02x:%02x:%02x",
            n->ether_addr_octet[0], n->ether_addr_octet[1], n->ether_addr_octet[2],
            n->ether_addr_octet[3], n->ether_addr_octet[4], n->ether_addr_octet[5]);
        if (i < 17)
                return (NULL);
        return ((char *)&a);
}


/*
 * FreeBSD: src/lib/libc/string/strcasestr.c,v 1.3
 * 
 * Find the first occurrence of find in s, ignore case.
 */
char *strcasestr(const char *s, const char *find)
{
        char c, sc;
        size_t len;

        if ((c = *find++) != 0) {
                c = tolower((unsigned char)c);
                len = strlen(find);
                do {
                        do {
                                if ((sc = *s++) == 0)
                                        return (NULL);
                        } while ((char)tolower((unsigned char)sc) != c);
                } while (strncasecmp(s, find, len) != 0);
                s--;
        }
        return ((char *)s);
}


//////////////////////////////////////////////////////////////////////////////////////////
#endif
// obtained from flow-tools
// Copyright (c) 2001 Mark Fullmer and The Ohio State University
/*
 * function: bigsockbuf
 *
 * There is no portable way to determine the max send and receive buffers
 * that can be set for a socket, so guess then decrement that guess by
 * 2K until the call succeeds.  If n > 1MB then the decrement by .5MB
 * instead.
 *
 * returns size or -1 for error
*/
int bigsockbuf(int fd, int dir, int size)
{
  int n, tries;

  /* initial size */
  n = size;
  tries = 0;

  while (n > 4096) {

    if (setsockopt(fd, SOL_SOCKET, dir, (char*)&n, sizeof (n)) < 0) {

      /* anything other than no buffers available is fatal */
      if (errno != ENOBUFS) {
        return -1;
      }

      /* try a smaller value */

      if (n > 1024*1024) /* most systems not > 256K bytes w/o tweaking */
        n -= 1024*1024;
      else
        n -= 2048;

      ++tries;

    } else {
      return n;
    }

  } /* while */

  /* no increase in buffer size */
  return 0;

} /* bigsockbuf */
//////////////////////////////////////////////////////////////////////////
const unsigned int CRC16tbl[ 256 ] = {                                 
   0x0000, 0xC0C1, 0xC181, 0x0140, 0xC301, 0x03C0, 0x0280, 0xC241,   
   0xC601, 0x06C0, 0x0780, 0xC741, 0x0500, 0xC5C1, 0xC481, 0x0440,   
   0xCC01, 0x0CC0, 0x0D80, 0xCD41, 0x0F00, 0xCFC1, 0xCE81, 0x0E40,   
   0x0A00, 0xCAC1, 0xCB81, 0x0B40, 0xC901, 0x09C0, 0x0880, 0xC841,   
   0xD801, 0x18C0, 0x1980, 0xD941, 0x1B00, 0xDBC1, 0xDA81, 0x1A40,   
   0x1E00, 0xDEC1, 0xDF81, 0x1F40, 0xDD01, 0x1DC0, 0x1C80, 0xDC41,   
   0x1400, 0xD4C1, 0xD581, 0x1540, 0xD701, 0x17C0, 0x1680, 0xD641,   
   0xD201, 0x12C0, 0x1380, 0xD341, 0x1100, 0xD1C1, 0xD081, 0x1040,   
   0xF001, 0x30C0, 0x3180, 0xF141, 0x3300, 0xF3C1, 0xF281, 0x3240,   
   0x3600, 0xF6C1, 0xF781, 0x3740, 0xF501, 0x35C0, 0x3480, 0xF441,   
   0x3C00, 0xFCC1, 0xFD81, 0x3D40, 0xFF01, 0x3FC0, 0x3E80, 0xFE41,   
   0xFA01, 0x3AC0, 0x3B80, 0xFB41, 0x3900, 0xF9C1, 0xF881, 0x3840,   
   0x2800, 0xE8C1, 0xE981, 0x2940, 0xEB01, 0x2BC0, 0x2A80, 0xEA41,   
   0xEE01, 0x2EC0, 0x2F80, 0xEF41, 0x2D00, 0xEDC1, 0xEC81, 0x2C40,   
   0xE401, 0x24C0, 0x2580, 0xE541, 0x2700, 0xE7C1, 0xE681, 0x2640,   
   0x2200, 0xE2C1, 0xE381, 0x2340, 0xE101, 0x21C0, 0x2080, 0xE041,   
   0xA001, 0x60C0, 0x6180, 0xA141, 0x6300, 0xA3C1, 0xA281, 0x6240,   
   0x6600, 0xA6C1, 0xA781, 0x6740, 0xA501, 0x65C0, 0x6480, 0xA441,   
   0x6C00, 0xACC1, 0xAD81, 0x6D40, 0xAF01, 0x6FC0, 0x6E80, 0xAE41,   
   0xAA01, 0x6AC0, 0x6B80, 0xAB41, 0x6900, 0xA9C1, 0xA881, 0x6840,   
   0x7800, 0xB8C1, 0xB981, 0x7940, 0xBB01, 0x7BC0, 0x7A80, 0xBA41,   
   0xBE01, 0x7EC0, 0x7F80, 0xBF41, 0x7D00, 0xBDC1, 0xBC81, 0x7C40,   
   0xB401, 0x74C0, 0x7580, 0xB541, 0x7700, 0xB7C1, 0xB681, 0x7640,   
   0x7200, 0xB2C1, 0xB381, 0x7340, 0xB101, 0x71C0, 0x7080, 0xB041,   
   0x5000, 0x90C1, 0x9181, 0x5140, 0x9301, 0x53C0, 0x5280, 0x9241,   
   0x9601, 0x56C0, 0x5780, 0x9741, 0x5500, 0x95C1, 0x9481, 0x5440,   
   0x9C01, 0x5CC0, 0x5D80, 0x9D41, 0x5F00, 0x9FC1, 0x9E81, 0x5E40,   
   0x5A00, 0x9AC1, 0x9B81, 0x5B40, 0x9901, 0x59C0, 0x5880, 0x9841,   
   0x8801, 0x48C0, 0x4980, 0x8941, 0x4B00, 0x8BC1, 0x8A81, 0x4A40,   
   0x4E00, 0x8EC1, 0x8F81, 0x4F40, 0x8D01, 0x4DC0, 0x4C80, 0x8C41,   
   0x4400, 0x84C1, 0x8581, 0x4540, 0x8701, 0x47C0, 0x4680, 0x8641,   
   0x8201, 0x42C0, 0x4380, 0x8341, 0x4100, 0x81C1, 0x8081, 0x4040 }; 


u_short CRC16(u_char *idx, u_char idx_size) {
	register u_short res=0;
	register u_char i;
	
	for(i=0; i<idx_size; i++)
		res = ( res >> 8 ) ^ CRC16tbl[ ( res & 0xFF ) ^ idx[i] ];

	return res;
}
//////////////////////////////////////////////////////////////////////////
