/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: policy_prefix.h,v 1.20 2008-02-23 08:35:02 anton Exp $ */

#define PREFIX_COMMENTED	0x01
#define PREFIX_INVERTED		0x02

typedef struct net_prefix {
	in_addr network;
	u_char mask;
	u_char flags;
	unsigned long long match;
} net_prefix;

class PrefixTree;

class PrefixFile {
	public:
		net_prefix *list;
		PrefixTree *ptree;
		char *filename;
		FILE *descriptor;
		unsigned num_prefixes;
		pthread_rwlock_t rwlock;
		PrefixFile();
		~PrefixFile();
		int Load(char *filename); // *
		void Unload(); // *
		void Do(struct cli_def *cli, char *action);
		u_char Check(unsigned addr);  // we will check if adr match net_prefix
		void Dump(struct cli_def *cli);
		void Save(struct cli_def *cli);
};
/////////////////////////////////////////////////////////////////////////////////////////////
