from arcnagios import arcutils, nagutils
from arcnagios.jobplugin import JobPlugin
import os, re, tempfile

def _split_url_urloptions(urlspec):
    if ';' in urlspec:
	xs = urlspec.split(';')
	return (xs[0], xs[1:])
    else:
	return (urlspec, [])

_lfc_re = re.compile(r'lfc://([a-z+-]+://[^@]+)@.*')

class StagingJobPlugin(JobPlugin):

    def staged_outputs(self):
	urls = self.getconf_strlist('staged_outputs', default = [])
	urls = map(_split_url_urloptions, urls)
	return [('%s-out-%d'%(self.test_name, i), url, urloptions)
		for i, (url, urloptions) in zip(range(0, len(urls)), urls)]

    def staged_inputs(self):
	urls = self.getconf_strlist('staged_inputs', default = [])
	urls = map(_split_url_urloptions, urls)
	return [('%s-in-%d'%(self.test_name, i), url, urloptions)
		for i, (url, urloptions) in zip(range(0, len(urls)), urls)]

    def upload_test_file(self, url):
	try:
	    try:
		fd, fn = tempfile.mkstemp(prefix = 'tmp-check_arcce_submit-',
					  text = True)
		fh = os.fdopen(fd, 'w')
		fh.write('This file was uploaded for use by ARC-CE '
			 'staging probes.\n')
		fh.close()
	    except Exception, xc:
		self.log.warning('Failed to create a temporary file '
				 'for upload, using /dev/null: %s'%xc)
		fn = '/dev/null'
	    self.log.info('Uploading %s to %s.'%(fn, url))
	    try:
		arcutils.arccp(fn, url)
	    finally:
		if fn != '/dev/null':
		    os.unlink(fn)
	except arcutils.CalledProcessError, xc:
	    self.log.warning('Failed to create %s: %s'%(url, xc))

    def upload_missing_test_files(self):
	urls = self.getconf_strlist('upload_if_missing', default = [])
	for url in urls:
	    try:
		mo = re.match(_lfc_re, url)
		if mo:
		    rep_url = mo.group(1)
		    rep_urls = arcutils.arcls_L(url, log = self.log)
		    if rep_urls == []:
			self.upload_test_file(url)
		    elif not rep_url in rep_urls:
			arcutils.arccp(url, rep_url)
			arcutils.arccp_T(rep_url, url, log = self.log)
		elif arcutils.arcls(url, log = self.log) == []:
		    self.upload_test_file(url)
	    except arcutils.CalledProcessError, xc:
		self.upload_test_file(url)

    def write_script(self, fh):
	self.upload_missing_test_files()
	fh.write('# Test "%s" handled by the "staging" job-plugin.\n'
		 % self.test_name)
	for filename, _0, _1 in self.staged_outputs():
	    fh.write('hostname >%s\n'%filename)
	fh.write('\n')

    def check(self, report, jobdir, stored_urls):
	for url in stored_urls:
	    try:
		files = arcutils.arcls(url, log = report.log)
		if len(files) == 0:
		    report.log.error('Could not list %s.'%url)
		    report.update_states(nagutils.CRITICAL)
		elif len(files) > 1:
		    report.log.warning('Got multiple entries from %s:'%url)
		    for file in files:
			report.log.warning('  %s'%file)
	    except arcutils.CalledProcessError, xc:
		report.log.error('Failed to list %s using arcls: %s'%(url, xc))
		report.update_status(nagutils.CRITICAL)
