%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(0)")}

%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

%{!?_jnidir: %global _jnidir %{_libdir}/java}

%if %{?rhel}%{!?rhel:0} == 5
%global __python26 %{_bindir}/python2.6
%{!?python26_sitearch: %global python26_sitearch %(%{__python26} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
%{!?python26_sitelib: %global python26_sitelib %(%{__python26} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(0)")}
# Disable the default python byte compilation
%global __os_install_post %(echo '%{__os_install_post}' | sed -e 's!/usr/lib[^[:space:]]*/brp-python-bytecompile[[:space:]].*$!!g')
%endif

%if %{?filter_setup:1}%{!?filter_setup:0}
%filter_provides_in %{python_sitearch}.*\.so$
%if %{?rhel}%{!?rhel:0} == 5
%filter_provides_in %{python26_sitearch}.*\.so$
%endif
%if %{?fedora}%{!?fedora:0} >= 13
%filter_provides_in %{python3_sitearch}.*\.so$
%endif
%filter_setup
%endif

#
# Build dependency descrepancies across platforms
#
%if %{?suse_version:1}%{!?suse_version:0}
%global glibmm2_devel  glibmm2-devel
%global openldap_devel openldap2-devel
%else
%global glibmm2_devel  glibmm24-devel
%global openldap_devel openldap-devel
%endif
%if %{?fedora}%{!?fedora:5} > 4 && %{?suse_version:0}%{!?suse_version:1}
%global nss_devel nss-devel
%else
%global nss_devel mozilla-nss-devel
%endif

%if %{?fedora}%{!?fedora:0} >= 12 || %{?rhel}%{!?rhel:0} >= 6 || %{?suse_version:1}%{!?suse_version:0}
%global libuuid_devel libuuid-devel
%else
%global libuuid_devel e2fsprogs-devel
%endif

#
# xROOTd
#
%if %{?fedora}%{!?fedora:0} >= 12 || %{?rhel}%{!?rhel:0}
%global with_xrootd %{!?_without_xrootd:1}%{?_without_xrootd:0}
%else
%global with_xrootd 0
%endif

#
# Java
#
%if %{?fedora}%{!?fedora:0} >= 7 || %{?rhel}%{!?rhel:0} >= 5
%if %{?rhel}%{!?rhel:0} == 5
%ifarch ppc
# RHEL 5 ppc only has java 1.4
%global with_java 0
%global with_junit 0
%else
%global with_java %{!?_without_java:1}%{?_without_java:0}
%global with_junit %{!?_without_junit:1}%{?_without_junit:0}
%endif
%else
%global with_java %{!?_without_java:1}%{?_without_java:0}
%global with_junit %{!?_without_junit:1}%{?_without_junit:0}
%endif
%else
%global with_java 0
%global with_junit 0
%endif
%global with_gcj %{!?_with_gcj:0}%{?_with_gcj:1}

#
# Python
#
%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5 || %{?suse_version:1}%{!?suse_version:0}
%if %{?rhel}%{!?rhel:0} == 6
%ifarch ppc64
# The python module doesn't build on RHEL6 ppc64 (.toc1 section overflow)
%global with_python 0
%global with_pylint 0
%else
%global with_python 1
%global with_pylint %{!?_without_pylint:1}%{?_without_pylint:0}
%endif
%else
%global with_python 1
%global with_pylint %{!?_without_pylint:1}%{?_without_pylint:0}
%endif
%else
%global with_python 0
%global with_pylint 0
%endif

%if %{?fedora}%{!?fedora:0} >= 7 || %{?rhel}%{!?rhel:0} >= 5 || %{?suse_version}%{!?suse_version:0} >= 1110
%global with_acix 1
%else
%global with_acix 0
%endif

%if %{?fedora}%{!?fedora:0} >= 21 || %{?rhel}%{!?rhel:0} >= 5
%global with_s3 1
%else
%global with_s3 0
%endif

%if %{?fedora}%{!?fedora:0} >= 21 || %{?rhel}%{!?rhel:0} >= 5
%global with_gfal 1
%else
%global with_gfal 0
%endif

%if %{?fedora}%{!?fedora:0} >= 8 || %{?rhel}%{!?rhel:0} >= 4
%if %{?fedora}%{!?fedora:0} <= 25
%global with_canl %{!?_without_canl:1}%{?_without_canl:0}
%else
%global with_canl 0
%endif
%else
%global with_canl 0
%endif

%if %{?fedora}%{!?fedora:0} || %{?rhel}%{!?rhel:0}
%global with_xmlsec1 %{!?_without_xmlsec1:1}%{?_without_xmlsec1:0}
%else
%global with_xmlsec1 0
%endif

#
# CA utils
#
%if %{?suse_version:1}%{!?suse_version:0}
%global with_cautils 0
%else
%global with_cautils 1
%endif

# SQLite
%if %{?fedora}%{!?fedora:0} >= 11 || %{?rhel}%{!?rhel:0} >= 6
%global with_sqlite 1
%else
%global with_sqlite 0
%endif

%global pkgdir arc

%if %{?fedora}%{!?fedora:0} >= 25 || %{?rhel}%{!?rhel:0} >= 8
%global use_systemd 1
%else
%global use_systemd 0
%endif

#
# Macros for scripts
#

# Stop and disable service on package removal
%if %{use_systemd}
%define stop_on_removal() %{expand:%%systemd_preun %(sed 's/[^ ]*/&.service/g' <<< '%{?*}')}
%else
%if %{?stop_on_removal:0}%{!?stop_on_removal:1}
%global stop_on_removal() if [ $1 -eq 0 ]; then for s in %*; do service $s stop > /dev/null 2>&1 || : ; done; for s in %*; do /sbin/chkconfig --del $s; done; fi
%endif
%endif

# Enable a service
%if %{use_systemd}
%define enable_service() %{expand:%%systemd_post %(sed 's/[^ ]*/&.service/g' <<< '%{?*}')}
%else
%if %{?suse_version:1}%{!?suse_version:0}
%define enable_service() %{expand:%%fillup_and_insserv -f %{?*}}
%else
%define enable_service() for s in %{?*}; do /sbin/chkconfig --add $s ; done
%endif
%endif

# Conditionally restart service on package update
%if %{use_systemd}
%define condrestart_on_update() %{expand:%%systemd_postun_with_restart %(sed 's/[^ ]*/&.service/g' <<< '%{?*}')}
%else
%if %{?suse_version:1}%{!?suse_version:0}
%define condrestart_on_update() %{expand:%%restart_on_update %{?*}} %{expand:%%insserv_cleanup}
%else
%define condrestart_on_update() if [ $1 -ge 1 ]; then for s in %{?*}; do service $s condrestart > /dev/null 2>&1 || : ; done; fi
%endif
%endif

# Standard service requirements
%if %{use_systemd}
%define service_post_requires   systemd-units
%define service_preun_requires  systemd-units
%define service_postun_requires systemd-units
%else
%if %{?suse_version:1}%{!?suse_version:0}
%define service_post_requires   %{insserv_prereq}
%define service_preun_requires  %{insserv_prereq}
%define service_postun_requires %{insserv_prereq}
%else
%define service_post_requires   chkconfig
%define service_preun_requires  chkconfig, initscripts
%define service_postun_requires initscripts
%endif
%endif

Name:		nordugrid-arc
Version:	5.3.0
Release:	0.rc1%{?dist}
Summary:	Advanced Resource Connector Grid Middleware
Group:		System Environment/Daemons
License:	ASL 2.0
URL:		http://www.nordugrid.org/
Source:		http://download.nordugrid.org/packages/%{name}/releases/%{version}rc1/src/%{name}-%{version}rc1.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

#		Packages dropped without replacements
Obsoletes:	nordugrid-arc-chelonia < 2.0.0
Obsoletes:	nordugrid-arc-hopi < 2.0.0
Obsoletes:	nordugrid-arc-isis < 2.0.0
Obsoletes:	nordugrid-arc-janitor < 2.0.0
Obsoletes:	nordugrid-arc-doxygen < 4.0.0

BuildRequires:	cppunit-devel
BuildRequires:	pkgconfig
%if %{?fedora}%{!?fedora:0} >= 12 || %{?rhel}%{!?rhel:0} >= 6 || %{?suse_version:1}%{!?suse_version:0}
BuildRequires:	libuuid-devel
%else
BuildRequires:	e2fsprogs-devel
%endif
BuildRequires:	gettext
%if %{with_python}
BuildRequires:	python-devel
%endif
%if %{?rhel}%{!?rhel:0} == 5
BuildRequires:	python26-devel
%endif
%if %{?fedora}%{!?fedora:0} >= 13
BuildRequires:	python3-devel
%endif
%if %{with_pylint}
BuildRequires:	pylint
%endif
BuildRequires:	%{glibmm2_devel}
BuildRequires:	glib2-devel
BuildRequires:	libxml2-devel
BuildRequires:	openssl
BuildRequires:	openssl-devel
%if %{with_xmlsec1}
BuildRequires:	xmlsec1-devel >= 1.2.4
BuildRequires:	xmlsec1-openssl-devel >= 1.2.4
%endif
BuildRequires:	%{nss_devel}
BuildRequires:	%{openldap_devel}
BuildRequires:	globus-common-devel
BuildRequires:	globus-ftp-client-devel
BuildRequires:	globus-ftp-control-devel
%if %{?fedora}%{!?fedora:0} >= 23 || %{?rhel}%{!?rhel:0} >= 5
BuildRequires:	globus-gssapi-gsi-devel >= 12.2
%else
BuildRequires:	globus-gssapi-gsi-devel < 12.2
%endif
%if %{with_canl}
BuildRequires:	canl-c++-devel
%endif
%if %{with_xrootd}
%if %{?fedora}%{!?fedora:0} >= 17 || %{?rhel}%{!?rhel:0} >= 5
BuildRequires:	xrootd-client-devel
%else
BuildRequires:	xrootd-devel
%endif
%endif
%if %{with_gfal}
BuildRequires:	gfal2-devel
%endif
%if %{with_s3}
BuildRequires:	libs3-devel
%endif
%if %{?suse_version}%{!?suse_version:0} == 1110
BuildRequires:	db43-devel
%else
%if %{?fedora}%{!?fedora:0} >= 15 || %{?rhel}%{!?rhel:0} >= 7
BuildRequires:	libdb-cxx-devel
%else
%if %{?fedora}%{!?fedora:0} == 14
BuildRequires:	libdb-devel
%else
BuildRequires:	db4-devel
%endif
%endif
%endif
%if %{with_java}
BuildRequires:	java-devel >= 1.5.0
BuildRequires:	jpackage-utils
%if %{with_gcj}
BuildRequires:	java-gcj-compat-devel
%endif
%if %{with_junit}
BuildRequires:	junit
%endif
%endif
# Needed for Boinc backend testing during make check
BuildRequires:	perl(DBI)
# Needed for infoprovider testing during make check
BuildRequires:	perl(XML::Simple)
# Needed for LRMS testing during make check
BuildRequires:	perl(Test::Harness)
BuildRequires:	perl(Test::Simple)
BuildRequires:	mktemp
# Needed to run ACIX unit tests
%if %{with_acix}
%if %{?suse_version:1}%{!?suse_version:0}
BuildRequires:	python-twisted
%else
BuildRequires:	python-twisted-core
%endif
BuildRequires:	python-twisted-web
%if %{?suse_version:1}%{!?suse_version:0}
BuildRequires:	python-openssl
%else
BuildRequires:	pyOpenSSL
%endif
%if %{?rhel}%{!?rhel:0} == 5
BuildRequires:	python-hashlib
%endif
%endif
%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
# The compilation of the selinux module fails on Fedora 5
BuildRequires:	selinux-policy-devel
BuildRequires:	checkpolicy
%endif
BuildRequires:	swig
%if %{?suse_version:1}%{!?suse_version:0}
# Needed for python/doxy2swig.py
BuildRequires:	python-xml
%endif
%if %{?fedora}%{!?fedora:0} >= 4 || %{?rhel}%{!?rhel:0} >= 5
BuildRequires:	libtool-ltdl-devel
%else
BuildRequires:	libtool
%endif
%if %{with_sqlite}
BuildRequires:	sqlite-devel >= 3.6
%endif

%description
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

The Advanced Resource Connector (ARC) brings computing resources
together across institutional boundaries. This concept is commonly
referred to as a "computational grid". Historically, grids address the
organization of distributed storage of data and parallel computation,
but could be expanded to arbitrary services.

Just like the web, ARC has its roots in the IT infrastructure that was
erected to analyze the experiments for high energy physics at CERN.
The first release, ARC-0.x, was dependent on Globus, the current
release keeps that compatibility but can also be used independently.

%package client
Summary:	ARC command line interface
Group:		Applications/Internet
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}

%description client
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

For the regular user of any ARC-based computational grid,
this client package contains (or depends on) all packages
that are needed to submit jobs, query their status and
retrieve results.

%package hed
Summary:	ARC Hosting Environment Daemon
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%description hed
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

The ARC Hosting Environment Daemon (HED). This daemon is a container for
ARC services.

%package gridftpd
Summary:	ARC gridftp server
Group:		System Environment/Daemons
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-plugins-globus

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%description gridftpd
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the ARC gridftp server which has a plugin framework.
Current plugins include:

  fileplugin : Standard gridftp server based on Globus globus-ftp-control
  jobplugin  : Classical ARC job submission interface

%package cache-service
Summary:	ARC cache service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-hed = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%description cache-service
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the ARC cache service. It provides a way to perform
some operations on the A-REX cache remotely. It can be especially helpful
for data management within a pilot job framework.

%package datadelivery-service
Summary:	ARC data delivery service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-hed = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%description datadelivery-service
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the ARC data delivery service.

%package ldap-infosys
Summary:	ARC LDAP information service
Group:		System Environment/Libraries
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif
Requires:	openldap-servers
Requires:	glue-schema >= 2.0.10
Requires:	bdii

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%if %{?fedora}%{!?fedora:0} >= 23 || %{?rhel}%{!?rhel:0} >= 8
Requires(post):		policycoreutils-python-utils
Requires(postun):	policycoreutils-python-utils
%else
%if %{?fedora}%{!?fedora:0} >= 11 || %{?rhel}%{!?rhel:0} >= 6
Requires(post):		policycoreutils-python
Requires(postun):	policycoreutils-python
%else
%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
Requires(post):		policycoreutils
Requires(postun):	policycoreutils
%endif
%endif
%endif

%description ldap-infosys
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the LDAP based information system for ARC.
This package is not self-contained. it should be pulled in by either
nordugrid-arc-arex to be a part of a local information system or by
nordugrid-arc-egiis to be a part of a EGIIS service.

%package aris
Summary:	ARC local information system
Group:		System Environment/Libraries
Requires:	%{name}-ldap-infosys = %{version}-%{release}
Requires:	bdii
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif
Requires:	openldap-servers
Requires:	glue-schema >= 2.0.10
Requires:	bdii

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%if %{?fedora}%{!?fedora:0} >= 23 || %{?rhel}%{!?rhel:0} >= 8
Requires(post):		policycoreutils-python-utils
Requires(postun):	policycoreutils-python-utils
%else
%if %{?fedora}%{!?fedora:0} >= 11 || %{?rhel}%{!?rhel:0} >= 6
Requires(post):		policycoreutils-python
Requires(postun):	policycoreutils-python
%else
%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
Requires(post):		policycoreutils
Requires(postun):	policycoreutils
%endif
%endif
%endif

%description aris
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the LDAP based information system for ARC.
This package is not self-contained but is closely connected to
nordugrid-arc-arex.

%package egiis
Summary:	ARC EGIIS service
Group:		System Environment/Libraries
Requires:	%{name}-ldap-infosys = %{version}-%{release}
Requires:	openldap-servers
Requires:	glue-schema >= 2.0.10

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
Requires(post):		policycoreutils
Requires(postun):	policycoreutils
%endif

%description egiis
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

The EGIIS is the Information Index Service used by ARC, This service is
used to set up a ldap-based server that local information systems register
to.

%package ldap-monitor
Summary:	ARC LDAP monitor service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	php
Requires:	php-gd
Requires:	php-ldap
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description ldap-monitor
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the LDAP monitor system for ARC.
This package is self-contained. It is used to set up a web-based monitor
which pulls information from a EGIIS and shows it graphically.

%package ws-monitor
Summary:	ARC WS monitor service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description ws-monitor
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the WS monitor system for ARC.
This package is self-contained. It is used to set up a web-based monitor
which pulls information from ISIS and shows it graphically.

%package arex
Summary:	ARC Remote EXecution service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-hed = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}
%if %{with_python}
Requires:	%{name}-python = %{version}-%{release}
%endif
Requires:	mktemp
Requires:	python-twisted-core
Requires:	python-twisted-web
Requires:	stomppy
Requires:	python-ldap
Requires:	python-dirq
Requires:	%{name}-aris = %{version}-%{release}

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%description arex
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

The ARC Remote EXecution service (AREX) provides a service for the
execution of compute jobs and the transfer of input or output data.

%package plugins-needed
Summary:	ARC base plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}

%description plugins-needed
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

ARC base plugins. This includes the Message Chain Components (MCCs) and
Data Manager Components (DMCs).

%package plugins-globus
Summary:	ARC Globus plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
%if %{?fedora}%{!?fedora:0} >= 23 || %{?rhel}%{!?rhel:0} >= 5
Requires:	globus-gssapi-gsi >= 12.2
%else
Requires:	globus-gssapi-gsi < 12.2
%endif

%description plugins-globus
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

ARC Globus plugins. This includes the Globus dependent Data Manager
Components (DMCs).

%if %{with_canl}
%package arcproxyalt
Summary:	ARC proxy client based on canl
Group:		Applications/Internet
Requires:	%{name} = %{version}-%{release}

%description arcproxyalt
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package includes a preview of the arcproxy command based on canl.
%endif

%if %{with_xrootd}
%package plugins-xrootd
Summary:	ARC xrootd plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}

%description plugins-xrootd
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

ARC xrootd plugins. These allow access to data through the xrootd protocol.
%endif

%if %{with_gfal}
%package plugins-gfal
Summary:	ARC GFAL plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}

%description plugins-gfal
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

ARC plugins for GFAL2. This allows third-party transfer and adds support
for several extra transfer protocols (rfio, dcap, gsidcap). Specific
protocol support is provided by separate gfal2-plugin packages.
%endif

%if %{with_s3}
%package plugins-s3
Summary:	ARC S3 plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}

%description plugins-s3
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

ARC plugins for S3. These allow access to data through the S3 protocol.
%endif

%if %{with_acix}
%package acix-core
Summary:	ARC cache index - core
Group:		System Environment/Libraries
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif
Requires:	python-twisted-core
Requires:	python-twisted-web
Requires:	pyOpenSSL
%if %{?rhel}%{!?rhel:0} == 5
Requires:	python-hashlib
%endif

%description acix-core
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Core components of the ARC Cache Index (ACIX).

%package acix-cache
Summary:	ARC cache index - cache server
Group:		System Environment/Libraries
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif
Requires:	python-twisted-core
Requires:	python-twisted-web
Requires:	pyOpenSSL
%if %{?rhel}%{!?rhel:0} == 5
Requires:	python-hashlib
%endif
Requires:	%{name}-acix-core = %{version}-%{release}

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%description acix-cache
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Cache server component of the ARC Cache Index (ACIX), usually installed
alongside A-REX. This component collects information on the content of
an A-REX cache.

%package acix-index
Summary:	ARC cache index - index server
Group:		System Environment/Libraries
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif
Requires:	python-twisted-core
Requires:	python-twisted-web
Requires:	pyOpenSSL
%if %{?rhel}%{!?rhel:0} == 5
Requires:	python-hashlib
%endif
Requires:	%{name}-acix-core = %{version}-%{release}

Requires(post):		%{service_post_requires}
Requires(preun):	%{service_preun_requires}
Requires(postun):	%{service_postun_requires}

%description acix-index
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Index server component of the ARC Cache Index (ACIX), usually installed
independently of any A-REX installation. This component pulls cache content
from cache servers and can be queried by clients for the location of cached
files.
%endif

%package devel
Summary:	ARC development files
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{glibmm2_devel}
Requires:	glib2-devel
Requires:	libxml2-devel
Requires:	openssl-devel

%description devel
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Header files and libraries needed to develop applications using ARC.

%if %{with_python}
%package python
Summary:	ARC Python wrapper
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}

%description python
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Python bindings for ARC.
%endif

%if %{?rhel}%{!?rhel:0} == 5
%package python26
Summary:	ARC Python wrapper
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	python(abi) = 2.6

%description python26
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Python bindings for ARC.
%endif

%if %{?fedora}%{!?fedora:0} >= 13
%package python3
Summary:	ARC Python wrapper
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}

%description python3
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Python bindings for ARC.
%endif

%if %{with_java}
%package java
Summary:	ARC Java wrapper
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}
%if %{?fedora}%{!?fedora:0} >= 20 || %{?rhel}%{!?rhel:0} >= 7
Requires:	java-headless
%else
Requires:	java
%endif
Requires:	jpackage-utils
%if %{with_gcj}
Requires(post):		java-gcj-compat
Requires(postun):	java-gcj-compat
%endif

%description java
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Java bindings for ARC.
%endif

%package gridmap-utils
Summary:	NorduGrid authorization tools
Group:		Applications/Internet
Requires:	perl(Crypt::SSLeay)
Requires:	perl(SOAP::Lite)
Requires:	perl(Crypt::OpenSSL::X509)
Requires:	crontabs
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description gridmap-utils
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the ARC authorization machinery.
A prominent tool distributed in this package is the nordugridmap
script to collect user information from the virtual organizations.

%if %{with_cautils}
%package ca-utils
Summary:	NorduGrid authentication tools
Group:		Applications/Internet
Requires:	fetch-crl
Requires(post):	fetch-crl
Requires(post):	chkconfig
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description ca-utils
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

The nordugrid-arc-ca-utils packages has been obsoleted.
The functionality of the grid-update-crls tool is provided by the
fetch-crl tool in the fetch-crl package.
%endif

%package misc-utils
Summary:	NorduGrid misc tools
Group:		Applications/Internet
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}

%description misc-utils
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains utilities for various tasks including testing. The
package is usually not required by users or sysadmins but is mainly for
developers.

%prep
%setup -q -n %{name}-%{version}rc1

%if %{?fedora}%{!?fedora:0} <= 9 && %{?rhel}%{!?rhel:0} <= 5
# Older versions of SELinux does not have policy for open
cd selinux
sed -e 's/ open / /' -e /open/d -i %{name}-egiis.te
cd -
%endif

%build
%if %{?fedora}%{!?fedora:0} == 23
# Workaround for too new libsigc++/glibmm + too old gcc combo in Fedora 23
export CXXFLAGS="%{optflags} -std=c++11"
%endif

%configure --disable-static \
%if ! %{with_java}
     --disable-java \
%endif
%if ! %{with_python}
     --disable-swig-python \
%endif
%if ! %{with_acix}
     --disable-acix \
%endif
%if %{with_gfal}
     --enable-gfal \
%endif
%if %{with_s3}
     --enable-s3 \
%endif
%if %{?rhel}%{!?rhel:0} == 5
     --with-altpython=python26 \
%endif
%if %{?fedora}%{!?fedora:0} >= 13
     --with-altpython=python3 \
%endif
%if %{with_canl}
     --enable-canlxx \
%endif
%if ! %{with_xrootd}
     --disable-xrootd \
%endif
%if %{with_sqlite}
     --enable-sqlite \
%endif
%if %{use_systemd}
     --with-systemd-units-location=%{_unitdir} \
%endif
     --disable-doc \
     --with-docdir=%{_pkgdocdir} \
     --with-jnidir=%{_jnidir}

make %{?_smp_mflags}

%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
cd selinux
make -f /usr/share/selinux/devel/Makefile
cd -
%endif

%check
make check

%install
rm -rf $RPM_BUILD_ROOT

make install DESTDIR=$RPM_BUILD_ROOT

# Install Logrotate.
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d
install -p -m 644 debian/%{name}-arex.logrotate \
    $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}-arex
install -p -m 644 debian/%{name}-gridftpd.logrotate \
    $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}-gridftpd
install -p -m 644 debian/%{name}-aris.logrotate \
    $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}-aris
install -p -m 644 debian/%{name}-datadelivery-service.logrotate \
    $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}-datadelivery-service

find $RPM_BUILD_ROOT -type f -name \*.la -exec rm -fv '{}' ';'

# The py-compile script in the source tarball is old (RHEL 6)
# It does the wrong thing for python 3 - remove and let rpmbuild do it right
find $RPM_BUILD_ROOT -type f -name \*.pyc -exec rm -fv '{}' ';'
find $RPM_BUILD_ROOT -type f -name \*.pyo -exec rm -fv '{}' ';'

# libarcglobusutils is not part of the ARC api.
find $RPM_BUILD_ROOT -name libarcglobusutils.so -exec rm -fv '{}' ';'

# Create log directory
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/arc

# Create spool directories for Jura
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/spool/arc
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/spool/arc/ssm
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/spool/arc/urs

%find_lang %{name}

%if %{with_java} && %{with_gcj}
%{_bindir}/aot-compile-rpm
%endif

%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
cd selinux
mkdir -p $RPM_BUILD_ROOT%{_datadir}/selinux/packages/%{name}
install -p -m 644 %{name}-egiis.pp \
    $RPM_BUILD_ROOT%{_datadir}/selinux/packages/%{name}
cd -
%endif

%if %{?rhel}%{!?rhel:0} == 5
%{__python}    -c 'import compileall; compileall.compile_dir("'"$RPM_BUILD_ROOT"'", 10, "%{python_sitearch}", 1)' > /dev/null
%{__python} -O -c 'import compileall; compileall.compile_dir("'"$RPM_BUILD_ROOT"'", 10, "%{python_sitearch}", 1)' > /dev/null
%{__python26}	 -c 'import compileall; compileall.compile_dir("'"$RPM_BUILD_ROOT%{python26_sitearch}"'", 10, "%{python26_sitearch}", 1)' > /dev/null
%{__python26} -O -c 'import compileall; compileall.compile_dir("'"$RPM_BUILD_ROOT%{python26_sitearch}"'", 10, "%{python26_sitearch}", 1)' > /dev/null
%endif

# Remove examples and let RPM package them under /usr/share/doc using the doc macro
rm -rf $RPM_BUILD_ROOT%{_datadir}/%{pkgdir}/examples
make -C src/libs/data-staging/examples	DESTDIR=$PWD/docdir/devel  pkgdatadir= install-exampleDATA
make -C src/hed/libs/compute/examples	DESTDIR=$PWD/docdir/devel  pkgdatadir= install-exampleDATA
make -C src/hed/libs/data/examples	DESTDIR=$PWD/docdir/devel  pkgdatadir= install-exampleDATA
make -C src/hed/acc/PythonBroker	DESTDIR=$PWD/docdir/python pkgdatadir= install-exampleDATA
make -C python/examples			DESTDIR=$PWD/docdir/python pkgdatadir= install-exampleDATA
make -C java/examples			DESTDIR=$PWD/docdir/java   pkgdatadir= install-exampleDATA
make -C src/clients			DESTDIR=$PWD/docdir/client pkgdatadir= install-exampleDATA
make -C src/tests/echo			DESTDIR=$PWD/docdir/hed	   pkgdatadir= install-exampleDATA
make -C src/hed				DESTDIR=$PWD/docdir/hed	   pkgdatadir= install-profileDATA

# arc.conf.reference needs special handling
make -C src/doc DESTDIR=$RPM_BUILD_ROOT install-exampleDATA

# Link to arc.conf.reference from doc
rm -f $PWD/docdir/arc.conf.reference
ln -s %{_datadir}/%{pkgdir}/examples/arc.conf.reference $PWD/docdir/arc.conf.reference

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%post plugins-globus -p /sbin/ldconfig

%postun plugins-globus -p /sbin/ldconfig

%post hed
%enable_service arched

%preun hed
%stop_on_removal arched

%postun hed
%condrestart_on_update arched

%post arex
%enable_service a-rex

%preun arex
%stop_on_removal a-rex

%postun arex
%condrestart_on_update a-rex

%post gridftpd
%enable_service gridftpd

%preun gridftpd
%stop_on_removal gridftpd

%postun gridftpd
%condrestart_on_update gridftpd

%post cache-service
%enable_service arc-cache-service

%preun cache-service
%stop_on_removal arc-cache-service

%postun cache-service
%condrestart_on_update arc-cache-service

%post datadelivery-service
%enable_service arc-datadelivery-service

%preun datadelivery-service
%stop_on_removal arc-datadelivery-service

%postun datadelivery-service
%condrestart_on_update arc-datadelivery-service

%post ldap-infosys
%enable_service nordugrid-arc-slapd nordugrid-arc-inforeg

%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
semanage port -a -t ldap_port_t -p tcp 2135 2>/dev/null || :
semanage fcontext -a -t slapd_etc_t "/var/run/arc/infosys/bdii-slapd\.conf" 2>/dev/null || :
%endif

%preun ldap-infosys
%stop_on_removal nordugrid-arc-slapd nordugrid-arc-inforeg

%postun ldap-infosys
%condrestart_on_update nordugrid-arc-slapd nordugrid-arc-inforeg

%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
if [ $1 -eq 0 ]; then
  semanage port -d -t ldap_port_t -p tcp 2135 2>/dev/null || :
  semanage fcontext -d -t slapd_etc_t "/var/run/arc/infosys/bdii-slapd\.conf" 2>/dev/null || :
fi
%endif

%post aris
%enable_service nordugrid-arc-bdii

%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
semanage fcontext -a -t slapd_db_t "/var/lib/arc/bdii/db(/.*)?" 2>/dev/null || :
semanage fcontext -a -t slapd_var_run_t "/var/run/arc/bdii/db(/.*)?" 2>/dev/null || :
# Remove selinux labels for old arc bdii var dir
semanage fcontext -d -t slapd_db_t "/var/run/arc/bdii(/.*)?" 2>/dev/null || :
%endif

%preun aris
%stop_on_removal nordugrid-arc-bdii

%postun aris
%condrestart_on_update nordugrid-arc-bdii

%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
if [ $1 -eq 0 ]; then
  semanage fcontext -d -t slapd_db_t "/var/lib/arc/bdii/db(/.*)?" 2>/dev/null || :
  semanage fcontext -d -t slapd_var_run_t "/var/run/arc/bdii/db(/.*)?" 2>/dev/null || :
fi
%endif

%triggerun aris -- bdii
%if %{?suse_version:1}%{!?suse_version:0}
FIRST_ARG=1
%restart_on_update nordugrid-arc-bdii
%else
service nordugrid-arc-bdii condrestart > /dev/null 2>&1 || :
%endif

%post egiis
%enable_service nordugrid-arc-egiis

%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
/usr/sbin/semodule -i %{_datadir}/selinux/packages/%{name}/%{name}-egiis.pp > /dev/null 2>&1 || :
/sbin/restorecon %{_sbindir}/arc-infoindex-relay
%endif

%preun egiis
%stop_on_removal nordugrid-arc-egiis

%postun egiis
%condrestart_on_update nordugrid-arc-egiis

%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
if [ $1 -eq 0 ] ; then
  /usr/sbin/semodule -r %{name}-egiis > /dev/null 2>&1 || :
fi
%endif

%if %{with_acix}
%post acix-cache
%enable_service acix-cache

%preun acix-cache
%stop_on_removal acix-cache

%postun acix-cache
%condrestart_on_update acix-cache

%post acix-index
%enable_service acix-index

%preun acix-index
%stop_on_removal acix-index

%postun acix-index
%condrestart_on_update acix-index
%endif

%if %{with_java} && %{with_gcj}
%post java
[ -x %{_bindir}/rebuild-gcj-db ] && %{_bindir}/rebuild-gcj-db
%endif

%if %{with_java} && %{with_gcj}
%postun java
[ -x %{_bindir}/rebuild-gcj-db ] && %{_bindir}/rebuild-gcj-db
%endif

%if %{with_cautils}
%post ca-utils
# Enable and start CRL updates via cron for backward compatibility
/sbin/chkconfig fetch-crl-cron on
service fetch-crl-cron start > /dev/null 2>&1
%endif

%files -f %{name}.lang
%defattr(-,root,root,-)
%doc docdir/arc.conf.reference README AUTHORS LICENSE NOTICE ChangeLog
%dir %{_libdir}/%{pkgdir}
%dir %{_libexecdir}/%{pkgdir}
%{_libdir}/libarccompute.so.*
%{_libdir}/libarccommunication.so.*
%{_libdir}/libarccommon.so.*
%{_libdir}/libarccredential.so.*
%{_libdir}/libarccredentialstore.so.*
%{_libdir}/libarccrypto.so.*
%{_libdir}/libarcdata.so.*
%{_libdir}/libarcdatastaging.so.*
%{_libdir}/%{pkgdir}/DataStagingDelivery
%{_libdir}/libarcloader.so.*
%{_libdir}/libarcmessage.so.*
%{_libdir}/libarcsecurity.so.*
%{_libdir}/libarcinfosys.so.*
%{_libdir}/libarcws.so.*
%{_libdir}/libarcwssecurity.so.*
%if %{with_xmlsec1}
%{_libdir}/libarcxmlsec.so.*
%endif
# We need to have libmodcrypto.so close to libarccrypto
%{_libdir}/%{pkgdir}/libmodcrypto.so
%{_libdir}/%{pkgdir}/libmodcrypto.apd
# We need to have libmodcredential.so close to libarccredential
%{_libdir}/%{pkgdir}/libmodcredential.so
%{_libdir}/%{pkgdir}/libmodcredential.apd
%{_libdir}/%{pkgdir}/arc-file-access
%dir %{_datadir}/%{pkgdir}/examples
%{_datadir}/%{pkgdir}/examples/arc.conf.reference
%dir %{_datadir}/%{pkgdir}/test-jobs
%{_datadir}/%{pkgdir}/test-jobs/test-job-*
%{_datadir}/%{pkgdir}/schema
%dir %{_datadir}/%{pkgdir}

%files client
%defattr(-,root,root,-)
%doc docdir/client/*
%{_bindir}/arccat
%{_bindir}/arcclean
%{_bindir}/arccp
%{_bindir}/arcecho
%{_bindir}/arcget
%{_bindir}/arcinfo
%{_bindir}/arckill
%{_bindir}/arcls
%{_bindir}/arcmkdir
%{_bindir}/arcrename
%{_bindir}/arcproxy
%{_bindir}/arcrenew
%{_bindir}/arcresub
%{_bindir}/arcresume
%{_bindir}/arcrm
%{_bindir}/arcstat
%{_bindir}/arcsub
%{_bindir}/arcsync
%{_bindir}/arctest
%dir %{_sysconfdir}/%{pkgdir}
%config(noreplace) %{_sysconfdir}/%{pkgdir}/client.conf
%doc %{_mandir}/man1/arccat.1*
%doc %{_mandir}/man1/arcclean.1*
%doc %{_mandir}/man1/arccp.1*
%doc %{_mandir}/man1/arcecho.1*
%doc %{_mandir}/man1/arcget.1*
%doc %{_mandir}/man1/arcinfo.1*
%doc %{_mandir}/man1/arckill.1*
%doc %{_mandir}/man1/arcls.1*
%doc %{_mandir}/man1/arcmkdir.1*
%doc %{_mandir}/man1/arcrename.1*
%doc %{_mandir}/man1/arcproxy.1*
%doc %{_mandir}/man1/arcrenew.1*
%doc %{_mandir}/man1/arcresub.1*
%doc %{_mandir}/man1/arcresume.1*
%doc %{_mandir}/man1/arcrm.1*
%doc %{_mandir}/man1/arcstat.1*
%doc %{_mandir}/man1/arcsub.1*
%doc %{_mandir}/man1/arcsync.1*
%doc %{_mandir}/man1/arctest.1*

%files hed
%defattr(-,root,root,-)
%doc docdir/hed/*
%if %{use_systemd}
%{_unitdir}/arched.service
%{_datadir}/%{pkgdir}/arched-start
%else
%{_initrddir}/arched
%endif
%{_sbindir}/arched
%{_libdir}/%{pkgdir}/libecho.so
%{_libdir}/%{pkgdir}/libecho.apd
%{_datadir}/%{pkgdir}/profiles
%doc %{_mandir}/man8/arched.8*
%doc %{_mandir}/man5/arc.conf.5*

%files gridftpd
%defattr(-,root,root,-)
%if %{use_systemd}
%{_unitdir}/gridftpd.service
%{_datadir}/%{pkgdir}/gridftpd-start
%else
%{_initrddir}/gridftpd
%endif
%{_sbindir}/gridftpd
%{_libdir}/%{pkgdir}/jobplugin.*
%{_libdir}/%{pkgdir}/fileplugin.*
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-gridftpd
%doc %{_mandir}/man8/gridftpd.8*

%files ldap-infosys
%defattr(-,root,root,-)
%if %{use_systemd}
%{_unitdir}/nordugrid-arc-slapd.service
%{_unitdir}/nordugrid-arc-inforeg.service
%else
%{_initrddir}/nordugrid-arc-ldap-infosys
%{_initrddir}/nordugrid-arc-slapd
%{_initrddir}/nordugrid-arc-inforeg
%endif
%{_datadir}/%{pkgdir}/create-slapd-config
%{_datadir}/%{pkgdir}/create-inforeg-config
%{_datadir}/%{pkgdir}/config_parser_compat.sh
%{_datadir}/%{pkgdir}/grid-info-soft-register
%{_datadir}/%{pkgdir}/ldap-schema

%files aris
%defattr(-,root,root,-)
%if %{use_systemd}
%{_unitdir}/nordugrid-arc-bdii.service
%else
%{_initrddir}/nordugrid-arc-bdii
%endif
%{_datadir}/%{pkgdir}/create-bdii-config
%{_datadir}/%{pkgdir}/glue-generator.pl
%{_datadir}/%{pkgdir}/glite-info-provider-ldap
%{_datadir}/%{pkgdir}/se.pl
%{_datadir}/%{pkgdir}/PerfData.pl
%{_datadir}/%{pkgdir}/Shared.pm
%{_datadir}/%{pkgdir}/ConfigParser.pm
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-aris

%files egiis
%defattr(-,root,root,-)
%if %{use_systemd}
%{_unitdir}/nordugrid-arc-egiis.service
%else
%{_initrddir}/nordugrid-arc-egiis
%endif
%{_sbindir}/arc-infoindex-relay
%{_sbindir}/arc-infoindex-server
%{_mandir}/man8/arc-infoindex-relay.8*
%{_mandir}/man8/arc-infoindex-server.8*
%{_libdir}/%{pkgdir}/arc-infoindex-slapd-wrapper.so
%{_libdir}/%{pkgdir}/arc-infoindex-slapd-wrapper.apd
%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
%{_datadir}/selinux/packages/%{name}
%endif

%files ldap-monitor
%defattr(-,root,root,-)
%{_datadir}/%{pkgdir}/ldap-monitor
%doc %{_mandir}/man7/ldap-monitor.7*

%files ws-monitor
%defattr(-,root,root,-)
%{_datadir}/%{pkgdir}/ws-monitor
%doc %{_mandir}/man7/ws-monitor.7*

%files cache-service
%defattr(-,root,root,-)
%if %{use_systemd}
%{_unitdir}/arc-cache-service.service
%{_datadir}/%{pkgdir}/arc-cache-service-start
%else
%{_initrddir}/arc-cache-service
%endif
%{_libdir}/%{pkgdir}/libcacheservice.so
%{_libdir}/%{pkgdir}/libcacheservice.apd

%files datadelivery-service
%defattr(-,root,root,-)
%if %{use_systemd}
%{_unitdir}/arc-datadelivery-service.service
%{_datadir}/%{pkgdir}/arc-datadelivery-service-start
%else
%{_initrddir}/arc-datadelivery-service
%endif
%{_libdir}/%{pkgdir}/libdatadeliveryservice.so
%{_libdir}/%{pkgdir}/libdatadeliveryservice.apd
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-datadelivery-service

%files arex
%defattr(-,root,root,-)
%if %{use_systemd}
%{_unitdir}/a-rex.service
%{_datadir}/%{pkgdir}/a-rex-start
%else
%{_initrddir}/a-rex
%endif
%{_libexecdir}/%{pkgdir}/cache-clean
%{_libexecdir}/%{pkgdir}/cache-list
%{_libexecdir}/%{pkgdir}/jura
%{_libexecdir}/%{pkgdir}/downloader
%if %{with_sqlite}
%{_libexecdir}/%{pkgdir}/gm-delegations-converter
%doc %{_mandir}/man8/gm-delegations-converter.8*
%endif
%{_libexecdir}/%{pkgdir}/gm-jobs
%{_libexecdir}/%{pkgdir}/gm-kick
%{_libexecdir}/%{pkgdir}/smtp-send
%{_libexecdir}/%{pkgdir}/smtp-send.sh
%{_libexecdir}/%{pkgdir}/uploader
%{_libexecdir}/%{pkgdir}/inputcheck
%{_libexecdir}/%{pkgdir}/arc-vomsac-check
%{_libexecdir}/%{pkgdir}/arc-config-check
%{_libexecdir}/%{pkgdir}/arc-blahp-logger
%{_datadir}/%{pkgdir}/cancel-*-job
%{_datadir}/%{pkgdir}/scan-*-job
%{_datadir}/%{pkgdir}/submit-*-job
%{_datadir}/%{pkgdir}/DGAuthplug.py*
%{_datadir}/%{pkgdir}/DGBridgeDataPlugin.py*
%{_datadir}/%{pkgdir}/DGLog2XML.py*
%{_libdir}/%{pkgdir}/libarex.so
%{_libdir}/%{pkgdir}/libarex.apd
%{_datadir}/%{pkgdir}/CEinfo.pl
%{_datadir}/%{pkgdir}/ARC0mod.pm
%{_datadir}/%{pkgdir}/FORKmod.pm
%{_datadir}/%{pkgdir}/Fork.pm
%{_datadir}/%{pkgdir}/SGEmod.pm
%{_datadir}/%{pkgdir}/SGE.pm
%{_datadir}/%{pkgdir}/LL.pm
%{_datadir}/%{pkgdir}/LSF.pm
%{_datadir}/%{pkgdir}/PBS.pm
%{_datadir}/%{pkgdir}/Condor.pm
%{_datadir}/%{pkgdir}/SLURMmod.pm
%{_datadir}/%{pkgdir}/SLURM.pm
%{_datadir}/%{pkgdir}/DGBridge.pm
%{_datadir}/%{pkgdir}/Boinc.pm
%{_datadir}/%{pkgdir}/XmlPrinter.pm
%{_datadir}/%{pkgdir}/InfosysHelper.pm
%{_datadir}/%{pkgdir}/LdifPrinter.pm
%{_datadir}/%{pkgdir}/GLUE2xmlPrinter.pm
%{_datadir}/%{pkgdir}/GLUE2ldifPrinter.pm
%{_datadir}/%{pkgdir}/NGldifPrinter.pm
%{_datadir}/%{pkgdir}/ARC0ClusterInfo.pm
%{_datadir}/%{pkgdir}/ARC1ClusterInfo.pm
%{_datadir}/%{pkgdir}/ConfigCentral.pm
%{_datadir}/%{pkgdir}/GMJobsInfo.pm
%{_datadir}/%{pkgdir}/HostInfo.pm
%{_datadir}/%{pkgdir}/RTEInfo.pm
%{_datadir}/%{pkgdir}/InfoChecker.pm
%{_datadir}/%{pkgdir}/IniParser.pm
%{_datadir}/%{pkgdir}/LRMSInfo.pm
%{_datadir}/%{pkgdir}/Sysinfo.pm
%{_datadir}/%{pkgdir}/LogUtils.pm
%{_datadir}/%{pkgdir}/condor_env.pm
%{_datadir}/%{pkgdir}/cancel_common.sh
%{_datadir}/%{pkgdir}/config_parser.sh
%{_datadir}/%{pkgdir}/configure-*-env.sh
%{_datadir}/%{pkgdir}/submit_common.sh
%{_datadir}/%{pkgdir}/scan_common.sh
%{_datadir}/%{pkgdir}/perferator
%doc %{_mandir}/man1/cache-clean.1*
%doc %{_mandir}/man1/cache-list.1*
%doc %{_mandir}/man1/jura.1*
%doc %{_mandir}/man8/gm-jobs.8*
%doc %{_mandir}/man1/arc-config-check.1*
%doc %{_mandir}/man8/arc-vomsac-check.8*
%doc %{_mandir}/man8/arc-blahp-logger.8*
%doc %{_mandir}/man8/a-rex-backtrace-collect.8*
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-arex
%dir %{_localstatedir}/log/arc
%dir %{_localstatedir}/spool/arc
%dir %{_localstatedir}/spool/arc/ssm
%dir %{_localstatedir}/spool/arc/urs
%{_libexecdir}/%{pkgdir}/ssmsend
%dir %{_datadir}/%{pkgdir}/ssm
%{_datadir}/%{pkgdir}/ssm/__init__.py*
%{_datadir}/%{pkgdir}/ssm/crypto.py*
%{_datadir}/%{pkgdir}/ssm/ssm2.py*
%{_datadir}/%{pkgdir}/ssm/brokers.py*
%{_datadir}/%{pkgdir}/ssm/sender.cfg
%{_sbindir}/a-rex-backtrace-collect

%if %{with_acix}
%files acix-core
%defattr(-,root,root,-)
%dir %{python_sitelib}/acix
%{python_sitelib}/acix/__init__.py*
%{python_sitelib}/acix/core

%files acix-cache
%defattr(-,root,root,-)
%{python_sitelib}/acix/cacheserver
%if %{use_systemd}
%{_unitdir}/acix-cache.service
%{_datadir}/%{pkgdir}/acix-cache-start
%else
%{_initrddir}/acix-cache
%endif

%files acix-index
%defattr(-,root,root,-)
%{python_sitelib}/acix/indexserver
%if %{use_systemd}
%{_unitdir}/acix-index.service
%{_datadir}/%{pkgdir}/acix-index-start
%else
%{_initrddir}/acix-index
%endif
%endif

%files devel
%defattr(-,root,root,-)
%doc docdir/devel/* src/hed/shc/arcpdp/*.xsd
%{_includedir}/%{pkgdir}
%{_libdir}/lib*.so
%{_bindir}/wsdl2hed
%doc %{_mandir}/man1/wsdl2hed.1*
%{_bindir}/arcplugin
%doc %{_mandir}/man1/arcplugin.1*
%{_libdir}/pkgconfig/arcbase.pc

%files plugins-needed
%defattr(-,root,root,-)
%dir %{_libdir}/%{pkgdir}/test
%{_libdir}/%{pkgdir}/test/libaccTEST.so
%{_libdir}/%{pkgdir}/libaccARC1.so
%{_libdir}/%{pkgdir}/libaccBroker.so
%{_libdir}/%{pkgdir}/libaccCREAM.so
%{_libdir}/%{pkgdir}/libaccEMIES.so
%{_libdir}/%{pkgdir}/libaccJobDescriptionParser.so
%{_libdir}/%{pkgdir}/libaccSER.so
%{_libdir}/%{pkgdir}/libaccldap.so
%{_libdir}/%{pkgdir}/libarcshc.so
%{_libdir}/%{pkgdir}/libarcshclegacy.so
%{_libdir}/%{pkgdir}/libdmcfile.so
%{_libdir}/%{pkgdir}/libdmchttp.so
%{_libdir}/%{pkgdir}/libdmcldap.so
%{_libdir}/%{pkgdir}/libdmcsrm.so
%{_libdir}/%{pkgdir}/libdmcrucio.so
%{_libdir}/%{pkgdir}/libdmcacix.so
%{_libdir}/%{pkgdir}/libidentitymap.so
%{_libdir}/%{pkgdir}/libarguspdpclient.so
%{_libdir}/%{pkgdir}/libmcchttp.so
%{_libdir}/%{pkgdir}/libmccmsgvalidator.so
%{_libdir}/%{pkgdir}/libmccsoap.so
%{_libdir}/%{pkgdir}/libmcctcp.so
%{_libdir}/%{pkgdir}/libmcctls.so
%{_libdir}/%{pkgdir}/libaccARC1.apd
%{_libdir}/%{pkgdir}/libaccBroker.apd
%{_libdir}/%{pkgdir}/libaccCREAM.apd
%{_libdir}/%{pkgdir}/libaccEMIES.apd
%{_libdir}/%{pkgdir}/libaccJobDescriptionParser.apd
%{_libdir}/%{pkgdir}/libaccSER.apd
%{_libdir}/%{pkgdir}/libaccldap.apd
%{_libdir}/%{pkgdir}/test/libaccTEST.apd
%{_libdir}/%{pkgdir}/libarcshc.apd
%{_libdir}/%{pkgdir}/libarcshclegacy.apd
%{_libdir}/%{pkgdir}/libdmcfile.apd
%{_libdir}/%{pkgdir}/libdmchttp.apd
%{_libdir}/%{pkgdir}/libdmcldap.apd
%{_libdir}/%{pkgdir}/libdmcsrm.apd
%{_libdir}/%{pkgdir}/libdmcrucio.apd
%{_libdir}/%{pkgdir}/libdmcacix.apd
%{_libdir}/%{pkgdir}/libidentitymap.apd
%{_libdir}/%{pkgdir}/libarguspdpclient.apd
%{_libdir}/%{pkgdir}/libmcchttp.apd
%{_libdir}/%{pkgdir}/libmccsoap.apd
%{_libdir}/%{pkgdir}/libmcctcp.apd
%{_libdir}/%{pkgdir}/libmccmsgvalidator.apd
%{_libdir}/%{pkgdir}/libmcctls.apd

%files plugins-globus
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libaccARC0.so
%{_libdir}/%{pkgdir}/libdmcgridftp.so
%{_libdir}/%{pkgdir}/libaccARC0.apd
%{_libdir}/%{pkgdir}/libdmcgridftp.apd
%{_libdir}/libarcglobusutils.so.*
%{_libexecdir}/%{pkgdir}/arc-lcas
%{_libexecdir}/%{pkgdir}/arc-lcmaps

%if %{with_canl}
%files arcproxyalt
%defattr(-,root,root,-)
%{_bindir}/arcproxyalt
%endif

%if %{with_xrootd}
%files plugins-xrootd
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libdmcxrootd.so
%{_libdir}/%{pkgdir}/libdmcxrootd.apd
%endif

%if %{with_gfal}
%files plugins-gfal
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libdmcgfal.so
%{_libdir}/%{pkgdir}/libdmcgfal.apd
%endif

%if %{with_s3}
%files plugins-s3
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libdmcs3.so
%{_libdir}/%{pkgdir}/libdmcs3.apd
%endif

%if %{with_python}
%files python
%defattr(-,root,root,-)
%doc docdir/python/*
%{python_sitearch}/_arc.*so
%{python_sitearch}/arc
%{_libdir}/%{pkgdir}/libaccPythonBroker.so
%{_libdir}/%{pkgdir}/libaccPythonBroker.apd
%{_libdir}/%{pkgdir}/libpythonservice.so
%{_libdir}/%{pkgdir}/libpythonservice.apd
%endif

%if %{?rhel}%{!?rhel:0} == 5
%files python26
%defattr(-,root,root,-)
%{python26_sitearch}/_arc.*so
%{python26_sitearch}/arc
%endif

%if %{?fedora}%{!?fedora:0} >= 13
%files python3
%defattr(-,root,root,-)
%{python3_sitearch}/_arc.*so
%{python3_sitearch}/arc
%endif

%if %{with_java}
%files java
%defattr(-,root,root,-)
%doc docdir/java/*
%{_libdir}/%{pkgdir}/libjarc.so
%{_jnidir}/arc.jar
%{_libdir}/%{pkgdir}/libjavaservice.so
%{_libdir}/%{pkgdir}/libjavaservice.apd
%if %{with_gcj}
%{_libdir}/gcj/%{name}
%endif
%endif

%files gridmap-utils
%defattr(-,root,root,-)
%{_sbindir}/nordugridmap
%config(noreplace) %{_sysconfdir}/cron.d/nordugridmap
%doc src/utils/gridmap/nordugridmap.conf
%doc %{_mandir}/man8/nordugridmap.8*

%if %{with_cautils}
%files ca-utils
%defattr(-,root,root,-)
%endif

%files misc-utils
%defattr(-,root,root,-)
%{_bindir}/arcemiestest
%{_bindir}/arcwsrf
%{_bindir}/arcperftest
%if %{with_xmlsec1}
%{_bindir}/saml_assertion_init
%doc %{_mandir}/man1/saml_assertion_init.1*
%endif
%doc %{_mandir}/man1/arcemiestest.1*
%doc %{_mandir}/man1/arcwsrf.1*
%doc %{_mandir}/man1/arcperftest.1*

%changelog
* Sat Nov 19 2016 Anders Waananen <waananen@nbi.dk> - 5.3.0-0.rc1
- 5.3.0 Release candidate 1

* Tue Oct 25 2016 Anders Waananen <waananen@nbi.dk> - 5.2.0-1
- 5.2.0 Final Release

* Wed Aug 24 2016 Anders Waananen <waananen@nbi.dk> - 5.1.3-1
- 5.1.3 Final Release

* Fri Jul 01 2016 Anders Waananen <waananen@nbi.dk> - 5.1.2-1
- 5.1.2 Final Release

* Wed May 25 2016 Anders Waananen <waananen@nbi.dk> - 5.1.1-1
- 5.1.1 Final Release

* Thu May 19 2016 Anders Waananen <waananen@nbi.dk> - 5.1.0-1
- 5.1.0 Final Release

* Fri Jan 08 2016 Anders Waananen <waananen@nbi.dk> - 5.0.5-1
- 5.0.5 Final Release

* Thu Nov 19 2015 Anders Waananen <waananen@nbi.dk> - 5.0.4-1
- 5.0.4 Final Release

* Sun Sep 27 2015 Anders Waananen <waananen@nbi.dk> - 5.0.3-1
- 5.0.3 Final Release

* Mon Jun 29 2015 Anders Waananen <waananen@nbi.dk> - 5.0.2-1
- 5.0.2 Final Release

* Thu Jun 25 2015 Anders Waananen <waananen@nbi.dk> - 5.0.1-1
- 5.0.1 Final Release

* Fri Mar 27 2015 Anders Waananen <waananen@nbi.dk> - 5.0.0-1
- 5.0.0 Final Release

* Thu Mar 19 2015 Anders Waananen <waananen@nbi.dk> - 5.0.0-0.rc5
- 5.0.0 Release candidate 5

* Wed Feb 18 2015 Anders Waananen <waananen@nbi.dk> - 5.0.0-0.rc4
- 5.0.0 Release candidate 4

* Fri Feb 06 2015 Anders Waananen <waananen@nbi.dk> - 5.0.0-0.rc3
- 5.0.0 Release candidate 3

* Thu Feb 05 2015 Anders Waananen <waananen@nbi.dk> - 5.0.0-0.rc2
- 5.0.0 Release candidate 2

* Thu Jan 08 2015 Anders Waananen <waananen@nbi.dk> - 5.0.0-0.rc1
- 5.0.0 Release candidate 1

* Thu Aug 14 2014 Anders Waananen <waananen@nbi.dk> - 4.2.0-1
- 4.2.0 Final release

* Tue Apr 29 2014 Anders Waananen <waananen@nbi.dk> - 4.1.0-1
- 4.1.0 Final release

* Mon Mar 24 2014 Anders Waananen <waananen@nbi.dk> - 4.1.0-0.rc1
- 4.1.0 Release candidate 1

* Wed Nov 27 2013 Anders Waananen <waananen@nbi.dk> - 4.0.0-1
- 4.0.0 Final Release

* Wed Nov 06 2013 Anders Waananen <waananen@nbi.dk> - 4.0.0-0.rc2
- 4.0.0 release candidate 2

* Wed Oct 23 2013 Anders Waananen <waananen@nbi.dk> - 4.0.0-0.rc1
- 4.0.0 release candidate 1

* Fri Jul 19 2013 Anders Waananen <waananen@nbi.dk> - 3.0.3-1
- 3.0.3 Final Release

* Wed Jun 12 2013 Anders Waananen <waananen@nbi.dk> - 3.0.2-1
- 3.0.2 Final Release

* Mon Apr 29 2013 Anders Waananen <waananen@nbi.dk> - 3.0.1-1
- 3.0.1 Final Release

* Fri Apr 12 2013 Anders Waananen <waananen@nbi.dk> - 3.0.1-0.rc2
- 3.0.1 release candidate 2

* Fri Apr 12 2013 Anders Waananen <waananen@nbi.dk> - 3.0.1-0.rc1
- 3.0.1 release candidate 1

* Fri Feb 22 2013 Anders Waananen <waananen@nbi.dk> - 3.0.0-1
- 3.0.0 Final Release

* Wed Feb 20 2013 Anders Waananen <waananen@nbi.dk> - 3.0.0-0.rc6
- 3.0.0 release candidate 6

* Wed Feb 06 2013 Anders Waananen <waananen@nbi.dk> - 3.0.0-0.rc5
- 3.0.0 release candidate 5

* Sat Feb 02 2013 Anders Waananen <waananen@nbi.dk> - 3.0.0-0.rc4
- 3.0.0 release candidate 4

* Wed Jan 30 2013 Anders Waananen <waananen@nbi.dk> - 3.0.0-0.rc3
- 3.0.0 release candidate 3

* Mon Jan 28 2013 Anders Waananen <waananen@nbi.dk> - 3.0.0-0.rc2
- 3.0.0 release candidate 2

* Thu Dec 06 2012 Anders Waananen <waananen@nbi.dk> - 3.0.0-0.rc1
- 3.0.0 release candidate 1

* Thu Nov 08 2012 Anders Waananen <waananen@nbi.dk> - 2.0.1-1
- 2.0.1 Final Release

* Thu Oct 25 2012 Anders Waananen <waananen@nbi.dk> - 2.0.1-0.rc2
- 2.0.1 release candidate 2

* Fri Aug 24 2012 Anders Waananen <waananen@nbi.dk> - 2.0.1-0.rc1
- 2.0.1 release candidate 1

* Wed May 23 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 2.0.0-1
- 2.0.0 Final Release

* Wed Apr 11 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 2.0.0-0.rc4.1
- 2.0.0 release candidate 4.1

* Mon Apr 02 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 2.0.0-0.rc4
- 2.0.0 release candidate 4

* Thu Mar 29 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 2.0.0-0.rc3.2
- 2.0.0 release candidate 3.2

* Tue Mar 27 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 2.0.0-0.rc3.1
- 2.0.0 release candidate 3.1

* Mon Mar 05 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 2.0.0-0.rc3
- 2.0.0 release candidate 3

* Wed Feb 15 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 2.0.0-0.rc2
- 2.0.0 release candidate 2

* Wed Feb 15 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.1-1
- 1.1.1 Final Release

* Mon Oct 03 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-1
- 1.1.0 Final Release

* Sun Sep 25 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc2
- 1.1.0 release candidate 2

* Sun Sep 11 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc1
- 1.1.0 release candidate 1

* Sat Jul 23 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.1-1
- 1.0.1 Final Release

* Tue Jul 19 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.1-0.rc4
- 1.0.1 release candidate 4

* Sat Jun 18 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.1-0.rc1
- 1.0.1 release candidate 1

* Mon Apr 18 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-1
- 1.0.0 Final Release

* Wed Apr 06 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.b5
- 1.0.0 beta 5

* Wed Mar 23 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.b4
- 1.0.0 beta 4

* Thu Mar 10 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.b3
- 1.0.0 beta 3

* Mon Mar 07 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.b2
- 1.0.0 Beta 2

* Mon Feb 14 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.b1
- rename nordugrid-arc-nox → nordugrid-arc
- 1.0.0 Beta 1

* Tue Dec 21 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.2.1-1
- 1.2.1 Final Release

* Tue Dec 21 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.2.1-0.rc2
- 1.2.1 Release Candidate 2

* Wed Dec 08 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.2.1-0.rc1
- 1.2.1 Release Candidate 1

* Fri Oct 22 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.2.0-1
- 1.2.0 Final Release

* Thu Sep 30 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.2.0-0.rc2
- 1.2.0 Release Candidate 2

* Mon Sep 13 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.2.0-0.rc1
- 1.2.0 Release Candidate 1

* Wed May 05 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-1
- 1.1.0 Final Release

* Mon Mar 08 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc6
- 1.1.0 Release Candidate 6

* Fri Feb 26 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc5.1
- Rebuild for Globus Toolkit 5

* Fri Feb 26 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc5
- 1.1.0 Release Candidate 5

* Wed Feb 24 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc4
- 1.1.0 Release Candidate 4

* Mon Feb 22 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc3
- 1.1.0 Release Candidate 3

* Mon Feb 15 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc2
- 1.1.0 Release Candidate 2

* Thu Feb 11 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc1
- 1.1.0 Release Candidate 1

* Sun Nov 29 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-1
- 1.0.0 Final Release

* Thu Nov 19 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.rc7
- 1.0.0 Release Candidate 7

* Thu Nov 12 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.rc6
- 1.0.0 Release Candidate 6

* Wed Nov 04 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.rc5
- rename nordugrid-arc1 → nordugrid-arc-nox
- 1.0.0 Release candidate 5

* Mon Oct 26 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 0.9.4-0.rc4
- 0.9.4 Release candidate 4

* Thu Oct 22 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 0.9.4-0.rc3
- 0.9.4 Release candidate 3

* Wed Oct 14 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 0.9.4-0.rc2
- 0.9.4 Release candidate 2

* Sun Sep 27 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 0.9.3-1
- 0.9.3 Final release

* Thu Sep 17 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 0.9.3-0.rc3
- 0.9.3 Release candidate 3

* Wed Jan 14 2009 Anders Wäänänen <waananen@nbi.dk> - 0.9.2-1
- 0.9.2

* Fri Oct 10 2008 Anders Wäänänen <waananen@nbi.dk> - 0.9.1-1
- Initial build
