// $Id: cleanmake.cpp,v 1.3 2000-08-08 23:26:09 bjohnson Exp $

/*
 * Cleaning program for auto-generated NMAKE files and Visual Studio project files
 *
 * BGJ (7/00)
 */

#pragma warning( disable : 4786 )

#include <string>
#include <fstream>
#include <iostream>
#include <vector>
#include <sys/stat.h>
#include <stdio.h>

#include <assert.h>
#define ASSERT assert

using namespace std;

bool AutoGenerated(const string& Filename);

int main(int argc, char* argv[])
{
  vector<string> Files; // List of files to delete if auto-generated
  Files.push_back("MakeFile");

  ASSERT(argc <= 2);
  if (argc == 2) {
    string Dir = argv[1];
    int pos = Dir.rfind('\\');
    if (pos == string::npos) pos = Dir.rfind('/');
    if (pos != string::npos) Dir.erase(0,pos+1);
    Files.push_back(Dir+".dsp");
    Files.push_back(Dir+"_wrap.dsp");
  }

  for (vector<string>::const_iterator i = Files.begin(); i != Files.end(); ++i) {
    if (AutoGenerated(*i)) {
      cout << "Deleting auto-generated " << *i << " in " << argv[1] << endl;
      if (remove(i->c_str()) != 0)
        cout << "  Error deleting " << *i << endl;
    }
  }

  return 0;
}

string GetFileAsString(const string& Filename)
{
  // Create string of correct length at the outset - avoids inefficiency
  // of frequent resizing as the string grows
  struct _stat stats;
  int ret = _stat(Filename.c_str(), &stats);
  ASSERT(ret == 0);
  string s(stats.st_size, ' ');

  // Read the file contents into the pre-set string
  ifstream is(Filename.c_str());
  ASSERT(is);
  string::iterator i = s.begin();
  while (is.get(*i++))
    ;

  return s;
}

bool AutoGenerated(const string& Filename)
{
  // Key that tells us a MakeFile has been automatically generated
  string AutoKey = "generated by convmake - do not edit";

  // Check whether output file already exists, and if so, whether it was auto-generated
  bool PreExists, AutoGenerated = false;
  {
    ifstream is(Filename.c_str());
    PreExists = is.good();
  }
  if (PreExists) {
    string S = GetFileAsString(Filename);
    string::size_type pos = S.find(AutoKey);
    AutoGenerated = pos != string::npos;
  }

  return AutoGenerated;
}
