      subroutine vib_istep(rtdb,nat3,natom,
     &    eigenvecs,eigenvals,coords,
     &    steps,stepsave,master)
*
* $Id: vib_istep.F,v 1.9 2005-06-03 23:54:51 marat Exp $
*
* routine to compute the direction vector, magnitudes, updated
* geometries for all negative eigenvalues in the current spectrum.
* only called during projected frequency analysis.
*
      implicit none
#include "errquit.fh"
#include "stdio.fh"
#include "geom.fh"
      double precision ddot
      external ddot
*
      integer rtdb    ! [input] rtdb handle
      integer natom   ! [input] number of atoms
      integer nat3    ! [input] 3*number of atoms
      double precision eigenvecs(nat3,nat3) ! [input](xyz&atom,mode)
      double precision eigenvals(nat3)      ! [input] (mode)
      double precision master(3,natom)    ! [scratch] original coordintates
      double precision coords(3,natom)    ! [scratch] coords after step
      double precision steps(3,natom)     ! [scratch] step generated by vector and scaled
      double precision stepsave(3,natom)  ! [scratch] step generated by vector 
c
      integer imode,ivec,iatom,ixyz
      integer nzero
      integer geom
      integer ip
      double precision scale
      double precision xyz(3),charge
      double precision length_of_step, maxstep
      double precision step_limit
      parameter (step_limit = 0.2d00)
      double precision percents(4), largest_step(4)
      character*16 tag
      character*10 units
      intrinsic sqrt
c
      double precision thresh
      parameter (thresh=1.0d-2)
c::-statement function
      logical is_it_close_to  
      double precision value,test
      intrinsic abs
*---          is value close to test?
      is_it_close_to(value,test) = (abs(value-test).lt.thresh)
c
      if (.not.geom_create(geom,'geometry')) call errquit
     &    ('vib_istep: geom create failed',911, GEOM_ERR)
      if (.not.geom_rtdb_load(rtdb,geom,'geometry')) call errquit
     &    ('vib_istep: geom_rtdb_load failed',911, RTDB_ERR)
      if (.not.geom_cart_coords_get(geom,master)) call errquit
     &    ('vib_istep: geom_get_cart_coords failed',911, GEOM_ERR)
      if (.not.geom_get_user_scale(geom,scale)) call errquit
     &    ('vib_istep: geom_get_user_scale failed',911, GEOM_ERR)
      if (.not.geom_get_user_units(geom,units)) call errquit
     &    ('vib_istep: geom_get_user_units failed',911, GEOM_ERR)
c
      percents(1) = 100.0d00
      percents(2) =  50.0d00
      percents(3) =   0.0d00
      percents(4) =   0.0d00
      nzero = 0

      do imode = 1,nat3
        if (is_it_close_to(eigenvals(imode),0.0d00)) then
          nzero = nzero + 1
          if (nzero.ge.3) goto 99999 ! found all negative eigenvalues :)
*                                    ! should always find 3 translational zeros
        else
          write(luout,10000)imode,eigenvals(imode)
          call dfill(nat3,0.0d00,steps,1)
          call dfill(nat3,0.0d00,stepsave,1)
* compute raw step
          ivec = 0
          maxstep = -0.1d00
          do iatom = 1, natom
            do ixyz = 1,3
              ivec = ivec+1
              stepsave(ixyz,iatom) =
     &            -1.0d00*eigenvecs(ivec,imode)
              maxstep = max(maxstep,abs(stepsave(ixyz,iatom)))
            enddo
          enddo
          largest_step(1) = maxstep
          largest_step(2) = maxstep/2.0d00
          largest_step(3) = step_limit
          largest_step(4) = step_limit/2.0d00
* determine percentages based on maximum raw displacement and limit
          percents(3) =  (step_limit/maxstep)*100.0d00
          percents(4) =  (step_limit/2.0d00/maxstep)*100.0d00
* print raw step
          call dcopy(nat3,stepsave,1,steps,1)
          call dscal(nat3,(1.0d00/scale),steps,1)
          length_of_step = sqrt(ddot(nat3,steps,1,steps,1))
          write(luout,10001)length_of_step,units
          do iatom=1,natom
            if (.not.geom_cent_get(geom,iatom,tag,xyz,charge))
     &          call errquit
     &          ('vib_istep: geom_cent_get failed',911, GEOM_ERR)
            write(luout,10002)iatom,tag,charge,
     &          (steps(ixyz,iatom),ixyz=1,3)
          enddo
          write(luout,'(/)')
* compute and print all scaled steps
          do ip = 1,4
            call dcopy(nat3,master,1,coords,1)
            call dcopy(nat3,stepsave,1,steps,1)
            call dscal(nat3,(percents(ip)/100.0d00),steps,1)
            length_of_step = sqrt(ddot(nat3,steps,1,steps,1))/
     &          scale
            call daxpy(nat3,1.0d00,steps,1,coords,1)
            if (.not.geom_cart_coords_set(geom,coords)) call errquit
     &          ('vib_istep: geom_cart_coords_set failed',911, GEOM_ERR)
            write(luout,10003)percents(ip),imode,length_of_step,units
            write(luout,10004)largest_step(ip)
            do iatom=1,natom
              if (.not.geom_cent_get(geom,iatom,tag,xyz,charge))
     &            call errquit
     &            ('vib_istep: geom_cent_get failed',911, GEOM_ERR)
              do ixyz = 1,3
                xyz(ixyz)=xyz(ixyz)/scale ! convert to user coordinates
              enddo
              write(luout,10002)iatom,tag,charge,(xyz(ixyz),ixyz=1,3)
            enddo
            write(luout,'(/)')
c
c     And also the negative step ...
c
            call dcopy(nat3,master,1,coords,1)
            call dcopy(nat3,stepsave,1,steps,1)
            call dscal(nat3,(-percents(ip)/100.0d00),steps,1)
            length_of_step = sqrt(ddot(nat3,steps,1,steps,1))/
     &          scale
            call daxpy(nat3,1.0d00,steps,1,coords,1)
            if (.not.geom_cart_coords_set(geom,coords)) call errquit
     &          ('vib_istep: geom_cart_coords_set failed',911, GEOM_ERR)
            write(luout,10003)-percents(ip),imode,length_of_step,units
            write(luout,10004)largest_step(ip)
            do iatom=1,natom
              if (.not.geom_cent_get(geom,iatom,tag,xyz,charge))
     &            call errquit
     &            ('vib_istep: geom_cent_get failed',911, GEOM_ERR)
              do ixyz = 1,3
                xyz(ixyz)=xyz(ixyz)/scale ! convert to user coordinates
              enddo
              write(luout,10002)iatom,tag,charge,(xyz(ixyz),ixyz=1,3)
            enddo
            write(luout,'(/)')
          enddo
        endif
      enddo
99999 continue
c
      call dcopy(nat3,master,1,coords,1) ! restore master coordinates
      if (.not.geom_destroy(geom)) call errquit
     &    ('vib_istep: geom_destroy failed',911, GEOM_ERR)
c
10000 format(/,/,/,1x,79('='),/,6x,'Negative Nuclear Hessian Mode',
     &      i5,2x,'Eigenvalue = ',f9.2,' cm**(-1)',/,1x,79('-'))
10001 format(2x,' Raw step length:',f7.3,1x,a10,';',
     &    2x, 'The Raw step for this mode is:')
10002 format(' ',i4,' ',a16,' ',f10.4,3f15.8)
10003 format(2x,'Geometry after ',f6.1,
     &    '% step for mode ',
     &    i2,'; Step length =',f7.3,1x,a10)
10004 format(3x,'Maximum component (any atom: x,y, or z) displacement:',
     &    f7.3,1x,a10)
      end
      subroutine vib_modestep(rtdb,nat3,natom,
     &    eigenvecs,eigenvals,coords,
     &    steps,stepsave,master)
*
* routine to compute the xyz coordinates along each mode vector
*
      implicit none
#include "errquit.fh"
#include "rtdb.fh"
#include "mafdecls.fh"
#include "stdio.fh"
#include "geom.fh"
#include "nwc_const.fh"
#include "inp.fh"
      double precision ddot
      external ddot
*
      integer rtdb    ! [input] rtdb handle
      integer natom   ! [input] number of atoms
      integer nat3    ! [input] 3*number of atoms
      double precision eigenvecs(nat3,nat3) ! [input](xyz&atom,mode)
      double precision eigenvals(nat3)      ! [input] (mode)
      double precision master(3,natom)    ! [scratch] original coordintates
      double precision coords(3,natom)    ! [scratch] coords after step
      double precision steps(3,natom)     ! [scratch] step generated by vector and scaled
      double precision stepsave(3,natom)  ! [scratch] step generated by vector 
c
      integer num_steps
      parameter (num_steps = 4*5) ! must be mod 4 == 0
      double precision step_norms(num_steps), cur_step, step_size
      integer my_sign, my_quad
      integer imode, ivec, iatom, ixyz, istep
      integer geom
      character*255 mydir, filename,filename1
*      character*30 tag, element
      double precision length_of_step, scale
*      double precision charge, atn
*
c::-statement function
      double precision thresh
      parameter (thresh=1.0d-2)
      logical is_it_close_to  
      double precision value,test
      intrinsic abs
*---          is value close to test?
      is_it_close_to(value,test) = (abs(value-test).lt.thresh)
c
*
      if (.not.geom_create(geom,'geometry')) call errquit
     &    ('vib_modestep: geom create failed',911, GEOM_ERR)
      if (.not.geom_rtdb_load(rtdb,geom,'geometry')) call errquit
     &    ('vib_modestep: geom_rtdb_load failed',911, GEOM_ERR)
      if (.not.geom_cart_coords_get(geom,master)) call errquit
     &    ('vib_modestep: geom_get_cart_coords failed',911, GEOM_ERR)
** set up symbols
*      do iatom = 1,natom
*        if (.not.geom_cent_get(geom, iatom, tag, coords, charge))
*     &      call errquit('vib_modestep: geom_cent_get failed',911)
*        if (.not.geom_tag_to_element(tag,syms(iatom),element,atn))
*     &      call errquit('vib_modestep: geom_tag_to_element failed',911)
*      enddo
** set up step metrics
*  1  2  3  4  5  6  7  8  9 10  11  12  13  14  15  16  17  18  19 20
* .0 .1 .2 .3 .4 .5 .4 .3 .2 .1 .0 -.1 -.2 -.3 -.4 -.5 -.4 -.3 -.2 -.1
*  1  1  1  1  1  2  2  2  2  2  3   3   3   3   3   4   4   4   4   4
      call dfill(num_steps,0.0d00,step_norms,1)
      if (.not.rtdb_get(rtdb,'vib:animate:step_size',
     &                            mt_dbl,1,step_size)) then
         step_size = 0.15
      endif
      cur_step = 0.0d00
      my_sign  = 1.0d00
      do istep = 1,num_steps
        my_quad = istep/5 + 1
        step_norms(istep) = cur_step
        cur_step = cur_step + my_sign*step_size
        if (my_quad.eq.1.or.my_quad.eq.4) then
          my_sign = 1.0d00
        else
          my_sign = -1.0d00
        endif
      enddo
*      do istep = 1,num_steps
*        write(6,*)' step norms ',istep,step_norms(istep)
*      enddo
*
      do imode = 1,nat3
* store raw step in stepsave for each mode
        ivec = 0
        do iatom = 1,natom
          do ixyz = 1,3
            ivec = ivec + 1
            stepsave(ixyz,iatom) = -1.0d00*eigenvecs(ivec,imode)
          enddo
        enddo
        iatom = (imode-1) / 3 + 1
        mydir = ' '
        call util_directory_name(mydir, .false., 0)
        filename = ' '
        write(filename1,10001)
     &      mydir(1:inp_strlen(mydir)),imode
        open(unit=89,file=filename1,
     &       form='formatted',status='new', err=99901)
        do istep = 1, num_steps
          filename = ' '
          write(filename,10000)
     &        mydir(1:inp_strlen(mydir)),imode,istep
          if (is_it_close_to(step_norms(istep),0.0d00)) then
            call dfill(nat3,0.0d00,steps,1)
          else
            call dcopy(nat3,stepsave,1,steps,1)
            length_of_step = sqrt(ddot(nat3,steps,1,steps,1))
            scale = step_norms(istep)/length_of_step
            call dscal(nat3,scale,steps,1)
            length_of_step = sqrt(ddot(nat3,steps,1,steps,1))
          endif
          length_of_step = sqrt(ddot(nat3,steps,1,steps,1))
          call dcopy(nat3,master,1,coords,1)
          call daxpy(nat3,1.0d00,steps,1,coords,1)
          if (.not.geom_cart_coords_set(geom,coords)) call errquit
     &        ('vib_modestep: geom_cart_coords_set failed',911,
     &       GEOM_ERR)
          if (.not.geom_print_xyz(geom,89))
     &        call errquit('vib_modestep: geom_print_xyz failed',911,
     &       GEOM_ERR)
          call util_file_unlink(filename)
          open(unit=88,file=filename,
     &        form='formatted',status='new', err=99901)
          if (.not.geom_print_xyz(geom,88))
     &        call errquit('vib_modestep: geom_print_xyz failed',911,
     &       GEOM_ERR)
          close(unit=88,status='keep',err=99902)
        enddo
        close(unit=89,status='keep',err=99902)
      enddo
*
      call dcopy(nat3,master,1,coords,1) ! restore master coordinates
      if (.not.geom_destroy(geom)) call errquit
     &    ('vib_modestep: geom_destroy failed',911, GEOM_ERR)
      return
10000 format(a,'/freq.m-',i3.3,'.s-',i3.3,'.xyz')
10001 format(a,'/freq.m-',i3.3,'.xyz')
99901 write(luout,*)' could not open file ',filename
      call errquit('vib_modestep: fatal error ',911, DISK_ERR)
99902 write(luout,*)' could not close file ',filename
      call errquit('vib_modestep: fatal error ',911, DISK_ERR)
      end
