// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _math_NewtonMinimum_HeaderFile
#define _math_NewtonMinimum_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Boolean.hxx>
#include <math_Status.hxx>
#include <math_Vector.hxx>
#include <math_Matrix.hxx>
#include <Standard_Real.hxx>
#include <Standard_Integer.hxx>
#include <Standard_OStream.hxx>
class StdFail_NotDone;
class Standard_DimensionError;
class math_MultipleVarFunctionWithHessian;



class math_NewtonMinimum 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! -- Given the  starting   point  StartingPoint,
  //! The tolerance  required on  the  solution is given  by
  //! Tolerance.
  //! Iteration are  stopped if
  //! (!WithSingularity)  and H(F(Xi)) is not definite
  //! positive  (if the smaller eigenvalue of H < Convexity)
  //! or IsConverged() returns True for 2 successives Iterations.
  //! Warning: Obsolete Constructor (because IsConverged can not be redefined
  //! with this. )
  Standard_EXPORT math_NewtonMinimum(math_MultipleVarFunctionWithHessian& F, const math_Vector& StartingPoint, const Standard_Real Tolerance = 1.0e-7, const Standard_Integer NbIterations = 40, const Standard_Real Convexity = 1.0e-6, const Standard_Boolean WithSingularity = Standard_True);
  

  //! The tolerance  required on  the  solution is given  by
  //! Tolerance.
  //! Iteration are  stopped if
  //! (!WithSingularity)  and H(F(Xi)) is not definite
  //! positive  (if the smaller eigenvalue of H < Convexity)
  //! or IsConverged() returns True for 2 successives Iterations.
  //! Warning: This constructor do not computation
  Standard_EXPORT math_NewtonMinimum(math_MultipleVarFunctionWithHessian& F, const Standard_Real Tolerance = 1.0e-7, const Standard_Integer NbIterations = 40, const Standard_Real Convexity = 1.0e-6, const Standard_Boolean WithSingularity = Standard_True);
  
  Standard_EXPORT virtual   void Delete() ;
Standard_EXPORT virtual ~math_NewtonMinimum(){Delete();}
  
  //! Search the solution.
  Standard_EXPORT   void Perform (math_MultipleVarFunctionWithHessian& F, const math_Vector& StartingPoint) ;
  
  //! This method is  called    at the end  of   each
  //! iteration to  check the convergence :
  //! || Xi+1 - Xi || < Tolerance
  //! or || F(Xi+1) - F(Xi)|| < Tolerance * || F(Xi) ||
  //! It can be  redefined in a sub-class to implement a specific  test.
  Standard_EXPORT virtual   Standard_Boolean IsConverged()  const;
  
  //! Tests if an error has occured.
      Standard_Boolean IsDone()  const;
  
  //! Tests if the Function is convexe during optimization.
      Standard_Boolean IsConvex()  const;
  
  //! returns the location vector of the minimum.
  //! Exception NotDone is raised if an error has occured.
     const  math_Vector& Location()  const;
  
  //! outputs the location vector of the minimum in Loc.
  //! Exception NotDone is raised if an error has occured.
  //! Exception DimensionError is raised if the range of Loc is not
  //! equal to the range of the StartingPoint.
      void Location (math_Vector& Loc)  const;
  
  //! returns the value of the minimum.
  //! Exception NotDone is raised if the minimum was not found.
      Standard_Real Minimum()  const;
  
  //! returns the gradient vector at the minimum.
  //! Exception NotDone is raised if an error has occured.the minimum was not found.
     const  math_Vector& Gradient()  const;
  
  //! outputs the gradient vector at the minimum in Grad.
  //! Exception NotDone is raised if the minimum was not found.
  //! Exception DimensionError is raised if the range of Grad is not
  //! equal to the range of the StartingPoint.
      void Gradient (math_Vector& Grad)  const;
  
  //! returns the number of iterations really done in the
  //! calculation of the minimum.
  //! The exception NotDone is raised if an error has occured.
      Standard_Integer NbIterations()  const;
  
  //! Prints on the stream o information on the current state
  //! of the object.
  //! Is used to redefine the operator <<.
  Standard_EXPORT   void Dump (Standard_OStream& o)  const;




protected:



  math_Status TheStatus;
  math_Vector TheLocation;
  math_Vector TheGradient;
  math_Vector TheStep;
  math_Matrix TheHessian;
  Standard_Real PreviousMinimum;
  Standard_Real TheMinimum;
  Standard_Real MinEigenValue;
  Standard_Real XTol;
  Standard_Real CTol;
  Standard_Integer nbiter;
  Standard_Boolean NoConvexTreatement;
  Standard_Boolean Convex;


private:



  Standard_Boolean Done;
  Standard_Integer Itermax;


};


#include <math_NewtonMinimum.lxx>





#endif // _math_NewtonMinimum_HeaderFile
