/***************************************************************************
                          filter_reduction.h  -  description
                             -------------------
    begin                : Fri Feb 26 2010
    copyright            : (C) 2001 by Thies Jochimsen
    email                : jochimse@cns.mpg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILTER_REDUCTION_H
#define FILTER_REDUCTION_H

enum                      reductionOp { minip=0, maxip,   proj };
static const char* reductionOpLabel[]={"minip", "maxip", "proj"};

#include <odindata/filter.h>

template<int Op>
class FilterReduction : public FilterStep
{
  STD_string label() const {return reductionOpLabel[Op];}
  STD_string description() const {
    STD_string opstr;
    if(Op==minip) opstr="minimum intensity ";
    if(Op==maxip) opstr="maximum intensity ";
    return "Perform "+opstr+"projection over slice direction";
  }

  bool process(Data<float,4>& data, Protocol& prot) const {
    TinyVector<int,4> inshape=data.shape();

    TinyVector<int,4> outshape=data.shape();
    outshape(sliceDim)=1;

    Data<float,4> outdata(outshape);

    for(int i=0; i<outdata.size(); i++) {
      TinyVector<int,4> index=outdata.create_index(i);

      TinyVector<int,4> lowerBounds=index;
      TinyVector<int,4> upperBounds=index;
      upperBounds(sliceDim)=inshape(sliceDim)-1;
    
      if(Op==minip) outdata(index)=min(data(RectDomain<4>(lowerBounds, upperBounds)));
      if(Op==maxip) outdata(index)=max(data(RectDomain<4>(lowerBounds, upperBounds)));
      if(Op==proj)  outdata(index)=sum(data(RectDomain<4>(lowerBounds, upperBounds)));
    }

    data.reference(outdata);

    prot.geometry.set_nSlices(1);
    prot.seqpars.set_MatrixSize(sliceDirection,1);
    
    return true;
  }

  FilterStep*  allocate() const {return new FilterReduction<Op>();}
  void init() {}
};

#endif
