/*
 * filter_splice.cpp
 *
 *  Created on: 23.02.2009
 *      Author: enni
 */

#include "filter_splice.h"
#include "filter.h"

void FilterSplice::init() {
  for(dataDim i=dataDim(0);i<n_dataDim;i=dataDim(i+1))
    dimension.add_item(dataDimLabel[i]);
  dimension.add_item("none");
  dimension.set_actual(dimension.n_items()-1);
  dimension.set_cmdline_option("dimension").set_description("dimension of the data to be spliced");
  append_arg(dimension,"dimension");
}
bool FilterSplice::process(FileIO::ProtocolDataMap& pdmap)const{
  if(dimension=="none"){
    Log<Filter> odinlog("FilterSplice","process");
    ODINLOG(odinlog,errorLog) << "no dimension given for splice" << STD_endl;
    return false;
  }

  STD_list<STD_pair<Protocol,Data<float,4> > > result;

  while(!pdmap.empty()){
    STD_pair<Protocol, Data<float,4> > pdpair=*pdmap.begin();
    pdmap.erase(pdmap.begin());//we modify the protocol so it is better to completly remove the pd-pair and insert it cleanly afterwards
    if(pdpair.second.extent(dimension)>1){
      result=splice(pdpair,dimension);
    } else result.push_back(pdpair);
  }
  for(STD_list<STD_pair<Protocol,Data<float,4> > >::iterator it=result.begin();it!=result.end();it++)
    pdmap.insert(*it);
  return true;
}

STD_list<STD_pair<Protocol,Data<float,4> > > FilterSplice::splice(const STD_pair<Protocol,Data<float,4> > &pdpair,const JDXenum &dimension){
  Log<Filter> odinlog("splice","swapdim");

  const Protocol &prot=pdpair.first;
  const Data<float,4> &src=pdpair.second;
  TinyVector<int,4> shape(src.shape());
  const int amount = shape(dimension);
  const Range all=Range::all();

  STD_string serDesc;
  int serNum;
  prot.study.get_Series(serDesc,serNum);
  if(serDesc!="") serDesc+="_";

  ODINLOG(odinlog,normalDebug) << "Splicing " << serDesc << " " << shape << " into " << amount << " Parts." << STD_endl;
  shape(dimension)=1;


  STD_list<STD_pair<Protocol,Data<float,4> > > ret(amount,STD_make_pair(prot,Data<float,4>(shape)));

  int i=0;
  for(STD_list<STD_pair<Protocol,Data<float,4> > >::iterator it=ret.begin();it!=ret.end();it++,i++){
    Protocol &dprot=it->first;
    Geometry &geo =dprot.geometry;

    Data<float,4> &dst=it->second;
    dvector dcenter=geo.get_center(),dir_vector;
    const double fov=geo.get_FOV( direction(sliceDirection-dimension));

    switch (dimension) {
      case timeDim:
        dst=src(Range(i),all,all,all);
        break;
      case sliceDim:
        dst=src(all,Range(i),all,all);
        geo.set_nSlices(1);
        dir_vector=geo.get_sliceVector();
        break;
      case phaseDim:
        dst=src(all,all,Range(i),all);
        dir_vector=geo.get_phaseVector();
        break;
      case readDim:
        dst=src(all,all,all,Range(i));
        dir_vector=geo.get_readVector();
        break;
    }
    if(dimension!=timeDim){//fix the position for every slice if splicing is spacial
      ODINLOG(odinlog,normalDebug) << "dcenter" << dcenter.printbody() << " - " << (dir_vector*fov/2.).printbody() << " + " << (dir_vector*fov/amount*i).printbody() << STD_endl;
      dcenter-=dir_vector*fov/2.;
      dcenter+=dir_vector*fov/amount*i;
      geo.set_orientation_and_offset(geo.get_readVector(),geo.get_phaseVector(),geo.get_sliceVector(),dcenter);
    }
    dprot.seqpars.set_MatrixSize(direction(sliceDirection-dimension),1);

    // Adjust series number
    dprot.study.set_Series(serDesc+dataDimLabel[int(dimension)]+itos(i,amount-1),serNum);
  }
  return ret;
}

//////////////////////////////////////////////////
/*

void splice(ProtocolDataMap& pd_out, ProtocolDataMap::const_iterator pdit, const JDXenum &dimension) {

  Protocol prot=pdit->first;
  const Data<float,4>& src = pdit->second;
  TinyVector<int,4> shape(src.shape());
  int amount=shape(dimension);

  shape(dimension)=1;
  ODINLOG(odinlog,infoLog) << "splicing " << dimension << " into " << amount << " blocks of shape " << shape << STD_endl;

  Range all(Range::all());

}

*/
