/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_COMPUTERSYSTEMSOFTWAREIDENTITYRESOURCEACCESSPOINTACCESS_H_
#define OPENDRIM_COMPUTERSYSTEMSOFTWAREIDENTITYRESOURCEACCESSPOINTACCESS_H_

#include "SoftwareInventory_Common.h"

#include "OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint.h"
#include "assocOpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint.h"

int SoftwareInventory_OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint_load(const CMPIBroker* broker, string& errorMessage);

int SoftwareInventory_OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint_unload(string& errorMessage);

int SoftwareInventory_OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint& instance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint& newInstance, const OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint& oldInstance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint>& OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint>& OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint_instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint_populate(OpenDRIM_ComputerSystemSoftwareIdentityResourceAccessPoint& instance, string& errorMessage);

#endif /*OPENDRIM_COMPUTERSYSTEMSOFTWAREIDENTITYRESOURCEACCESSPOINTACCESS_H_*/
