/*
 * mcu.h
 *
 * Main MCU process routines for a simple MCU
 *
 * Copyright (c) 1993-1998 Equivalence Pty. Ltd.
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Portable Windows Library.
 *
 * The Initial Developer of the Original Code is Equivalence Pty. Ltd.
 *
 * Portions of ths code were written by by Post Increment (http://www.postincrement.com) 
 * with the assistance of funding from Stonevoice, slc. http://www.stonevoice.com
 *
 * Portions of this code were written by Post Increment (http://www.postincrement.com) 
 * with the assistance of funding from Citron Networks (http://www.citron.com.tw)
 *
 * Contributor(s): Derek J Smithies (derek@indranet.co.nz)
 *                 Craig Southeren (craig@postincrement.com)
 *
 * $Log: mcu.h,v $
 * Revision 1.4  2009/02/24 11:47:51  willamowius
 * compatibility with older H323Plus versions
 *
 * Revision 1.3  2008/05/23 11:18:18  willamowius
 * switch BOOL to PBoolean to be able to compile with Ptlib 2.2.x
 *
 * Revision 1.2  2008/02/19 06:36:11  shorne
 * Added ability to have 16CIF & 4CIF size video. Thx Marcos Jardini for the initial 4CIF patch
 *
 * Revision 1.1  2007/10/17 19:44:33  shorne
 * Initial Commit
 *
 * Revision 2.1.2.2  2007/08/16 20:29:01  shorne
 * Better Gatekeeper anf Gateway prefix support
 *
 * Revision 2.1.2.1  2007/02/06 11:41:27  shorne
 * Updates for OpenH323 Video Plugins
 *
 * Revision 2.1  2006/06/09 04:39:59  csoutheren
 * Migrated VideoBranch to main trunk
 *
 * Revision 1.1.2.6  2006/04/26 13:09:08  csoutheren
 * Fix problem when connecting file not available
 * Add optional time limit for rooms
 *
 * Revision 1.1.2.5  2006/04/18 00:32:41  csoutheren
 * Removed dependence on custom.h
 *
 * Revision 1.1.2.4  2006/04/12 01:46:13  csoutheren
 * Added defaut image when audio-only member enters video conference
 * Added image to Web gui
 *
 * Revision 1.1.2.3  2006/04/06 01:11:16  csoutheren
 * Latest sources include
 *   - premedia blanking and optional image display
 *   - ablity to defer conference join for authentication if required
 *   - more bulletproofing on conference join
 *   - new video copy/fill functions
 *
 * Revision 1.1.2.2  2006/04/06 00:50:30  csoutheren
 * Latest changes (more to come)
 *
 * Revision 1.1.2.1  2006/03/28 05:13:38  csoutheren
 * Normalised file headers
 * Fixed problem with QCIF video
 * Seperated H.323 and MCU process functions into seperate files
 *
 */

#ifndef _OpenMCU_MCU_H
#define _OpenMCU_MCU_H

#ifdef _WIN32
#pragma warning(disable:4786)
#endif

#include <ptlib.h>
#include <ptclib/httpsvc.h>

#include "config.h"

#include <map>
#include <h323.h>
#include <h323ep.h>
#include <h323pdu.h>
#include <h245.h>

#if !defined(P_USE_STANDARD_CXX_BOOL) && !defined(P_USE_INTEGER_BOOL)
    typedef int PBoolean;
#endif

#include "conference.h"
#include "filemembers.h"
#include "h323.h"

#if P_SSL
#include <ptclib/shttpsvc.h>
typedef PSecureHTTPServiceProcess OpenMCUProcessAncestor;
#else
#include <ptclib/httpsvc.h>
typedef PHTTPServiceProcess OpenMCUProcessAncestor;
#endif

class OpenMCUH323EndPoint;
class OpenMCUMonitor;

class OpenMCU : public OpenMCUProcessAncestor
{
  PCLASSINFO(OpenMCU, OpenMCUProcessAncestor)

  public:
    OpenMCU();
    void Main();
    PBoolean OnStart();
    void OnStop();
    void OnControl();
    void OnConfigChanged();
    PBoolean Initialise(const char * initMsg);

    static OpenMCU & Current() { return (OpenMCU &)PProcess::Current(); }

    virtual ConferenceManager * CreateConferenceManager();
    virtual OpenMCUH323EndPoint * CreateEndPoint(ConferenceManager & manager);

    virtual void OnCreateConfigPage(PConfig & /*cfg*/, PConfigPage & /*page*/)
    { }

    virtual PBoolean GetConnectingWAVFile(PFilePath & fn) const
    { return FALSE; }

    PString GetDefaultRoomName() const { return defaultRoomName; }
    PString GetNewRoomNumber();
    void LogMessage(const PString & str);

    OpenMCUH323EndPoint & GetEndpoint()
    { return *endpoint; }

    int GetRoomTimeLimit() const
    { return roomTimeLimit; }

#if OPENMCU_VIDEO

    PBoolean GetForceScreenSplit() const
    { return forceScreenSplit; }

    virtual MCUVideoMixer * CreateVideoMixer()
    { return new MCUSimpleVideoMixer(forceScreenSplit,frameSize); }

    virtual PBoolean GetPreMediaFrame(void * buffer, int width, int height, PINDEX & amount)
    { return FALSE; }

    virtual PBoolean GetEmptyMediaFrame(void * buffer, int width, int height, PINDEX & amount)
    { return GetPreMediaFrame(buffer, width, height, amount); }

#endif

	static int defaultRoomCount;

  protected:
    ConferenceManager * manager;
    OpenMCUH323EndPoint * endpoint;
    long GetCodec(const PString & codecname);

    PString    defaultRoomName;
    PFilePath  logFilename;
    int        roomTimeLimit;

#if OPENMCU_VIDEO
    PBoolean forceScreenSplit;
	H323Capability::CapabilityFrameSize frameSize;
#endif
};


#endif // _OpenMCU_MCU_H

// End of File ///////////////////////////////////////////////////////////////
