#ifndef MSXROMCLI_HH
#define MSXROMCLI_HH

#include "CLIOption.hh"

namespace openmsx {

class CommandLineParser;

class MSXRomCLI final : public CLIOption, public CLIFileType
{
public:
	explicit MSXRomCLI(CommandLineParser& cmdLineParser);

	void parseOption(const std::string& option,
	                 array_ref<std::string>& cmdLine) override;
	string_ref optionHelp() const override;

	void parseFileType(const std::string& filename,
	                   array_ref<std::string>& cmdLine) override;
	string_ref fileTypeHelp() const override;

private:
	void parse(const std::string& arg, const std::string& slotname,
	           array_ref<std::string>& cmdLine);

	CommandLineParser& cmdLineParser;

	class IpsOption final : public CLIOption {
		void parseOption(const std::string& option,
		                 array_ref<std::string>& cmdLine) override;
		string_ref optionHelp() const override;
	} ipsOption;
	class RomTypeOption final : public CLIOption {
		void parseOption(const std::string& option,
		                 array_ref<std::string>& cmdLine) override;
		string_ref optionHelp() const override;
	} romTypeOption;
};

} // namespace openmsx

#endif
