#ifndef ROMFSA1FM1_HH
#define ROMFSA1FM1_HH

#include "MSXRom.hh"
#include "RomBlocks.hh"

namespace openmsx {

class MSXMotherBoard;
class FirmwareSwitch;
class SRAM;

class RomFSA1FMSram
{
protected:
	explicit RomFSA1FMSram(const DeviceConfig& config);
	~RomFSA1FMSram();

	MSXMotherBoard& motherBoard;
	SRAM* fsSram;
};

class RomFSA1FM1 final : public MSXRom, private RomFSA1FMSram
{
public:
	RomFSA1FM1(const DeviceConfig& config, std::unique_ptr<Rom> rom);
	~RomFSA1FM1();

	void reset(EmuTime::param time) override;
	byte peekMem(word address, EmuTime::param time) const override;
	byte readMem(word address, EmuTime::param time) override;
	const byte* getReadCacheLine(word address) const override;
	void writeMem(word address, byte value,
	              EmuTime::param time) override;
	byte* getWriteCacheLine(word address) const override;

	template<typename Archive>
	void serialize(Archive& ar, unsigned version);

private:
	const std::unique_ptr<FirmwareSwitch> firmwareSwitch;
};

class RomFSA1FM2 final : public Rom8kBBlocks, private RomFSA1FMSram
{
public:
	RomFSA1FM2(const DeviceConfig& config, std::unique_ptr<Rom> rom);
	~RomFSA1FM2();

	void reset(EmuTime::param time) override;
	byte peekMem(word address, EmuTime::param time) const override;
	byte readMem(word address, EmuTime::param time) override;
	const byte* getReadCacheLine(word address) const override;
	void writeMem(word address, byte value,
	              EmuTime::param time) override;
	byte* getWriteCacheLine(word address) const override;

	template<typename Archive>
	void serialize(Archive& ar, unsigned version);

private:
	void changeBank(byte region, byte bank);

	byte bankSelect[8];
	bool isRam[8];
	bool isEmpty[8];
	byte control;
};

} // namespace openmsx

#endif
