#ifndef ROMMSXDOS2_HH
#define ROMMSXDOS2_HH

#include "RomBlocks.hh"

namespace openmsx {

class RomMSXDOS2 final : public Rom16kBBlocks
{
public:
	RomMSXDOS2(const DeviceConfig& config, std::unique_ptr<Rom> rom);

	void reset(EmuTime::param time) override;
	void writeMem(word address, byte value, EmuTime::param time) override;
	byte* getWriteCacheLine(word address) const override;

private:
	const byte range;
};

} // namespace openmsx

#endif
