// $Id: MegaSCSI.hh 8352 2008-11-12 18:39:08Z m9710797 $

#ifndef MEGASCSI_HH
#define MEGASCSI_HH

#include "MSXDevice.hh"
#include <memory>

namespace openmsx {

class MB89352;
class SRAM;

class MegaSCSI : public MSXDevice
{
public:
	MegaSCSI(MSXMotherBoard& motherBoard, const XMLElement& config);
	virtual ~MegaSCSI();

	virtual void reset(EmuTime::param time);

	virtual byte readMem(word address, EmuTime::param time);
	virtual byte peekmem(word address, EmuTime::param time) const;
	virtual void writeMem(word address, byte value, EmuTime::param time);
	virtual const byte* getReadCacheLine(word start) const;
	virtual byte* getWriteCacheLine(word start) const;

	template<typename Archive>
	void serialize(Archive& ar, unsigned version);

private:
	void setSRAM(unsigned region, byte block);

	const std::auto_ptr<MB89352> mb89352;
	const std::auto_ptr<SRAM> sram;

	bool isWriteable[4]; // which region is readonly?
	byte mapped[4]; // SPC block mapped in this region?
	const byte blockMask;
};

} // namespace openmsx

#endif
