#
#    Copyright 2016 Kai Pastor
#    
#    This file is part of OpenOrienteering.
# 
#    OpenOrienteering is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
# 
#    OpenOrienteering is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with OpenOrienteering.  If not, see <http://www.gnu.org/licenses/>.

TEMPLATE = aux
CONFIG  -= debug_and_release

CMAKE_TOOLCHAIN_FILE = $$clean_path($$OUT_PWD/../../toolchain.cmake)
if (exists($$CMAKE_TOOLCHAIN_FILE)) {
    CMAKE_ARGS      += "-DCMAKE_TOOLCHAIN_FILE=\"$$CMAKE_TOOLCHAIN_FILE\""
    gdal.depends    += $$CMAKE_TOOLCHAIN_FILE
}

gdal.dir      = $$OUT_PWD/gdal
gdal.target   = $$gdal.dir/GDAL-prefix/lib/libgdal.so
osx: gdal.target = $$gdal.dir/GDAL-prefix/lib/libgdal.dylib
win32: gdal.target = $$gdal.dir/GDAL-prefix/bin/libgdal-20.dll
gdal.cflags   = $$QMAKE_CFLAGS -Wno-declaration-after-statement -Wno-int-to-pointer-cast
gdal.commands = \
  mkdir -p "$$gdal.dir" && \
  cd "$$gdal.dir" && \
  if [ -d CMakeFiles -o -f CMakeCache.txt ] ; then rm -R CMake*; fi && \
  if [ -d GDAL-prefix ] ; then rm -R GDAL-prefix; fi && \
  cmake "$$PWD" $$CMAKE_ARGS && \
  PATH="$$NDK_TOOLCHAIN_PATH/bin:${PATH}" $(MAKE) VERBOSE=$(VERBOSE) all && \
  $(MAKE) clean VERBOSE=$(VERBOSE)

QMAKE_EXTRA_TARGETS += gdal
PRE_TARGETDEPS      += $$gdal.target
QMAKE_CLEAN         += $$gdal.target

GDAL_PRI = \
  "$$LITERAL_HASH Generated by $$_PRO_FILE_" \
  "DEPENDPATH  += $$gdal.dir/GDAL-prefix/include" \
  "INCLUDEPATH += $$gdal.dir/GDAL-prefix/include"
win32: GDAL_PRI += \
  "LIBS        += \"-L$$gdal.dir/GDAL-prefix/bin\""
else: GDAL_PRI += \
  "LIBS        += \"-L$$gdal.dir/GDAL-prefix/lib\""
android: GDAL_PRI += \
  "ANDROID_EXTRA_LIBS += \"$$gdal.target\""

write_file($$OUT_PWD/gdal.pri, GDAL_PRI)

android|win32 {
  INSTALLS += gdal_data
  gdal_data.prefix =
  android: gdal_data.prefix = /assets
  gdal_data.path   = $$gdal_data.prefix/gdal
  gdal_data.files  = $$gdal.dir/GDAL-prefix/share/gdal/*
}

OTHER_FILES += \
  CMakeLists.txt \
  LICENSE.TXT
