##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/01/30
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import unittest
from parser import debian


class DebianParserTestCase(unittest.TestCase):

    ## Initial Setup
    debian_parser_obj = debian.Parser()

    def setUp(self):
        ptr = open('./test/unit_test/work/input/deb-msg00038.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.debian_parser_obj, 'Html_content', self.Html_content)


    def test_getCVE(self):
        print "\nTesting Debian Parser Test Suite ..."
        req_out_put = 'CVE-2008-4989'

        out_put = self.debian_parser_obj.getCVE()
        self.assertEquals(out_put, req_out_put)


    def test_getAdvID(self):
        req_out_put = 'DSA-1719-2'

        out_put = self.debian_parser_obj.getAdvID()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedPackage(self):
        req_out_put = 'gnutls13, gnutls26'

        out_put = self.debian_parser_obj.getAffectedPackage()
        self.assertEquals(out_put, req_out_put)


    def test_getDescription1(self):
        req_out_put = "  Changes in DSA-1719-1 caused GNUTLS to reject X.509v1 certificates as\n  CA root certificates by default, as originally described in the\n  documentation.  However, it turned out that there is still significant\n  use of historic X.509v1 CA root certificates, so this constitutes an\n  unacceptable regression.  This update reverses this part of the\n  changes in DSA-1719-1.  Note that the X.509v1 certificate format does\n  not distinguish between server and CA certificates, which means that\n  an X.509v1 server certificates is implicitly converted into a CA\n  certificate when added to the trust store (which was the reason for\n  the change in DSA-1719-1).\n  \n  The current stable distribution (lenny) was released with the changes\n  in DSA-1719-1 already applied, and this update reverses the changes\n  concerning X.509v1 CA certificates for this distribution, too.\n  \n  For the old stable distribution (etch), this problem has been fixed in\n  version 1.4.4-3+etch4.\n  \n  For the stable distribution (lenny), this problem has been fixed in\n  version 2.4.2-6+lenny1.\n  \n  We recommend that you upgrade your GNUTLS packages."

        out_put = self.debian_parser_obj.getDescription()
        self.assertEquals(out_put, req_out_put)

    def test_getDescription2(self):
        ptr = open('./test/unit_test/work/input/deb-msg00001.html', 'r')
        lines = ptr.readlines()
        ptr.close

        Html_content = "".join(lines)
        setattr(self.debian_parser_obj, 'Html_content', Html_content)

        req_out_put = "  Several remote vulnerabilities have been discovered in PHP, a\n  server-side, HTML-embedded scripting language. The Common\n  Vulnerabilities and Exposures project identifies the following\n  problems:\n  \n  CVE-2007-3799  \n  It was discovered that the session_start() function allowed the\n  insertion of attributes into the session cookie.\n  \n  CVE-2007-3998  \n  Mattias Bengtsson and Philip Olausson discovered that a\n  programming error in the implementation of the wordwrap() function\n  allowed denial of service through an infinite loop.\n  \n  CVE-2007-4658  \n  Stanislav Malyshev discovered that a format string vulnerability\n  in the money_format() function could allow the execution of\n  arbitrary code.\n  \n  CVE-2007-4659  \n  Stefan Esser discovered that execution control flow inside the\n  zend_alter_ini_entry() function in handled incorrectly in case\n  of a memory limit violation.\n  \n  CVE-2007-4660  \n  Gerhard Wagner discovered an integer overflow inside the\n  chunk_split function().\n  \n  CVE-2007-5898  \n  Rasmus Lerdorf discovered that incorrect parsing of multibyte\n  sequences may lead to disclosure of memory contents.\n  \n  CVE-2007-5899  \n  It was discovered that the output_add_rewrite_var() function could\n  leak session ID information, resulting in information disclosure.\n  \n  This update also fixes two bugs from in the PHP 5.2.4 release which\n  don't have security impact according to the Debian PHP security policy\n  (CVE-2007-4657 and CVE-2007-4662), but which are fixed nonetheless.\n  \n  \n  For the stable distribution (etch), these problems have been fixed in\n  version 5.2.0-8+etch9.\n  \n  The old stable distribution (sarge) doesn't contain php5.\n  \n  For the unstable distribution (sid), these problems have been fixed\n  in version 5.2.4-1, with the exception of CVE-2007-5898 and\n  CVE-2007-5899, which will be fixed soon. Please note that Debian's\n  version of PHP is hardened with the Suhosin patch beginning with\n  version 5.2.4-1, which renders several vulnerabilities ineffective.\n  \n  We recommend that you upgrade your php5 packages."

        out_put = self.debian_parser_obj.getDescription()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedProduct(self):
        req_out_put = ['Debian 4.0']

        out_put = self.debian_parser_obj.getAffectedProduct()
        self.assertEquals(out_put, req_out_put)


    def test_getRPM(self):
        req_out_put = {'DEB4.0': ['libgnutls13-dbg_1.4.4-3+etch4', 'libgnutls13_1.4.4-3+etch4', 'gnutls-bin_1.4.4-3+etch4', 'libgnutls-dev_1.4.4-3+etch4', 'libgnutls26-dbg_2.4.2-6+lenny1', 'libgnutls-dev_2.4.2-6+lenny1', 'libgnutls26_2.4.2-6+lenny1', 'guile-gnutls_2.4.2-6+lenny1', 'gnutls-bin_2.4.2-6+lenny1', 'gnutls-doc_1.4.4-3+etch4', 'gnutls-doc_2.4.2-6+lenny1']}

        prod_list = ['Debian 4.0']
        out_put = self.debian_parser_obj.getRPM(prod_list)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference1(self):
        req_out_put = 'http://lists.debian.org/debian-security-announce/2007/msg00001.html'

        main_url = 'http://lists.debian.org/debian-security-announce/'
        file_name = '2007_msg00001.html'
        out_put = self.debian_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference2(self):
        req_out_put = 'http://lists.debian.org/debian-security-announce/2007/msg00001.html'

        main_url = 'http://lists.debian.org/debian-security-announce'
        file_name = '2007_msg00001.html'
        out_put = self.debian_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_parser(self):
        req_out_put = True

        prod_list = ['Debian 4.0']
        setattr(self.debian_parser_obj, 'Platforms', prod_list)
        out_put = self.debian_parser_obj.parser(self.Html_content)
        self.assertEquals(out_put, req_out_put)


    def test_getYearLinks(self):
        req_out_put = 'http://lists.debian.org/debian-security-announce/2008/threads.html'

        link = './test/unit_test/work/input/debian-advisory-main.html'
        year = '2008'
        out_put = self.debian_parser_obj._getYearLinks(link, year)
        self.assertEquals(out_put, req_out_put)


    def test_getEachAdvLink(self):
        req_out_put = ['http://lists.debian.org/debian-security-announce/input/msg00000.html', 'http://lists.debian.org/debian-security-announce/input/msg00001.html', 'http://lists.debian.org/debian-security-announce/input/msg00002.html', 'http://lists.debian.org/debian-security-announce/input/msg00003.html', 'http://lists.debian.org/debian-security-announce/input/msg00004.html', 'http://lists.debian.org/debian-security-announce/input/msg00005.html', 'http://lists.debian.org/debian-security-announce/input/msg00006.html', 'http://lists.debian.org/debian-security-announce/input/msg00007.html', 'http://lists.debian.org/debian-security-announce/input/msg00008.html', 'http://lists.debian.org/debian-security-announce/input/msg00009.html', 'http://lists.debian.org/debian-security-announce/input/msg00010.html', 'http://lists.debian.org/debian-security-announce/input/msg00011.html', 'http://lists.debian.org/debian-security-announce/input/msg00012.html', 'http://lists.debian.org/debian-security-announce/input/msg00013.html', 'http://lists.debian.org/debian-security-announce/input/msg00014.html', 'http://lists.debian.org/debian-security-announce/input/msg00015.html', 'http://lists.debian.org/debian-security-announce/input/msg00016.html', 'http://lists.debian.org/debian-security-announce/input/msg00017.html', 'http://lists.debian.org/debian-security-announce/input/msg00018.html', 'http://lists.debian.org/debian-security-announce/input/msg00019.html', 'http://lists.debian.org/debian-security-announce/input/msg00020.html', 'http://lists.debian.org/debian-security-announce/input/msg00021.html', 'http://lists.debian.org/debian-security-announce/input/msg00022.html', 'http://lists.debian.org/debian-security-announce/input/msg00023.html', 'http://lists.debian.org/debian-security-announce/input/msg00024.html', 'http://lists.debian.org/debian-security-announce/input/msg00025.html', 'http://lists.debian.org/debian-security-announce/input/msg00026.html', 'http://lists.debian.org/debian-security-announce/input/msg00027.html', 'http://lists.debian.org/debian-security-announce/input/msg00028.html', 'http://lists.debian.org/debian-security-announce/input/msg00029.html', 'http://lists.debian.org/debian-security-announce/input/msg00030.html', 'http://lists.debian.org/debian-security-announce/input/msg00031.html', 'http://lists.debian.org/debian-security-announce/input/msg00032.html', 'http://lists.debian.org/debian-security-announce/input/msg00033.html', 'http://lists.debian.org/debian-security-announce/input/msg00034.html', 'http://lists.debian.org/debian-security-announce/input/msg00035.html', 'http://lists.debian.org/debian-security-announce/input/msg00036.html', 'http://lists.debian.org/debian-security-announce/input/msg00037.html', 'http://lists.debian.org/debian-security-announce/input/msg00038.html', 'http://lists.debian.org/debian-security-announce/input/msg00039.html', 'http://lists.debian.org/debian-security-announce/input/msg00040.html', 'http://lists.debian.org/debian-security-announce/input/msg00041.html', 'http://lists.debian.org/debian-security-announce/input/msg00042.html', 'http://lists.debian.org/debian-security-announce/input/msg00043.html', 'http://lists.debian.org/debian-security-announce/input/msg00044.html', 'http://lists.debian.org/debian-security-announce/input/msg00045.html', 'http://lists.debian.org/debian-security-announce/input/msg00046.html', 'http://lists.debian.org/debian-security-announce/input/msg00047.html', 'http://lists.debian.org/debian-security-announce/input/msg00048.html', 'http://lists.debian.org/debian-security-announce/input/msg00049.html', 'http://lists.debian.org/debian-security-announce/input/msg00050.html', 'http://lists.debian.org/debian-security-announce/input/msg00051.html', 'http://lists.debian.org/debian-security-announce/input/msg00052.html']

        link = './test/unit_test/work/input/Debian-2009-page.html'
        out_put = self.debian_parser_obj._getEachAdvLink(link)
        self.assertEquals(out_put, req_out_put)


if __name__ == '__main__':
    unittest.main()

