# OpenVAS
# $Id$
# Description: RPM spec file for openvas-plugins
#
# Authors:
# Jan-Oliver Wagner <jan-oliver.wagner@intevation.de>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.de
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

%define PACKAGE_NAME openvas-plugins
%define PACKAGE_VERSION 1.0.0
%define release 1.fc8.openvas
%define _prefix /usr

Summary: The Open Vulnerability Assessment (OpenVAS) Server
Name:    %PACKAGE_NAME
Version: %PACKAGE_VERSION
Release: %{release}
Source0: %{name}-%{version}.tar.gz
Patch0:  %{name}-%{version}-Makefile.diff
License: GNU GPLv2
Group: Productivity/Networking/Security
Vendor: OpenVAS Development Team, http://www.openvas.org 
Distribution: Fedora 8
BuildRoot: %{_builddir}/%{name}-root
Prefix: %{_prefix}
BuildRequires: openvas-server-devel

%description
openvas-plugins adds the acutal vulnerbaility tests to
the Network Vulnerabilty Scanner OpenVAS.

%prep
%setup -b 0
%patch0

%build
%configure --prefix=%{_prefix}
make

%install
%makeinstall

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc CHANGES COPYING
%{_mandir}/man?/*
%{_libdir}/openvas/plugins/*
%{_sbindir}/openvas-nvt-sync
%{_bindir}/openvas-build
%{_libdir}/openvas/plugins_factory/*

%changelog
* Fri Apr 18 2008 Jan-Oliver Wagner <jan-oliver.wagner@intevation.de>
  - Adapated for Fedora 8 (naming)
  - %post and %postrun removed
* Wed Apr 16 2008 Jan-Oliver Wagner <jan-oliver.wagner@intevation.de>
  Initial OpenSUSE 10.2 spec file, tested for i586
