#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
# This script is released under the GNU GPL v2


if(description)
{
 script_id(14285);
 script_version ("$Revision: 7198 $");
 script_tag(name:"risk_factor", value:"High");
 script_xref(name:"OSVDB", value:"8641");
 name = "CVSTrac database plaintext password storage";

 script_name(name);
 
 desc = "
The remote host seems to be running cvstrac, 
a web-based bug and patch-set tracking system for CVS.

This version contains a flaw related to *.db files that 
may allow an attacker to gain access to plaintext passwords.

***** OpenVAS has determined the vulnerability exists on the target
***** simply by looking at the version number(s) of CVSTrac
***** installed there. 


Solution : Update to version 1.1.4 or disable this CGI suite
Risk factor : High";


 script_description(desc);
 
 summary = "Checks for CVSTrac version";
 
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright("This script is Copyright (C) 2004 David Maciejak");
 family = "Web application abuses";
 script_family(family);
 script_dependencie("cvstrac_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_http_port(default:80);
kb = get_kb_item("www/" + port + "/cvstrac" );
if ( ! kb ) exit(0);
stuff = eregmatch(pattern:"(.*) under (.*)", string:kb );
version = stuff[1];

if(ereg(pattern:"^(0\..*|1\.0\.[0-5]([^0-9]|$))", string:version))
	security_hole( port );
