# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1438-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60070);
 script_cve_id("CVE-2007-4131", "CVE-2007-4476");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1438-1 (tar)";
 script_name(name);

 desc = "The remote host is missing an update to tar
announced via advisory DSA 1438-1.

Several vulnerabilities have been discovered in GNU Tar. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2007-4131

A directory traversal vulnerability enables attackers using
specially crafted archives to extract contents outside the
directory tree created by tar.

CVE-2007-4476

A stack-based buffer overflow in the file name checking code may
lead to arbitrary code execution when processing maliciously
crafted archives.

For the stable distribution (etch), these problems have been fixed in
version 1.16-2etch1.

For the old stable distribution (sarge), these problems have been
fixed in 1.14-2.4.

For the unstable distribution (sid), these problems have been fixed in
version 1.18-2.

We recommend that you upgrade your tar package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201438-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1438-1 (tar)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"tar", ver:"1.14-2.4", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tar", ver:"1.16-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
