# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-6014 (apr-util)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64295);
 script_cve_id("CVE-2009-0023", "CVE-2009-1955", "CVE-2009-1956");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.4");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 9 FEDORA-2009-6014 (apr-util)";
 script_name(name);

 desc = "The remote host is missing an update to apr-util
announced via advisory FEDORA-2009-6014.

Update Information:

Backport security fixes from upstream version 1.3.7:
- CVE-2009-0023 Fix underflow in apr_strmatch_precompile.
- CVE-2009-1955 Fix a denial of service attack against the
  apr_xml_* interface using the billion laughs entity
  expansion technique.
- CVE-2009-1956 Fix off by one overflow in apr_brigade_vprintf.
  Note: CVE-2009-1956 is only an issue on big-endian architectures.

ChangeLog:

* Mon Jun  8 2009 Bojan Smojver  - 1.2.12-7
- include missing bit of the apr_strmatch.c patch
* Mon Jun  8 2009 Bojan Smojver  - 1.2.12-6
- CVE-2009-0023
- billion laughs fix of apr_xml_* interface
- off by one in apr_brigade_vprintf
* Wed Jun 11 2008 Dennis Gilmore  - 1.2.12-5.1
- minor rebuild on sparc

References:

[ 1 ] Bug #504555 - CVE-2009-1955 apr-util billion laughs attack
https://bugzilla.redhat.com/show_bug.cgi?id=504555
[ 2 ] Bug #504390 - CVE-2009-1956 apr-util single NULL byte buffer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=504390
[ 3 ] Bug #503928 - CVE-2009-0023 apr-util heap buffer underwrite
https://bugzilla.redhat.com/show_bug.cgi?id=503928

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update apr-util' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-6014

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-6014 (apr-util)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"apr-util", rpm:"apr-util~1.2.12~7.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apr-util-devel", rpm:"apr-util-devel~1.2.12~7.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apr-util-mysql", rpm:"apr-util-mysql~1.2.12~7.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apr-util-pgsql", rpm:"apr-util-pgsql~1.2.12~7.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apr-util-sqlite", rpm:"apr-util-sqlite~1.2.12~7.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apr-util-debuginfo", rpm:"apr-util-debuginfo~1.2.12~7.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
