#
#VID 56ba8728-f987-11de-b28d-00215c6a37bb
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 56ba8728-f987-11de-b28d-00215c6a37bb
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66644);
 script_cve_id("CVE-2009-4024", "CVE-2009-4025");
 script_bugtraq_id(37093,37094);
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("FreeBSD Ports: pear-Net_Ping");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   pear-Net_Ping
   pear-Net_Traceroute

CVE-2009-4024
Argument injection vulnerability in the ping function in Ping.php in
the Net_Ping package before 2.4.5 for PEAR allows remote attackers to
execute arbitrary shell commands via the host parameter.

CVE-2009-4025
Argument injection vulnerability in the traceroute function in
Traceroute.php in the Net_Traceroute package before 0.21.2 for PEAR
allows remote attackers to execute arbitrary shell commands via the
host parameter.  NOTE: some of these details are obtained from third
party information.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://pear.php.net/advisory20091114-01.txt
http://www.vuxml.org/freebsd/56ba8728-f987-11de-b28d-00215c6a37bb.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: pear-Net_Ping");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"pear-Net_Ping");
if(!isnull(bver) && revcomp(a:bver, b:"2.4.5")<0) {
    security_note(0, data:"Package pear-Net_Ping version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"pear-Net_Traceroute");
if(!isnull(bver) && revcomp(a:bver, b:"0.21.2")<0) {
    security_note(0, data:"Package pear-Net_Traceroute version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
