###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_avast_av_detect_win.nasl 5171 2009-10-06 16:57:29Z oct $
#
# avast! AntiVirus Version Detection (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801110);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("avast! AntiVirus Version Detection (Win)");
  desc = "
  Overview: This script detects the installed version of avast! AntiVirus
  and sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of avast! AntiVirus");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

path1 = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

foreach path (make_list("avast!", "avast5"))
{
  avastName = registry_get_sz(key:path1 + path, item:"DisplayName");

  if(avastName =~ "avast! (Free )?Antivirus")
  {
    avastVer = registry_get_sz(key:path1 + path, item:"DisplayVersion");

    if(!(avastVer =~ "^([0-9]\.[0-9]+\.[0-9]+\.[0-9]+)"))
    {
      avastPath = registry_get_sz(key:path1 + path, item:"DisplayIcon");
      share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:avastPath);
      file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:avastPath);
      avastVer = GetVer(file:file, share:share);
    }
    if(!isnull(avastVer))
    {
      set_kb_item(name:"Avast!/AV/Win/Ver", value:avastVer);
      security_note(data:"Avast! Anti virus version " + avastVer +
                         " was detected on the host");
    }
  }
}
