###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_gd_graphics_library_bof_vuln_lin.nasl 5387 2009-10-23 16:48:56Z oct $
#
# GD Graphics Library '_gdGetColors()' Buffer Overflow Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801122);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-3546");
  script_bugtraq_id(36712);
  script_name("GD Graphics Library '_gdGetColors()' Buffer Overflow Vulnerability (Linux)");
  desc = "
  Overview: The host is installed with GD Graphics Library and is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  The flaw is due to error in '_gdGetColors' function in gd_gd.c which fails to
  check certain colorsTotal structure member, whicn can be exploited to cause
  buffer overflow or buffer over-read attacks via a crafted GD file.

  Impact:
  Successful exploitation could allow attackers to potentially compromise a
  vulnerable system.

  Impact Level: System

  Affected Software/OS:
  GD Graphics Library version 2.x on Linux.

  Fix: No solution or patch is available as on 23rd October, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.boutell.com/gd/

  References:
  http://secunia.com/advisories/37069/
  http://www.vupen.com/english/advisories/2009/2929
  http://marc.info/?l=oss-security&m=125562113503923&w=2

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of GD Graphics Library");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_gd_graphics_library_detect_lin.nasl");
  script_require_keys("GD-Graphics-Lib/Lin/Ver");
  exit(0);
}


gdVer = get_kb_item("GD-Graphics-Lib/Lin/Ver");

# Check GD Graphics Library version 2.x
if(gdVer =~ "^2\..*"){
  security_hole(0);
}
