###############################################################################
# OpenVAS Vulnerability Test
# $Id: mysql_29106.nasl 7517 2010-05-04 08:33:01Z chandra $
#
# MySQL MyISAM Table Privileges Secuity Bypass Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100156);
 script_bugtraq_id(29106);
 script_cve_id("CVE-2008-2079","CVE-2008-4097","CVE-2008-4098");
 script_version ("1.0");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("MySQL MyISAM Table Privileges Secuity Bypass Vulnerability");
 desc = "

 Overview:
  According to its version number, the remote version of MySQL is
  prone to a security-bypass vulnerability.

  An attacker can exploit this issue to gain access to table files created by
  other users, bypassing certain security restrictions.

  NOTE 1: This issue was also assigned CVE-2008-4097 because
  CVE-2008-2079 was incompletely fixed, allowing symlink attacks.

  NOTE 2: CVE-2008-4098 was assigned because fixes for the vector
  described in CVE-2008-4097 can also be bypassed.

  This issue affects versions prior to MySQL 4 (prior to 4.1.24) and
  MySQL 5 (prior to 5.0.60). 

 Solution:
  Updates are available. Update to newer Version.

 See also:
  http://www.securityfocus.com/bid/29106

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if MySQL is vulnerable to Table Privileges Secuity Bypass");
 script_category(ACT_GATHER_INFO);
 script_family("Databases");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("mysql_version.nasl");
 script_require_ports("Services/mysql", 3306);
 exit(0);
}

include("version_func.inc");
include("misc_func.inc");

port = get_kb_item("Services/mysql");
if(!port)port = 3306;
if(!get_tcp_port_state(port))exit(0);

if(!ver = get_mysql_version(port:port))exit(0);

if(version_in_range(version:ver, test_version:"4", test_version2:"4.1.24") ||
   version_in_range(version:ver, test_version:"5", test_version2:"5.0.60") ) {
     security_hole(port:port);
     exit(0);
} 

exit(0); 
