##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_lightneasy_detect.nasl 2738 2009-06-17 21:00:29Z jun $
#
# LightNEasy Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900371);
  script_version("$Revision: 1.1 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("LightNEasy Version Detection");
  desc = "

  Overview: This script detects the installed version of LightNEasy and
  sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set KB for the Version of LightNEasy");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

lightNEasyPort = get_http_port(default:80);
if(!lightNEasyPort){
  lightNEasyPort = 80;
}

if(!get_port_state(lightNEasyPort)){
  exit(0);
}

foreach lightDir (make_list("/lightneasy", "/nodatabase", "/sqlite", "/",
                  cgi_dirs()))
{
  sndReq = http_get(item:string(lightDir, "/LightNEasy.php?do=login"),
                    port:lightNEasyPort);
  rcvRes = http_send_recv(port:lightNEasyPort, data:sndReq);

  if("LightNEasy" >!< rcvRes || rcvRes == NULL)
  {
    sndReq = http_get(item:string(lightDir, "/index.php"), port:lightNEasyPort);
    rcvRes = http_send_recv(port:lightNEasyPort, data:sndReq);
  }

  if("LightNEasy" >< rcvRes && egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    lightNEasyVer = eregmatch(pattern:"LightNEasy ([0-9.]+)", string:rcvRes);
    if("SQLite" >< rcvRes || "sqlite" >< rcvRes)
    {
      if(lightNEasyVer[1]!= NULL)
      {
        set_kb_item(name:"www/"+ lightNEasyPort + "/LightNEasy/Sqlite",
                    value:lightNEasyVer[1] + " under " + lightDir);
        security_note(data:"LightNEasy version " + lightNEasyVer[1] +
            " running at location " + lightDir +  " was detected on the host");
      }
    }
    else if(lightNEasyVer[1] != NULL)
    {
      set_kb_item(name:"www/"+ lightNEasyPort + "/LightNEasy/NoDB",
                  value:lightNEasyVer[1] + " under " + lightDir);
      security_note(data:"LightNEasy version " + lightNEasyVer[1] + 
            " running at location " + lightDir +  " was detected on the host");
    }
  }
}
