###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_ie_addr_bar_spoofing_vuln.nasl 4379 2009-09-01 15:09:29Z sep $
#
# Microsoft Internet Explorer Address Bar Spoofing Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900836);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3003");
  script_name("Microsoft Internet Explorer Address Bar Spoofing Vulnerability");
  desc = "
  Overview: This host is installed with Internet Explorer and is prone to
  Address Bar Spoofing vulnerability.

  Vulnerability Insight:
  Error exists when opening a new window using 'window.open()' which can be
  exploited to display spoofed content in the browser window while the address
  bar shows an arbitrary path on a possibly trusted host.

  Impact:
  Successful exploitation lets the attackers to spoof parts of the address bar
  and modify page content on a host that a user may consider partly trusted.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Internet Explorer version 6.x, 7.x and 8.x

  Fix: No solution or patch is available as on 01st Sep 2009, Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,
  http://www.microsoft.com/windows/internet-explorer/download-ie.aspx

  References:
  http://secunia.com/advisories/36334
  http://lostmon.blogspot.com/2009/08/multiple-browsers-fake-url-folder-file.html

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score  : 3.9
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/EXE/Ver");
  exit(0);
}


include("version_func.inc");

ieVer = get_kb_item("MS/IE/EXE/Ver");
if(!ieVer)
{
  exit(0);
}

# Check for Microsoft Internet Explorer version 6.0 <= 6.0.3790.3959,
# 7.0 <= 7.0.6000.16876 and 8.0 <= 8.0.6001.18702
if(version_in_range(version:ieVer, test_version:"6.0", test_version2:"6.0.3790.3959") ||
   version_in_range(version:ieVer, test_version:"7.0", test_version2:"7.0.6000.16876")||
   version_in_range(version:ieVer, test_version:"8.0", test_version2:"8.0.6001.18702")){
   security_warning(0);
}
