##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_xoops_detect.nasl 5798 2009-11-19 15:06:29Z nov $
#
# XOOPS Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900892);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("XOOPS Version Detection");
  desc = "
  Overview: This script detects the installed XOOPS version and sets
  the result in KB.

  Risk factor:None";

  script_description(desc);
  script_summary("Set KB for the version of XOOPS");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

xoopsPort = get_http_port(default:80);
if(!xoopsPort){
  exit(0);
}

foreach dir (make_list("/","/htdocs", "/xoops/htdocs", "/xoops-230/htdocs","/xoops-2014rc1/htdocs", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:xoopsPort);
  rcvRes = http_send_recv(port:xoopsPort, data:sndReq);
  if("XOOPS" >!< rcvRes)
  {
    sndReq = http_get(item:string(dir, "/user.php"), port:xoopsPort);
    rcvRes = http_keepalive_send_recv(port:xoopsPort, data:sndReq);
    if("XOOPS" >!< rcvRes){
      continue; 
    }
  }

  if("XOOPS" >< rcvRes && egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    sndReq = string("GET ", dir, "/../release_notes.txt HTTP/1.1 \r\n",
                    "Host: ", get_host_ip(), "\r\n\r\n");
    rcvRes = http_send_recv(port:xoopsPort, data:sndReq);

    if("XOOPS" >< rcvRes && "version" >< rcvRes)
    {
      xoopsVer = eregmatch(pattern:"XOOPS ([0-9]\.[0-9.]+).?(Final|RC[0-9]" +
                                   "|[a-z])?", string:rcvRes, icase:1);
      if(!isnull(xoopsVer[1]))
      {
        if(!isnull(xoopsVer[2]))
          xoopsVer = xoopsVer[1] + "." + xoopsVer[2];
        else
          xoopsVer = xoopsVer[1];

        set_kb_item(name:"www/"+ xoopsPort + "/XOOPS",
                    value:xoopsVer + " under " + dir);
        security_note(data:"XOOPS version " + xoopsVer + " running at " +
                           "location " + dir +  " was detected on the host");
      }
    }
  }
}
