class gearman_worker($deploymentname = $uniqueid) {

  package{'gearman-tools': ensure => installed} -> File <<| tag == "gearman_${deploymentname}" |>>

  package{'libgearman-client-perl': ensure => installed, require => Package['gearman-tools']}
  package{'libgearman-client-async-perl': ensure => installed, require => Package['libgearman-client-perl']}

  package{'python-gearman.libgearman': ensure => installed, require => Package['libgearman-client-async-perl']}

  package{'libgearman-dev': ensure => installed, require => Package['python-gearman.libgearman']}
  package{'uuid-dev': ensure => installed, require => Package['libgearman-dev']}
  package{'libev-libevent-dev': ensure => installed, require => Package['uuid-dev']}
  package{'php-pear': ensure => installed, require => Package['libev-libevent-dev']}
  package{'php5-dev': ensure => installed, require => Package['php-pear']}

  exec{ "libgearman-php":
    command => "pecl install \"channel://pecl.php.net/gearman-0.7.0\"",
    require => Package["php5-dev"], 
    unless => "test -e /usr/lib/php5/20090626+lfs/gearman.so",
  }

  exec {"gearman_ini":
    command => "echo extension=gearman.so > /etc/php5/conf.d/gearman.ini",
    require => Exec["libgearman-php"],
    unless => "test -e /etc/php5/conf.d/gearman.ini",
  }

  exec{ "/bin/cat /etc/gearman/deployments/${deploymentname}.deployment_data >> /etc/hosts":  
    unless => "grep ${deploymentname} /etc/hosts",
    onlyif => "test -e /etc/gearman/deployments/${deploymentname}.deployment_data",
    require => Exec["gearman_ini"],
  }


}
