# Hadoop Master Node


class hadoop_slave( $clustername = $uniqueid )
{
  apt::ppa{"ppa:canonical-sig/thirdparty":}
  package{"debconf": ensure => present}

  exec{"create_cluster_data_dir":
    command => "mkdir -p /etc/hadoop/cluster_data/${clustername}",
    require => Apt::Ppa["ppa:canonical-sig/thirdparty"],
  } -> File <<| tag == "hadoop_${clustername}" |>> 

#   debconf::set_selection{ "namenode":
#     selection => "hadoop/namenode", 
#     value_type => "string", 
#     value => file("/etc/hadoop/cluster_data/${clustername}/namenode.cluster_data"),
#     require => File["namenode_${clustername}"],
#     onlyif => "test -e /etc/hadoop/cluster_data/${clustername}/namenode.cluster_data",
#   }
  exec{"debconf_namenode":
    command => "echo debconf hadoop/namenode string `cat /etc/hadoop/cluster_data/${clustername}/namenode.cluster_data | cut -d: -f2` | debconf-set-selections", 
    require => [ Package["debconf"], Exec["create_cluster_data_dir"]],
  }

#   debconf::set_selection{ "jobtracker":
#     selection => "hadoop/jobtracker", 
#     value_type => "string", 
#     value => file("/etc/hadoop/cluster_data/${clustername}/jobtracker.cluster_data"),
#     require => [Debconf::Set_selection["namenode"],File["jobtracker_${clustername}"]],
#     onlyif => "test -e /etc/hadoop/cluster_data/${clustername}/jobtracker.cluster_data",
#   }
  exec{"debconf_jobtracker":
    command => "echo debconf hadoop/jobtracker string `cat /etc/hadoop/cluster_data/${clustername}/jobtracker.cluster_data | cut -d: -f2` | debconf-set-selections", 
    require => [ Exec["debconf_namenode"]],
  }


#   debconf::set_selection{ "hdfsdatadir": 
#     selection => "hadoop/hdfsdatadir", 
#     value_type => "string", 
#     value => file("/etc/hadoop/cluster_data/${clustername}/hdfsdatadir.cluster_data"),
#     require => [Debconf::Set_selection["jobtracker"],File["hdfsdatadir_${clustername}"]],
#     onlyif => "test -e /etc/hadoop/cluster_data/${clustername}/hdfsdatadir.cluster_data",
#   }
  exec{"debconf_hdfsdatadir":
    command => "echo debconf hadoop/hdfsdatadir string `cat /etc/hadoop/cluster_data/${clustername}/hdfsdatadir.cluster_data | cut -d: -f2` | debconf-set-selections", 
    require => [ Exec["debconf_jobtracker"]],
  }

  package{"hadoop-0.20-datanode": ensure => installed, require => Exec["debconf_hdfsdatadir"]}

  package{"hadoop-0.20-tasktracker": ensure => installed, require => Package["hadoop-0.20-datanode"]}

}



