#
# Miscellaneous puppet defines not substantial enough to warrant a module.
#

#
# Manipulate a line in a file.
#
define line($file, $line, $ensure = 'present') {
  case $ensure {
    default : { err ( "unknown ensure value ${ensure}" ) }
    present: {
      exec { "/bin/echo '${line}' >> '${file}'":
	command => "/bin/echo '${line}' >> '${file}'",
	unless => "/bin/grep -qFx '${line}' '${file}'"
      }
    }
    absent: {
      exec { "/usr/bin/perl -ni -e 'print unless /^\\Q${line}\\E\$/' '${file}'":
	command => "/usr/bin/perl -ni -e 'print unless /^\\Q${line}\\E\$/' '${file}'",
	onlyif => "/bin/grep -qFx '${line}' '${file}'"
      }
    }
  }
}


#
# Pull a file from elsewhere not using puppet://...
#
define download_file(
  $site="",
  $cwd="",
  $unless="",
  $timeout = 300) {

  exec { $name:
    command => "wget ${site} -O ${name}",
    cwd => $cwd,
    creates => "${cwd}/${name}",
    timeout => $timeout,
    unless => $unless
  }
}

#
# Create ssh key
#
define create_ssh_keypair($key_file = "~/.ssh/id_rsa", $type = "rsa", $password = "")
{
  package{"openssh-client": ensure => installed}
  exec{"generate_ssh_key":
    command => "/usr/bin/ssh-keygen -q -t ${type} -N '${password}' -f ${key_file}",
    require => Package["openssh-client"],
    unless => "test -e ${key_file}",
  }
}

# #
# # Create a normal user (with adduser) and optionally assign default ssh keys
# #
# define ubuntu_user($username = "", $ssh_private_key = "", $ssh_publick_key = "", $ssh_key_type = "rsa")
# {
#   if ($username == "")
#   {
#     err("Username must be defined and not blank.")
#   }
# 
#   package{"adduser": ensure => present}
# 
#   exec{"create_${username}_$uniqueid":
#     command => "/usr/sbin/adduser ${username}",
#     unless => "cat /etc/passwd | grep ${username}",
#   }
# 
#   if ($ssh_private_key != "") and ($ssh_publick_key != "") and (($ssh_key_type == "rsa") or ($ssh_key_type == "dsa"))
#   {
# 
#     file{"private_ssh_key_${username}_${uniqueid}":
#       name => "/home/${username}/.ssh
#     }
# 
#     file{"public_ssh_key_${username}_${uniqueid}":
#     }
# 
#   }
#
#}