/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#include "message.h"
#include "globals.h"

#include <QByteArray>

QString getParametr(QString par, QString str);

Message::Message(QC_DatagramHeader* Hdr)
{
  if(Hdr)
  {
    m_version     = Hdr->programVersion;
    m_msg         = Hdr->msg;
    m_userName    = Hdr->name;
    m_compName    = Hdr->comp_name;
    m_srcIp       = Hdr->src_ip;
    m_sendTime    = Hdr->tm;
    m_receiveTime = Hdr->receive_tm;
    m_type        = Hdr->type;
    m_color       = Hdr->color;
  }
  else
  {
    m_version     = 0;
    m_srcIp       = 0;
    m_sendTime    = 0;
    m_receiveTime = 0;
    m_color       = Qt::black;
  }

  m_requested = false;
}

Message::~Message()
{
}

void Message::setMsg(const QC_DatagramHeader* Hdr)
{
  m_version     = Hdr->programVersion;
  m_msg         = Hdr->msg;
  m_userName    = Hdr->name;
  m_compName    = Hdr->comp_name;
  m_srcIp       = Hdr->src_ip;
  m_sendTime    = Hdr->tm;
  m_receiveTime = Hdr->receive_tm;
}
//\*****************************************************************************
