/*
 * Decompiled with CFR 0.152.
 */
package king.core;

import java.awt.Color;
import king.core.HeavyKPaint;
import king.core.LightKPaint;

public abstract class KPaint {
    public static final Color black = new Color(0.0f, 0.0f, 0.0f);
    public static final Color white = new Color(1.0f, 1.0f, 1.0f);
    public static final int COLOR_LEVELS = 16;
    static final float BVAL = 0.36f;
    static final float WVAL = 0.4f;
    static final float WSAT = 0.36f;
    static final double AMBIENT_COEFF = 0.4;
    static final double DIFFUSE_COEFF = 0.6;
    public static final int BLACK_COLOR = 0;
    public static final int WHITE_COLOR = 1;
    public static final int BLACK_MONO = 2;
    public static final int WHITE_MONO = 3;
    public static final int N_BACKGROUNDS = 4;
    static final Color[][] SHADE_BACKGROUNDS = new Color[4][16];
    String name;
    KPaint aliasOf;
    boolean isInvisible;

    KPaint() {
    }

    public static KPaint createHSV(String string, float f, float f2, float f3, float f4, float f5) {
        if (string == null) {
            throw new NullPointerException("Must give paint a name");
        }
        HeavyKPaint heavyKPaint = new HeavyKPaint();
        heavyKPaint.name = string;
        heavyKPaint.aliasOf = null;
        heavyKPaint.paints = new Color[4][];
        heavyKPaint.paintsBackup = heavyKPaint.paints;
        heavyKPaint.isInvisible = false;
        f /= 360.0f;
        f2 /= 100.0f;
        f3 /= 100.0f;
        f4 /= 100.0f;
        f5 /= 100.0f;
        Color[] colorArray = new Color[16];
        float[] fArray = KPaint.interpolate(0.36f, 1.0, 16);
        for (int i = 0; i < 16; ++i) {
            colorArray[i] = KPaint.getHSB(f, f2, fArray[i] * f4);
        }
        Color[] colorArray2 = new Color[16];
        float[] fArray2 = KPaint.interpolate(0.36f, 1.0, 16);
        float[] fArray3 = KPaint.interpolate(0.4f * f5 + 0.6f, f5, 16);
        for (int i = 0; i < 16; ++i) {
            colorArray2[i] = KPaint.getHSB(f, fArray2[i] * f3, fArray3[i]);
        }
        heavyKPaint.paints[0] = colorArray;
        heavyKPaint.paints[1] = colorArray2;
        heavyKPaint.paints[2] = KPaint.makeMonochrome(heavyKPaint.paints[0]);
        heavyKPaint.paints[3] = KPaint.makeMonochrome(heavyKPaint.paints[1]);
        return heavyKPaint;
    }

    private static Color getHSB(float f, float f2, float f3) {
        return new Color(Color.HSBtoRGB(f, f2, f3));
    }

    public static KPaint createLightweightHSV(String string, float f, float f2, float f3, float f4, float f5, float f6) {
        if (string == null) {
            throw new NullPointerException("Must give paint a name");
        }
        LightKPaint lightKPaint = new LightKPaint(f / 360.0f, f2 / 100.0f, f3 / 100.0f, f4 / 360.0f, f5 / 100.0f, f6 / 100.0f);
        lightKPaint.name = string;
        lightKPaint.aliasOf = null;
        lightKPaint.isInvisible = false;
        return lightKPaint;
    }

    public static KPaint createSolid(String string, Color color) {
        if (string == null) {
            throw new NullPointerException("Must give paint a name");
        }
        if (color == null) {
            throw new NullPointerException("Must provide a valid Color");
        }
        HeavyKPaint heavyKPaint = new HeavyKPaint();
        heavyKPaint.name = string;
        heavyKPaint.aliasOf = null;
        heavyKPaint.paints = new Color[4][16];
        heavyKPaint.paintsBackup = heavyKPaint.paints;
        heavyKPaint.isInvisible = false;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 16; ++j) {
                heavyKPaint.paints[i][j] = color;
            }
        }
        return heavyKPaint;
    }

    public static KPaint createAlias(String string, KPaint kPaint) {
        if (string == null) {
            throw new NullPointerException("Must give paint a name");
        }
        if (kPaint == null) {
            throw new NullPointerException("Must give paint alias an existing paint to reference");
        }
        HeavyKPaint heavyKPaint = (HeavyKPaint)kPaint;
        HeavyKPaint heavyKPaint2 = new HeavyKPaint();
        heavyKPaint2.name = string;
        heavyKPaint2.aliasOf = heavyKPaint;
        heavyKPaint2.paints = heavyKPaint.paints;
        heavyKPaint2.paintsBackup = heavyKPaint2.paints;
        heavyKPaint2.isInvisible = heavyKPaint.isInvisible;
        return heavyKPaint2;
    }

    public static KPaint createInvisible(String string) {
        Color color = new Color(51, 51, 51);
        KPaint kPaint = KPaint.createSolid(string, color);
        kPaint.isInvisible = true;
        return kPaint;
    }

    public Color getPaint(int n, double d, int n2, int n3) {
        Color color = this.getPaint(n, n2);
        if (d < 0.0) {
            d = -d;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d == 1.0 && n3 == 255) {
            return color;
        }
        try {
            double d2 = 0.4 + 0.6 * d;
            return KPaint.blendColors(color, d2, SHADE_BACKGROUNDS[n][n2], 1.0 - d2, n3);
        }
        catch (ClassCastException classCastException) {
            return color;
        }
    }

    public abstract Color getPaint(int var1, int var2);

    public abstract Color[] getPaints(int var1);

    private static Color blendColors(Color color, double d, Color color2, double d2, int n) {
        int n2 = (int)((double)color.getRed() * d + (double)color2.getRed() * d2);
        int n3 = (int)((double)color.getGreen() * d + (double)color2.getGreen() * d2);
        int n4 = (int)((double)color.getBlue() * d + (double)color2.getBlue() * d2);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 255) {
            n2 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 255) {
            n3 = 255;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > 255) {
            n4 = 255;
        }
        return new Color(n2, n3, n4, n);
    }

    private static Color[] makeMonochrome(Color[] colorArray) {
        Color[] colorArray2 = new Color[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray2[i] = KPaint.makeMonochrome(colorArray[i]);
        }
        return colorArray2;
    }

    static Color makeMonochrome(Color color) {
        float f = (0.297f * (float)color.getRed() + 0.589f * (float)color.getGreen() + 0.114f * (float)color.getBlue()) / 255.0f;
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        return new Color(f, f, f, (float)color.getAlpha() / 255.0f);
    }

    static float[] interpolate(double d, double d2, int n) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            double d3 = (double)i / (double)(n - 1);
            fArray[i] = (float)((1.0 - d3) * d + d3 * d2);
        }
        return fArray;
    }

    public Color getBlackExemplar() {
        return this.getPaint(0, 15);
    }

    public Color getWhiteExemplar() {
        return this.getPaint(1, 15);
    }

    public boolean isInvisible() {
        return this.isInvisible;
    }

    public boolean isAlias() {
        return this.aliasOf != null;
    }

    public KPaint getAlias() {
        if (this.aliasOf != null) {
            return this.aliasOf;
        }
        throw new UnsupportedOperationException(this + " is not an alias of some other KPaint");
    }

    public String toString() {
        return this.name;
    }

    public void setContrast(double d) {
    }

    static {
        Color[] colorArray = new Color[16];
        for (int i = 0; i < 16; ++i) {
            colorArray[i] = black;
        }
        KPaint.SHADE_BACKGROUNDS[0] = colorArray;
        KPaint.SHADE_BACKGROUNDS[2] = colorArray;
        float[] fArray = KPaint.interpolate(0.6f, 0.0, 16);
        colorArray = new Color[16];
        for (int i = 0; i < 16; ++i) {
            colorArray[i] = new Color(Color.HSBtoRGB(0.0f, 0.0f, fArray[i]));
        }
        KPaint.SHADE_BACKGROUNDS[1] = colorArray;
        KPaint.SHADE_BACKGROUNDS[3] = colorArray;
    }
}

