/***************************************************************************
                          soundcard.h  -  QSSTV
                             -------------------
    begin                : Tue Apr 17 22:27:58 CEST 2001
    copyright            : (C) 2001 by Johan Maes ON1MH
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef LSOUNDCARD_H
#define LSOUNDCARD_H

#include <sys/soundcard.h>
#include <qobject.h>
#include <qstring.h>

#define AUDIOBUFFERSIZE 1024
class QTimer;

struct dspstruct
  {
    int fdDSP;                      // filedescriptor for /dev/dsp
    unsigned int speed;             // sampling rate
    int channels;                   // 1=mono, 2=stereo
    int format;                     // AFMT_S16_LE (16-Bits) or AFMT_U8 (8-bits samples)
    unsigned int fragSize;          // Size of one fragment to process
    unsigned int numFrags;          // number of fragments
    unsigned int buffLen;           // length of the buffer
    unsigned int caps;              // Soundcard driver capabilities
    char * pbuffer;                 // DMA buffer. note: caddr_t = char *
  };

class soundcard:public QObject
{
	Q_OBJECT
 public:
  soundcard(int i_samplingRate=8000);
  ~soundcard();
  void setSamplingrate(int s);
  bool startReceive(const char *s,QString &errorString);
  bool startTransmit(const char *s,QString &errorString);
  bool startFullDuplex(const char *s,QString &errorString);
  void stop();
  int readBuffer(char *audioBuffer);
  int writeBuffer(char *audioBuffer);
  int waitEnd();
  //void read(short int *longBuffer,uint length);
  bool write(short int *longBuffer,uint length);
  int audioBufferLen; // in bytes
  int fragmentLatency;
 private:


  enum esoundStatus {CLOSED,OPENFORREAD,OPENFORWRITE,OPENFORREADWRITE};
  esoundStatus status;
  struct dspstruct dspInfo;

  bool writeWrapped;
  uint blockSize;
  uint writeIndex;
  uint writeLength;
  char *longBuffer;

public slots:
	 void delayedStop();

private slots: // Public slots
  /** write next audio block*/
  void writeNext();


  /** wait for empty buffer */

  void slotStop();
signals:
	void signalStopped();
	void signalTransmitBufferAvailable();
private:
	bool setParam(int format, int fragsize,int channels,QString &errorString);
	bool started;
	bool busy;
	QTimer *timer1;
	QTimer *timer2; 	
};

#endif










