/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef IMAGEVIEWER_H
#define IMAGEVIEWER_H
#include <QLabel>
#include <QSettings>
#include <QEvent>
#include <QMovie>
#include "editor/editor.h"
#include "editor/editorscene.h"


class QMenu;
class QAction;
class editor;

class imageViewer : public QLabel
{
  Q_OBJECT
  /*! thumbnail type */
public:
  enum thumbType
    {
    RXIMG, /*!< just for receiver */
    TXIMG, /*!< just for transmitter */
    RXTHUMB, /*!< thumbnail for receiver. */
    TXTHUMB,/*!< thumbnail for transmitter. */
    TEMPLATETHUMB /*!< thumbnail for template. */
    };
  imageViewer(QWidget *parent=0);
  ~imageViewer();
  void init(thumbType tp);
  bool openImage(QString &filename, QString start, bool ask, bool showMessage, bool emitSignal);
  bool openImage(QString &filename, bool showMessage, bool emitSignal);
  bool openImage(QImage im);
  bool openImage(QByteArray *ba);
  bool reload();
  void scale( int w, int h);
  QImage * getImagePtr() {return &image;}
  bool hasValidImage();
  QImage *createImage(QSize sz,QColor fill);
  QRgb *getScanLineAddress(int line);
  void copy(imageViewer *src);

  bool readThumbSettings(QSettings *qs);
  void writeThumbSettings(QSettings *qs);
  void setType(thumbType t);
  QString getFilename() {return imageFileName;}
  void enablePopup(bool en) {popupEnabled=en;}
  void displayImage(bool useCompression);
  void save(QString fileName, QString fmt, bool convertRGB);
  void copyToBuffer(QByteArray *ba);
  int calcSize(int &sizeRatio);
  void setSizeRatio(int sizeRatio);
  int getFileSize(){return fileSize;}
  QString toCall;
  QString toOperator;
  QString rsv;
  QString comment1;
  QString comment2;
  QString comment3;



  void applyTemplate(QString templateName, bool useTemplate, int w=0, int h=0);

  //  QSize sizeHint () {return QSize(32,26);}

signals:
  void layoutChanged();
  void imageChanged();

private:
  QImage image;
  QImage overlayedImage;
  QImage compressedImage;

  void mousePressEvent( QMouseEvent *e );
  bool validImage;
  QString imageFileName;
  QString imageFilePath;
  thumbType ttype;
  bool popupEnabled;

  QMenu *popup;
  QAction *newAct;
  QAction *loadAct;
  QAction *toTXAct;
  QAction *editAct;
  QAction *printAct;
  QAction *deleteAct;
  QAction *propertiesAct;

  double psizeRatio;
  int fileSize;
  QString format;
  QMovie qm;
  bool activeMovie;


  // for overlays



private slots:
  void slotDelete();
  void slotEdit();
  void slotLoad();
  void slotNew();
  void slotPrint();
  void slotProperties();
  void slotToTX();
};

#endif
